module cloud_basic
! CReSS αʪ
! ܴؿǤ, ͤ礭ʪ̤Τ٤׻ФƤ,
! ɤտŪ exp(log()) Ȥ׻Ԥä
! 򤹤.
! Ȥ, Ǥդʪ a**b ξ, exp(b*log(a)) .
! ʤʤ, a**b=exp(log(a**b))=exp(b*log(a)) Ǥ.
! ޤ, ʪ a*b ξ, exp(log(a)+log(b)) ȤƤ.
! Τʪ̤껻äƤ,
! exp(-a) Ȥ뤳Ȥǳ껻򤹤.
  use Thermo_Const
  use Cloud_Const
  use Math_Const
  use Phys_Const

contains

real function Lv( temp )
!  -> ǤǮǮ
  use Thermo_Const
  implicit none
  real, intent(in) :: temp  !  [K]

  call ptcheck( temp )

  Lv=2.50078e6*(ti0/temp)**(0.167+3.67e-4*temp)

  return

end function Lv

real function Ls( temp )
! ɹ -> ǤǮǮ
  use Thermo_Const
  implicit none
  real, intent(in) :: temp !  [K]

  call ptcheck( temp )

  Ls=2.834e6+100.0*(temp-ti0)

  return

end function Ls

real function Lf( temp )
!  -> ɹǤͻǮ
  use Thermo_Const
  implicit none
  real, intent(in) :: temp !  [K]

  call ptcheck( temp )

  Lf=3.34e5+2500.0*(temp-ti0)

  return

end function Lf

real function nu_air( temp, pres )
! ưǴ
  use Thermo_Const
  implicit none
  real, intent(in) :: temp !  [K]
  real, intent(in) :: pres !  [Pa]

  call ptcheck( temp )

  nu_air=1.328e-5*(p00/pres)*(temp/ti0)**1.754

  return

end function nu_air

real function mu_air( temp, pres )
! Ǵ
  implicit none
  real, intent(in) :: temp !  [K]
  real, intent(in) :: pres !  [Pa]
  real :: rho

  call ptcheck( temp )

  rho=TP_2_rho( temp, pres )

  mu_air=nu_air( temp, pres )*rho

  return

end function mu_air

real function Dv( temp, pres )
! γȻ
  use Thermo_Const
  implicit none
  real, intent(in) :: temp !  [K]
  real, intent(in) :: pres !  [Pa]

  call ptcheck( temp )

  Dv=2.23e-5*(p00/pres)*(temp/ti0)**1.81

  return

end function Dv

real function qvss( temp, pres )
  use Thermo_Const
  implicit none
  real, intent(in) :: temp
  real, intent(in) :: pres
  real :: eps
  real :: a, b, c, tmp

  call ptcheck( temp )

  a=610.78
  b=17.269
  c=35.86
  eps=Rd/Rv
  tmp=b*(temp-t0)/(temp-c)

  qvss=eps*a*exp(tmp)/pres

  return

end function qvss

real function qvsi( temp, pres )
  use Thermo_Const
  implicit none
  real, intent(in) :: temp
  real, intent(in) :: pres
  real :: eps
  real :: a, b, c, tmp

  call ptcheck( temp )

  a=610.78
  b=21.875
  c=7.86
  eps=Rd/Rv
  tmp=b*(temp-t0)/(temp-c)

  qvsi=eps*a*exp(tmp)/pres

  return

end function qvsi

!---------------------------------
! ʲ, ץ饤١ȴؿ
!---------------------------------

real function lamx( types, qx, rhob, Nx )
! ŷʪλؿؿʬۤˤ뷹׻.
! ǻ٤ʤ, y ҤͤǲꤷƷ׻.
  use Math_Const
  use Cloud_Const
  use Thermo_Const
  implicit none
  character(1), intent(in) :: types  ! ŷʪμ 'r' = , 's' = , 'g' = 
  real, intent(in) :: qx     ! ŷʪκ [kg/kg]
  real, intent(in) :: rhob   ! ܾ̩ [kg/m3]
  real, intent(in), optional :: Nx  ! qx Ȥŷʪοǻ
  real :: tmpa

  if(qx>=qthres)then
     if(present(Nx))then
        tmpa=pi*Nx/rhob/qx
        select case (types(1:1))  ! 'r'  Nx ȤʤΤ, ʬʤ.
        case ('s')
           lamx=exp((1.0/3.0)*log(tmpa*rhos))
        case ('g')
           lamx=exp((1.0/3.0)*log(tmpa*rhog))
        end select
     else
        tmpa=pi/rhob/qx
        select case (types(1:1))  ! 'r'  Nx ȤʤΤ, ʬʤ.
        case ('r')
           lamx=exp(0.25*log(tmpa*rhow*nr0))
        case ('s')
           lamx=exp(0.25*log(tmpa*rhos*ns0))
        case ('g')
           lamx=exp(0.25*log(tmpa*rhog*ng0))
        end select
     end if
  else
     lamx=0.0
  end if

  return

end function lamx

real function nx0( types, qx, rhob, Nx )
! ŷʪλؿؿʬۤˤ y Ҥ׻.
! ǻ٤ʤ, y ҤͤǲꤷƷ׻.
  use Math_Const
  use Cloud_Const
  use Thermo_Const
  implicit none
  character(1), intent(in) :: types  ! ŷʪμ 'r' = , 's' = , 'g' = 
  real, intent(in) :: qx     ! ŷʪκ [kg/kg]
  real, intent(in) :: rhob   ! ܾ̩ [kg/m3]
  real, intent(in), optional :: Nx  ! qx Ȥŷʪοǻ
  real :: tmpa, lamdax

  if(qx>=qthres)then
     if(present(Nx))then
        tmpa=pi*Nx/rhob/qx
        select case (types(1:1))  ! 'r'  Nx ȤʤΤ, ʬʤ.
        case ('s')
           lamdax=exp(log(Nx)+(1.0/3.0)*log(tmpa*rhos))
        case ('g')
           lamdax=exp(log(Nx)+(1.0/3.0)*log(tmpa*rhog))
        end select
     else
        select case (types(1:1))  ! 'r'  Nx ȤʤΤ, ʬʤ.
        case ('r')
           nx0=nr0
        case ('s')
           nx0=ns0
        case ('g')
           nx0=ng0
        end select
     end if
  else
     nx0=0.0
  end if

  return

end function nx0


real function Knudsen( temp, pres )
! Knudsen ׻.
  use Cloud_Const
  use Thermo_Const
  implicit none
  real, intent(in) :: temp   !  [k]
  real, intent(in) :: pres   !  [Pa]

  call ptcheck( temp )

  Knudsen=MFP0*p00*temp/(tref*Raero*pres)

  return

end function


real function Daero( temp, pres )
! γȻ׻.
! , β٤ȼϤβ٤ƱȤƤ.
  use Cloud_Const
  use Thermo_Const
  use Phys_Const
  use Math_Const
  implicit none
  real, intent(in) :: temp   !  [k]
  real, intent(in) :: pres   !  [Pa]
  real :: Tcl

  call ptcheck( temp )

  Tcl=temp
  Daero=kB*Tcl*(1.0+Knudsen( temp, pres ))/(6.0*pi*Raero*mu_air( temp, pres ))

  return

end function


real function Naero( temp )
! ܿˤοǻ٤׻.
! Ǥϱγβ٤Ϥξ絤β٤ȤƷ׻Ƥ.
  use Cloud_Const
  use Thermo_Const
  use Phys_Const
  use Math_Const
  implicit none
  real, intent(in) :: temp   !  [k]

  call ptcheck( temp )

  if(270.16>temp)then
     Naero=Na0*((270.16-temp)**(1.3))
  else
     Naero=0.0
  end if

  return

end function Naero


real function Dbc( qc, rhob )
! ñʬʬۤαʿľ¤׻. (4.51)
  use Cloud_Const
  use Thermo_Const
  use Math_Const
  implicit none
  real, intent(in) :: qc     ! 庮 [kg/kg]
  real, intent(in) :: rhob   ! ܾ̩ [kg/m3]
  real :: tmp

  tmp=6.0*rhob*qc/(pi*rhow*Nc)
  Dbc=exp((1.0/3.0)*log(tmp))

  return

end function Dbc


real function Dbi( qi, rhob, Ni )
! ñʬʬۤαɹʿľ¤׻. (4.52)
! Ni ۤͿʤ, temp, pres, qv Ǥ.
  use Cloud_Const
  use Thermo_Const
  use Math_Const
  implicit none
  real, intent(in) :: qi     ! ɹ [kg/kg]
  real, intent(in) :: rhob   ! ܾ̩ [kg/m3]
  real, intent(in), optional :: Ni     ! ɹοǻ [1/m3]
  real :: tmp, tmpNi

  if(present(Ni))then
     tmpNi=Ni
  else
     tmpNi=Ni_calc( qi )
  end if

  if(tmpNi>0.0)then
     tmp=6.0*rhob*qi/(pi*rhoi*tmpNi)
     Dbi=exp((1.0/3.0)*log(tmp))
  else
     Dbi=0.0
  end if

  return

end function Dbi


real function Ni_calc( qi )
! diagni.f90 Ѥ, ɹοǻ٤׻.
  use Cloud_Const
  use Thermo_Const
  implicit none
  real, intent(in) :: qi     ! ɹκ [kg/kg]

  Ni_calc=4.0*qi/(3.0*mi0max)  

  return

end function Ni_calc


!real function Ni_calc( temp, pres, qv )  Ѥʤ.
!! (4.75) Ѥ, ɹοǻ٤׻.
!  use Cloud_Const
!  use Thermo_Const
!  implicit none
!  real, intent(in) :: temp   !  [K]
!  real, intent(in) :: pres   !  [Pa]
!  real, intent(in) :: qv     !  [kg/kg]
!  real :: Si, temps, SSi, Swi, tmpa
!  
!  call ptcheck( temp )
!
!  Ni_calc=0.0
!
!  if(temp<=ti0)then
!     temps=ti0-temp
!     Si=qv/qvsi( temp, pres )
!     SSi=Si-1.0
!     Swi=qvss( temp, pres )/qvsi( temp, pres )
!     if(SSi>0.0)then
!        if(Swi>1.0)then
!           tmpa=(Si-1.0)/(Swi-1.0)
!           if(temp>=t0-5.0)then
!              Ni_calc=Ni01*exp(FLT2*temps)*exp(HVB*log(tmpa))
!           else
!              Ni_calc=Ni02*exp(Fea1*SSi-Feb1)
!           end if
!        end if
!     end if
!  end if
!
!  return
!
!end function Ni_calc


real function Koenig1( temp )
  implicit none
  real, intent(in) :: temp   !  [K]
  real :: tc
  real, dimension(32) :: param
  integer :: i

  call ptcheck( temp )

  param=(/0.0,  &
  &       7.939e-11,  &
  &       7.841e-10,  &
  &       3.369e-9,  &
  &       4.336e-9,  &
  &       5.285e-9,  &
  &       3.728e-9,  &
  &       1.852e-9,  &
  &       2.991e-10,  &
  &       4.248e-10,  &
  &       7.434e-10,  &
  &       1.812e-9,  &
  &       4.394e-9,  &
  &       9.145e-9,  &
  &       1.725e-10,  &
  &       3.348e-8,  &
  &       1.725e-8,  &
  &       9.175e-9,  &
  &       4.412e-9,  &
  &       2.252e-9,  &
  &       9.115e-10,  &
  &       4.876e-10,  &
  &       3.473e-10,  &
  &       4.758e-10,  &
  &       6.306e-10,  &
  &       8.573e-10,  &
  &       7.868e-10,  &
  &       7.192e-10,  &
  &       6.153e-10,  &
  &       5.956e-10,  &
  &       5.333e-10,  &
  &       4.834e-10 /)

  tc=temp-t0
  Koenig1=0.0

  if(tc<0.0)then
     do i=1,32
        if(temp>=-real(i).and.temp<-real(i-1))then
           Koenig1=param(i)
           exit
        end if
     end do
  end if

  return

end function Koenig1


real function Koenig2( temp )
  implicit none
  real, intent(in) :: temp   !  [K]
  real :: tc
  real, dimension(32) :: param
  integer :: i

  call ptcheck( temp )

  param=(/0.0,  &
  &       4.006e-1,  &
  &       4.831e-1,  &
  &       5.320e-1,  &
  &       5.307e-1,  &
  &       5.319e-1,  &
  &       5.249e-1,  &
  &       4.888e-1,  &
  &       3.894e-1,  &
  &       4.047e-1,  &
  &       4.318e-1,  &
  &       4.771e-1,  &
  &       5.183e-1,  &
  &       5.463e-1,  &
  &       5.651e-1,  &
  &       5.813e-1,  &
  &       5.655e-1,  &
  &       5.478e-1,  &
  &       5.203e-1,  &
  &       4.906e-1,  &
  &       4.447e-1,  &
  &       4.126e-1,  &
  &       3.960e-1,  &
  &       4.149e-1,  &
  &       4.320e-1,  &
  &       4.506e-1,  &
  &       4.483e-1,  &
  &       4.460e-1,  &
  &       4.433e-1,  &
  &       4.413e-1,  &
  &       4.382e-1,  &
  &       4.316e-1 /)

  tc=temp-t0
  Koenig2=0.0

  if(tc<0.0)then
     do i=1,32
        if(temp>=-real(i).and.temp<-real(i-1))then
           Koenig2=param(i)
           exit
        end if
     end do
  end if

  return

end function Koenig2


real function Exy( typexy, temp, pres, qc, qx, rhob, rho0, Nx )
! ʻˤªΨ.
  use Cloud_Const
  implicit none
  character(2), intent(in) :: typexy  ! ŷʪμ 'r' = , 's' = , 'g' = , 'c' = , 'i' = ɹ
  real, intent(in), optional :: temp !  [K]
  real, intent(in), optional :: pres !  [Pa]
  real, intent(in), optional :: qc     ! κ [kg/kg]
  real, intent(in), optional :: qx     ! ŷʪκ [kg/kg]
  real, intent(in), optional :: rhob   ! ܾ̩ [kg/m3]
  real, intent(in), optional :: rho0   ! Ͼˤܾ̩ [kg/m3]
  real, intent(in), optional :: Nx  ! qx Ȥŷʪοǻ
  real :: tmp_Stk

  if(typexy(1:1)=='c')then
     if(qc>=qthres.and.qx>=qthres)then
        if(present(Nx))then
           tmp_Stk=Stk( typexy(2:2), temp, pres, qc, qx, rhob, rho0, Nx )
        else
           tmp_Stk=Stk( typexy(2:2), temp, pres, qc, qx, rhob, rho0 )
        end if
        Exy=(tmp_Stk/(tmp_Stk+0.5))**2
     else
        Exy=0.0
     end if
  else if(typexy(1:1)=='r')then
     Exy=1.0
  else if(typexy(1:1)=='i')then
     if(typexy(2:2)=='g')then
        Exy=0.1
     else
        Exy=1.0
     end if
  else if(typexy(1:1)=='s')then
     if(typexy(2:2)=='g')then
        Exy=0.001
     else
        Exy=1.0
     end if
  else
     write(*,*) "ERROR (Exy) : typexy(1:1) is not valid ("//typexy(1:1)//")."
  end if

end function Exy


real function Stk( types, temp, pres, qc, qx, rhob, rho0, Nx )
! ȡ׻. (4.110)
  use Cloud_Const
  use Thermo_Const
  implicit none
  character(1), intent(in) :: types  ! ŷʪμ 'r' = , 's' = , 'g' = 
  real, intent(in) :: temp !  [K]
  real, intent(in) :: pres !  [Pa]
  real, intent(in) :: qc     ! κ [kg/kg]
  real, intent(in) :: qx     ! ŷʪκ [kg/kg]
  real, intent(in) :: rhob   ! ܾ̩ [kg/m3]
  real, intent(in) :: rho0   ! Ͼˤܾ̩ [kg/m3]
  real, intent(in), optional :: Nx  ! qx Ȥŷʪοǻ

  real :: tmpDbc, Dy, Uby, mu

  call ptcheck( temp )

  if(qc>=qthres.and.qx>=qthres)then
     tmpDbc=Dbc( qc, rhob )
     if(present(Nx))then
        Uby=UhxN( types(1:1), qx, rhob, rho0, Nx )
        Dy=1.0/lamx( types, qx, rhob, Nx )
     else
        Uby=UhxN( types(1:1), qx, rhob, rho0 )
        Dy=1.0/lamx( types, qx, rhob )
     end if
     mu=mu_air( temp, pres )

     Stk=tmpDbc*tmpDbc*rhow*Uby/(9.0*mu*Dy)

  else

     Stk=0.0

  end if

  return

end function Stk


real function Category_rs( qr, qs, rhob, Ns )
! ξ͸ʬ۷׻. (4.113)
  use Cloud_Const
  use Thermo_Const
  implicit none
  real, intent(in) :: qr  ! κ [kg/kg]
  real, intent(in) :: qs  ! κ [kg/kg]
  real, intent(in) :: rhob   ! ܾ̩ [kg/m3]
  real, intent(in), optional :: Ns  ! οǻ [1/m3]
  real :: lamdas, lamdar, mbr, mbs

  if(qr>=qthres.and.qs>=qthres)then
     if(present(Ns))then
        lamdas=lamx( 's', qs, rhob, Ns )
     else
        lamdas=lamx( 's', qs, rhob )
     end if

     lamdar=lamx( 'r', qr, rhob )
     mbr=rhow*exp(3.0*(log(4.0)-log(lamdar)))
     mbs=rhos*exp(3.0*(log(4.0)-log(lamdas)))

     Category_rs=mbs*mbs/(mbs*mbs+mbr*mbr)

  else

     Category_rs=0.0

  end if

  return

end function Category_rs


real function Gw( temp, pres, rhob )
  use Cloud_Const
  use Math_Const
  use Thermo_Const
  implicit none
  real, intent(in) :: temp  !  [K]
  real, intent(in) :: pres  !  [Pa]
  real, intent(in) :: rhob  ! ̩ [kg/m3]
  real :: tmpa, tmpb, tmpc, tmpd

  call ptcheck( temp )

  tmpa=Lv(temp)
  tmpb=kappaa*Rv*temp*temp
  tmpc=rhob*qvss(temp,pres)*Dv(temp,pres)
  tmpd=tmpa*tmpa/tmpb+1.0/tmpc
  Gw=1.0/tmpd

  return

end function Gw


real function Gi( temp, pres, rhob )
  use Cloud_Const
  use Math_Const
  use Thermo_Const
  implicit none
  real, intent(in) :: temp  !  [K]
  real, intent(in) :: pres  !  [Pa]
  real, intent(in) :: rhob  ! ̩ [kg/m3]
  real :: tmpa, tmpb, tmpc, tmpd

  call ptcheck( temp )

  tmpa=Ls(temp)
  tmpb=kappaa*Rv*temp*temp
  tmpc=rhob*qvsi(temp,pres)*Dv(temp,pres)
  tmpd=tmpa*tmpa/tmpb+1.0/tmpc
  Gi=1.0/tmpd

  return

end function Gi


real function VENTx( types, temp, pres, qx, rhob, rho0, Nx )
  use Cloud_Const
  use Math_Const
  use Thermo_Const
  implicit none
  character(1), intent(in) :: types  ! ŷʪμ 'r' = , 's' = , 'g' = 
  real, intent(in) :: temp  !  [K]
  real, intent(in) :: pres  !  [Pa]
  real, intent(in) :: qx    ! types κ [kg/kg]
  real, intent(in) :: rhob  ! ̩ [kg/m3]
  real, intent(in) :: rho0  ! ɽ̤Ǥδ̩ [kg/m3]
  real, intent(in), optional :: Nx    ! types οǻ [1/m3]
  real :: tmp, tmpa, tmpb, tmpc, aux, bux, ny0, lamdax

  call ptcheck( temp )

  if(qx>=qthres)then
     select case (types(1:1))
     case ('r')
        aux=aur
        bux=bur

     case ('s')
        aux=aus
        bux=bus

     case ('g')
        aux=aug
        bux=bug

     end select

     if(present(Nx))then
        lamdax=lamx( types(1:1), qx, rhob, Nx )
        ny0=nx0( types(1:1), qx, rhob, Nx )
     else
        lamdax=lamx( types(1:1), qx, rhob )
        ny0=nx0( types(1:1), qx, rhob )
     end if

     tmp=0.5*(5.0+bux)
     tmpa=0.78*exp(-2.0*log(lamdax))
     tmpb=0.31*(Sc**(1.0/3.0))*sqrt(aux/nu_air( temp, pres ))  &
  &       *gamma_func(tmp)*sqrt(sqrt(rho0/rhob))
     tmpc=exp(-tmp*log(lamdax))
     VENTx=ny0*(tmpa+tmpb*tmpc)

  else

     VENTx=0.0

  end if

  return

end function VENTx


real function UbxN( types, qx, rhob, rho0, Nx )
! ǻ٤νŤߤ򤫤ƥ꡼ x νü®٤׻.
! ǻ٤ʤ, y ҤͤǲꤷƷ׻.
  use Math_Const
  use Cloud_Const
  use Thermo_Const
  implicit none
  character(1), intent(in) :: types  ! ŷʪμ 'r' = , 's' = , 'g' = 
  real, intent(in) :: qx     ! ŷʪκ [kg/kg]
  real, intent(in) :: rhob   ! ܾ̩ [kg/m3]
  real, intent(in) :: rho0   ! Ͼˤܾ̩ [kg/m3]
  real, intent(in), optional :: Nx  ! qx Ȥŷʪοǻ
  real :: tmpa, tmpb, tmpc, lamxx

  if(qx>=qthres)then
     if(present(Nx))then
        lamxx=lamx( types(1:1), qx, rhob, Nx )
     else
        lamxx=lamx( types(1:1), qx, rhob )
     end if

     select case (types(1:1))  ! 'r'  Nx ȤʤΤ, ʬʤ.
     case ('r')
        tmpa=aur*gamma_func(1.0+bur)
        tmpb=exp(-bur*log(lamxx))
        tmpc=(rho0/rhob)**(cur)
     case ('s')
        tmpa=aus*gamma_func(1.0+bus)
        tmpb=exp(-bus*log(lamxx))
        tmpc=(rho0/rhob)**(cus)
     case ('g')
        tmpa=aug*gamma_func(1.0+bug)
        tmpb=exp(-bug*log(lamxx))
        tmpc=(rho0/rhob)**(cug)
     end select

     UbxN=tmpa*tmpc*tmpb

  else

     UbxN=0.0

  end if

  return

end function UbxN


subroutine ptcheck( temp )
  implicit none
  real, intent(in) :: temp  !  [K]

  if(temp>1000.0)then
     write(*,*) "ERROR ptcheck", temp
     stop
  end if

end subroutine ptcheck


real function UhxN( types, qx, rhob, rho0, Nx )
! ̤νŤߤ򤫤ƥ꡼ x νü®٤׻.
! ǻ٤ʤ, y ҤͤǲꤷƷ׻.
  use Math_Const
  use Cloud_Const
  use Thermo_Const
  implicit none
  character(1), intent(in) :: types  ! ŷʪμ 'r' = , 's' = , 'g' = 
  real, intent(in) :: qx     ! ŷʪκ [kg/kg]
  real, intent(in) :: rhob   ! ܾ̩ [kg/m3]
  real, intent(in) :: rho0   ! Ͼˤܾ̩ [kg/m3]
  real, intent(in), optional :: Nx  ! qx Ȥŷʪοǻ
  real :: tmpa, tmpb, tmpc, lamxx

  if(qx>=qthres)then

     if(present(Nx))then
        lamxx=lamx( types(1:1), qx, rhob, Nx )
     else
        lamxx=lamx( types(1:1), qx, rhob )
     end if

     select case (types(1:1))  ! 'r'  Nx ȤʤΤ, ʬʤ.
     case ('r')
        tmpa=aur*gamma_func(4.0+bur)
        tmpb=exp(-(log(6.0)+bur*log(lamxx)))
        tmpc=(rho0/rhob)**(cur)
     case ('s')
        tmpa=aus*gamma_func(4.0+bus)
        tmpb=exp(-(log(6.0)+bus*log(lamxx)))
        tmpc=(rho0/rhob)**(cus)
     case ('g')
        tmpa=aug*gamma_func(4.0+bug)
        tmpb=exp(-(log(6.0)+bug*log(lamxx)))
        tmpc=(rho0/rhob)**(cug)
     end select

     UhxN=tmpa*tmpc*tmpb

  else

     UhxN=0.0

  end if

  return

end function UhxN


real function gamma_func(x)
! ޴ؿ׻.
! ˤϡִȿظüؿp.5פζ¿༰.
! ζ 0<=x<=1 ǤȤʤΤ, ޴ؿ
! $z\Gamma (z)=\Gamma (z+1)$ ǶŬϰϤȤ.
! z>1.0 ξ,
! $\Gamma (z)=(z-1)\Gamma (z-1)=\cdots =(z-1)\cdots (x)\Gamma (x)$
! z<0.0 ξ,
! $\Gamma (z)=\Gamma (z+1)/z=\cdots =\Gamma (x)/(z\cdots x)$
! ޤ, ޴ؿ, ǤϷ׻ȥåפ褦.

  implicit none
  real, intent(in) :: x
  real :: tmp, intg
  real :: coe(8)
  integer :: i
  intrinsic :: aint

  if(x<0.0.and.x==aint(x))then
     write(*,*) "*** Error ***"
     write(*,*) " The agreement of Gamma function must not be negative and integer."
     write(*,*) "Stop"
     stop
  end if

  coe=(/-0.577191652, 0.988205891, -0.897056937, 0.918206857,  &
  &     -0.756704078, 0.482199394, -0.193527818, 0.035868343 /)

  if(abs(x)>1.0)then
     intg=aint(abs(x))  ! ʲڤΤ
     if(x>1.0)then  ! Ƚ
        tmp=x-intg
     else
        tmp=x+1.0+intg  ! 0 ޤΤ +1.
     end if
  else
     tmp=x
  end if

  gamma_func=1.0

  do i=1,8
     gamma_func=gamma_func+coe(i)*(tmp**i)
  end do

  if(abs(x)>1.0)then  ! ޴ؿˤ׻
     tmp=x
     do while(tmp>1.0.or.tmp<0.0)
        if(x>1.0)then
           gamma_func=gamma_func*tmp
           tmp=tmp-1.0
        else
           gamma_func=gamma_func/tmp
           tmp=tmp+1.0
        end if
     end do
  end if

  return
end function


real function Tq_2_Trho( T, qv, qo )
! ٤ȿʪ̩ٲ٤׻.
  use Thermo_Const
  implicit none
  real, intent(in) :: T  !  [K]
  real, intent(in) :: qv  !  [kg/kg]
  real, intent(in), optional :: qo(:)  ! ʳοŷʪ [kg/kg]
                   ! ŷʪΥƥϤǤ⹽ʤ.
  integer :: i, n
  real :: tmpq

  if(present(qo))then
     n=size(qo)
     tmpq=qv
     do i=1,n
        tmpq=tmpq+qo(i)
     end do
  else
     tmpq=qv
  end if

  Tq_2_Trho=T*(1.0+qv*Rv/Rd)/(1.0+tmpq)

  return
end function


real function TP_2_rho( T, P )
! 絤ξ, ٤ȵͿ̩٤.
  use Thermo_Const
  implicit none
  real, intent(in) :: T    ! 絤β [K]
  real, intent(in) :: P    ! 絤ΰ [Pa]

  TP_2_rho=p/(Rd*T)

  return
end function


real function thetaP_2_T(theta,P)  ! , Ϥ鲹٤׻(絤ȤƷ׻)
  use Thermo_Const
  implicit none
  real, intent(in) :: theta  !  [K]
  real, intent(in) :: P  ! 絤 [Pa]
  real :: kappa

  kappa=Rd/Cpd

  thetaP_2_T=theta*(P/p0)**kappa

  return
end function


real function exner_func_dry(P)  ! 絤ˤĤƤΥʡؿ׻
  use Thermo_Const
  implicit none
  real, intent(in) :: P  !  [Pa]
  real :: kappa

  kappa=Rd/Cpd
  exner_func_dry=(P/p0)**kappa

  return
end function


subroutine Moist_Sature_Adjust( pres, pt, qv, qc, err )
  use Thermo_Const
  implicit none
  real, intent(in) :: pres !  [Pa]
  real, intent(inout) :: pt   !  [K]
  real, intent(inout) :: qv   !  [kg kg-1]
  real, intent(inout) :: qc   ! 庮 [kg kg-1]
  real, intent(in), optional :: err  ! convergence limit [default = 1.0e-8]
  real :: tmppt, tmpqv, tmpqc, dqc, temp, gam, coe, pt1, qv1, qc1, err_max
  real :: tmp_err

  if(qv<0.0.or.qc<0.0)then
     write(*,*) "ERROR : Argument in Moist_Sature_Adjust must be greater than zero."
     write(*,*) "STOP."
     stop
  end if

  if(present(err))then
     err_max=err
  else
     err_max=1.0e-8
  end if

  temp=thetaP_2_T( pt, pres )
  dqc=qv-qvss( temp, pres )
  gam=Lv( temp )/(Cpd*exner_func_dry( pres ))
  pt1=pt
  qv1=qv
  qc1=qc


  do while (dqc>0.0.or.qc>0.0)
     coe=qvss( temp, pres )*  &
  &      (Cpd/(pt1*Rd)+17.269*(t0-35.86)/(exner_func_dry( pres )*(temp-t0)**2))
     tmppt=pt1+gam*(dqc)/(1.0+gam*coe)
     tmpqv=qv1+(pt1-tmppt)/gam
     tmpqc=qv1+qc1-tmpqv
     if(tmpqc>0.0)then
        pt1=tmppt
        qv1=tmpqv
        qc1=tmpqc
     else if(tmpqc<=0.0)then
        pt1=pt1-gam*qc1
        qv1=qv1+qc1
        qc1=0.0
        exit
     end if
     temp=thetaP_2_T( pt1, pres )
     dqc=qv1-qvss( temp, pres )

     tmp_err=abs(tmppt-pt1)
     if(err_max>tmp_err)then
        exit
     end if
  end do

  pt=pt1
  qv=qv1
  qc=qc1


end subroutine Moist_Sature_Adjust


subroutine Moist_Sature_Adjust_Ice( pres, pt, qv, qi, err )
  use Thermo_Const
  implicit none
  real, intent(in) :: pres !  [Pa]
  real, intent(inout) :: pt   !  [K]
  real, intent(inout) :: qv   !  [kg kg-1]
  real, intent(inout) :: qi   ! ɹ [kg kg-1]
  real, intent(in), optional :: err  ! convergence limit [default = 1.0e-8]
  real :: tmppt, tmpqv, tmpqi, dqi, temp, gam, coe, pt1, qv1, qi1, err_max
  real :: tmp_err

  if(qv<0.0.or.qi<0.0)then
     write(*,*) "ERROR : Argument in Moist_Sature_Adjust must be greater than zero."
     write(*,*) "STOP."
     stop
  end if

  if(present(err))then
     err_max=err
  else
     err_max=1.0e-8
  end if

  temp=thetaP_2_T( pt, pres )
  dqi=qv-qvsi( temp, pres )
  gam=Lf( temp )/(Cpd*exner_func_dry( pres ))
  pt1=pt
  qv1=qv
  qi1=qi

  do while (dqi>0.0.or.qi>0.0.or.temp<ti0)
     coe=qvsi( temp, pres )*  &
  &      (Cpd/(pt1*Rd)+21.875*(t0-7.86)/(exner_func_dry( pres )*(temp-t0)**2))
     tmppt=pt1+gam*(dqi)/(1.0+gam*coe)
     tmpqv=qv1+(pt1-tmppt)/gam
     tmpqi=qv1+qi1-tmpqv
     if(tmpqi>0.0)then
        pt1=tmppt
        qv1=tmpqv
        qi1=tmpqi
     else if(tmpqi<=0.0)then
        pt1=pt1-gam*qi1
        qv1=qv1+qi1
        qi1=0.0
        exit
     end if
     temp=thetaP_2_T( pt1, pres )
     dqi=qv1-qvsi( temp, pres )

     tmp_err=abs(tmppt-pt1)
     if(err_max>tmp_err)then
        exit
     end if
  end do

  pt=pt1
  qv=qv1
  qi=qi1


end subroutine Moist_Sature_Adjust_Ice



end module
