module fft_read_namelist

  use fft_saveval_define

  implicit none

contains

subroutine fft_read_name()

  use fft_saveval_define

  namelist /input /nxi, nyi, hxnt, hynt, nt, Lx, Ly, dt,  &
  &                dmpstp, ininame, inix, iniy, iniz, inixd, iniyd,  &
  &                foname, time_flag, nu
  namelist /restart /resopt, resfname, restp
  read(5,nml=input)
  read(5,nml=restart)

  nx=hxnt*2+1
  ny=hynt*2+1
  jxnt=hxnt*3+1
  jynt=hynt*3+1
  dx=Lx/dble(nx-1)
  dy=Ly/dble(ny-1)
  xmin=0.0d0
  ymin=0.0d0

end subroutine fft_read_name

end module fft_read_namelist
