program solver
! Rotunno and Emanuel (1987)  2 оΥǥ
  use gtool_history
  use Derivation
  use max_min
  use Statistics
  use Math_Const
  use Phys_Const
  use file_operate
  use Basis
  use val_define
  use read_namelist
  use val_alloc
  use val_init
  use val_coord
  use time_scheme
  use make_init
  use sub_calc
  use force_solv

  implicit none

!-- do loop ѿ
  integer :: i, j, it, im, ns
  type(GT_HISTORY) :: d3_hst, d2_hst

!-- namelist ɤ߹

  call read_name()

!-- allocating array

  call val_allocate()
  call val_initialize()

!-- ʻκ

  call val_coordinate()

  write(*,*) "starting initialization."

!-- ͺ

  call make_initialize()

  write(*,*) "normally pass the initialization."

  ns=int(dtb/dts)    ! small step number
  Tsurf=Ts           ! surface constant temperature.
!  alpha=5.0e-6*dr*dr/dts

!-- ϥեν
  call HistoryCreate( file=trim(foname), title='RE87 result data', &
  & source='test', institution='test', dims=(/'r', 'z', 't'/),  &
  & dimsizes=(/nr, nz, 0/),  & 
  & longnames=(/'R-coordinate','Z-coordinate', 'time        '/),  &
  & units=(/'m', 'm', 's'/), origin=0.0, interval=dmpstp*dtb,  &
  & history=d3_hst )
  
  call HistoryCreate( file=trim(foname)//'.mon', title='RE87 surface data', &
  & source='test', institution='test', dims=(/'r', 't'/),  &
  & dimsizes=(/nr, 0/),  & 
  & longnames=(/'R-coordinate', 'time        '/),  &
  & units=(/'m', 's'/), origin=0.0, interval=dmpstp*dtb,  &
  & history=d2_hst )
  
  call HistoryPut( 'r', r_s(1:nr), history=d3_hst )
  call HistoryPut( 'z', z_s(1:nz), history=d3_hst )
  
  call HistoryPut( 'r', r_s(1:nr), history=d2_hst )

  call HistoryAddVariable( varname='u', dims=(/'r','z','t'/), &
    & longname='R wind', units='m s-1', xtype='float', history=d3_hst )
  call HistoryAddVariable( varname='v', dims=(/'r','z','t'/), &
    & longname='T wind', units='m s-1', xtype='float', history=d3_hst )
  call HistoryAddVariable( varname='w', dims=(/'r','z','t'/), &
    & longname='Z wind', units='m s-1', xtype='float', history=d3_hst )
  call HistoryAddVariable( varname='p', dims=(/'r','z','t'/), &
    & longname='Pressure', units='Pa', xtype='float', history=d3_hst )
  call HistoryAddVariable( varname='pt', dims=(/'r','z','t'/), &
    & longname='Potential Temperature', units='K', xtype='float',  &
    & history=d3_hst )
  call HistoryAddVariable( varname='qv', dims=(/'r','z','t'/), &
    & longname='Vapor Mixing Ratio', units='kg kg-1', xtype='float',  &
    & history=d3_hst )
  call HistoryAddVariable( varname='qc', dims=(/'r','z','t'/), &
    & longname='Cloud Mixing Ratio', units='kg kg-1', xtype='float',  &
    & history=d3_hst )
  call HistoryAddVariable( varname='ql', dims=(/'r','z','t'/), &
    & longname='Liquid Mixing Ratio', units='kg kg-1', xtype='float',  &
    & history=d3_hst )

  call HistoryAddVariable( varname='us', dims=(/'r','t'/), &
    & longname='R surface wind', units='m s-1', xtype='float', history=d2_hst )
  call HistoryAddVariable( varname='vs', dims=(/'r','t'/), &
    & longname='T surface wind', units='m s-1', xtype='float', history=d2_hst )
!  call HistoryAddVariable( varname='ws', dims=(/'r','t'/), &
!    & longname='Z wind', units='m s-1', xtype='float', history=d2_hst )
  call HistoryAddVariable( varname='ps', dims=(/'r','t'/), &
    & longname='surface pressure', units='Pa', xtype='float', history=d2_hst )
  call HistoryAddVariable( varname='pts', dims=(/'r','t'/), &
    & longname='surface Potential Temperature', units='K', xtype='float',  &
    & history=d2_hst )
  call HistoryAddVariable( varname='qvs', dims=(/'r','t'/), &
    & longname='surface Vapor Mixing Ratio', units='kg kg-1', xtype='float',  &
    & history=d2_hst )

  write(*,*) "time integration start."

  !-- ν (ͤν)

  write(*,*) "*******************************************"
  write(*,*) "File damp (time =", 0.0, "[s])."
  write(*,*) "*******************************************"

  call dmp_val( r_u, r_s, z_w, z_s, u_old,  &
  &             v_old, w_old, p_old, pb_s, t_old, qv_old, qc_old, ql_old,  &
  &             u_dmp, v_dmp, w_dmp, p_dmp, t_dmp, qv_dmp, qc_dmp, ql_dmp )

  call dmp_suf( z_s(1), u_dmp(1:nr,1), v_dmp(1:nr,1), w_dmp(1:nr,1),  &
  &             p_dmp(1:nr,1), t_dmp(1:nr,1), qv_dmp(1:nr,1),  &
  &             qc_dmp(1:nr,1), ql_dmp(1:nr,1), Tsurf(1:nr),  &
  &             us_dmp(1:nr), vs_dmp(1:nr), ws_dmp(1:nr), ps_dmp(1:nr),  &
  &             ts_dmp(1:nr), qvs_dmp(1:nr), qts_dmp(1:nr), qts_dmp(1:nr) )

  call HistoryPut( 'u', u_dmp(1:nr,1:nz), history=d3_hst )
  call HistoryPut( 'v', v_dmp(1:nr,1:nz), history=d3_hst )
  call HistoryPut( 'w', w_dmp(1:nr,1:nz), history=d3_hst )
  call HistoryPut( 'p', p_dmp(1:nr,1:nz), history=d3_hst )
  call HistoryPut( 'pt', t_dmp(1:nr,1:nz), history=d3_hst )
  call HistoryPut( 'qv', qv_dmp(1:nr,1:nz), history=d3_hst )
  call HistoryPut( 'qc', qc_dmp(1:nr,1:nz), history=d3_hst )
  call HistoryPut( 'ql', ql_dmp(1:nr,1:nz), history=d3_hst )

  call HistoryPut( 'us', us_dmp(1:nr), history=d2_hst )
  call HistoryPut( 'vs', vs_dmp(1:nr), history=d2_hst )
!  call HistoryPut( 'ws', ws_dmp(1:nr), history=d2_hst )
  call HistoryPut( 'ps', ps_dmp(1:nr), history=d2_hst )
  call HistoryPut( 'pts', ts_dmp(1:nr), history=d2_hst )
  call HistoryPut( 'qvs', qvs_dmp(1:nr), history=d2_hst )
!  call HistoryPut( 'qts', qts_dmp(1:nr), history=d2_hst )

!-- solver 

  do it=1,nt

     do im=1,ns
        call time_schematic( im, 's' )
     end do
     call time_schematic( it, 'b' )

  !-- ƥåפοʤ߶
     write(*,*) "This step is ", it, "(time =", real(it)*dtb, "[s])."

     !-- ν (2)
     if(mod(it,dmpstp)==0)then

        call dmp_val( r_u, r_s, z_w, z_s, u_old, v_old,  &
  &                   w_old, p_old, pb_s, t_old, qv_old, qc_old, ql_old,  &
  &                   u_dmp, v_dmp, w_dmp, p_dmp, t_dmp, qv_dmp, qc_dmp, ql_dmp )

        call dmp_suf( z_s(1), u_dmp(1:nr,1), v_dmp(1:nr,1), w_dmp(1:nr,1),  &
  &             p_dmp(1:nr,1), t_dmp(1:nr,1), qv_dmp(1:nr,1),  &
  &             qc_dmp(1:nr,1), ql_dmp(1:nr,1), Tsurf(1:nr),  &
  &             us_dmp(1:nr), vs_dmp(1:nr), ws_dmp(1:nr), ps_dmp(1:nr),  &
  &             ts_dmp(1:nr), qvs_dmp(1:nr), qts_dmp(1:nr), qts_dmp(1:nr) )

        write(*,*) "*******************************************"
        write(*,*) "File damp (time =", real(it)*dtb, "[s])."
        write(*,*) "*******************************************"

        call HistoryPut( 'u', u_dmp(1:nr,1:nz), history=d3_hst )
        call HistoryPut( 'v', v_dmp(1:nr,1:nz), history=d3_hst )
        call HistoryPut( 'w', w_dmp(1:nr,1:nz), history=d3_hst )
        call HistoryPut( 'p', p_dmp(1:nr,1:nz), history=d3_hst )
        call HistoryPut( 'pt', t_dmp(1:nr,1:nz), history=d3_hst )
        call HistoryPut( 'qv', qv_dmp(1:nr,1:nz), history=d3_hst )
        call HistoryPut( 'qc', qc_dmp(1:nr,1:nz), history=d3_hst )
        call HistoryPut( 'ql', ql_dmp(1:nr,1:nz), history=d3_hst )

        call HistoryPut( 'us', us_dmp(1:nr), history=d2_hst )
        call HistoryPut( 'vs', vs_dmp(1:nr), history=d2_hst )
!        call HistoryPut( 'ws', ws_dmp(1:nr), history=d2_hst )
        call HistoryPut( 'ps', ps_dmp(1:nr), history=d2_hst )
        call HistoryPut( 'pts', ts_dmp(1:nr), history=d2_hst )
        call HistoryPut( 'qvs', qvs_dmp(1:nr), history=d2_hst )
!        call HistoryPut( 'qts', qts_dmp(1:nr), history=d2_hst )

     end if

  end do

!-- solver ȥå

  write(*,*) "solver is normally."

end program
