require "numru/netcdf"
include NumRu
include NMath

# perturbations of vx, vy are given as vt (azimuthal velocity).
# V = vx*ex+vy*ey = vr*er+vt*et
# Now, vr is zero, so V = vt*et
# let be k vertical unit vector, et = er x k.
# let be R vector of position, er = R/|R|.
# So, V = (vt/|R|) * (R x k).
# Where R = x*ex+y*ey.
# Thus, V = (vt/|R|) * ( (x*ex+y*ey) x k ) = (vt/|R|) * (y*ex-x*ey)
# Therefore, vx = C*y, vy = -C*x, where C = vt/|R|

nx = 1000
ny = 1000
fname = 'init.dat'
mean_height = 0.0
meanu_flow = 0.0
meanv_flow = 0.0
pert_height = 10.0
pertu_flow = 0.0
pertv_flow = 0.0
pertvr_max = 0.0   # RMW = (inix[nx]-inix[1])*pertvr_max

inix = NArray.sfloat(nx).indgen(0.0)
tmpx = inix[nx/2]
for i in 0..nx-1
   inix[i] = nx * (inix[i] - tmpx)
end
#inix = inix * nx
iniy = NArray.sfloat(ny).indgen(0.0)
tmpy = iniy[ny/2]
for i in 0..ny-1
   iniy[i] = ny * (iniy[i] - tmpy)
end
#iniy = iniy * ny
hei = NArray.sfloat(nx,ny)
ubar = NArray.sfloat(nx,ny)
vbar = NArray.sfloat(nx,ny)
ini_h = NArray.sfloat(nx,ny)
ini_u = NArray.sfloat(nx,ny)
ini_v = NArray.sfloat(nx,ny)

tmpr = 0.0
tmpt = 0.0
tmpva = 0.0
pert_rmw = (inix[nx-1]-inix[0])*pertvr_max
pertva = sqrt(pertu_flow**2+pertv_flow**2)

hei[0..nx-1,0..ny-1] = 0.0
ini_h[0..nx-1,0..ny-1] = 0.0
ini_u[0..nx-1,0..ny-1] = 0.0
ini_v[0..nx-1,0..ny-1] = 0.0

for j in 0..ny-1
   for i in 0..nx-1
#      if (((inix[i]-inix[nx/2])**2+(iniy[j]-iniy[ny/2])**2)**0.5<10.0*nx) then
#         ini[i,j] = 1.0
#      end
      ini_h[i,j]=pert_height*exp(-0.01*((inix[i]/nx)**2+(iniy[j]/ny)**2))
      ini_u[i,j]=pertu_flow*exp(-0.01*((inix[i]/nx)**2+(iniy[j]/ny)**2))
      ini_v[i,j]=pertv_flow*exp(-0.01*((inix[i]/nx)**2+(iniy[j]/ny)**2))
      tmpr = sqrt((inix[i]-inix[nx/2])**2+(iniy[j]-iniy[ny/2])**2)
      tmpva = pertva*exp(-0.01*((tmpr-pert_rmw)/nx)**2)
      hei[i,j]=mean_height+100.0*exp(-0.25*((inix[i]/nx)**2+(iniy[j]/ny)**2))
#      hei[i,j]=mean_height
      ubar[i,j]=meanu_flow
      vbar[i,j]=meanv_flow
   end
end

f = NetCDF.create(fname)
f.def_dim('x',nx)
f.def_dim('y',ny)
require 'date'
f.put_att('history','created by #{$0} #{Date.today}')
x = f.def_var('x','sfloat',['x'])
y = f.def_var('y','sfloat',['y'])

h = f.def_var('h','sfloat',['x','y'])
h.put_att('long_name','surface height')
h.put_att('units','m')
ht = f.def_var('ht','sfloat',['x','y'])
ht.put_att('long_name','height')
ht.put_att('units','m')
ub = f.def_var('ub','sfloat',['x','y'])
ub.put_att('long_name','ubar')
ub.put_att('units','m s-1')
vb = f.def_var('vb','sfloat',['x','y'])
vb.put_att('long_name','vbar')
vb.put_att('units','m s-1')
val1 = f.def_var('u','sfloat',['x','y'])
val1.put_att('long_name','zonal wind')
val1.put_att('units','m s-1')
val2 = f.def_var('v','sfloat',['x','y'])
val2.put_att('long_name','meridional wind')
val2.put_att('units','m s-1')
f.enddef

x.put(inix)
y.put(iniy)
h.put(ini_h)
ht.put(hei)
ub.put(ubar)
vb.put(vbar)
val1.put(ini_u)
val2.put(ini_v)

f.close
