module val_alloc
! 変数の定義
! 変数名の命名規則
! 実数 -> r, 純虚数 -> i, 複素数 -> c
! 平均場 -> b, 擾乱場 -> p
! 時間発展 -> old, new

  use val_define
  use read_namelist
  use mpi

  implicit none

contains

subroutine val_allocate()

  implicit none

  allocate(ri(nr))  ! スカラー動径座標初期値
  allocate(rs(nr))  ! スカラー動径座標
  allocate(rv(nr))  ! ベクトル動径座標
  allocate(theta(ntheta))  ! 接線座標
  allocate(hb(nr))  ! ジオポテンシャル平均場
  allocate(ub(nr))  ! 動径風平均場
  allocate(vb(nr))  ! 接線風平均場
  allocate(hib(nr))  ! 初期ジオポテンシャル平均場
  allocate(uib(nr))  ! 初期動径風平均場
  allocate(vib(nr))  ! 初期接線風平均場
  allocate(dhbdr(nr))  ! ジオポテンシャル平均場
  allocate(dubdr(nr))  ! 動径風平均場
  allocate(dvbdr(nr))  ! 接線風平均場
  allocate(ubdub(nr))
  allocate(ubdvb(nr))
  allocate(ubdhb(nr))
  allocate(vbdub(nr))
  allocate(vbdvb(nr))
  allocate(vbdhb(nr))
  allocate(hbdub(nr))
  allocate(hbdvb(nr))
  allocate(hbdhb(nr))
  allocate(epsu(nr))  ! レイリーダンピング係数 u
  allocate(epsv(nr))  ! レイリーダンピング係数 v
  allocate(epsh(nr))  ! レイリーダンピング係数 h
!-- 2d val
  allocate(urp_dmp(nr,ntheta))  ! 動径風速 dmp
  allocate(vrp_dmp(nr,ntheta))  ! 接線風速 dmp
  allocate(hrp_dmp(nr,ntheta))  ! ジオポテンシャル dmp
  allocate(urp_new(nr,ntheta))  ! 動径風速 new
  allocate(vrp_new(nr,ntheta))  ! 接線風速 new
  allocate(hrp_new(nr,ntheta))  ! ジオポテンシャル new
  allocate(uip_new(nr,ntheta))  ! 動径風速 new
  allocate(vip_new(nr,ntheta))  ! 接線風速 new
  allocate(hip_new(nr,ntheta))  ! ジオポテンシャル new
  allocate(durpdr(nr,ntheta))
  allocate(dvrpdr(nr,ntheta))
  allocate(dhrpdr(nr,ntheta))
  allocate(duipdr(nr,ntheta))
  allocate(dvipdr(nr,ntheta))
  allocate(dhipdr(nr,ntheta))
  allocate(coril(nr,ntheta))

!-- complex, save part
!-- 回転行列はすべて, ここより先に割付しておく

  allocate(ucp_dmp(nr,ntheta))  ! 動径風速 old
  allocate(vcp_dmp(nr,ntheta))  ! 接線風速 old
  allocate(hcp_dmp(nr,ntheta))  ! ジオポテンシャル old
  allocate(ucp_tmp(nr,ntheta))  ! 動径風速 old
  allocate(vcp_tmp(nr,ntheta))  ! 接線風速 old
  allocate(hcp_tmp(nr,ntheta))  ! ジオポテンシャル old
  allocate(ucp_old(nr,ntheta))  ! 動径風速 old
  allocate(vcp_old(nr,ntheta))  ! 接線風速 old
  allocate(hcp_old(nr,ntheta))  ! ジオポテンシャル old
  allocate(ucp_new(nr,ntheta))  ! 動径風速 new
  allocate(vcp_new(nr,ntheta))  ! 接線風速 new
  allocate(hcp_new(nr,ntheta))  ! ジオポテンシャル new
  allocate(ducpdr(nr,ntheta))
  allocate(dvcpdr(nr,ntheta))
  allocate(dhcpdr(nr,ntheta))
  allocate(updup(nr,ntheta))  ! updup
  allocate(updvp(nr,ntheta))  ! updvp
  allocate(updhp(nr,ntheta))  ! updhp
  allocate(vpdup(nr,ntheta))  ! vpdup
  allocate(vpdvp(nr,ntheta))  ! vpdvp
  allocate(vpdhp(nr,ntheta))  ! vpdhp
  allocate(hpdup(nr,ntheta))  ! hpdup
  allocate(hpdvp(nr,ntheta))  ! hpdvp
  allocate(hpdhp(nr,ntheta))  ! hpdhp
  allocate(ubdup(nr,ntheta))  ! ubdup
  allocate(ubdvp(nr,ntheta))  ! ubdvp
  allocate(ubdhp(nr,ntheta))  ! ubdhp
  allocate(vbdup(nr,ntheta))  ! vbdup
  allocate(vbdvp(nr,ntheta))  ! vbdvp
  allocate(vbdhp(nr,ntheta))  ! vbdhp
  allocate(hbdup(nr,ntheta))  ! hbdup
  allocate(hbdvp(nr,ntheta))  ! hbdvp
  allocate(hbdhp(nr,ntheta))  ! hbdhp
  allocate(updub(nr,ntheta))  ! updub
  allocate(updvb(nr,ntheta))  ! updvb
  allocate(updhb(nr,ntheta))  ! updhb
  allocate(vpdub(nr,ntheta))  ! vpdub
  allocate(vpdvb(nr,ntheta))  ! vpdvb
  allocate(vpdhb(nr,ntheta))  ! vpdhb
  allocate(hpdub(nr,ntheta))  ! hpdub
  allocate(hpdvb(nr,ntheta))  ! hpdvb
  allocate(hpdhb(nr,ntheta))  ! hpdhb
  allocate(ubup(nr,ntheta))  ! ubup
  allocate(ubvp(nr,ntheta))  ! ubvp
  allocate(ubhp(nr,ntheta))  ! ubhp
  allocate(upvp(nr,ntheta))  ! upvp
  allocate(uphp(nr,ntheta))  ! uphp
  allocate(vbup(nr,ntheta))  ! vbup
  allocate(vbvp(nr,ntheta))  ! vbvp
  allocate(vbhp(nr,ntheta))  ! vbhp
  allocate(vpup(nr,ntheta))  ! vpup
  allocate(vpvp(nr,ntheta))  ! vpvp
  allocate(hbup(nr,ntheta))  ! hbup
  allocate(hbvp(nr,ntheta))  ! hbvp
  allocate(hbhp(nr,ntheta))  ! hbhp
  allocate(hpup(nr,ntheta))  ! hpup
  allocate(hpvp(nr,ntheta))  ! hpvp
  allocate(forceu(nr,ntheta))  ! forceu
  allocate(forcev(nr,ntheta))  ! forcev
  allocate(forceh(nr,ntheta))  ! forceh
  allocate(forceua(nr,ntheta))  ! forceu
  allocate(forceva(nr,ntheta))  ! forcev
  allocate(forceha(nr,ntheta))  ! forceh
  allocate(eup(nr,ntheta))  ! レイリーダンピング項 u
  allocate(evp(nr,ntheta))  ! レイリーダンピング項 v
  allocate(ehp(nr,ntheta))  ! レイリーダンピング項 h
  allocate(corilu(nr,ntheta))  ! コリオリ項 u
  allocate(corilv(nr,ntheta))  ! コリオリ項 v
  allocate(fup(nr,jnt))
  allocate(fvp(nr,jnt))
  allocate(fhp(nr,jnt))
  allocate(fdupdr(nr,jnt))
  allocate(fdvpdr(nr,jnt))
  allocate(fdhpdr(nr,jnt))
  allocate(fdupdt(nr,jnt))
  allocate(fdvpdt(nr,jnt))
  allocate(fdhpdt(nr,jnt))
  allocate(frup(nr,jnt))
  allocate(frvp(nr,jnt))
  allocate(frhp(nr,jnt))
  allocate(frdupdr(nr,jnt))
  allocate(frdvpdr(nr,jnt))
  allocate(frdhpdr(nr,jnt))
  allocate(frdupdt(nr,jnt))
  allocate(frdvpdt(nr,jnt))
  allocate(frdhpdt(nr,jnt))
  allocate(fupvp(nr,jnt))
  allocate(fuphp(nr,jnt))
  allocate(fvpvp(nr,jnt)) 
  allocate(fupdup(nr,jnt))
  allocate(fupdvp(nr,jnt))
  allocate(fupdhp(nr,jnt))
  allocate(fvpdup(nr,jnt))
  allocate(fvpdvp(nr,jnt))
  allocate(fvpdhp(nr,jnt))
  allocate(fhpdup(nr,jnt))
  allocate(fhpdvp(nr,jnt))
  allocate(fhpdhp(nr,jnt))
  allocate(fiupvp(nr,jnt))
  allocate(fiuphp(nr,jnt))
  allocate(fivpvp(nr,jnt)) 
  allocate(fiupdup(nr,jnt))
  allocate(fiupdvp(nr,jnt))
  allocate(fiupdhp(nr,jnt))
  allocate(fivpdup(nr,jnt))
  allocate(fivpdvp(nr,jnt))
  allocate(fivpdhp(nr,jnt))
  allocate(fihpdup(nr,jnt))
  allocate(fihpdvp(nr,jnt))
  allocate(termu(nr,ntheta))  ! u term
  allocate(termv(nr,ntheta))  ! v term
  allocate(termh(nr,ntheta))  ! h term

  coril=1.0e-5

end subroutine val_allocate

end module
