!= O3 ʬۤ
!
!= Set O3 distribution
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: set_o3.f90,v 1.1 2010-01-11 01:48:47 yot Exp $
! Tag Name::  $Name: dcpam5-20100224 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module set_o3
  !
  != O3 ʬۤ
  !
  != Set O3 distribution
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! O3 ʬ.
  !
  ! Set O3 distribution. 
  !
  !== References
  !
!!$  !  Roewe, D., and K.-N. Liou, Influence of cirrus clouds on the infrared cooling 
!!$  !    rate in the troposphere and lower stratosphere, J. Appl. Met., 17, 92-106, 1978.
  !
  !== Procedures List
  !
!!$  ! RadiationFluxDennouAGCM :: ͥեåη׻
!!$  ! RadiationDTempDt        :: ͥեåˤ벹Ѳη׻
!!$  ! RadiationFluxOutput     :: ͥեåν
!!$  ! RadiationFinalize       :: λ (⥸塼ѿγդ)
!!$  ! ------------            :: ------------
!!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
!!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
!!$  ! RadiationFluxOutput     :: Output radiation fluxes
!!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
  !
  !== NAMELIST
  !
!!$  ! NAMELIST#radiation_DennouAGCM_nml
  !

  ! USE statements
  !

  ! 
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! Double precision.
    &                 STRING, &  ! Strings.
    &                 TOKEN      ! Keywords.

  ! Declaration statements
  !
  implicit none
  private

  ! 
  ! Public procedure
  !
  public:: SetO3


  character(*), parameter:: module_name = 'set_o3'
                              ! ⥸塼̾.
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20100224 $' // &
    & '$Id: set_o3.f90,v 1.1 2010-01-11 01:48:47 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  logical          , save:: FlagO3

  character(STRING), save:: O3File

  logical          , save:: sw_fs

  data sw_fs /.true./


contains

  subroutine SetO3( &
    & xyz_Press, & ! (in )
    & xyz_QO3    & ! (out)
    & )


    ! USE statements
    !

    ! 
    ! Grid points settings
    !
    use gridset, only: imax, & ! 
                               ! Number of grid points in longitude
      &                jmax, & ! 
                               ! Number of grid points in latitude
      &                kmax    ! 
                               ! Number of vertical level

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable, HistoryAutoPut

    ! 
    ! Time control
    !
    use timeset, only: &
      & TimeN                   ! ƥå $ t $ λ.
                                ! Time of step $ t $.

    use read_time_series, only: SetValuesFromTimeSeriesWrapper

    real(DP), intent(in ):: xyz_Press(0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(out):: xyz_QO3  (0:imax-1, 1:jmax, 1:kmax)


    ! 
    ! Work variables
    !



    if ( sw_fs ) then
      call SetO3Init
    end if


    if ( FlagO3 ) then

      call SetValuesFromTimeSeriesWrapper( &
        & O3File, "O3",   &
        & xyz_Press,      &               ! (in)
        & xyz_QO3,        &               ! (inout)
        & "O3"            &
        & )

    else

      xyz_QO3 (:,:,:) = 0.0d0

    end if

    call HistoryAutoPut( TimeN, "O3", xyz_QO3 )


  end subroutine SetO3

  !**************************************************************************

  subroutine SetO3Init


    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    integer:: unit_nml        ! NAMELIST ե륪ץֹ.
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT.
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /set_O3_nml/ &
      & FlagO3,  &
      & O3File
          !
          ! ǥեͤˤĤƤϽ³ "radiation_DennouAGCM#RadiationInit"
          ! Υɤ򻲾ȤΤ.
          !
          ! Refer to source codes in the initialization procedure
          ! "radiation_DennouAGCM#RadiationInit" for the default values.
          !

    ! ǥեͤ
    ! Default values settings
    !

    FlagO3 = .false.

    O3File = ""


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml,                     & ! (in)
        & nml = set_O3_nml,               & ! (out)
        & iostat = iostat_nml )             ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if


    call HistoryAutoAddVariable( "O3",         & ! (in)
      & (/ 'lon ', 'lat ', 'sig ', 'time' /),  & ! (in)
      & "ozone", 'kg kg-1' )                     ! (in)

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  FlagO3 = %b', l = (/ FlagO3 /) )
    call MessageNotify( 'M', module_name, '  O3File = %c', c1 = trim( O3File ) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )


    sw_fs = .false.


  end subroutine SetO3Init

  !****************************************************************************

end module set_o3
