!= dcpam 絤ͥǥ Ver. 1
!
!= dcpam radiation model for the Mars' atmosphere Ver. 1
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: radiation_dcpam_M_V1.f90,v 1.6 2011-02-25 03:21:25 yot Exp $
! Tag Name::  $Name: dcpam5-20110228-4 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
module radiation_dcpam_M_V1
  !
  != dcpam 絤ͥǥ Ver. 1
  !
  != dcpam radiation model for the Mars' atmosphere Ver. 1
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ϵ絤ͥǥ.
  !
  ! This is a radiation model for the Mars' atmospehre.
  !
  ! Radiation in the wavenumber range from   40 to  2600 cm-1 
  ! is calculated in the routine of long wave radiation. 
  ! Radiation in the wavenumber range from 2600 to 66667 cm-1 (0.15 to 3.85 micron) 
  ! is calculated in the routine of shortwave radiation. 
  !
  !== References
  !
  !
  !== Procedures List
  !
!!$  ! RadiationFluxDennouAGCM :: ͥեåη׻
!!$  ! RadiationDTempDt        :: ͥեåˤ벹Ѳη׻
!!$  ! RadiationFluxOutput     :: ͥեåν
!!$  ! RadiationFinalize       :: λ (⥸塼ѿγդ)
!!$  ! ------------            :: ------------
!!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
!!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
!!$  ! RadiationFluxOutput     :: Output radiation fluxes
!!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
  !
  !== NAMELIST
  !
!!$  ! NAMELIST#radiation_DennouAGCM_nml
  !

  ! USE statements
  !

  !
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! Double precision.
    &                 STRING, &  ! Strings.
    &                 TOKEN      ! Keywords.

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ.
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ.
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ.
                             ! Number of vertical level

  implicit none

  private


  ! ѿ
  ! Public variables
  !
  logical, save, public:: radiation_dcpam_M_V1_inited = .false.
                              ! ե饰.
                              ! Initialization flag

  ! Private variables
  !

  real(DP), save :: SolarConst   ! Solar radiation at the distance of semi-major axis
  real(DP), save :: DOD067       ! Dust optical depth at 0.67 micron.
  real(DP), save :: DustVerDistCoef


  public :: RadiationDcpamMV1Flux

  character(*), parameter:: module_name = 'radiation_dcpam_M_V1'
                              ! ⥸塼̾.
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20110228-4 $' // &
    & '$Id: radiation_dcpam_M_V1.f90,v 1.6 2011-02-25 03:21:25 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  !--------------------------------------------------------------------------------------

contains

  !--------------------------------------------------------------------------------------

  subroutine RadiationDcpamMV1Flux(                                                &
    & xy_SurfAlbedo,                                                               &
    & xyz_Press, xyr_Press, xyz_Temp, xy_SurfTemp,  &
    & xyr_RadSFlux, xyr_RadLFlux, xyra_DelRadLFlux                                 &
    & )

    ! USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only : &
      & PI,               &
      & GasRDry

    ! 
    ! Time control
    !
    use timeset, only: &
      & TimeN, &              ! ƥå $ t $ λ.
                              ! Time of step $ t $.
      & DelTime, &            ! $ \Delta t $
      & TimesetClockStart, TimesetClockStop

    ! û ()
    ! Short wave (insolation) incoming
    !
    use radiation_short_income, only : ShortIncoming

    use radiation_dcpam_M_15m, only : rad15m_main

    ! ʹϢ롼
    ! Routines for radiation calculation
    !
    use radiation_utils, only : RadiationRTEQNonScatWrapper

    use radiation_two_stream_app, only : RadiationTwoStreamAppHomogAtm


    real(DP), intent(in ) :: xy_SurfAlbedo( 0:imax-1, 1:jmax )
    real(DP), intent(in ) :: xyz_Press    ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(in ) :: xyr_Press    ( 0:imax-1, 1:jmax, 0:kmax )
    real(DP), intent(in ) :: xyz_Temp     ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(in ) :: xy_SurfTemp     (0:imax-1, 1:jmax)
    real(DP), intent(out) :: xyr_RadSFlux ( 0:imax-1, 1:jmax, 0:kmax )
    real(DP), intent(out) :: xyr_RadLFlux    (0:imax-1, 1:jmax, 0:kmax)
    real(DP), intent(out) :: xyra_DelRadLFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)


    real(DP), parameter :: DiffFact = 1.66_DP

    real(DP) :: xyz_Rho             (0:imax-1, 1:jmax, 1:kmax)

    real(DP) :: xyr_DOD067  (0:imax-1, 1:jmax, 0:kmax)
    real(DP) :: xyr_DOD     (0:imax-1, 1:jmax, 0:kmax)
    real(DP) :: xyz_DelTrans(0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyrr_Trans  (0:imax-1, 1:jmax, 0:kmax, 0:kmax)

    real(DP) :: QeRat
    real(DP) :: SSA
    real(DP) :: AF

    real(DP) :: xyr_RadLFluxComp    (0:imax-1, 1:jmax, 0:kmax)
    real(DP) :: xyra_DelRadLFluxComp(0:imax-1, 1:jmax, 0:kmax, 0:1)

    real(DP) :: xy_SurfEmis(0:imax-1, 1:jmax)

    real(DP) :: xy_InAngle (0:imax-1, 1:jmax)
    real(DP) :: DistFromStarScld
    real(DP) :: DiurnalMeanFactor
    real(DP) :: SolarFluxTOA

    real(DP)           :: WNs
    real(DP)           :: WNe
    integer, parameter :: NumGaussNode = 5

    integer :: k
    integer :: kk



    ! 
    ! Initialization
    !
    if ( .not. radiation_dcpam_M_V1_inited ) call RadiationDcpamMV1Init


    xyz_Rho = xyz_Press / ( GasRDry * xyz_Temp )

    !  Dust optical depth
    !
    call SetDOD067(                    &
      & DOD067, xyr_Press, xyz_Press,        & ! (in)
      & xyr_DOD067                           & ! (out)
      & )



    ! û
    ! Short wave radiation
    !

    call ShortIncoming(                         &
      & xy_InAngle         = xy_InAngle,        & ! (out) optional
      & DistFromStarScld   = DistFromStarScld,  & ! (out) optional
      & DiurnalMeanFactor  = DiurnalMeanFactor  & ! (out) optional
      & )
    SolarFluxTOA = SolarConst / DistFromStarScld**2 * DiurnalMeanFactor

!!$    QeRat   = 0.9837_DP    !   Ockert-Bell et al. (1997)
!!$    xyz_SSA = 0.86_DP
!!$    xyz_AF  = 0.68_DP
!!$    QeRat   = 1.0_DP       !   Clancy and Lee (1991)
    SSA = 0.92_DP
    AF  = 0.55_DP

    call RadiationTwoStreamAppHomogAtm(                            &
      & xy_SurfAlbedo, SolarFluxTOA, xy_InAngle, SSA, AF, xyr_DOD067,  & ! (in )
      & xyr_RadSFlux                                                    & ! (out)
      & )


    ! Ĺ
    ! Long wave radiation
    !
    xyr_RadLFlux     = 0.0_DP
    xyra_DelRadLFlux = 0.0_DP


    !  Surface emissivity
    !
    xy_SurfEmis = 1.0_DP


    !    Flux from 0 to 500 cm-1
    !
    WNs     =   0.0d2
    WNe     = 500.0d2
    QeRat   = 0.17_DP                       ! Wavenumber averaged extinction coefficient
                                            ! ssa = 0.35d0
                                            ! af  = 0.36d0

    xyr_DOD = QeRat * xyr_DOD067

    do k = 1, kmax
      xyz_DelTrans(:,:,k) = exp( - DiffFact * ( xyr_DOD(:,:,k-1) - xyr_DOD(:,:,k) ) )
    end do
    !
    do k = 0, kmax
      do kk = k, k
        xyrr_Trans(:,:,k,kk) = 1.0_DP
      end do
      do kk = k+1, kmax
        xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,k,kk-1) * xyz_DelTrans(:,:,kk)
      end do
    end do
    do k = 0, kmax
      do kk = 0, k-1
        xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,kk,k)
      end do
    end do

    call RadiationRTEQNonScatWrapper(                    &
      & xyz_Temp, xy_SurfTemp, xy_SurfEmis, xyrr_Trans, & ! (in )
      & xyr_RadLFluxComp, xyra_DelRadLFluxComp,        & ! (out)
      & WNs, WNe, NumGaussNode                          & ! (in ) optional
      & )


    xyr_RadLFlux     = xyr_RadLFlux     + xyr_RadLFluxComp
    xyra_DelRadLFlux = xyra_DelRadLFlux + xyra_DelRadLFluxComp



    !    Flux from 500 to 850 cm-1
    !

    QeRat = 0.25_DP                      ! Wavenumber averaged extinction coefficient
    SSA   = 0.45_DP                      ! Wavenumber averaged single scattering albedo

    call rad15m_main( TimeN, DelTime, &
      & xyz_Temp, xyr_Press, xyz_Press, xy_SurfTemp, xyz_Rho, &
      & xyr_DOD067, QeRat, SSA, xy_SurfEmis, &
      & xyr_RadLFluxComp, xyra_DelRadLFluxComp &
      & )

    xyr_RadLFlux     = xyr_RadLFlux     + xyr_RadLFluxComp
    xyra_DelRadLFlux = xyra_DelRadLFlux + xyra_DelRadLFluxComp


    !    Flux from 850 to 2000 cm-1
    !
    WNs     =  850.0d2
    WNe     = 2000.0d2
    QeRat   =    0.41_DP                    ! Wavenumber averaged extinction coefficient
                                            ! ssa = 0.55d0
                                            ! af  = 0.55d0

    xyr_DOD = QeRat * xyr_DOD067

    do k = 1, kmax
      xyz_DelTrans(:,:,k) = exp( - DiffFact * ( xyr_DOD(:,:,k-1) - xyr_DOD(:,:,k) ) )
    end do
    !
    do k = 0, kmax
      do kk = k, k
        xyrr_Trans(:,:,k,kk) = 1.0_DP
      end do
      do kk = k+1, kmax
        xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,k,kk-1) * xyz_DelTrans(:,:,kk)
      end do
    end do
    do k = 0, kmax
      do kk = 0, k-1
        xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,kk,k)
      end do
    end do

    call RadiationRTEQNonScatWrapper(                   &
      & xyz_Temp, xy_SurfTemp, xy_SurfEmis, xyrr_Trans, & ! (in )
      & xyr_RadLFluxComp, xyra_DelRadLFluxComp,         & ! (out)
      & WNs, WNe, NumGaussNode                          & ! (in ) optional
      & )

    xyr_RadLFlux     = xyr_RadLFlux     + xyr_RadLFluxComp
    xyra_DelRadLFlux = xyra_DelRadLFlux + xyra_DelRadLFluxComp


  end subroutine RadiationDcpamMV1Flux

  !-------------------------------------------------------------------
  ! This subroutine will be deleted in future.
  !
!!$
!!$  subroutine RadiationRTEQNonScat(                    &
!!$    & WNs, WNe, NumGaussNode,                         & ! (in)
!!$    & xyz_Temp, xy_SurfTemp, xy_SurfEmis, xyr_OptDep, & ! (in)
!!$    & xyr_RadLFlux, xyra_DelRadLFlux                  & ! (out)
!!$    & )
!!$    !
!!$    ! ʤξãη׻
!!$    !
!!$    ! Integrate radiative transfer equation without scattering
!!$    !
!!$
!!$    ! ⥸塼 ; USE statements
!!$    !
!!$
!!$    ! ʪ
!!$    ! Physical constants settings
!!$    !
!!$    use constants, only: PI
!!$
!!$    ! ץ󥯴ؿη׻
!!$    ! Calculate Planck function
!!$    !
!!$    use planck_func, only :                            &
!!$      & Integ_PF_GQ_Array3D   , Integ_PF_GQ_Array2D,   &
!!$      & Integ_DPFDT_GQ_Array3D, Integ_DPFDT_GQ_Array2D
!!$
!!$    ! ʸ ; Declaration statements
!!$    !
!!$
!!$    real(DP), intent(in ):: WNs
!!$    real(DP), intent(in ):: WNe
!!$    integer,  intent(in ):: NumGaussNode
!!$    real(DP), intent(in ):: xyz_Temp    (0:imax-1, 1:jmax, 1:kmax)
!!$                              ! $ T $ .     . Temperature
!!$    real(DP), intent(in ):: xy_SurfTemp (0:imax-1, 1:jmax)
!!$                              ! ɽ̲. 
!!$                              ! Surface temperature
!!$    real(DP), intent(in ):: xy_SurfEmis (0:imax-1, 1:jmax)
!!$                              ! ɽ̼ͽΨ. 
!!$                              ! Surface emissivity
!!$    real(DP), intent(in ):: xyr_OptDep  (0:imax-1, 1:jmax, 0:kmax)
!!$                              ! Optical depth
!!$    real(DP), intent(out):: xyr_RadLFlux (0:imax-1, 1:jmax, 0:kmax)
!!$                              ! Ĺȥեå. 
!!$                              ! Longwave flux
!!$    real(DP), intent(out):: xyra_DelRadLFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
!!$                              ! ĹɽѲ. 
!!$                              ! Surface temperature tendency with longwave
!!$
!!$    ! ѿ
!!$    ! Work variables
!!$    !
!!$    real(DP), parameter :: DiffFact = 1.66_DP
!!$
!!$    real(DP):: xyz_DelTrans (0:imax-1, 1:jmax, 1:kmax)
!!$    real(DP):: xyrr_Trans   (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
!!$                              ! Ʃ᷸. 
!!$                              ! Transmission coefficient
!!$    real(DP):: xyz_IntPF      (0:imax-1, 1:jmax, 1:kmax)
!!$                              ! Integrated Planck function
!!$    real(DP):: xy_SurfIntPF   (0:imax-1, 1:jmax)
!!$                              ! Integrated Planck function with surface temperature
!!$    real(DP):: xyz_IntDPFDT   (0:imax-1, 1:jmax, 1:kmax)
!!$                              ! Integrated temperature derivative of Planck function
!!$    real(DP):: xy_SurfIntDPFDT(0:imax-1, 1:jmax)
!!$                              ! Integrated temperature derivative of Planck function
!!$                              ! with surface temperature
!!$
!!$    integer:: k, kk           ! ľ˲ DO 롼Ѻѿ
!!$                              ! Work variables for DO loop in vertical direction
!!$
!!$    ! ¹ʸ ; Executable statement
!!$    !
!!$
!!$    ! 
!!$    ! Initialization
!!$    !
!!$    if ( .not. radiation_dcpam_M_V1_inited ) call RadiationDcpamMV1Init
!!$
!!$    ! Integrate Planck function and temperature derivative of it
!!$    !
!!$    call Integ_PF_GQ_Array3D( &
!!$      & WNs, WNe, NumGaussNode, &
!!$      & 0, imax-1, 1, jmax, 1, kmax, &
!!$      & xyz_Temp, &
!!$      & xyz_IntPF &
!!$      & )
!!$    call Integ_PF_GQ_Array2D( &
!!$      & WNs, WNe, NumGaussNode, &
!!$      & 0, imax-1, 1, jmax, &
!!$      & xy_SurfTemp, &
!!$      & xy_SurfIntPF &
!!$      & )
!!$    call Integ_DPFDT_GQ_Array3D( &
!!$      & 0, imax-1, 1, jmax, 1, kmax, &
!!$      & WNs, WNe, NumGaussNode, xyz_Temp, & ! (in )
!!$      & xyz_IntDPFDT          & ! (out)
!!$      & )
!!$    call Integ_DPFDT_GQ_Array2D( &
!!$      & 0, imax-1, 1, jmax, &
!!$      & WNs, WNe, NumGaussNode, xy_SurfTemp, & ! (in )
!!$      & xy_SurfIntDPFDT           & ! (out)
!!$      & )
!!$
!!$
!!$    ! Ʃؿ׻
!!$    ! Calculate transmission functions
!!$    !
!!$    do k = 1, kmax
!!$      xyz_DelTrans(:,:,k) = &
!!$        & exp( - DiffFact * ( xyr_OptDep(:,:,k-1) - xyr_OptDep(:,:,k) ) )
!!$    end do
!!$    !
!!$    do k = 0, kmax
!!$      do kk = k, k
!!$        xyrr_Trans(:,:,k,kk) = 1.0_DP
!!$      end do
!!$      do kk = k+1, kmax
!!$        xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,k,kk-1) * xyz_DelTrans(:,:,kk)
!!$      end do
!!$    end do
!!$    do k = 0, kmax
!!$      do kk = 0, k-1
!!$        xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,kk,k)
!!$      end do
!!$    end do
!!$
!!$
!!$    ! ͥեå׻
!!$    ! Calculate radiation flux
!!$    !
!!$    do k = 0, kmax
!!$
!!$      xyr_RadLFlux(:,:,k) = xy_SurfEmis * PI * xy_SurfIntPF * xyrr_Trans(:,:,k,0)
!!$
!!$      do kk = 0, kmax-1
!!$        xyr_RadLFlux(:,:,k) = xyr_RadLFlux(:,:,k)                &
!!$          & - PI * xyz_IntPF(:,:,kk+1)                           &
!!$          & * ( xyrr_Trans(:,:,k,kk) - xyrr_Trans(:,:,k,kk+1) )
!!$      end do
!!$
!!$    end do
!!$
!!$
!!$    ! ͥեåѲΨη׻
!!$    ! Calculate rate of change of radiative flux
!!$    !
!!$    do k = 0, kmax
!!$      xyra_DelRadLFlux(:,:,k,0) =                           &
!!$        & xy_SurfEmis * xy_SurfIntDPFDT * xyrr_Trans(:,:,k,0)
!!$
!!$      xyra_DelRadLFlux(:,:,k,1) =                           &
!!$        & xyz_IntDPFDT(:,:,1)                               &
!!$        &   * ( xyrr_Trans(:,:,k,1) - xyrr_Trans(:,:,k,0) )
!!$    end do
!!$
!!$
!!$  end subroutine RadiationRTEQNonScat
!!$
  !-------------------------------------------------------------------

  subroutine SetDOD067(                    &
    & DOD067, xyr_Press, xyz_Press,        & ! (in)
    & xyr_DOD067                           & ! (out)
    & )
    !
    ! 
    !
    ! Set dust optical depth at 0.67 micron
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: Grav


    ! ʸ ; Declaration statements
    !

    real(DP), intent(in ):: DOD067
                              ! Dust optical depth at 0.67 micron
    real(DP), intent(in ):: xyr_Press    (0:imax-1, 1:jmax, 0:kmax)
                              ! Pressure
    real(DP), intent(in ):: xyz_Press    (0:imax-1, 1:jmax, 1:kmax)
                              ! Pressure
    real(DP), intent(out):: xyr_DOD067   (0:imax-1, 1:jmax, 0:kmax)
                              ! Optical depth

    ! ѿ
    ! Work variables
    !
    real(DP)            :: xyz_MixRtDust(0:imax-1, 1:jmax, 1:kmax)
    real(DP)            :: xy_DODFac    (0:imax-1, 1:jmax)

    real(DP), parameter :: DustOptDepRefPress  = 610.0_DP
    real(DP), parameter :: DustVerDistRefPress = 610.0_DP

    real(DP)            :: MixRtDust0

    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement
    !

    ! 
    ! Initialization
    !
    if ( .not. radiation_dcpam_M_V1_inited ) call RadiationDcpamMV1Init


    MixRtDust0      =   1.0_DP

    xyz_MixRtDust = MixRtDust0 &
      & * exp( DustVerDistCoef * ( 1.0_DP - ( DustVerDistRefPress / xyz_Press ) ) )

    k = kmax
    xyr_DOD067(:,:,k) = 0.0_DP
    do k = kmax-1, 0, -1
      xyr_DOD067(:,:,k) = xyr_DOD067(:,:,k+1) &
        & + xyz_MixRtDust(:,:,k+1) * ( xyr_Press(:,:,k) - xyr_Press(:,:,k+1) ) / Grav
    end do

    xy_DODFac = DOD067 * xyr_Press(:,:,0) / DustOptDepRefPress / xyr_DOD067(:,:,0)
    do k = 0, kmax
      xyr_DOD067(:,:,k) = xyr_DOD067(:,:,k) * xy_DODFac
    end do


  end subroutine SetDOD067

  !--------------------------------------------------------------------------------------

  subroutine RadiationDcpamMV1Init

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify


    ! ʸ ; Declaration statements
    !

    integer:: unit_nml        ! NAMELIST ե륪ץֹ.
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT.
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /radiation_dcpam_M_V1_nml/ &
      & SolarConst,   &
      & DOD067,       &
      & DustVerDistCoef
          !
          ! ǥեͤˤĤƤϽ³ "radiation_dcpam_SWEV1#RadiationDcpamSWEV1Init"
          ! Υɤ򻲾ȤΤ.
          !
          ! Refer to source codes in the initialization procedure
          ! "radiation_dcpam_SWEV1#RadiationDcpamSWEV1Init" for the default values.
          !


    ! ǥեͤ
    ! Default values settings
    !
    SolarConst      = 1380.0_DP / 1.52_DP**2
    DOD067          = 0.0_DP
    DustVerDistCoef = 0.01_DP

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml,                     & ! (in)
        & nml = radiation_dcpam_M_V1_nml, & ! (out)
        & iostat = iostat_nml )             ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if



    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, 'SolarConst = %f', d = (/ SolarConst /) )
    call MessageNotify( 'M', module_name, 'DOD067     = %f', d = (/ DOD067     /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )


    radiation_dcpam_M_V1_inited = .true.

  end subroutine RadiationDcpamMV1Init

  !--------------------------------------------------------------------------------------

end module radiation_dcpam_M_V1
