!-------------------------------------------------
!  SGpack Module
!-------------------------------------------------
module sgpack
  use dcl_common

  interface DclDrawLine
    module procedure DclDrawLine1, DclDrawLine2
  end interface  

  interface DclDrawLineNormalized
    module procedure DclDrawLineNormalized1, DclDrawLineNormalized2
  end interface  

  interface DclDrawLineProjected
    module procedure DclDrawLineProjected1, DclDrawLineProjected2
  end interface  

  private :: DclDrawLine1,           DclDrawLine2
  private :: DclDrawLineNormalized1, DclDrawLineNormalized2
  private :: DclDrawLineProjected1,  DclDrawLineProjected2

  contains
!---------------------------------------------------------
    subroutine DclPrintDeviceList() ![NXe[ṼXg
      call prcopn('DclPrintDeviceList')
      call sgpwsn()
      call prccls('DclPrintDeviceList')
    end subroutine
!------------------------------------------------------------------------
!Kϊ
!---------------------------------
    subroutine DclTransShortToLong(short,long) !̂疼̂߂D
      character(len=*), intent(in)  :: short 
      character(len=*), intent(out) :: long

      call prcopn('DclTransShortToLong')
      call sgtrsl(short,long) 
      call prccls('DclTransShortToLong')
    end subroutine
!---------------------------------
    subroutine DclTransShortToNum(short,num) !̂ϊ֐ԍ߂D
      character(len=*), intent(in)  :: short 
      integer,          intent(out) :: num

      call prcopn('DclTransShortToNum')
      call sgtrsn(short,num)
      call prccls('DclTransShortToNum')
    end subroutine
!---------------------------------
    subroutine DclTransLongToShort(long,short) !̂痪̂߂D
      character(len=*), intent(in)  :: long
      character(len=*), intent(out) :: short 

      call prcopn('DclTransLongToShort')
      call sgtrls(long,short)
      call prccls('DclTransLongToShort')
    end subroutine
!---------------------------------
    subroutine DclTransLongToNum(long,num) !̂ϊ֐ԍ߂D
      character(len=*), intent(in)  :: long
      integer,          intent(out) :: num

      call prcopn('DclTransLongToNum')
      call sgtrln(long,num)
      call prccls('DclTransLongToNum')
    end subroutine
!---------------------------------
    subroutine DclTransNumToShort(num,short) !ϊ֐ԍ痪̂߂D
      integer,          intent(in)  :: num
      character(len=*), intent(out) :: short

      call prcopn('DclTransNumToShort')
      call sgtrns(num,short)
      call prccls('DclTransNumToShort')
    end subroutine
!---------------------------------
    subroutine DclTransNumToLong(num,long) !ϊ֐ԍ疼̂߂D
      integer,          intent(in) :: num
      character(len=*), intent(out) :: long

      call prcopn('DclTransNumToLong')
      call sgtrnl(num,long)
      call prccls('DclTransNumToLong')
    end subroutine
!---------------------------------
    subroutine DclGetViewPort(xmin, xmax, ymin, ymax) 
      real, intent(out), optional :: xmin, xmax, ymin, ymax !r[|[g

      call prcopn('DclGetViewPort')
      call sgqvpt(xmin0, xmax0, ymin0, ymax0) 
      if(present(xmin)) xmin = xmin0
      if(present(xmax)) xmax = xmax0
      if(present(ymin)) ymin = ymin0
      if(present(ymax)) ymax = ymax0
      call prccls('DclGetViewPort')
    end subroutine
!---------------------------------
    subroutine DclGetWindow(xmin, xmax, ymin, ymax) 
      real, intent(out), optional :: xmin, xmax, ymin, ymax !EChE

      call prcopn('DclGetWindow')
      call sgqwnd(xmin0, xmax0, ymin0, ymax0) 
      if(present(xmin)) xmin = xmin0
      if(present(xmax)) xmax = xmax0
      if(present(ymin)) ymin = ymin0
      if(present(ymax)) ymax = ymax0
      call prccls('DclGetWindow')
    end subroutine
!---------------------------------
    subroutine DclGetSimilarity(factor, xoffset, yoffset)  
      real, intent(out), optional :: factor, xoffset, yoffset

      call prcopn('DclGetSimilarity')
      call sgqsim(factor0, xoff0, yoff0) 
      if(present(factor))  factor  = factor0 
      if(present(xoffset)) xoffset = xoff0 
      if(present(yoffset)) yoffset = yoff0 
      call prccls('DclGetSimilarity')
    end subroutine
!---------------------------------
    subroutine DclGetMapProjectionAngle(longitude,latitude,rotation)  
      real, intent(out), optional :: longitude,latitude,rotation 
      real                        :: lon, lat, rot

      call prcopn('DclGetMapProjectionAngle')
      call sgqmpl(lon, lat, rot)
      if(present(longitude)) longitude = lon
      if(present(latitude )) latitude  = lat
      if(present(rotation )) rotation  = rot
      call prccls('DclGetMapProjectionAngle')
    end subroutine
!---------------------------------
    function DclGetTransNumber() 
      integer :: DclGetTransNumber     !ϊ֐ԍ

      call prcopn('DclGetTransNumber')
      call sgqtrn(DclGetTransNumber) 
      call prccls('DclGetTransNumber')
    end function
!------------------------------------------------------------------------
!|Cv~eBu
!---------------------------------
    subroutine DclDrawLine1 (x,y,type,index)  !܂`D
      real,      intent(in), dimension(:) :: x, y
      integer,   intent(in), optional     :: type, index
      integer                             :: type0, index0
      
        call sgoopn('DclDrawLine', ' ')
        if(present(type))  then ; type0 = type
                           else ; call sgqplt(type0)
        end if
        
        if(present(index)) then ; index0 = index
                           else ; call sgqpli(index0)
        end if

        nx = size(x)
        ny = size(y)
        if(nx.ne.ny) call msgdmp('M', 'DclDrawLine', 'Length of x and y don''t match.')
        n = min(nx, ny)
        call sgplzu(n,x,y,type0,index0)
        call sgocls('DclDrawLine')
        
    end subroutine

!---------------------------------
    subroutine DclDrawLine2 (x1,y1,x2,y2,type,index)  !܂`D
      real,      intent(in)               :: x1, y1, x2, y2
      integer,   intent(in), optional     :: type, index
      integer                             :: type0, index0
      real,      dimension(2)             :: x, y
      
        call sgoopn('DclDrawLine', ' ')
        if(present(type))  then ; type0 = type
                           else ; call sgqplt(type0)
        end if
        
        if(present(index)) then ; index0 = index
                           else ; call sgqpli(index0)
        end if

        x(1) = x1 ; y(1) = y1
        x(2) = x2 ; y(2) = y2

        call sgplzu(2,x,y,type0,index0)
        call sgocls('DclDrawLine')
        
    end subroutine

!---------------------------------
    subroutine DclDrawLineNormalized1(x, y, type, index)
      real,      intent(in), dimension(:) :: x, y
      integer,   intent(in), optional     :: type, index
      integer                             :: type0, index0
      
        call sgoopn('DclDrawLineNormalized', ' ')
        if(present(type))  then ; type0 = type
                           else ; call sgqplt(type0)
        end if
        
        if(present(index)) then ; index0 = index
                           else ; call sgqpli(index0)
        end if

        nx = size(x)
        ny = size(y)
        if(nx.ne.ny) call msgdmp('M', 'DclDrawLineNormalized', &
                           & 'Length of x and y don''t match.')
        n = min(nx, ny)

        call sgplzv(n, x, y, type0, index0)
        call sgocls('DclDrawLineNormalized')
    end subroutine
!---------------------------------
    subroutine DclDrawLineNormalized2(x1, y1, x2, y2, type, index)
      real,      intent(in)            :: x1, y1, x2, y2
      integer,   intent(in), optional  :: type, index
      integer                          :: type0, index0
      real,      dimension(2)          :: x, y
      
        call sgoopn('DclDrawLineNormalized', ' ')
        if(present(type))  then ; type0 = type
                           else ; call sgqplt(type0)
        end if
        
        if(present(index)) then ; index0 = index
                           else ; call sgqpli(index0)
        end if

        x(1) = x1 ; y(1) = y1
        x(2) = x2 ; y(2) = y2

        call sgplzv(2, x, y, type0, index0)
        call sgocls('DclDrawLineNormalized')
    end subroutine
!---------------------------------
    subroutine DclDrawLineProjected1(x,y,type,index)
      real,      intent(in), dimension(:) :: x, y
      integer,   intent(in), optional     :: type, index
      integer                             :: type0, index0
      
        call sgoopn('DclDrawLineProjected', ' ')
        if(present(type))  then ; type0 = type
                           else ; call sgqplt(type0)
        end if
        
        if(present(index)) then ; index0 = index
                           else ; call sgqpli(index0)
        end if

        nx = size(x)
        ny = size(y)
        if(nx.ne.ny) call msgdmp('M', 'DclDrawLineProjected', &
                           & 'Length of x and y don''t match.')
        n = min(nx, ny)

        call sgplzr(n, x, y, type0, index0)
        call sgocls('DclDrawLineProjected')
    end subroutine
!---------------------------------
    subroutine DclDrawLineProjected2(x1,y1,x2,y2,type,index)
      real,    intent(in)           :: x1, y1, x2, y2
      integer, intent(in), optional :: type, index
      integer                       :: type0, index0
      real,    dimension(2)         :: x, y
      
        call sgoopn('DclDrawLineProjected', ' ')
        if(present(type))  then ; type0 = type
                           else ; call sgqplt(type0)
        end if
        
        if(present(index)) then ; index0 = index
                           else ; call sgqpli(index0)
        end if

        x(1) = x1 ; y(1) = y1
        x(2) = x2 ; y(2) = y2

        call sgplzr(2, x, y, type0, index0)
        call sgocls('DclDrawLineProjected')
    end subroutine
!---------------------------------
    subroutine DclSetLineType(type)  !C^Cvݒ肷D   
      integer, intent(in) :: type    !

      call prcopn('DclSetLineType')
      call sgsplt(type)
      call prccls('DclSetLineType')
    end subroutine
!---------------------------------
    subroutine DclSetLineIndex(index)  !CCfNX̐ݒD   
      integer,   intent(in) :: index    !CCfNX 

      call prcopn('DclSetLineIndex')
      call sgspli(index)
      call prccls('DclSetLineIndex')
    end subroutine
!---------------------------------
    subroutine DclSetLineText(text)  !x̕ݒD  
      character(len=*), intent(in) :: text  !`il'A')

      call prcopn('DclSetLineText')
      call sgsplc(text)
      call prccls('DclSetLineText')
    end subroutine
!---------------------------------
    subroutine DclSetLineTextSize(height)  !x̕ݒ  
      real, intent(in) :: height  !̍

      call prcopn('DclSetLineTextSize')
      call sgspls(height)
      call prccls('DclSetLineTextSize')
    end subroutine
!---------------------------------
    subroutine DclNextLineText()  !x̍Ō̕ԍ𑝂₷D

      call prcopn('DclNextLineText')
      call sgnplc()
      call prccls('DclNextLineText')
    end subroutine
!---------------------------------
    function DclGetLineType()  
      integer :: DclGetLineType 

      call prcopn('DclGetLineType')
      call sgqplt(DclGetLineType)
      call prccls('DclGetLineType')
    end function
!---------------------------------
    function DclGetLineIndex() 
      integer :: DclGetLineIndex

      call prcopn('DclGetLineIndex')
      call sgqpli(DclGetLineIndex) 
      call prccls('DclGetLineIndex')
    end function
!---------------------------------
    subroutine DclGetLineText(text)   
      character(len=*), intent(out) :: text !`il'A')

      call prcopn('DclGetLineText')
      call sgqplc(text) 
      call prccls('DclGetLineText')
    end subroutine
!---------------------------------
    function DclGetLineTextSize()   
      real :: DclGetLineTextSize

      call prcopn('DclGetLineTextSize')
      call sgqpls(DclGetLineTextSize)   
      call prccls('DclGetLineTextSize')
    end function
!------------------------------------------------------------------------------
! |}[J[v~eBu
!---------------------------------
    subroutine DclDrawMarker(x,y,type,index,height)
      real,      intent(in), dimension(:) :: x, y
      integer,   intent(in), optional     :: type, index
      real,      intent(in), optional     :: height

      integer                             :: type0, index0
      real                                :: height0
        
        call sgoopn('DclDrawMarker', ' ')
        nx = size(x)
        ny = size(y)
        if(nx.ne.ny) call msgdmp('M', 'DclDrawMarker', 'Length of x and y don''t match.')
        n = min(nx, ny)

        if(present(type)  ) then ; type0 = type
                            else ; call sgqpmt(type0)
        end if
        
        if(present(index) ) then ; index0 = index
                            else ; call sgqpmi(index0)
        end if
        
        if(present(height)) then ; height0 = height
                            else ; call sgqpms(height0)
        end if
        
        call sgpmzu(n,x,y,type0,index0, height0)
        call sgocls('DclDrawMarker')
    end subroutine
!---------------------------------
    subroutine DclDrawMarkerNormalized(x, y, type, index, height) 

      real,      intent(in), dimension(:) :: x, y
      integer,   intent(in), optional     :: type, index
      real,      intent(in), optional     :: height

      integer                             :: type0, index0
      real                                :: height0
        
        call sgoopn('DclDrawMarkerNormalized', ' ')
        nx = size(x)
        ny = size(y)
        if(nx.ne.ny) call msgdmp('M', 'DclDrawMarkerNormalized', &
                               & 'Length of x and y don''t match.')
        n = min(nx, ny)

        if(present(type)  ) then ; type0 = type
                            else ; call sgqpmt(type0)
        end if
        
        if(present(index) ) then ; index0 = index
                            else ; call sgqpmi(index0)
        end if
        
        if(present(height)) then ; height0 = height
                            else ; call sgqpms(height0)
        end if
        
        call sgpmzv(n,x,y,type0,index0, height0)
        call sgocls('DclDrawMarkerNormalized')

    end subroutine
!---------------------------------
    subroutine DclDrawMarkerProjected(x, y, type, index, height)

      real,      intent(in), dimension(:) :: x, y
      integer,   intent(in), optional     :: type, index
      real,      intent(in), optional     :: height

      integer                             :: type0, index0
      real                                :: height0
        
        call sgoopn('DclDrawMarkerProjected', ' ')
        nx = size(x)
        ny = size(y)
        if(nx.ne.ny) call msgdmp('M', 'DclDrawMarkerProjected', &
                               & 'Length of x and y don''t match.')
        n = min(nx, ny)

        if(present(type)  ) then ; type0 = type
                            else ; call sgqpmt(type0)
        end if
        
        if(present(index) ) then ; index0 = index
                            else ; call sgqpmi(index0)
        end if
        
        if(present(height)) then ; height0 = height
                            else ; call sgqpms(height0)
        end if
        
        call sgpmzr(n,x,y,type0,index0, height0)
        call sgocls('DclDrawMarkerProjected')

    end subroutine
!---------------------------------
    subroutine DclSetMarkerType(type)  !}[J[^Cv̐ݒD    
      integer, intent(in) :: type    !}[J[^Cv

      call prcopn('DclSetMarkerType')
      call sgspmt(type)
      call prccls('DclSetMarkerType')
    end subroutine
!---------------------------------
    subroutine DclSetMarkerIndex(index)  !}[J[̃CCfNX̐ݒ  
      integer,   intent(in) :: index     !CCfNX 

      call prcopn('DclSetMarkerIndex')
      call sgspmi(index)
      call prccls('DclSetMarkerIndex')
    end subroutine
!---------------------------------
    subroutine DclSetMarkerSize(height)   !}[J[̑傫ݒD     
      real,    intent(in) :: height    !}[J[̑傫

      call prcopn('DclSetMarkerSize')
      call sgspms(height) 
      call prccls('DclSetMarkerSize')
    end subroutine
!---------------------------------
    function DclGetMarkerType()  
      integer :: DclGetMarkerType     !}[J[^Cv

      call prcopn('DclGetMarkerType')
      call sgqpmt(DclGetMarkerType) 
      call prccls('DclGetMarkerType')
    end function
!---------------------------------
    function DclGetMarkerIndex()
      integer :: DclGetMarkerIndex     !CCfNX 

      call prcopn('DclGetMarkerIndex')
      call sgqpmi(DclGetMarkerIndex)
      call prccls('DclGetMarkerIndex')
    end function
!---------------------------------
    function DclGetMarkerSize()
      real :: DclGetMarkerSize     !}[J[̑傫

      call prcopn('DclGetMarkerSize')
      call sgqpms(DclGetMarkerSize)
      call prccls('DclGetMarkerSize')
    end function
!------------------------------------------------------------------
!     eLXg
!---------------------------------
    subroutine DclDrawText(x, y, text, height, angle, centering, index) 
      real,             intent(in) :: x, y          !̈ʒu
      character(len=*), intent(in) :: text          !
      real,             intent(in) :: height, angle !̍
      integer,          intent(in) :: centering,index

      optional :: height, angle, centering,index

      real    :: height0
      integer :: angle0, cent0, index0

        call sgoopn('DclDrawText', ' ')
        if(present(height))    then ; height0 = height
                               else ; call sgqtxs(height0)
        end if

        if(present(angle) )    then ; angle0 = nint(angle)
                               else ; call sgqtxr(angle0)
        end if

        if(present(centering)) then ; cent0 = centering
                               else ; call sgqtxc(cent0)
        end if
        
        if(present(index) )    then ; index0 = index
                               else ; call sgqtxi(index0)
        end if

        call sgtxzu(x,y,text,height0,angle0,cent0,index0) 
        call sgocls('DclDrawText')
    end subroutine
!---------------------------------
    subroutine DclDrawTextNormalized(x, y, text, height, angle, centering, index)

      real,             intent(in) :: x, y          !̈ʒu
      character(len=*), intent(in) :: text          !
      real,             intent(in) :: height, angle !̍
      integer,          intent(in) :: centering,index

      optional :: height, angle, centering,index

      real    :: height0
      integer :: angle0, cent0, index0

        call sgoopn('DclDrawTextNormalized', ' ')
        if(present(height))    then ; height0 = height
                               else ; call sgqtxs(height0)
        end if

        if(present(angle) )    then ; angle0 = nint(angle)
                               else ; call sgqtxr(angle0)
        end if

        if(present(centering)) then ; cent0 = centering
                               else ; call sgqtxc(cent0)
        end if
        
        if(present(index) )    then ; index0 = index
                               else ; call sgqtxi(index0)
        end if

        call sgtxzv(x,y,text,height0,angle0,cent0,index0) 
        call sgocls('DclDrawTextNormalized')
    end subroutine
!---------------------------------
    subroutine DclDrawTextProjected(x, y, text, height, angle, centering, index)

      real,             intent(in) :: x, y          !̈ʒu
      character(len=*), intent(in) :: text          !
      real,             intent(in) :: height, angle !̍
      integer,          intent(in) :: centering,index

      optional :: height, angle, centering,index

      real    :: height0 
      integer :: angle0, cent0, index0

        call sgoopn('DclDrawTextProjected', ' ')
        if(present(height))    then ; height0 = height
                               else ; call sgqtxs(height0)
        end if

        if(present(angle) )    then ; angle0 = nint(angle)
                               else ; call sgqtxr(angle0)
        end if

        if(present(centering)) then ; cent0 = centering
                               else ; call sgqtxc(cent0)
        end if
        
        if(present(index) )    then ; index0 = index
                               else ; call sgqtxi(index0)
        end if

        call sgtxzr(x,y,text,height0,angle0,cent0,index0) 
        call sgocls('DclDrawTextProjected')
    end subroutine
!---------------------------------
    subroutine DclSetTextHeight(height)  !̍ݒD  
      real,  intent(in) :: height  !̍

      call prcopn('DclSetTextHeight')
      call sgstxs(height)
      call prccls('DclSetTextHeight')
    end subroutine
!---------------------------------
    subroutine DclSetTextAngle(angle)  !̊px̐ݒD  
      real,  intent(in) :: angle   !̌Xx̒Pʂŗ^ 

      call prcopn('DclSetTextAngle')
      call sgstxr(nint(angle))
      call prccls('DclSetTextAngle')
    end subroutine
!---------------------------------
    subroutine DclSetTextIndex(index)  !̃CCfNX̐ݒD                 
      integer,   intent(in) :: index     !CCfNX 

      call prcopn('DclSetTextIndex')
      call sgstxi(index) 
      call prccls('DclSetTextIndex')
    end subroutine
!---------------------------------
    subroutine DclSetTextPosition(centering)  !̃Z^OIvVݒ
      integer,   intent(in) :: centering   !Z^OIvV

      call prcopn('DclSetTextPosition')
      call sgstxc(centering)
      call prccls('DclSetTextPosition')
    end subroutine
!---------------------------------
    function DclGetTextHeight() 
      real :: DclGetTextHeight  !̍

      call prcopn('DclGetTextHeight')
      call sgqtxs(DclGetTextHeight) 
      call prccls('DclGetTextHeight')
    end function
!---------------------------------
    function DclGetTextAngle()
      real :: DclGetTextAngle      !̌Xx̒Pʂŗ^

      call prcopn('DclGetTextAngle')
      call sgqtxr(irot)
      DclGetTextAngle = irot
      call prccls('DclGetTextAngle')
    end function
!---------------------------------
    function DclGetTextIndex() 
      integer :: DclGetTextIndex      !CCfNX

      call prcopn('DclGetTextIndex')
      call sgqtxi(DclGetTextIndex) 
      call prccls('DclGetTextIndex')
    end function
!---------------------------------
    function DclGetTextPosition()  
      integer :: DclGetTextPosition   !Z^OIvV

      call prcopn('DclGetTextPosition')
      call sgqtxc(DclGetTextPosition)  
      call prccls('DclGetTextPosition')
    end function
!-------------------------------------------------------------
! g[v~eBu
!---------------------------------
    subroutine DclShadeRegion(x, y, pattern)  !u Wnőp`̈̓hԂD
      real,    intent(in), dimension(:) :: x,y 
      integer, intent(in), optional     :: pattern

        call sgoopn('DclShadeRegion', ' ')
        nx = size(x)
        ny = size(y)
        if(nx.ne.ny) call msgdmp('M', 'DclShadeRegion', &
                               & 'Length of x and y don''t match.')
        n = min(nx, ny)

        if(present(pattern)) then ; ipat0 = pattern
                             else ; call sgqtnp(ipat0)
        end if

        call sgtnzu(n,x,y,ipat0) 
        call sgocls('DclShadeRegion')
    end subroutine
!---------------------------------
    subroutine DclShadeRegionNormalized(x, y, pattern)
      real,    intent(in), dimension(:) :: x,y 
      integer, intent(in), optional     :: pattern

        call sgoopn('DclShadeRegionNormalized', ' ')
        nx = size(x)
        ny = size(y)
        if(nx.ne.ny) call msgdmp('M', 'DclShadeRegionNormalized', &
                               & 'Length of x and y don''t match.')
        n = min(nx, ny)

        if(present(pattern)) then ; ipat0 = pattern
                             else ; call sgqtnp(ipat0)
        end if

        call sgtnzv(n,x,y,itpat0) 
        call sgocls('DclShadeRegionNormalized')
    end subroutine
!---------------------------------
    subroutine DclShadeRegionProjected(x, y, pattern)
      real,    intent(in), dimension(:) :: x,y 
      integer, intent(in), optional     :: pattern

        call sgoopn('DclShadeRegionProjected', ' ')
        nx = size(x)
        ny = size(y)
        if(nx.ne.ny) call msgdmp('M', 'DclShadeRegionProjected', &
                               & 'Length of x and y don''t match.')
        n = min(nx, ny)

        if(present(pattern)) then ; ipat0 = pattern
                             else ; call sgqtnp(ipat0)
        end if

        call sgtnzr(n,x,y,itpat0) 
        call sgocls('DclShadeRegionProjected')
    end subroutine
!---------------------------------
    subroutine DclSetShadePattern(pattern) ! g[p^[ԍݒ
      integer,   intent(in) :: pattern  !g[p^[ԍ

      call prcopn('DclSetShadePattern')
      call sgstnp(pattern) 
      call prccls('DclSetShadePattern')
    end subroutine
!---------------------------------
    function DclGetShadePattern() !ݐݒ肳Ăg[p^[ԍQ
      integer :: DclGetShadePattern     !ݐݒ肳Ăg[p^[ԍ

      call prcopn('DclGetShadePattern')
      call sgqtnp(DclGetShadePattern)
      call prccls('DclGetShadePattern')
    end function
!-------------------------------------------------------------------------
!     A[Tuv~eBu
!-------------------------------------------------------------------------
    subroutine DclDrawArrow(x1,y1,x2,y2,type,index)
      real,    intent(in)           :: x1, y1, x2, y2
      integer, intent(in), optional :: type, index

      integer :: type0

        call sgoopn('DclDrawArrow', ' ')
        if(present(type)  ) then ; type0 = type
                            else ; call sgqlat(type0)
        end if
        
        if(present(index) ) then ; index0 = index
                            else ; call sgqlai(index0)
        end if
        
        call sglazu(x1,y1,x2,y2,type0,index0)
        call sgocls('DclDrawArrow')
    end subroutine
!---------------------------------
    subroutine DclDrawArrowNormalized(x1,y1,x2,y2,type,index)
      real,    intent(in)           :: x1, y1, x2, y2
      integer, intent(in), optional :: type, index

      integer :: type0

        call sgoopn('DclDrawArrowNormalized', ' ')
        if(present(type)  ) then ; type0 = type
                            else ; call sgqlat(type0)
        end if
        
        if(present(index) ) then ; index0 = index
                            else ; call sgqlai(index0)
        end if
        
        call sglazv(x1,y1,x2,y2,type0,index0)
        call sgocls('DclDrawArrowNormalized')
    end subroutine
!---------------------------------
    subroutine DclDrawArrowProjected(x1,y1,x2,y2,type,index)
      real,    intent(in)           :: x1, y1, x2, y2
      integer, intent(in), optional :: type, index

      integer :: type0

        call sgoopn('DclDrawArrowProjected', ' ')
        if(present(type)  ) then ; type0 = type
                            else ; call sgqlat(type0)
        end if
        
        if(present(index) ) then ; index0 = index
                            else ; call sgqlai(index0)
        end if
        
        call sglazr(x1,y1,x2,y2,type0,index0)
        call sgocls('DclDrawArrowProjected')
    end subroutine
!---------------------------------
    subroutine DclSetArrowLineType(type)  !`̃C^Cvݒ肷D 
      integer,   intent(in) :: type  !̃C^Cv 

      call prcopn('DclSetArrowLineType')
      call sgslat(type)
      call prccls('DclSetArrowLineType')
    end subroutine
!---------------------------------
    subroutine DclSetArrowLineIndex(index) !` CCfNXݒ肷
      integer,   intent(in) :: index  !̃CCfNX 

      call prcopn('DclSetArrowLineIndex')
      call sgslai(index)
      call prccls('DclSetArrowLineIndex')
    end subroutine
!---------------------------------
    function DclGetArrowLineType() !ݐݒ肳Ă郉C^Cv
      integer :: DclGetArrowLineType   !̃C^Cv

      call prcopn('DclGetArrowLineType')
      call sgqlat(DclGetArrowLineType)
      call prccls('DclGetArrowLineType')
    end function
!---------------------------------
    function DclGetArrowLineIndex() !ݐݒ肳Ă郉CCfNX
      integer :: DclGetArrowLineIndex      !̃CCfNX 

      call prcopn('DclGetArrowLineIndex')
      call sgqlai(DclGetArrowLineIndex) 
      call prccls('DclGetArrowLineIndex')
    end function
!---------------------------------
end module

