!-------------------------------------------------
!  UEpack Module
!-------------------------------------------------
module uepack
  use dcl_common

  interface DclSetShadeLevel
     module procedure DclSetShadeA, DclSetShadeB, DclSetShadeV, DclSetShadeN
  end interface

  private :: DclSetShadeA, DclSetShadeB, DclSetShadeV, DclSetShadeN

  contains
!------------------------------2l}̂ʂ킯ȂD
    subroutine DclShadeContour(z)
      real,      intent(in), dimension(:,:) :: z

      call sgoopn('DclShadeContour', ' ')
      nx = size(z,1)
      ny = size(z,2)
      call uetone(z,nx,nx,ny)   
      call sgocls('DclShadeContour')
    end subroutine
!------------------------------2l}̂ʂ킯ȂD
    subroutine DclShadeContourEx(z)
      real,      intent(in), dimension(:,:) :: z

      call sgoopn('DclShadeContourEX', ' ')
      nx = size(z,1)
      ny = size(z,2)
      call uetonf(z,nx,nx,ny)  
      call sgocls('DclShadeContourEX')
    end subroutine
!------------------------------g[xlŏlEől,ݒlŐݒ肷D
    subroutine   DclSetShadeA(xmin,xmax,dx)
      real,      intent(in) :: xmin,xmax    !g[x̍ŏEől
      real,      intent(in) :: dx           !dx > 0 ̂Ƃdxݕ

      call prcopn('DclSetShadeLevel')
      call uegtla(xmin,xmax,dx) 
      call prccls('DclSetShadeLevel')
    end subroutine
!------------------------------g[xlz,ݒlŐݒ肷D
    subroutine DclSetShadeB(z,dx)
      real,      intent(in), dimension(:,:) :: z
      real,      intent(in) :: dx            !dx > 0 ̂Ƃdxݕ

      call prcopn('DclSetShadeLevel')
      nx = size(z,1)
      ny = size(z,2)
      call uegtlb(z,nx,nx,ny,dx) 
      call prccls('DclSetShadeLevel')
     end subroutine
!------------------------------ ʂ킯郌xƃp^[1xƎw肷D
    subroutine DclSetShadeV(level1,level2,pattern)
      real,      intent(in) :: level1,level2  !ʂ킯郌x̉l
      integer,   intent(in) :: pattern        !g[p^[ԍ

      call prcopn('DclSetShadeLevel')
      call uestlv(level1,level2,pattern)
      call prccls('DclSetShadeLevel')
    end subroutine
!----------------------------- ʂ킯郌xƃp^[zŕxw肷D
    subroutine DclSetShadeN(level,pattern)
      integer, intent(in), dimension(:) :: pattern 
      real,    intent(in), dimension(size(pattern)) :: level 

      call prcopn('DclSetShadeLevel')
      call uestln(level,pattern,size(pattern)) 
      call prccls('DclSetShadeLevel')
    end subroutine
!-------------------------------itonԖڂ̃g[x̑
    subroutine DclGetShadeLevel(number, level1, level2, pattern) 
      integer,   intent(in) :: number
      real,      intent(out) :: level1, level2
      integer,   intent(out) :: pattern

      call prcopn('DclGetShadeLevel')
      call ueqtlv(level1,level2,pattern,number) 
      call prccls('DclGetShadeLevel')
    end subroutine
!------------------------------ݐݒ肳Ăg[x̐
    function DclGetShadeLevelNumber()
      integer :: DclGetShadeLevelNumber

      call prcopn('DclGetShadeLevelNumber')
      call ueqntl(DclGetShadeLevelNumber)  
      call prccls('DclGetShadeLevelNumber')
    end function
!-----------------------------g[x𖳌ɂD
    subroutine DclClearShadeLevel()

      call prcopn('DclClearShadeLevel')
      call ueitlv() 
      call prccls('DclClearShadeLevel')
    end subroutine
      
end module
