!-----------------------------------------------------------------------
!  LASER SHOT DRIVER FOR MS-FortranPowerStation    Jun, 1996  S.Sakai
!-----------------------------------------------------------------------
!
!**************** coordinate module **************
!
module ZLCOORD
    integer, public                    :: pmode,  pmode2, lmode
    integer, private, parameter        :: mdmax=4
    integer, private                   :: ix1, iy1
    real,    private, dimension(mdmax) :: xwidth, ywidth, xoff, yoff, poff
    real,    private                   :: cdot

    data  xwidth /  26.3, 18.6, 33.0, 23.3 /  ! page size(x)
    data  ywidth /  18.6, 13.2, 23.3, 16.5 /  ! page size(y)
    data  xoff   /   1.3,  0.8,  1.3,  0.8 /  ! origin (x)
    data  yoff   /   0.6,  0.6,  0.7,  0.6 /  ! origin (y)
    data  poff   /   0.0, 14.2,  0.0, 18.2 /  ! page offset

contains
  subroutine ZLCOINI (mode, lbpmod)
    lmode = lbpmod 
    if(lmode.ge.3) then
      cdot = 118.11          ! dot/cm (300 dot/inch)
    else
      cdot =  94.49          ! dot/cm (240 dot/inch)
    end if

    pmode  = mode
    pmode2 = mod(pmode,2)
  end subroutine

  subroutine zltrf(xx, yy, ix, iy)
    ix = xx*cdot
    iy = yy*cdot
  end subroutine

  subroutine zlgetorg(ix, iy)
    ix = xoff(pmode)*cdot
    iy = yoff(pmode)*cdot
  end subroutine

  function joffset(npage)
    joffset = poff(pmode)*cdot*(mod(npage,2)*2 - 1)
  end function
 
  subroutine zlfint(wx, wy, iwx, iwy)
  end subroutine

  subroutine zliint(iwx, iwy, wx, wy)
  end subroutine

  subroutine zlqrct(xmin, xmax, ymin, ymax, fact)
    xmin = 0.
    ymin = 0.
    xmax = xwidth(pmode)
    ymax = ywidth(pmode)
    fact = 1.
  end subroutine
end module zlcoord
!
!**************** Laser Shot Module **************
!
module ZLSHOT
    use ZLCOORD
    use PORTLIB
    integer,   public            :: iunit, imsg
    character, public, parameter :: esc*(1)=char(27), is2*(1)=char(30), &
                                    csi*(2)=esc//'['
    integer,   private           :: nvec =0             ! for dot graph

contains
  subroutine zlopen(cfile)
    character*(*) cfile

    call glpget('msgunit', imsg)
    iunit = iufopn()
    open(iunit, file=cfile, access='sequential', form='binary')

    im1 = 48 + (pmode+1)/2
    im2 = 52 + pmode2
    if ( lmode.eq.3 ) then
       write(iunit) esc//'%@'//esc//'P31;300;1J'//esc//'\'
       write(iunit) esc//'<'                         ! soft reset
       write(iunit) csi//char(im1)//char(im2)//';;p' ! page format
    elseif ( lmode.eq.2 ) then
       write(iunit) esc//'%@'//esc//'P21;240;1J'//esc//'\'
       write(iunit) esc//'<'                         ! soft reset
       write(iunit) csi//char(im1)//char(im2)//';;p' ! page format
    else
       write(iunit) esc//'<'                         ! soft reset
       write(iunit) csi//char(im1)//char(im2)//';;p' ! page format
       write(iunit) csi//char(im1+1)//'&z'           ! full paint mode 
    endif
    write(iunit) csi//'2 K'//csi//'72 C'//csi//'0y'  ! Set up text mode
    write(iunit) csi//'0&}'                          ! shift to vector mode

    write(iunit) '#'//is2                 ! begin picture
    write(iunit) '!0'//char(35)//'5'//is2 ! set scaling mode (dot)
    write(iunit) '$'//is2                 ! begin picture body
    write(iunit) '(0055'//is2             ! page orientation (land scape)

    write(iunit) 'E10' // is2             ! line type
    write(iunit) 'F1!' // is2             ! line width
    write(iunit) '}G0' // is2             ! line attribute
    if ( lmode.ge.3 ) then
       write(iunit) '}E1' // is2          ! line term
    endif

    call zlgetorg(ix, iy)

    call zlsetorg(ix, iy+joffset(1))
  end subroutine

  subroutine zlsetorg(ix, iy)
    write(iunit) '}"'
    call zzlxy(ix)
    call zzlxy(iy)
    write(iunit) is2
  end subroutine

  subroutine zlnewpage(npage)
    character cmsg*32

    cmsg = ' '
    call date(cmsg(1:9))
    call time(cmsg(11:18))
    write(cmsg(21:28), '(a,i3)') 'page', npage
    call zlqrct(xmin, xmax, ymin, ymax, fact)
    call zltrf(xmax-4.55, -0.4, ix, iy)

    write(iunit) '}p'
    call zzlxy(ix)
    call zzlxy(iy)
    write(iunit) is2 // cmsg(1:28) // csi // '0&}'

    nvec = 0                             ! reset dot graph
    write(imsg, '(/)')
    call zlsetorg(0, joffset(npage+1))
    if(pmode2.eq.1 .or. mod(npage,2).eq.0) then
      write(iunit) char(12)
    endif
  end subroutine

  subroutine zlclose
    write(iunit) '%' //is2                ! end vector mode
    write(iunit) '}p'//is2                ! back to text mode
    write(iunit) esc //'<'                ! soft reset

    if ( lmode.ge.3 ) then
       write(iunit) esc//'P0J'//esc//'\'//esc//'%@'
    endif
    close(iunit)
  end subroutine

  subroutine zzlxy(ix)
    idata=abs(ix)
    if(idata.lt.   16) then
      goto 10
    elseif(idata.lt. 1024) then
      n=0
    elseif(idata.lt.65536) then
      n=1
    else
      call msgdmp('e', 'zzlxy', 'too big ix')
    endif

    !---------- higher byte ------------
    do i = n, 0, -1
      ifact = 16*64**i
      nbyte = 64

      do n = 5, 0, -1
        ibase = 2**n
        ibf = ibase*ifact
        if(idata.ge.ibf) then
          nbyte = nbyte + ibase
          idata = idata - ibf
        endif
      end do

      write(iunit) char(nbyte)
    end do

    !----------- lowest byte -----------
 10 continue
    if(ix.lt.0) then
      nbyte = idata + 32
    else
      nbyte = idata + 48
    endif
    write(iunit) char(nbyte)
  end subroutine

  subroutine zzldot(ix, iy, ipen)
    logical   :: lfirst=.true.
    character(LEN=8), dimension(32) :: cmark3, cmark4

    data cmark3 / 14*'00000000', '0001c000', '0003e000', '0003e000', &
                     '0003e000', '0001c000', &
                  13*'00000000' /
    data cmark4 / 13*'00000000', '0001c000', '0003e000', '0007f000', &
                     '0007f000', '0007f000', '0003e000', '0001c000', &
                  12*'00000000'/

    if(lfirst) then                   !---- register marker -----
      lfirst = .false.
      write(iunit) '}@0*'//char(30)
      write(iunit)  cmark3
      write(iunit) '}@0+'//char(30)
      write(iunit)  cmark4
    endif
    
    if(ipen.eq.3) then                 !-- specify marker type --
      write(iunit) 'A*'//char(30)
    elseif(ipen.ge.4) then
      write(iunit) 'A+'//char(30)
    else
      return
    endif

    write(iunit) '0'
    call zzlxy(ix)
    call zzlxy(iy)
    write(iunit) char(30)
  end subroutine

  subroutine zzlbar     !--- bar graph ---
     nvec  = nvec + 1
    if(mod(nvec, 20).eq.16) then
      if(mod(nvec, 1000).eq.16) then
        write(imsg, '(/, tr1, i3,\)') nvec/1000
      else
        write(imsg, '(''.'',\)')
      endif
    endif
  end subroutine
end module ZLSHOT
!
!*************** line module ********************
!
module ZLLINE
  use ZLSHOT
  integer, private :: jx, jy, nline, jwdidx
  
contains
  subroutine zlqwdc(lflag)
    logical lflag
    lflag = .true.
  end subroutine

  subroutine zlqclc(lflag)
    logical lflag
    lflag = .false.
  end subroutine

  subroutine zlswdi(index)
    jwdidx = index
    if(jwdidx.eq.0) jwdidx=1
    jwdidx = mod(jwdidx-1, 9)/2 + 1
    if(jwdidx.gt.4) jwdidx = 4
  end subroutine

  subroutine zlscli(index)
  end subroutine

  subroutine zlgopn
    nline = 0
    write(iunit) 'F1'// char(jwdidx+32) // is2
  end subroutine

  subroutine zlgplt(xx, yy)
    if(nline.ge.300) then
      write(iunit) is2
      nline = 0
    endif

    if(nline.eq.0) then
      write(iunit) '1'
      call zzlxy(jx)
      call zzlxy(jy)
    endif

    call zltrf (xx, yy, ix, iy)
    call zzlxy (ix-jx)
    call zzlxy (iy-jy)
    jx = ix
    jy = iy
    nline = nline + 1

    call zzlbar
  end subroutine

  subroutine zlgmov(xx, yy)
    if(nline.ne.0) then
      write(iunit) is2
      if ( lmode.lt.3 ) then
         call zzldot(jx, jy, jwdidx)
      endif
      nline = 0
    endif

    call zltrf(xx, yy, jx, jy)
  end subroutine

  subroutine zlgcls
    if(nline.ne.0) then
      write(iunit) is2
      if ( lmode.lt.3 ) then
         call zzldot(jx, jy, jwdidx)
      endif
    endif
  end subroutine
end module ZLLINE
!
!************* BITMAP FILE *********************
!
module ZLBITMAP
    use ZLSHOT
    integer,    private, parameter :: npat=500
    integer(2), private :: ipat(npat, 2), ipos(npat), ilen(npat), nrec
    integer,    private :: iuttmp, jwtrot

contains
  subroutine ZLBMINI (cbfile)
    character cbfile*(*)

    iuttmp = iufopn()
    open (iuttmp, file=cbfile, access='direct', recl=4)
    read (iuttmp, rec=1) nrec
    do  i=1, npat
      read(iuttmp, rec=i+1     ) ipat(i,1), ipat(i,2)
      read(iuttmp, rec=i+npat+1) ipos(i),   ilen(i)
    end do
  end subroutine

  subroutine ZLSPATTERN(itptn)
    character :: cbuf*8, cmsg*32
    integer   :: itpz = -1
    
    if(itptn.ne.itpz) then
      itpz = itptn
      itrec = 1
      do while (ipat(itrec, jwtrot) .ne. itptn)
        itrec = itrec + 1
        if(itrec .gt. nrec) then
          cmsg = 'pattern (xxxxx) is not defined.'
          write(cmsg(10:14), '(i5)') itptn
          call msgdmp('w', 'zlspattern', cmsg)
          exit
        end if
      end do

      write(iunit) '}O0'//char(42)//is2
      do i=1, 32
        ips = ipos(itrec) + mod(i-1, ilen(itrec))
        read(iuttmp, rec=ips) ibit
        call hexdic(ibit,cbuf(1:8))
        write(iunit) cbuf(1:8) 
      end do
      write(iunit) 'I'//char(42)//'0'//is2
    endif
  end subroutine

  subroutine zlsrot(iwtrot)
    jwtrot=iwtrot
  end subroutine

  subroutine ZLBMCLS
    close (iuttmp)
  end subroutine
end module ZLBITMAP
!
!***************** tone module *******************
!
module ZLTONE
    use ZLBITMAP

contains
  subroutine zlqtnc(lflag)
    logical lflag
    lflag = .true.
  end subroutine

  subroutine zlgton(np, wpx, wpy, itpat)
    real      wpx ( * ), wpy ( * )

    call zlspattern (mod(itpat,1000))

    write(iunit) '2'
    call zltrf(wpx(1), wpy(1), jx, jy)
    call zzlxy(jx)
    call zzlxy(jy)
    do i = 2, np
      call zltrf(wpx(i), wpy(i), ix, iy)
      call zzlxy (ix-jx)
      call zzlxy (iy-jy)
      jx = ix
      jy = iy
    end do
    write(iunit) is2
    call zzlbar
  end subroutine
end module ZLTONE
!
!***************** image module ******************
!
module ZLIMAGE

contains
  subroutine zlqimc(lflag)
    logical lflag
    lflag = .false.
  end subroutine

  subroutine zliopn(iwx, iwy, imw, imh)
  end subroutine

  subroutine zlidat(image, nlen)
    integer(4) :: image(*)
  end subroutine

  subroutine zlicls
  end subroutine
end module ZLIMAGE
!
!********************* mouse module ***************
!
module ZLMOUSE

contains
  subroutine zlqptc(lflag)
    logical lflag
    lflag = .false.
  end subroutine

  subroutine zlqpnt(wx, wy, mb)
  end subroutine
end module ZLMOUSE
!
!********************ZLPACK CONTROL *****************
!
module ZLPACK
    use ZLLINE
    use ZLTONE
    use ZLIMAGE
    use ZLMOUSE
    integer, private :: npage

contains
  subroutine zldopn(mode, lbpmod, cbfile, cout)
    character cmsg*64
    character cout*(*), cbfile*(*)

    cmsg = ' initializing laser shot. (lbp mode: x)'
    write(cmsg(38:38),'(i1)') lbpmod
    write(imsg,'(a)') cmsg

    call zlcoini (mode, lbpmod)
    call zlbmini (cbfile)
    call zlopen  (cout)
  end subroutine

  subroutine zldcls
    write(imsg,'(a)') ' Closing LaserShot.'
    call zlclose
    call zlbmcls
  end subroutine

  subroutine zlpopn
    npage = npage + 1
    write(imsg, '('' page'', i3)') npage
  end subroutine

  subroutine zlpcls
    call zlnewpage(npage)
  end subroutine

  subroutine zloopn(cobj, comm)
    character cobj*(*), comm*(*)
  end subroutine

  subroutine zlocls(cobj)
     character cobj*(*)
  end subroutine
end module ZLPACK
