!-----------------------------------------------------------------------
!     Copyright (C) 2000-2004 GFD Dennou Club. All rights reserved.
!-----------------------------------------------------------------------
      PROGRAM G2PK02

	use dcl

	integer,parameter :: nx=15,ny=15

	real,dimension(nx) :: ux,uyw
	real,dimension(ny) :: uy,uxw
	real,dimension(nx,ny) :: cx,cy,z
	real,dimension(nx) :: terrain


!     / SET PARAMETERS /

      CALL GLRGET('RUNDEF',RUNDEF)

      DO  I=1,NX
        UX(I)=(I-1.0)/(NX-1.0) - 0.5
        TERRAIN(I) = 0.1 * EXP(-24*UX(I)**2)
	end do
      DO J=1,NY
        UY(J)=(J-1.0)/(NY-1.0)
	end do

      CX(1,1) = RUNDEF
      DO J=1,NY
        DO I=1,NX
          CY(I,J) = UY(J)*(1.0-TERRAIN(I)) + TERRAIN(I)
		end do
	end do

!     / GRAPHIC /
	call DclOpenGraphics
	call DclNewFrame
	call DclSetViewPort(0.15,0.85,0.15,0.85)
	call DclSetWindow(UX(1),UX(NX),UY(1),UY(NY))
	call DclSetTransNumber(51)
	call DclGrid2DSetCoordinateTransform(UX,UY,CX,CY)

	call DclSetTransFunction

!     / TONE /

      DO J=1,NY
        DO I=1,NX
          Z(I,J) = UX(I) * (1-UY(J))
		end do
	end do

	call DclSetParm('ENABLE_AUTO_SHADE_LEVEL',.TRUE.)
	call DclSetXGrid(ux)
	call DclSetYGrid(uy)
	call DclShadeContour(z)

!     / GRID LINES /

      DO J=1,NY
        DO I=1,NX
          UYW(I) = UY(J)
		end do
 !       CALL SGPLU(NX,UX,UYW)
	call DclDrawLine(UX,UYW)
	end do

      DO I=1,NX
        DO J=1,NY
          UXW(J) = UX(I)
		end do
!        CALL SGPLU(NY,UXW,UY)
	call DclDrawLine(UXW,UY)
	end do

!     / AXES  (Switch to ITR==1) /
	call DclGrid2DGetCoordinateTransform(CXMIN, CXMAX, CYMIN, CYMAX)
 	call DclSetWindow(CXMIN,CXMAX,CYMIN,CYMAX)
	call DclSetTransNumber(1)
	call DclSetTransFunction
	call DclDrawScaledAxis
	call DclDrawTitle('T','TERRAIN FOLLOWING',0.0)

	call DclCloseGraphics

      END
