*-----------------------------------------------------------------------
*     USPACK DRAW X-AXIS (LOG)                        S.Sakai  90/02/26
*                                                              92/02/22
*-----------------------------------------------------------------------

      SUBROUTINE USXAXL(CXS, NLBL, NTICKS, IXTYPE, XFAC, CUNIT)
      CHARACTER CXS*(*), CUNIT*(*), CXSUB*32, CSBLBL*32, CPOS*1, CP*8
      LOGICAL LAB1
      EXTERNAL CSBLBL, LENZ

      CALL ULIGET('IXTYPE', IT)
      CALL ULISET('IXTYPE', IXTYPE)

      CALL SGQTRN(ITR)
      IF(.NOT.(ITR.EQ.3 .OR. ITR.EQ.4))
     &   CALL MSGDMP('E', 'USXAXL', 'INVALID TRANSFORMATION NUMBER.')
      CALL SGQWND(XMIN, XMAX, YMIN, YMAX)

      XMINA = XMIN/XFAC
      XMAXA = XMAX/XFAC
      CALL SGSWND(XMINA, XMAXA, YMIN, YMAX)
      CALL SGSTRN(ITR)
      CALL SGSTRF

*---------------------------- X-AXIS -----------------------------------

      NXS = MIN(LEN(CXS), 2)
      DO 100 I=1, NXS
        CALL ULXLOG(CXS(I:I), NLBL, NTICKS)
        CP = 'LABELX'//CXS(I:I)
        CALL UZLGET(CP, LAB1)
        IF(LAB1) THEN
          CXSUB = CSBLBL(XFAC, 0., CUNIT)
          IF(LENZ(CXSUB).NE.0) THEN
            CALL USCGET('CXSPOS', CPOS)
            CALL USXSUB(CXS(I:I), CPOS, CXSUB, 3.)
          ENDIF
        ENDIF
  100 CONTINUE

*------------------------------ ----------------------------------------

      CALL SGSWND(XMIN, XMAX, YMIN, YMAX)
      CALL SGSTRN(ITR)
      CALL SGSTRF
      CALL ULISET('IXTYPE', IT)

      RETURN
      END
