!= Held and Suarez (1994) ˤ붯Ȼ
!
!= Forcing and dissipation suggested by Held and Suarez (1994)
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: phy_hs94.f90,v 1.9 2008-02-28 04:00:06 morikawa Exp $
! Tag Name::  $Name: dcpam4-20080427 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module phy_hs94
  != Held and Suarez (1994) ˤ붯Ȼ
  !
  != Forcing and dissipation suggested by Held and Suarez (1994)
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! Held and Suarez (1994) Ƥ봥絤 GCM ٥ޡѤ
  ! Ȼ׻ޤ. 
  ! Ϳ붯ȻȤ, پӾоξؤδñʥ˥塼ȥѤ, 
  ! ໤ɽ벼Υ쥤꡼໤Ѥޤ. 
  ! ܺ٤ʲ˵ޤ. 
  !
  ! Forcing and dissipation for dry air GCM benchmark
  ! suggested by Held and Suarez (1994) are caluclate.
  ! We use simple Newtonian relaxation of the temperature field to a
  ! zonally symmetric state and Rayleigh damping of low-level winds to
  ! represent boundary-layer friction.
  ! Their specifications are detailed as follows.
  !
  ! \[
  !    \left( \DP{\Dvect{v}}{t} \right)_{\mathrm{HS94}} = 
  !        - k_v (\sigma) \Dvect{v}, \] \[
  !    \left( \DP{T}{t} \right)_{\mathrm{HS94}} = 
  !        - k_T (\phi, \sigma) [T - T_{eq} (\phi,p)], \] \[
  !    T_{eq} = \mathrm{max}
  !     \left\{
  !        200 \mathrm{K}, 
  !        \left[
  !          315 \mathrm{K} - (\Delta T)_y \sin^2\phi 
  !                         - (\Delta \theta)_z 
  !                           \log \left(\frac{p}{p_0}\right) \cos^2\phi
  !        \right] \left(\frac{p}{p_0}\right)^\kappa
  !     \right\}, \] \[
  !    k_T = k_a + (k_s - k_a) 
  !          \mathrm{max} 
  !          \left(0, \frac{\sigma - \sigma_b}{1 - \sigma_b}\right) \cos^4\phi,
  !     \] \[
  !    k_v = k_f
  !          \mathrm{max} 
  !          \left(0, \frac{\sigma - \sigma_b}{1 - \sigma_b}\right),
  !     \] \[
  !    \sigma_b = 0.7, \qquad 
  !    k_f = 1 \mathrm{day}^{-1}, \qquad
  !    k_a = \Dinv{40} \mathrm{day}^{-1}, \qquad
  !    k_s = \Dinv{4} \mathrm{day}^{-1}, \] \[
  !    (\Delta T)_y = 60 \mathrm{K}, \qquad
  !    (\Delta \theta)_z = 10 \mathrm{K}, \qquad
  !    p_0 = 1000 \mathrm{hPa}, \qquad
  !    \kappa = \frac{R}{c_p}.
  ! \]
  !
  ! Forcing Ǥ, Ϳ줿®٤䲹 ( $ t+\Delta t$ ) 
  ! ФưʲΤ褦˶ȻŬѤޤ.
  !
  ! By Forcing, forcing and dissipation are applied to 
  ! given wind and temperature ($ t+\Delta t$ is expected) as follows.
  !
  ! \[
  !    \hat{\Dvect{v}}^{t+\Delta t} = 
  !      \Dvect{v}^{t+\Delta t} 
  !      + 2 \Delta t \left( \DP{\Dvect{v}}{t} \right)_{\mathrm{HS94}} \] \[
  !    \hat{T}^{t+\Delta t} = 
  !      T^{t+\Delta t} 
  !      + 2 \Delta t \left( \DP{T}{t} \right)_{\mathrm{HS94}}
  ! \]
  !
  !== Procedures List
  !
  ! PhyHsCreate        :: PHYHS94 ѿν
  ! PhyHsClose         :: PHYHS94 ѿνλ
  ! PhyHsPutLine       :: PHYHS94 ѿ˳ǼƤΰ
  ! PhyHsInitialized   :: PHYHS94 ѿꤵƤ뤫ݤ
  ! PhyHsForcing       :: Ȼη׻
  ! ------------  :: ------------
  ! PhyHsCreate        :: Constructor of "PHYHS94"
  ! PhyHsClose         :: Deconstructor of "PHYHS94"
  ! PhyHsPutLine       :: Print information of "PHYHS94"
  ! PhyHsInitialized   :: Check initialization of "PHYHS94"
  ! PhyHsForcing       :: Calculate forcing and dissipation
  !
  !== Usage
  !
  ! Ϥ, PHYHS94 ѿ, PhyHsCreate ǽԤޤ.
  ! Ȼη׻ PhyHsForcing Ѥޤ.
  ! PHYHS94 ѿνλˤ PhyHsClose ѤƤ.
  !
  ! First, initialize "PHYHS94" by "PhyHsCreate".
  ! Use "PhyHsForcing" in order to calculate forcing and dissipation
  ! In order to terminate "PHYHS94", use "PhyHsClose".
  !
  !== References
  !
  ! * Held, I. M., Suarez, M. J., 1994: 
  !   A proposal for the intercomparison of the dynamical cores of
  !   atmospheric general circuation models.
  !   <i>Bull. Am. Meteor. Soc.</i>, <b>75</b>, 1825--1830.
  !

  use dc_types, only: DP, TOKEN
  use dc_date_types, only: DC_DIFFTIME
  use gt4_history_nmlinfo, only: GTHST_NMLINFO
  implicit none
  private
  public:: PHYHS94, PhyHsCreate, PhyHsForcing
  public:: PhyHsClose, PhyHsPutLine, PhyHsInitialized, PhyHsSetTime

  type PHYHS94
    !
    ! ޤ, PhyHsCreate  "PHYHS94" ѿꤷƲ.
    ! ꤵ줿 "PHYHS94" ѿѤݤˤ,
    ! PhyHsClose ˤäƽλԤäƤ.
    !
    ! Initialize "PHYHS94" variable by "PhyHsCreate" before usage. 
    ! If you reuse "PHYHS94" variable again for another application, 
    ! terminate by "PhyHsClose".
    !
    logical:: initialized = .false.     ! ե饰. 
                                        ! Initialization flag

    !-----------------------------------------------------------------
    !  ʻȿ
    !  Grid points and maximum truncated wavenumber
    !-----------------------------------------------------------------
    integer:: imax ! ٳʻ. 
                   ! Number of grid points in longitude
    integer:: jmax ! ٳʻ. 
                   ! Number of grid points in latitude
    integer:: kmax ! ľؿ. 
                   ! Number of vertical level

    !-----------------------------------------------------------------
    !  ɸѿ
    !  Coordinate variables
    !-----------------------------------------------------------------
    real(DP), pointer:: x_Lon (:)
                              ! . Longitude
    real(DP), pointer:: x_Lon_Weight (:)
                              ! ʬѺɸŤ. 
                              ! Weight for integration in longitude
    real(DP), pointer:: y_Lat (:) =>null()
                              ! . Latitude
    real(DP), pointer:: y_Lat_Weight (:)
                              ! ʬѺɸŤ. 
                              ! Weight for integration in latitude
    real(DP), pointer:: z_Sigma (:) =>null()
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level

    !-----------------------------------------------------------------
    !  
    !  Time control
    !-----------------------------------------------------------------
    type(DC_DIFFTIME):: current_time
                              ! ߻. Current time.
    type(DC_DIFFTIME):: delta_time
                              ! $ Delta t $ . ॹƥå. Time step

    !-----------------------------------------------------------------
    !  ҥȥեؤΥǡ
    !  Configure the settings for history data output
    !-----------------------------------------------------------------
    type(GTHST_NMLINFO):: gthstnml
                              ! NAMELIST#phy_hs94_history_nml 
                              ! ꤵ̤ΥǡϾ. 
                              ! 
                              ! Individual data output information from 
                              ! "NAMELIST#phy_hs94_history_nml". 

    !-----------------------------------
    !  Held and Suarez (1994) ǻѤ뷸
    !  Coefficient used by Held and Suarez (1994) 
    real(DP):: Kappa      ! $ \kappa = R/C_p $ .
                          ! 갵ǮФ. Ratio of gas constant to specific heat
    real(DP):: P0             ! $ p_0 $ .
    real(DP):: DelTempY       ! $ (\Delta T)_y $ .
    real(DP):: DelPotTempZ    ! $ (\Delta \theta)_z $ .
    real(DP), pointer:: z_kv (:) =>null()
                              ! $ k_v $ .
    real(DP), pointer:: yz_kt (:,:) =>null()
                              ! $ k_T $ .
  end type PHYHS94

  character(*), parameter:: version = &
    & '$Name: dcpam4-20080427 $' // &
    & '$Id: phy_hs94.f90,v 1.9 2008-02-28 04:00:06 morikawa Exp $'

  !-----------------------------------------------------------------
  !  ³
  !  Public procedures
  !-----------------------------------------------------------------

  interface PhyHsCreate
    module procedure PhyHsCreate
  end interface

  interface PhyHsForcing
    module procedure PhyHsForcing
  end interface

  interface PhyHsClose
    module procedure PhyHsClose
  end interface

  interface PhyHsPutLine
    module procedure PhyHsPutLine
  end interface

  interface PhyHsInitialized
    module procedure PhyHsInitialized
  end interface

  interface PhyHsSetTime
    module procedure PhyHsSetTime
  end interface

!!$  interface PhyHsSample
!!$    module procedure PhyHsSample
!!$  end interface

  !-----------------------------------------------------------------
  !  ³
  !  Private procedures
  !-----------------------------------------------------------------

  interface NmlRead
    module procedure PhyHsNmlRead
  end interface

contains

  subroutine PhyHsCreate( phy_hs, &
    & imax, jmax, kmax, &
    & x_Lon, y_Lat, z_Sigma, DelTime, &
    & Cp, RAir, &
    & day_seconds, &
    & x_Lon_Weight, y_Lat_Weight, &
    & current_time_value, current_time_unit, &
    & history_varlist, &
    & history_interval_value, history_interval_unit, &
    & history_precision, history_fileprefix, &
    & nmlfile, err )
    !
    ! PHYHS94 ѿνԤޤ.
    ! ¾Υ֥롼ѤɬΥ֥롼ˤä
    ! PHYHS94 ѿꤷƤ.
    !
    ! ʤ, Ϳ줿 *phy_hs* ˽ꤵƤ,
    ! ץϥ顼ȯޤ.
    !
    ! NAMELIST Ѥˤϰ *nmlfile*  NAMELIST ե̾
    ! ͿƤ. NAMELIST ѿξܺ٤˴ؤƤ 
    ! NAMELIST#phy_hs94_nml 򻲾ȤƤ. 
    !
    ! Constructor of "PHYHS94".
    ! Initialize *phy_hs* by this subroutine, 
    ! before other procedures are used, 
    !
    ! Note that if *phy_hs* is already initialized 
    ! by this procedure, error is occurred.
    !
    ! In order to use NAMELIST, specify a NAMELIST filename to 
    ! argument *nmlfile*. See "NAMELIST#phy_hs94_nml"
    ! for details about a NAMELIST group.
    !
    use dc_trace, only: BeginSub, EndSub, DbgMessage
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_present, only: present_and_not_empty, present_and_true
    use dc_message, only: MessageNotify
    use dc_error, only: StoreError, DC_NOERR, DC_EALREADYINIT, &
      & DC_EARGLACK, DC_ENEGATIVE, DC_ENOFILEREAD, USR_ERRNO
    use dc_date_types, only: DAY_SECONDS_EARTH
    use dc_date, only: DCDiffTimeCreate
    use dc_hash, only: HASH, DCHashPut, DCHashRewind, DCHashNext, DCHashDelete
    use gt4_history_nmlinfo, only: HstNmlInfoCreate, HstNmlInfoAdd, &
      & HstNmlInfoEndDefine, HstNmlInfoPutLine
    use gt4_history, only: GT_HISTORY, &
      & HistoryAddVariable, HistoryAddAttr
    implicit none
    type(PHYHS94), intent(inout):: phy_hs
    integer, intent(in):: imax ! ٳʻ. 
                               ! Number of grid points in longitude
    integer, intent(in):: jmax ! ٳʻ. 
                               ! Number of grid points in latitude
    integer, intent(in):: kmax ! ľؿ. 
                               ! Number of vertical level
    real(DP), intent(in):: x_Lon (0:imax-1)
                              ! . Longitude
    real(DP), intent(in):: y_Lat (0:jmax-1)
                              ! . Latitude
    real(DP), intent(in):: z_Sigma (0:kmax-1)
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
    real(DP), intent(in):: DelTime    ! $ \Delta t $ . ॹƥå. Time step
    real(DP), intent(in):: Cp         ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
    real(DP), intent(in):: RAir       ! $ R $ .      絤.   Gas constant of air
    real(DP), intent(in), optional:: day_seconds
                              ! 1 ÿ. 
                              ! ΰͿʤ, 1 ÿ
                              ! 86400.0 Ȥʤޤ. 
                              ! 
                              ! Seconds in day. 
                              ! If this argument is not given, seconds in day
                              ! become 86400.0 .
    real(DP), intent(in), optional:: x_Lon_Weight (0:imax-1)
                              ! ʬѺɸŤ. 
                              ! Weight for integration in longitude
    real(DP), intent(in), optional:: y_Lat_Weight (0:jmax-1)
                              ! ʬѺɸŤ. 
                              ! Weight for integration in latitude
    real, intent(in), optional:: current_time_value
                              ! ߻ο. Numerical value of current time
    character(*), intent(in), optional:: current_time_unit
                              ! ߻ñ. Unit of current time
    character(*), intent(in), optional:: history_varlist
                              ! ҥȥǡνѿꥹ. 
                              ! ޤǶڤä¤٤. 
                              ! (: "Data1,Data2" ). 
                              ! 
                              ! List of variables output to history data. 
                              ! Delimiter is comma. 
                              ! (exp. "Data1,Data2" ). 
                              ! 
    real, intent(in), optional:: history_interval_value
                              ! ҥȥǡνϴֳ֤ο. 
                              ! Numerical value for interval of history data output
    character(*), intent(in), optional:: history_interval_unit
                              ! ҥȥǡνϴֳ֤ñ. 
                              ! Unit for interval of history data output
    character(*), intent(in), optional:: history_precision
                              ! ҥȥǡ. 
                              ! Precision of history data
    character(*), intent(in), optional:: history_fileprefix
                              ! ҥȥǡΥե̾Ƭ. 
                              ! Prefix of history data filenames
    character(*), intent(in), optional :: nmlfile
                              ! NAMELIST ե̾. 
                              ! ΰ˶ʸʳͿ, 
                              ! ꤵ줿ե뤫 
                              ! NAMELIST ѿɤ߹ߤޤ. 
                              ! եɤ߹ʤˤϥ顼
                              ! ޤ.
                              !
                              ! NAMELIST ѿξܺ٤˴ؤƤ 
                              ! NAMELIST#phy_hs94_nml 
                              ! 򻲾ȤƤ. 
                              !
                              ! NAMELIST file name. 
                              ! If nonnull character is specified to
                              ! this argument, 
                              ! NAMELIST group name is loaded from the 
                              ! file. 
                              ! If the file can not be read, 
                              ! an error occurs.
                              ! 
                              ! See "NAMELIST#phy_hs94_nml" 
                              ! for details about a NAMELIST group.
                              ! 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ҥȥեؤΥǡ
    !  Configure the settings for history data output
    character(STRING):: name = ''
                              ! ѿ̾. Variable identifier
    character(STRING):: longname = ''
                              ! ѿεŪ̾. Descriptive name of variables
    character(STRING), allocatable:: dims(:)
                              ! ɸ̾. Name of axes
    character(STRING):: units = ''
                              ! ñ. Units
    type(GT_HISTORY), pointer:: gthist =>null()
                              ! gt4_history ⥸塼ѹ¤. 
                              ! Derived type for "gt4_history" module
    character(TOKEN):: precision
                              ! ҥȥǡ. 
                              ! Precision of history data
    logical:: average
                              ! ϥǡʿѲե饰. 
                              ! Flag for average of output data
    type(HASH):: registered_varnames
                              ! Υ⥸塼뤫Ϥѿ̾Υꥹ.
                              ! 
                              ! List of names of variables output 
                              ! from this module. 
    logical:: end

    !-----------------------------------
    !  ѿ
    !  Work variables
    real(DP):: day_seconds_work
                              ! 1 ÿ. 
                              ! Seconds in day. 
    real(DP):: SigmaB         ! $ \sigma_b $ .
    real(DP):: kf             ! $ k_f $ .
    real(DP):: ka             ! $ k_a $ .
    real(DP):: ks             ! $ k_s $ .

    integer:: j, k            ! DO 롼Ѻѿ
                              ! Work variables for DO loop
    integer:: stat
    character(STRING):: cause_c
    real(DP), parameter:: PI = 3.1415926535897930_DP
                                ! $ \pi $ . ߼Ψ. Circular constant
    character(*), parameter:: subname = 'PhyHsCreate'
  continue
    call BeginSub( subname,  version = version, &
      & fmt = 'Cp=<%f> RAir=<%f>', &
      & d=(/Cp, RAir/) )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( phy_hs % initialized ) then
      stat = DC_EALREADYINIT
      cause_c = 'PHYHS94'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ͤΥå
    !  Validate setting values
    !-----------------------------------------------------------------
    if (imax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'imax'
      goto 999
    end if
    if (jmax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'jmax'
      goto 999
    end if
    if (kmax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'kmax'
      goto 999
    end if
    if (DelTime < 0.0_DP) then
      stat = DC_ENEGATIVE
      cause_c = 'DelTime'
      goto 999
    end if
    if ( present(day_seconds) ) then
      if (day_seconds < 0.0_DP) then
        stat = DC_ENEGATIVE
        cause_c = 'day_seconds'
        goto 999
      end if
    end if

    !-----------------------------------------------------------------
    !  ɸ
    !  Configure axes
    !-----------------------------------------------------------------
    phy_hs % imax  = imax 
    phy_hs % jmax  = jmax 
    phy_hs % kmax  = kmax 

    allocate( phy_hs % x_Lon (0:imax-1) )
    phy_hs % x_Lon = x_Lon

    allocate( phy_hs % y_Lat (0:jmax-1) )
    phy_hs % y_Lat = y_Lat

    allocate( phy_hs % z_Sigma (0:kmax-1) )
    phy_hs % z_Sigma = z_Sigma

    allocate( phy_hs % x_Lon_Weight (0:imax-1) )
    if ( present(x_Lon_Weight) ) then
      phy_hs % x_Lon_Weight = x_Lon_Weight
    else
      phy_hs % x_Lon_Weight = 2.0_DP * PI / imax
    end if

    allocate( phy_hs % y_Lat_Weight (0:jmax-1) )
    if ( present(y_Lat_Weight) ) then
      phy_hs % y_Lat_Weight = y_Lat_Weight
    else
      phy_hs % y_Lat_Weight = 2.0_DP / jmax
    end if

    !-----------------------------------------------------------------
    !  
    !  Time control
    !-----------------------------------------------------------------
    if ( present(current_time_value) .and. present(current_time_unit) ) then
      call DCDiffTimeCreate( &
        & diff = phy_hs % current_time, &      ! (out)
        & value = real(current_time_value, DP), & ! (in)
        & unit = current_time_unit )              ! (in)
    else
      call DCDiffTimeCreate( &
        & diff = phy_hs % current_time, & ! (out)
        & value = 0.0_DP, &    ! (in)
        & unit = 'sec' )       ! (in)
    end if

    call DCDiffTimeCreate( &
      & diff = phy_hs % delta_time, & ! (out)
      & value = DelTime, &             ! (in)
      & unit = 'sec' )                 ! (in)


    !-----------------------------------------------------------------
    !  ҥȥեؤΥǡ
    !  Configure the settings for history data output
    !-----------------------------------------------------------------

    !-------------------------
    !  ǥե
    !  Default values
    call HstNmlInfoCreate( gthstnml = phy_hs % gthstnml ) ! (inout)

    !-------------------------
    !  ץʥ
    !  Values from optional arguments
    call HstNmlInfoAdd( &
      & gthstnml = phy_hs % gthstnml, &   ! (inout)
      & name = '', &                               ! (in)
      & interval_value = history_interval_value, & ! (in)
      & interval_unit = history_interval_unit, &   ! (in)
      & precision = history_precision, &           ! (in)
      & average = .false., &                       ! (in)
      & fileprefix = history_fileprefix )          ! (in)

    if ( present(history_varlist) ) then
      call HstNmlInfoAdd( &
        & gthstnml = phy_hs % gthstnml, & ! (inout)
        & name = history_varlist )                 ! (in)
    end if

    !-----------------------------------------------------------------
    !  NAMELIST ͤɤ߹
    !  Load values from NAMELIST
    !-----------------------------------------------------------------
    if ( present_and_not_empty(nmlfile) ) then
      call MessageNotify( 'M', subname, &
        & 'Loading NAMELIST file "%c" ...', &
        & c1 = trim(nmlfile) )
      call NmlRead ( nmlfile = nmlfile, &          ! (in)
!!$        & CoefAlpha   = phy_hs % CoefAlpha, & ! (inout)
!!$        & key00_      = phy_hs % key00, &     ! (inout)
        & gthstnml    = phy_hs % gthstnml, &  ! (inout)
        & err = err )                              ! (out)
      if ( present_and_true(err) ) then
        call MessageNotify( 'W', subname, &
          & '"%c" can not be read.', &
          & c1 = trim(nmlfile) )
        stat = DC_ENOFILEREAD
        cause_c = nmlfile
        goto 999
      end if
    end if

    call HstNmlInfoEndDefine( &
      & gthstnml = phy_hs % gthstnml, & ! (inout)
      & err = err )                              ! (out)
    if ( present_and_true( err ) ) then
      stat = USR_ERRNO
      goto 999
    end if

    !-----------------------------------------------------------------
    !  
    !  Configure coefficients
    !-----------------------------------------------------------------
    phy_hs % Kappa = RAir / Cp

    if ( present(day_seconds) ) then
      day_seconds_work = day_seconds
    else
      day_seconds_work = DAY_SECONDS_EARTH
    end if

    phy_hs % P0          = 1000.0e2_DP
    phy_hs % DelTempY    = 60.0_DP
    phy_hs % DelPotTempZ = 10.0_DP

    SigmaB = 0.7_DP
    kf     = 1.0_DP / day_seconds_work
    ka     = 1.0_DP / ( 40.0_DP * day_seconds_work )
    ks     = 1.0_DP / (  4.0_DP * day_seconds_work )

    call DbgMessage( &
      & 'day_seconds=<%f>, SigmaB=<%f>, kf=<%f>, ka=<%f>, ks=<%f>', &
      & d=(/day_seconds_work, SigmaB, kf, ka, ks/) )

    allocate( phy_hs % z_kv (0:kmax-1) )

    phy_hs % z_kv = &
      & kf * max( 0.0_DP, &
      &           (    z_Sigma - SigmaB ) &
      &             / ( 1.0_DP - SigmaB ) &
      &         )

    allocate( phy_hs % yz_kt (0:jmax-1,0:kmax-1) )

    do k = 0, kmax - 1
      do j = 0, jmax - 1
        phy_hs % yz_kt(j,k) = &
          & ka + ( ks - ka ) &
          &  * max( 0.0_DP, &
          &         ( z_Sigma(k) - SigmaB ) &
          &           / ( 1.0_DP - SigmaB ) &
          &       ) * cos( y_Lat(j) ) ** 4
      end do
    end do

    !-----------------------------------------------------------------
    !  ǡϤν
    !  Initialize data output
    !-----------------------------------------------------------------

    !-------------------------
    !  xyz_DUDt ν
    !  Configure the settings for "xyz_DUDt" output
    name = 'DUDt'
    longname = 'eastward wind tendency'
    units = 'm s-2'
    allocate( dims(4) )
    dims = StoA( 'lon', 'lat', 'sig', 'time' )

    ! ϥեν.
    !   * gthist (gt4_history#GT_HISTORY) ꤵ.
    ! Initialize output file.
    !   * "gthist" (gt4_history#GT_HISTORY) is configured.
    call output_init  ! ֥롼. This is internal subroutine
    deallocate( dims )

    !-------------------------
    !  xyz_DVDt ν
    !  Configure the settings for "xyz_DVDt" output
    name = 'DVDt'
    longname = 'northward wind tendency'
    units = 'm s-2'
    allocate( dims(4) )
    dims = StoA( 'lon', 'lat', 'sig', 'time' )

    ! ϥեν.
    !   * gthist (gt4_history#GT_HISTORY) ꤵ.
    ! Initialize output file.
    !   * "gthist" (gt4_history#GT_HISTORY) is configured.
    call output_init  ! ֥롼. This is internal subroutine
    deallocate( dims )

    !-------------------------
    !  xyz_DTempDt ν
    !  Configure the settings for "xyz_DTempDt" output
    name = 'DTempDt'
    longname = 'temperature tendency'
    units = 'K s-1'
    allocate( dims(4) )
    dims = StoA( 'lon', 'lat', 'sig', 'time' )

    ! ϥեν.
    !   * gthist (gt4_history#GT_HISTORY) ꤵ.
    ! Initialize output file.
    !   * "gthist" (gt4_history#GT_HISTORY) is configured.
    call output_init  ! ֥롼. This is internal subroutine
    deallocate( dims )

    !-------------------------
    !  xyz_TempEQ ν
    !  Configure the settings for "xyz_TempEQ" output
    name = 'TempEQ'
    longname = 'equilibrium temperature'
    units = 'K'
    allocate( dims(4) )
    dims = StoA( 'lon', 'lat', 'sig', 'time' )

    ! ϥեν.
    !   * gthist (gt4_history#GT_HISTORY) ꤵ.
    ! Initialize output file.
    !   * "gthist" (gt4_history#GT_HISTORY) is configured.
    call output_init  ! ֥롼. This is internal subroutine
    deallocate( dims )

    !-----------------------------------------------------------------
    !  Υ⥸塼뤫Ϥѿ̾ΥꥹȤɽ
    !  Print list of names of variables output from this module
    !-----------------------------------------------------------------
    call Printf( STDOUT, &
      & ' *** MESSAGE *** +---- "%c" module output varnames list -----', &
      & c1 = 'phy_hs94' )
    call DCHashRewind( hashv = registered_varnames ) ! (inout)
    do
      call DCHashNext( hashv = registered_varnames, & ! (inout)
        & key = name, value = longname, end = end )   ! (out)
      if ( end ) exit
      call Printf( STDOUT, &
        & ' *** MESSAGE *** |      "%c" (%c)', &
        & c1 = trim(name), c2 = trim(longname) )
    enddo
    call DCHashDelete( hashv = registered_varnames ) ! (inout)
    call Printf( STDOUT, &
      & ' *** MESSAGE *** `----------------------------------------' )

    !-----------------------------------------------------------------
    !  ͤΥå
    !  Validate setting values
    !-----------------------------------------------------------------

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    phy_hs % initialized = .true.
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )

  contains

    subroutine output_init
      !
      ! ѿ *name* ˴ؤƽϥեνԤޤ. 
      ! ϥե̾ϴֳ֤ʤɤξ phy_hs % gthstnml 
      ! Фޤ. 
      ! 
      ! ѿ *name* ˴ؤƽϤԤˤ, 
      ! *gthist* ˽ե gt4_history#GT_HISTORY
      ! ѿ礵ޤ. Ǥʤ, *gthist* ֤ˤޤ. 
      !
      ! ޤ, ϥǡ٤ precision , 
      ! ϥǡʿѲβݤ average ꤷޤ. 
      ! 
      ! ɸϤɽѿꥹ *registered_varnames* 
      ! *name*, *longname*, *dims*, *units* Ͽޤ. 
      !
      ! An output file is initialized for a variable *name*. 
      ! Information such as the output filename and output intervals 
      ! is taken out of "phy_hs % gthstnml". 
      !
      ! When output is done for the variable *name*, *gthist* is 
      ! associated with the "gt4_history#GT_HISTORY" variable of 
      ! the output file. Otherwise, *gthist* is nullified. 
      !
      ! Moreover, the accuracy of output data is set to *precision*, and 
      ! right or wrong of averaging the output data is set to *average*. 
      !
      ! *name*, *longname*, *dims*, *units* are registered to 
      ! a list of variables *registered_varnames* that is printed to 
      ! standard output. 
      !
      use dc_date, only: DCDiffTimeCreate, EvalSec, EvalByUnit
      use gt4_history_nmlinfo, only: GTHST_NMLINFO, &
        & HstNmlInfoInitialized, HstNmlInfoInquire, &
        & HstNmlInfoOutputValid, HstNmlInfoAssocGtHist, HstNmlInfoPutLine
      use gt4_history, only: GT_HISTORY, &
        & HistoryCreate, HistoryAddVariable, HistoryPut, &
        & HistoryAddAttr, HistoryInitialized

      !-----------------------------------
      !  ѿ
      !  Work variables
      character(STRING):: file
                                ! ҥȥǡΥե̾. 
                                ! History data filenames
      character(STRING):: dims_str
                                ! ɸΥꥹ. 
                                ! List of axes
      real:: interval_value
                                ! ҥȥǡνϴֳ֤ο. 
                                ! Numerical value for interval of history data output
      character(TOKEN):: interval_unit
                                ! ҥȥǡνϴֳ֤ñ. 
                                ! Unit for interval of history data output
      real(DP), parameter:: PI = 3.1415926535897930_DP
                                ! $ \pi $ . ߼Ψ. Circular constant
    continue
      !-----------------------------------------------------------------
      !  ɸϤɽѿϿ
      !  Register a variable name for print to standard output
      !-----------------------------------------------------------------
      if ( allocated(dims) ) then
        dims_str = JoinChar( dims, ',' )
      else
        dims_str = ''
      end if
      call DCHashPut( hashv = registered_varnames, &     ! (inout)
        & key = name, &                                  ! (in)
        & value = trim( longname ) // ' [' // &
        &         trim( units ) // '] {' // &
        &         trim( dims_str ) // '}' ) ! (in)

      !-----------------------------------------------------------------
      !  ѿν
      !  Initialize variable
      !-----------------------------------------------------------------
      nullify( gthist )
      precision = 'float'
      average = .false.

      !-----------------------------------------------------------------
      !  Ϥͭɤǧ
      !  Confirm whether the output is effective
      !-----------------------------------------------------------------
      if ( .not. HstNmlInfoOutputValid( phy_hs % gthstnml, name ) ) then
        return
      end if

      !-----------------------------------------------------------------
      !  GT_HISTORY ѿμ
      !  Get "GT_HISTORY" variable
      !-----------------------------------------------------------------
      call HstNmlInfoAssocGtHist( &
        & gthstnml = phy_hs % gthstnml, & ! (in)
        & name = name, &                       ! (in)
        & history = gthist, &                  ! (out)
        & err = err )                          ! (out)
      if ( present_and_true( err ) ) return

      call HstNmlInfoInquire( &
        & gthstnml = phy_hs % gthstnml, & ! (in)
        & name = name, &                       ! (in)
        & precision = precision, &             ! (out)
        & average = average, &                 ! (out)
        & err = err )                          ! (out)
      if ( present_and_true( err ) ) return

      !-----------------------------------------------------------------
      !  GT_HISTORY ѿνγǧ
      !  Check initialization of "GT_HISTORY" variable
      !-----------------------------------------------------------------
      if ( HistoryInitialized( gthist ) ) then

        !---------------------------------------------------------------
        !  HistoryAddVariable ˤѿ
        !  A variable is created by "HistoryAddVariable"
        !---------------------------------------------------------------
        call HistoryAddVariable( &
          &  history = gthist, &                       ! (inout)
          &  varname = name,         dims = dims, &    ! (in)
          & longname = longname,    units = units, &   ! (in)
          &    xtype = precision, average = average )  ! (in)
        return
      end if

      !-----------------------------------------------------------------
      !  HistoryCreate Τͤμ
      !  Get the settings for "HistoryCreate"
      !-----------------------------------------------------------------
      call HstNmlInfoInquire( &
        & gthstnml = phy_hs % gthstnml, & ! (in)
        & name = name, &                       ! (in)
        & file = file, &                       ! (out)
        & interval_unit = interval_unit, &     ! (out)
        & interval_value = interval_value, &   ! (out)
        & err = err )                          ! (out)
      if ( present_and_true( err ) ) return

      !-----------------------------------------------------------------
      !  HistoryCreate ˤե
      !  Files are created by "HistoryCreate"
      !-----------------------------------------------------------------
      call HistoryCreate( &
        & history = gthist, &   ! (out)
        & file = file, &        ! (in)
        & title = 'Held and Suarez (1994) Forcing', &            ! (in)
        & source = 'dcpam4 : ' // trim(version), &               ! (in)
        & institution = 'GFD Dennou Club', &                     ! (in)
        & dims = StoA('lon', 'lat', 'sig', 'time'), &            ! (in)
        & dimsizes = (/ phy_hs % imax, phy_hs % jmax, &
        &               phy_hs % kmax, 0 /), &                ! (in)
        & longnames = StoA('longitude', 'latitude', &
        &                  'sigma at layer midpoints', &
        &                  'time'), &                            ! (in)
        & units = StoA( 'degree_east', 'degree_north', &
        &               '1', interval_unit ), &                  ! (in)
        & origin = real( EvalbyUnit( phy_hs % current_time, &
        &                            interval_unit) ), &         ! (in)
        & interval = interval_value, &                           ! (in)
        & err = err )                                            ! (out)
      if ( present_and_true( err ) ) then
        nullify( gthist )
        return
      end if

      call HistoryAddAttr( &
        & history = gthist, &                            ! (inout)
        & varname = 'lon', attrname = 'standard_name', & ! (in)
        & value = 'longitude' )                          ! (in)
      call HistoryAddAttr( &
        & history = gthist, &                            ! (inout)
        & varname = 'lat', attrname = 'standard_name', & ! (in)
        & value = 'latitude' )                           ! (in)
      call HistoryAddAttr( &
        & history = gthist, &                              ! (inout)
        & varname = 'sig', attrname = 'standard_name', &   ! (in)
        & value = 'atmosphere_sigma_coordinate' )          ! (in)
      call HistoryAddAttr( &
        & history = gthist, &                             ! (inout)
        & varname = 'time', attrname = 'standard_name', & ! (in)
        & value = 'time' )                                ! (in)
      call HistoryAddAttr( &
        & history = gthist, &                              ! (inout)
        & varname = 'sig', attrname = 'positive', &        ! (in)
        & value = 'down' )                                 ! (in)

      call HistoryPut( &
        & history = gthist, &                      ! (inout)
        & varname = 'lon', &                       ! (in)
        & array = phy_hs % x_Lon / PI * 180.0_DP ) ! (in)
      call HistoryPut( &
        & history = gthist, &                      ! (inout)
        & varname = 'lat', &                       ! (in)
        & array = phy_hs % y_Lat / PI * 180.0_DP ) ! (in)
      call HistoryPut( &
        & history = gthist, &          ! (inout)
        & varname = 'sig', &           ! (in)
        & array = phy_hs % z_Sigma )   ! (in)

      call HistoryAddVariable( &
        & history = gthist, &                                 ! (inout)
        & varname = 'lon_weight', &                           ! (in)
        & dims = StoA('lon'), &                               ! (in)
        & longname = 'weight for integration in longitude', & ! (in)
        & units = 'radian', xtype = 'double' )                ! (in)
      call HistoryAddAttr( &
        & history = gthist, &                                 ! (inout)
        & varname = 'lon', attrname = 'gt_calc_weight', &     ! (in)
        & value = 'lon_weight' )                              ! (in)
      call HistoryPut( &
        & history = gthist, &                     ! (inout)
        & varname = 'lon_weight', &               ! (in)
        & array = phy_hs % x_Lon_Weight )         ! (in)

      call HistoryAddVariable( &
        & history = gthist, &                                 ! (inout)
        & varname = 'lat_weight', &                           ! (in)
        & dims = StoA('lat'), &                               ! (in)
        & longname = 'weight for integration in latitude', &  ! (in)
        & units = 'radian', xtype = 'double' )                ! (in)
      call HistoryAddAttr( &
        & history = gthist, &                                 ! (inout)
        & varname = 'lat', attrname = 'gt_calc_weight', &     ! (in)
        & value = 'lat_weight' )                              ! (in)
      call HistoryPut( &
        & history = gthist, &                     ! (inout)
        & varname = 'lat_weight', &               ! (in)
        & array = phy_hs % y_Lat_Weight )         ! (in)

      !-----------------------------------------------------------------
      !  HistoryAddVariable ˤѿ
      !  A variable is created by "HistoryAddVariable"
      !-----------------------------------------------------------------
      if ( HistoryInitialized( gthist ) ) then
        call HistoryAddVariable( &
          &  history = gthist, &                       ! (inout)
          &  varname = name,         dims = dims, &    ! (in)
          & longname = longname,    units = units, &   ! (in)
          &    xtype = precision, average = average )  ! (in)
      else
        nullify( gthist )
      end if

    end subroutine output_init

  end subroutine PhyHsCreate

  subroutine PhyHsForcing( phy_hs, &
    & xyz_U,    xyz_V,    xyz_Temp, xy_Ps, &
    & xyz_DUDt, xyz_DVDt, xyz_DTempDt, &
    & historyput_flag, err )
    !
    ! ȤͿ줿® xyz_U, ® xyz_V, 
    !  xyz_Temp , 
    ! پӾоξؤδñʥ˥塼ȥѤ
    ! ໤ɽ벼Υ쥤꡼໤ˤ
    ! ®Ȳ٤ѲΨ, 
    ! xyz_DUDt, xyz_DVDt, xyz_DTempDt ֤ޤ. 
    !
    ! ʤ, Ϳ줿 *phy_hs*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Tendencies by simple Newtonian relaxation of the temperature field to a
    ! zonally symmetric state and Rayleigh damping of low-level winds to
    ! represent boundary-layer friction are calculated 
    ! from zonal wind "xyz_U", meridional wind "xyz_V", 
    ! temperature "xyz_Temp".
    ! And the tencencies are returned as 
    ! "xyz_DUDt", "xyz_DVDt", "xyz_DTempDt". 
    !
    ! If *phy_hs* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT, USR_ERRNO
    use dc_present, only: present_and_true
    use dc_date, only: EvalSec, EvalbyUnit, operator(+)
    use gt4_history_nmlinfo, only: HstNmlInfoInquire, &
      & HstNmlInfoOutputValid, HstNmlInfoAssocGtHist, HstNmlInfoPutLine
    use gt4_history, only: GT_HISTORY, HistoryPut, HistoryInitialized
    implicit none
    type(PHYHS94), intent(inout):: phy_hs
    real(DP), intent(in):: xyz_U (0:phy_hs%imax-1, 0:phy_hs%jmax-1, 0:phy_hs%kmax-1)
                              ! $ U $ . ®. 
                              ! Zonal wind
    real(DP), intent(in):: xyz_V (0:phy_hs%imax-1, 0:phy_hs%jmax-1, 0:phy_hs%kmax-1)
                              ! $ V $ . ®. 
                              ! Meridional wind
    real(DP), intent(in):: xyz_Temp (0:phy_hs%imax-1, 0:phy_hs%jmax-1, 0:phy_hs%kmax-1)
                              ! $ T $ . . 
                              ! Temperature
    real(DP), intent(in):: xy_Ps (0:phy_hs%imax-1, 0:phy_hs%jmax-1)
                              ! $ P_s $ . ɽ̵. 
                              ! Surface pressure
    real(DP), intent(out):: xyz_DUDt (0:phy_hs%imax-1, 0:phy_hs%jmax-1, 0:phy_hs%kmax-1)
                              ! $ \DP{U}{t} $ . ®Ѳ. 
                              ! Zonal wind tendency
    real(DP), intent(out):: xyz_DVDt (0:phy_hs%imax-1, 0:phy_hs%jmax-1, 0:phy_hs%kmax-1)
                              ! $ \DP{V}{t} $ . ®Ѳ. 
                              ! Meridional wind tendency
    real(DP), intent(out):: xyz_DTempDt (0:phy_hs%imax-1, 0:phy_hs%jmax-1, 0:phy_hs%kmax-1)
                              ! $ \DP{T}{t} $ . Ѳ. 
                              ! Temperature tendency
    logical, intent(in), optional:: historyput_flag
                              ! ǡϤΥե饰. 
                              ! SetTime ˤäƻŪ
                              ! ꤷˤ, ΰ
                              ! .true. ޤ .false. ꤹ
                              ! ȤǥǡϤΥ󥪥դ
                              ! Ū˻ꤹɬפޤ. 
                              ! ǥեȤ .false. Ǥ.
                              ! 
                              ! Data output flag. 
                              ! When time is specified by "SetTime", 
                              ! explicit specification of data output
                              ! on/off by specifying ".true." or ".false."
                              ! to this argument.
                              ! Default value is ".false.". 
                              ! 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ҥȥեؤΥǡ
    !  Configure the settings for history data output
    character(STRING):: name = ''
                              ! ѿ̾. Variable identifier
    real:: time
                              ! . Time
    type(GT_HISTORY), pointer:: gthist =>null()
                              ! gt4_history ⥸塼ѹ¤. 
                              ! Derived type for "gt4_history" module

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: jmax ! ٳʻ. 
                   ! Number of grid points in latitude
    integer:: kmax ! ľؿ. 
                   ! Number of vertical level

    real(DP):: y_Lat (0:phy_hs%jmax-1)
                              ! . Latitude
    real(DP):: z_Sigma (0:phy_hs%kmax-1)
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level

!!$    real(DP):: DelTime    ! $ \Delta t $ . ॹƥå. Time step

    real(DP):: Kappa      ! $ \kappa = R/C_p $ .
                          ! 갵ǮФ. Ratio of gas constant to specific heat

    real(DP):: P0             ! $ p_0 $ .
    real(DP):: DelTempY       ! $ (\Delta T)_y $ .
    real(DP):: DelPotTempZ    ! $ (\Delta \theta)_z $ .
    real(DP):: z_kv (0:phy_hs%kmax-1)
                              ! $ k_v $ .
    real(DP):: yz_kt (0:phy_hs%jmax-1, 0:phy_hs%kmax-1)
                              ! $ k_T $ .
    real(DP):: xyz_TempEQ (0:phy_hs%imax-1, 0:phy_hs%jmax-1, 0:phy_hs%kmax-1)
                              ! $ T_{eq} $ . ʿղ. 
                              ! Equilibrium temperature
    real(DP):: xyz_Press (0:phy_hs%imax-1, 0:phy_hs%jmax-1, 0:phy_hs%kmax-1)
                              ! $ T $ . . 
                              ! Pressure
    integer:: j, k            ! DO 롼Ѻѿ
                              ! Work variables for DO loop
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyHsForcing'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_hs % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYHS94'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *phy_hs* ˳ǼƤͤμФ
    !  Fetch setting values stored in *phy_hs*
    !-----------------------------------------------------------------
    jmax = phy_hs % jmax
    kmax = phy_hs % kmax

    y_Lat   = phy_hs % y_Lat
    z_Sigma = phy_hs % z_Sigma
!!$    DelTime = EvalSec( phy_hs % delta_time )

    Kappa   = phy_hs % Kappa

    P0          = phy_hs % P0
    DelTempY    = phy_hs % DelTempY
    DelPotTempZ = phy_hs % DelPotTempZ
    z_kv        = phy_hs % z_kv
    yz_kt       = phy_hs % yz_kt

    !-----------------------------------------------------------------
    !  ® $ U $ ® $ V $ إ쥤꡼໤Ŭ
    !  Apply Rayleigh damping to zonal wind $ U $ and meridional wind $ V $
    !-----------------------------------------------------------------
!!$    do k = 0, kmax - 1
!!$      xyz_U (:,:,k) = &
!!$        & xyz_U (:,:,k) &
!!$        & * ( 1.0_DP - 2.0_DP * DelTime * z_kv (k) )
!!$
!!$      xyz_V (:,:,k) = &
!!$        & xyz_V (:,:,k) &
!!$        & * ( 1.0_DP - 2.0_DP * DelTime * z_kv (k) )
!!$    end do

    do k = 0, kmax - 1
      xyz_DUDt (:,:,k) = - z_kv (k) * xyz_U (:,:,k)

      xyz_DVDt (:,:,k) = - z_kv (k) * xyz_V (:,:,k)
    end do


    !-----------------------------------------------------------------
    !   $ T $ إ˥塼ȥѤŬ
    !  Apply Newtonian relaxation to temperature $ T $
    !-----------------------------------------------------------------
    do k = 0, kmax - 1
       xyz_Press(:,:,k) = z_Sigma(k) * xy_Ps
    enddo

    do j = 0, jmax - 1
      xyz_TempEQ(:,j,:) = &
        & max( 200.0_DP, &
        &      ( 315.0_DP &
        &        - DelTempY * sin( y_Lat(j) ) ** 2 &
        &        - DelPotTempZ * log( xyz_Press(:,j,:) / P0 ) &
        &                                 * cos( y_Lat(j) ) ** 2 &
        &      ) &
        &      * ( xyz_Press(:,j,:) / P0 ) ** Kappa &
        &     )
    end do

!!$    do k = 0, kmax - 1
!!$      do j = 0, jmax - 1
!!$        xyz_Temp (:,j,k) = xyz_Temp (:,j,k) &
!!$          & - 2.0_DP * DelTime &
!!$          &   * yz_kt (j,k) * ( xyz_Temp (:,j,k) - xyz_TempEQ (:,j,k) )
!!$      end do
!!$    end do

    do k = 0, kmax - 1
      do j = 0, jmax - 1
        xyz_DTempDt (:,j,k) = &
          & - yz_kt (j,k) * ( xyz_Temp (:,j,k) - xyz_TempEQ (:,j,k) )
      end do
    end do


    !----------------------------------------------------------------
    !  ҥȥեؤΥǡ
    !  History data output
    !----------------------------------------------------------------

    !-------------------------
    !  xyz_DUDt ν
    !  Output "xyz_DUDt"
    name = 'DUDt'

    ! ϤΥå. 
    !   * gthist (gt4_history#GT_HISTORY), time (ñټ¿) ꤵ.
    ! Check for output.
    !   * "gthist" (gt4_history#GT_HISTORY), time (real) are configured.
    call output_check ! ֥롼. This is internal subroutine

    ! ϥǡ array Ϥ.
    ! Give output data to argument "array"
    if ( associated( gthist ) ) then
      call HistoryPut( &
        & history = gthist, &                 ! (inout)
        & varname = name, array = xyz_DUDt, & ! (in)
        & time = time, quiet = .false., &     ! (in)
        & err = err )                         ! (out)
    end if


    !-------------------------
    !  xyz_DVDt ν
    !  Output "xyz_DVDt"
    name = 'DVDt'

    ! ϤΥå. 
    !   * gthist (gt4_history#GT_HISTORY), time (ñټ¿) ꤵ.
    ! Check for output.
    !   * "gthist" (gt4_history#GT_HISTORY), time (real) are configured.
    call output_check ! ֥롼. This is internal subroutine

    ! ϥǡ array Ϥ.
    ! Give output data to argument "array"
    if ( associated( gthist ) ) then
      call HistoryPut( &
        & history = gthist, &                 ! (inout)
        & varname = name, array = xyz_DVDt, & ! (in)
        & time = time, quiet = .false., &     ! (in)
        & err = err )                         ! (out)
    end if


    !-------------------------
    !  xyz_DTempDt ν
    !  Output "xyz_DTempDt"
    name = 'DTempDt'

    ! ϤΥå. 
    !   * gthist (gt4_history#GT_HISTORY), time (ñټ¿) ꤵ.
    ! Check for output.
    !   * "gthist" (gt4_history#GT_HISTORY), time (real) are configured.
    call output_check ! ֥롼. This is internal subroutine

    ! ϥǡ array Ϥ.
    ! Give output data to argument "array"
    if ( associated( gthist ) ) then
      call HistoryPut( &
        & history = gthist, &                    ! (inout)
        & varname = name, array = xyz_DTempDt, & ! (in)
        & time = time, quiet = .false., &        ! (in)
        & err = err )                            ! (out)
    end if


    !-------------------------
    !  xyz_TempEQ ν
    !  Output "xyz_TempEQ"
    name = 'TempEQ'

    ! ϤΥå. 
    !   * gthist (gt4_history#GT_HISTORY), time (ñټ¿) ꤵ.
    ! Check for output.
    !   * "gthist" (gt4_history#GT_HISTORY), time (real) are configured.
    call output_check ! ֥롼. This is internal subroutine

    ! ϥǡ array Ϥ.
    ! Give output data to argument "array"
    if ( associated( gthist ) ) then
      call HistoryPut( &
        & history = gthist, &                   ! (inout)
        & varname = name, array = xyz_TempEQ, & ! (in)
        & time = time, quiet = .false., &       ! (in)
        & err = err )                           ! (out)
    end if

    !-----------------------------------------------------------------
    !  ι
    !  Update time
    !-----------------------------------------------------------------
    phy_hs % current_time = &
      & phy_hs % current_time + phy_hs % delta_time

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )

  contains

    subroutine output_check
      !
      ! ѿ *name* Ϥ뤫ɤåޤ. 
      ! Ϥ˴ؤ phy_hs % gthstnml Фޤ. 
      !
      ! ѿ *name* ˴ؤƽϤ褦ꤵƤˤ, 
      ! *gthist* ˽ե gt4_history#GT_HISTORY
      ! ѿ礵ޤ. Ǥʤ, *gthist* ֤ˤޤ. 
      !
      ! ޤ, ߻ *time* ꤷޤ. 
      !
      ! Check whether to output variable *name*. 
      ! Information about output is taken out of "phy_hs % gthstnml". 
      !
      ! When output is done for the variable *name*, *gthist* is 
      ! associated with "gt4_history#GT_HISTORY" variable of
      ! the output file. Otherwise, *gthist* is nullified. 
      !
      ! Moreover, current time is set to *time*. 
      !
      character(TOKEN):: interval_unit
                                ! ҥȥǡνϴֳ֤ñ. 
                                ! Unit for interval of history data output
    continue

      nullify( gthist )
      time = 0.0

      if ( HstNmlInfoOutputValid( phy_hs % gthstnml, name ) ) then
        call HstNmlInfoInquire( &
          & gthstnml = phy_hs % gthstnml, & ! (in)
          & name = name, &                     ! (in)
          & interval_unit = interval_unit )    ! (out)

        time = real( EvalbyUnit( phy_hs % current_time, interval_unit ) )
        if ( present_and_true( historyput_flag ) ) time = 0.0

        call HstNmlInfoAssocGtHist( & 
          & gthstnml = phy_hs % gthstnml, & 
          & name = name, &                     ! (in)
          & history = gthist, err = err )      ! (out)
        if ( present_and_true( err ) ) then
          nullify( gthist )
          return
        end if

        if ( .not. HistoryInitialized( gthist ) ) nullify( gthist )
      end if

    end subroutine output_check

  end subroutine PhyHsForcing

  subroutine PhyHsClose( phy_hs, err )
    !
    ! PHYHS94 ѿνλԤޤ.
    ! ʤ, Ϳ줿 *phy_hs*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Deconstructor of "PHYHS94".
    ! Note that if *phy_hs* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    use gt4_history_nmlinfo, only: HstNmlInfoClose, HstNmlInfoNames, &
      & HstNmlInfoAssocGtHist, HstNmlInfoPutLine
    use gt4_history, only: GT_HISTORY, HistoryClose, HistoryInitialized
    implicit none
    type(PHYHS94), intent(inout):: phy_hs
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ҥȥեؤΥǡ
    !  Configure the settings for history data output
    character(STRING):: name = ''
                              ! ѿ̾. Variable identifier
    character(STRING):: varnames
                              ! ѿ̾ꥹ. 
                              ! List of variables
    character(TOKEN), pointer:: varnames_array(:) =>null()
                              ! ѿ̾ꥹ. 
                              ! List of variables (array) 
    integer:: i, vnmax
    type(GT_HISTORY), pointer:: gthist =>null()
                              ! gt4_history ⥸塼ѹ¤. 
                              ! Derived type for "gt4_history" module

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyHsClose'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_hs % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYHS94'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  "PHYHS94" ξõ
    !  Clear the settings for "PHYHS94"
    !-----------------------------------------------------------------
    deallocate( phy_hs % x_Lon )
    deallocate( phy_hs % x_Lon_Weight )
    deallocate( phy_hs % y_Lat )
    deallocate( phy_hs % y_Lat_Weight )
    deallocate( phy_hs % z_Sigma )
    deallocate( phy_hs % z_kv )
    deallocate( phy_hs % yz_kt )

    !-----------------------------------------------------------------
    !  ҥȥեؤΥǡϤνλ
    !  Terminate the settings for history data output
    !-----------------------------------------------------------------
    varnames = HstNmlInfoNames( phy_hs % gthstnml )
    call Split( str = varnames, sep = ',', & ! (in)
      & carray = varnames_array )            ! (out)
    vnmax = size( varnames_array )

    do i = 1, vnmax
      name = varnames_array(i)
      if ( trim( name ) == '' ) exit
      nullify( gthist )
      call HstNmlInfoAssocGtHist( & 
        & gthstnml = phy_hs % gthstnml, & ! (in)
        & name = name, &                           ! (in)
        & history = gthist, &                      ! (out)
        & err = err )                              ! (out)
      if ( HistoryInitialized( gthist ) ) then

        call HistoryClose( history = gthist, & ! (inout)
          & err = err )                        ! (out)

      end if
    end do

    !-----------------------------------------------------------------
    !  ҥȥեؤΥǡγղ
    !  Deallocate the settings for history data output
    !-----------------------------------------------------------------
    call HstNmlInfoClose( &
      & phy_hs % gthstnml, & ! (inout)
      & err = err )                   ! (out)

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    phy_hs % initialized = .false.
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyHsClose

  subroutine PhyHsPutLine( phy_hs, unit, indent, err )
    !
    !  *phy_hs* ꤵƤޤ.
    ! ǥեȤǤϥåɸϤ˽Ϥޤ. 
    ! *unit* ֹꤹ뤳Ȥ, ѹ뤳ȤǽǤ.
    !
    ! Print information of *phy_hs*.
    ! By default messages are output to standard output.
    ! Unit number for output can be changed by *unit* argument.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    use dc_string, only: Printf
    use dc_date, only: EvalSec
    use gt4_history_nmlinfo, only: HstNmlInfoPutLine
    implicit none
    type(PHYHS94), intent(in):: phy_hs
    integer, intent(in), optional:: unit
                              ! ֹ.
                              ! ǥեȤνɸ.
                              !
                              ! Unit number for output.
                              ! Default value is standard output.
    character(*), intent(in), optional:: indent
                              ! ɽåλ.
                              !
                              ! Indent of displayed messages.
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: out_unit
    integer:: indent_len
    character(STRING):: indent_str
    character(*), parameter:: subname = 'PhyHsPutLine'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( present(unit) ) then
      out_unit = unit
    else
      out_unit = STDOUT
    end if

    indent_len = 0
    indent_str = ''
    if ( present(indent) ) then
      if ( len(indent) /= 0 ) then
        indent_len = len(indent)
        indent_str(1:indent_len) = indent
      end if
    end if


    !-----------------------------------------------------------------
    !  "PHYHS94" ΰ
    !  Print the settings for "PHYHS94"
    !-----------------------------------------------------------------
    if ( phy_hs % initialized ) then
      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & '#<PHYHS94:: @initialized=%y', &
        & l=(/phy_hs % initialized/))

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @imax=%d @jmax=%d @kmax=%d', &
        & i=(/phy_hs % imax, phy_hs % jmax, phy_hs % kmax/) )

      call Printf( unit = out_unit, &                             ! (in)
        & fmt = indent_str(1:indent_len) // &
        &       ' @current_time=%f [sec] @delta_time=%f [sec]', & ! (in)
        & d = (/ EvalSec( phy_hs % current_time ), &
        &        EvalSec( phy_hs % delta_time ) /) )              ! (in)

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @x_Lon=%*f', &
        & d=phy_hs % x_Lon, n=(/phy_hs % imax/) )

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @x_Lon_Weight=%*f', &
        & d=phy_hs % x_Lon_Weight, n=(/phy_hs % imax/) )

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @y_Lat=%*f', &
        & d=phy_hs % y_Lat, n=(/phy_hs % jmax/) )

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @y_Lat_Weight=%*f', &
        & d=phy_hs % y_Lat_Weight, n=(/phy_hs % jmax/) )

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @z_Sigma=%*f', &
        & d=phy_hs % z_Sigma, n=(/phy_hs % kmax/) )

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @Kappa=%f @P0=%f', &
        & d=(/phy_hs % Kappa, phy_hs % P0/) )

!!$      call Printf(out_unit, &
!!$        & indent_str(1:indent_len) // &
!!$        & ' @Cp=%f @RAir=%f @Kappa=%f', &
!!$        & d=(/phy_hs % Cp, phy_hs % RAir, phy_hs % Kappa/) )
!!$
!!$      call Printf(out_unit, &
!!$        & indent_str(1:indent_len) // &
!!$        & ' @SigmaB=%f @P0=%f @kf=%f @ka=%f @ks=%f', &
!!$        & d=(/phy_hs % SigmaB, phy_hs % P0, &
!!$        &     phy_hs % kf, phy_hs % ka, phy_hs % ks/) )

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @DelTempY=%f @DelPotTempZ=%f', &
        & d=(/phy_hs % DelTempY, phy_hs % DelPotTempZ/) )

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @z_kv=%*f', &
        & d=phy_hs % z_kv, n=(/phy_hs % kmax/) )

!!$      call Printf(out_unit, &
!!$        & indent_str(1:indent_len) // &
!!$        & ' @yz_kt=%*f', &
!!$        & d=pack( phy_hs % yz_kt ), n=(/phy_hs % jmax * phy_hs % kmax/) )

      call Printf( unit = out_unit, &         ! (in)
        & fmt = indent_str(1:indent_len) // &
        &       ' @gthstnml=' )               ! (in)
      call HstNmlInfoPutLine( &
        & gthstnml = phy_hs % gthstnml, &    ! (in)
        & unit = out_unit, &                          ! (in)
        & indent = indent_str(1:indent_len) // '  ' ) ! (in)

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & '>' )
    else
      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & '#<PHYHS94:: @initialized=%y>', &
        & l=(/phy_hs % initialized/))
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyHsPutLine

  logical function PhyHsInitialized( phy_hs ) result(result)
    !
    ! *phy_hs* ꤵƤˤ .true. ,
    ! ꤵƤʤˤ .false. ֤ޤ.
    !
    ! If *phy_hs* is initialized, .true. is returned.
    ! If *phy_hs* is not initialized, .false. is returned.
    !
    implicit none
    type(PHYHS94), intent(in):: phy_hs
  continue
    result = phy_hs % initialized
  end function PhyHsInitialized

  subroutine PhyHsSetTime( phy_hs, &
    & current_time_value, current_time_unit, &
    & err )
    !
    ! *phy_hs* ФƻԤޤ. 
    !
    ! ҥȥǡϤƤˤ, 
    ! ҥȥǡνϻꤷޤ. 
    ! ٤Ǥ⤳Υ֥롼Ƥˤ, 
    ! ʸΥҥȥǡˤΥ֥롼ƤӽФ, 
    ! ԤäƤ. 
    ! ޤ, ǡϤ륵֥롼ФƤ 
    ! ץʥ historyput_flag  .true. ͿƤ. 
    !
    ! ʤ, Ϳ줿 *phy_hs*  PhyHsCreate 
    ! ˤäƽꤵƤʤ, ץϥ顼ȯޤ. 
    !
    ! Set time to *phy_hs*. 
    !
    ! When history data are output, 
    ! the output time of history data are specified. 
    ! Once this subroutine is called, the time of history data must be 
    ! specified by this routine before history data output. 
    ! In additional, give ".true." to an optional argument 
    ! "historyput_flag" of a data output subroutine. 
    !
    ! If *phy_hs* is not initialized 
    ! by "PhyHsCreate" yet, error is occurred. 
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_date, only: DCDiffTimeCreate, EvalbyUnit
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    use gt4_history_nmlinfo, only: HstNmlInfoAdd, HstNmlInfoInquire, &
      & HstNmlInfoNames, HstNmlInfoAssocGtHist, &
      & HstNmlInfoOutputStepDisable, HstNmlInfoPutLine
    use gt4_history, only: GT_HISTORY, HistorySetTime, HistoryInitialized
    implicit none
    type(PHYHS94), intent(inout):: phy_hs
    real, intent(in):: current_time_value
                              ! ߻ο. Numerical value of current time
    character(*), intent(in):: current_time_unit
                              ! ߻ñ. Unit of current time
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ҥȥեؤΥǡ
    !  Configure the settings for history data output
    character(STRING):: name = ''
                              ! ѿ̾. Variable identifier
    character(TOKEN):: interval_unit
                              ! ҥȥǡνϴֳ֤ñ. 
                              ! Unit for interval of history data output
    character(STRING):: varnames
                              ! ѿ̾ꥹ. 
                              ! List of variables
    character(TOKEN), pointer:: varnames_array(:) =>null()
                              ! ѿ̾ꥹ. 
                              ! List of variables (array) 
    integer:: i, vnmax
    type(GT_HISTORY), pointer:: gthist =>null()
                              ! gt4_history ⥸塼ѹ¤. 
                              ! Derived type for "gt4_history" module

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyHsSetTime'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_hs % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYHS94'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  
    !  Configure time
    !-----------------------------------------------------------------
    call DCDiffTimeCreate( &
      & diff = phy_hs % current_time, &  ! (out)
      & value = real( current_time_value, DP ), & ! (in)
      & unit = current_time_unit )                ! (in)

    !-----------------------------------------------------------------
    !  ҥȥեؤΥǡλ
    !  Configure the time of history data
    !-----------------------------------------------------------------
    varnames = HstNmlInfoNames( phy_hs % gthstnml )
    call Split( str = varnames, sep = ',', & ! (in)
      & carray = varnames_array )            ! (out)
    vnmax = size( varnames_array )

    do i = 1, vnmax
      name = varnames_array(i)
      if ( trim( name ) == '' ) exit

      call HstNmlInfoOutputStepDisable( & 
        & gthstnml = phy_hs % gthstnml, & ! (inout)
        & name = name, &                           ! (in)
        & err = err )                              ! (out)

      nullify( gthist )
      call HstNmlInfoAssocGtHist( & 
        & gthstnml = phy_hs % gthstnml, & ! (in)
        & name = name, &                           ! (in)
        & history = gthist, &                      ! (out)
        & err = err )                              ! (out)

      if ( HistoryInitialized( gthist ) ) then
        call HstNmlInfoInquire( &
          & gthstnml = phy_hs % gthstnml, & ! (in)
          & name = name, &                           ! (in)
          & interval_unit = interval_unit )          ! (out)

        call HistorySetTime( &
          & history = gthist, &                     ! (inout)
          & time = &
          &   real( EvalbyUnit( phy_hs % current_time, &
          &                     interval_unit) ) ) ! (in)
      end if

    end do

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )

  end subroutine PhyHsSetTime

!!$  subroutine PhyHsSample( phy_hs, err )
!!$    !--
!!$    ! PhyHsSample 򵭽ҤƤ.
!!$    !++
!!$    ! ʤ, Ϳ줿 *phy_hs*  Create ˤäƽ
!!$    ! Ƥʤ, ץϥ顼ȯޤ.
!!$    !--
!!$    ! Describe brief of PhyHsSample
!!$    !++
!!$    ! If *phy_hs* is not initialized by "Create" yet,
!!$    ! error is occurred.
!!$    !
!!$    use dc_trace, only: BeginSub, EndSub
!!$    use dc_types, only: DP, STRING, TOKEN, STDOUT
!!$    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
!!$    implicit none
!!$    type(PHYHS94), intent(inout):: phy_hs
!!$    logical, intent(out), optional:: err
!!$                              ! 㳰ѥե饰.
!!$                              ! ǥեȤǤ, μ³ǥ顼
!!$                              ! , ץ϶λޤ.
!!$                              !  *err* Ϳ,
!!$                              ! ץ϶λ, 
!!$                              ! *err*  .true. ޤ.
!!$                              !
!!$                              ! Exception handling flag. 
!!$                              ! By default, when error occur in 
!!$                              ! this procedure, the program aborts. 
!!$                              ! If this *err* argument is given, 
!!$                              ! .true. is substituted to *err* and 
!!$                              ! the program does not abort. 
!!$
!!$!!$    integer:: param_i
!!$!!$    real(DP):: param_r
!!$!!$    character(STRING):: param_c
!!$
!!$    !-----------------------------------
!!$    !  ѿ
!!$    !  Work variables
!!$    integer:: stat
!!$    character(STRING):: cause_c
!!$    character(*), parameter:: subname = 'PhyHsSample'
!!$  continue
!!$    call BeginSub( subname )
!!$    stat = DC_NOERR
!!$    cause_c = ''
!!$
!!$    !-----------------------------------------------------------------
!!$    !  Υå
!!$    !  Check initialization
!!$    !-----------------------------------------------------------------
!!$    if ( .not. phy_hs % initialized ) then
!!$      stat = DC_ENOTINIT
!!$      cause_c = 'PHYHS94'
!!$      goto 999
!!$    end if
!!$
!!$    !-----------------------------------------------------------------
!!$    !  *phy_hs* ˳ǼƤͤμФ
!!$    !  Fetch setting values stored in *phy_hs*
!!$    !-----------------------------------------------------------------
!!$!!$    param_i = phy_hs % param_i
!!$!!$    param_r = phy_hs % param_r
!!$!!$    param_c = phy_hs % param_c
!!$
!!$
!!$    !-----------------------------------------------------------------
!!$    !  λ, 㳰
!!$    !  Termination and Exception handling
!!$    !-----------------------------------------------------------------
!!$999 continue
!!$    call StoreError( stat, subname, err, cause_c )
!!$    call EndSub( subname )
!!$  end subroutine PhyHsSample

  subroutine PhyHsNmlRead( nmlfile, &
!!$    & CoefAlpha, &
!!$    & key00_, &
    & gthstnml, &
    & err )
    !
    ! NAMELIST ե *nmlfile* ͤϤ뤿
    ! ֥롼Ǥ. PhyHsCreate ǸƤӽФ뤳Ȥ
    ! ꤷƤޤ.
    !
    ! ͤ NAMELIST եǻꤵƤʤˤ,
    ! Ϥ줿ͤΤޤ֤ޤ.
    !
    ! ʤ, *nmlfile* ˶ʸͿ줿, ޤ
    ! Ϳ줿 *nmlfile* ɤ߹ळȤǤʤ, 
    ! ץϥ顼ȯޤ.
    !
    ! This is an internal subroutine to input values from 
    ! NAMELIST file *nmlfile*. This subroutine is expected to be
    ! called by "PhyHsCreate".
    !
    ! A value not specified in NAMELIST file is returned
    ! without change.
    !
    ! If *nmlfile* is empty, or *nmlfile* can not be read, 
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_iounit, only: FileOpen
    use dc_message, only: MessageNotify
    use dc_present, only: present_and_true
    use dc_date, only: DCDiffTimeCreate
    use dc_error, only: StoreError, DC_NOERR, DC_ENOFILEREAD, DC_ENOASSOC
    use gt4_history_nmlinfo, only: GTHST_NMLINFO, HstNmlInfoAdd, &
      & HstNmlInfoInquire, HstNmlInfoInitialized, HstNmlInfoPutLine
    implicit none
    character(*), intent(in):: nmlfile
                              ! NAMELIST ե̾. 
                              ! NAMELIST file name
!!$    real(DP), intent(inout):: CoefAlpha
!!$                              ! $ \alpha $ . . Coefficient
!!$
!!$    character(*), intent(inout):: key00_
!!$    character(TOKEN):: key00
!!$                              ! . Keyword
!!$
    type(GTHST_NMLINFO), intent(inout):: gthstnml
                              ! NAMELIST#phy_hs94_history_nml 
                              ! ꤵ̤ΥǡϾ. 
                              ! 
                              ! ǥեͤʤɤ
                              ! ԤäͿ뤳. 
                              ! 
                              ! Individual data output information from 
                              ! "NAMELIST#phy_hs94_history_nml". 
                              ! 
                              ! Before this argument is given to 
                              ! this procedure, initialize and 
                              ! configure the defaut settings. 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

!!$    namelist /phy_hs94_nml/ &
!!$      & CoefAlpha, key00
                              ! phy_hs94 ⥸塼
                              ! NAMELIST ѿ̾.
                              !
                              ! phy_hs94#PhyHsCreate Ѥݤ, 
                              ! ץʥ *nmlfile*  NAMELIST 
                              ! ե̾ꤹ뤳Ȥ, Υե뤫
                              !  NAMELIST ѿɤ߹ߤޤ.
                              !
                              ! NAMELIST group name for
                              ! "phy_hs94" module.
                              ! 
                              ! If a NAMELIST filename is specified to 
                              ! an optional argument *nmlfile* 
                              ! when "phy_hs94#PhyHsCreate" is used, 
                              ! this NAMELIST group is loaded from 
                              ! the file.

    character(STRING):: name
                              ! ѿ̾. 
                              ! ξˤ, ¾ͤ
                              ! phy_hs94 ⥸塼ˤ
                              ! ϤǡƤ
                              ! ǥեͤȤʤޤ. 
                              ! 
                              ! "Data1,Data2" Τ褦˥ޤǶڤäʣ
                              ! ѿꤹ뤳ȤǽǤ. 
                              ! 
                              ! Variable identifier. 
                              ! If blank is given, other values are 
                              ! used as default values of output data 
                              ! in "phy_hs94". 
                              ! 
                              ! Multiple variables can be specified 
                              ! as "Data1,Data2" too. Delimiter is comma. 
    character(STRING):: file
                              ! ϥե̾. 
                              ! ϥǥեͤȤƤϻѤޤ. 
                              ! *name* ͤꤵƤΤͭǤ. 
                              ! 
                              ! Output file name. 
                              ! This is not used as default value. 
                              ! This value is valid only when *name* is 
                              ! specified. 

    real:: interval_value
                              ! ҥȥǡνϴֳ֤ο. 
                              ! ͤͿ, Ϥ޻ߤޤ. 
                              ! Numerical value for interval of history data output
                              ! Negative values suppresses output.
    character(TOKEN):: interval_unit
                              ! ҥȥǡνϴֳ֤ñ. 
                              ! Unit for interval of history data output
    character(TOKEN):: precision
                              ! ҥȥǡ. 
                              ! Precision of history data
    logical:: average
                              ! ϥǡʿѲե饰. 
                              ! Flag for average of output data
    character(STRING):: fileprefix
                              ! ҥȥǡΥե̾Ƭ. 
                              ! Prefixes of history data filenames

    namelist /phy_hs94_history_nml/ &
      & name, &
      & file, &
      & interval_value, &
      & interval_unit, &
      & precision, &
      & fileprefix, &
      & average
                              ! phy_hs94 ⥸塼Υҥȥǡ
                              ! NAMELIST ѿ̾.
                              !
                              ! phy_hs94#PhyHsCreate Ѥݤ, 
                              ! ץʥ *nmlfile*  NAMELIST 
                              ! ե̾ꤹ뤳Ȥ, Υե뤫
                              !  NAMELIST ѿɤ߹ߤޤ.
                              !
                              ! NAMELIST group name for 
                              ! history data of "phy_hs94" module.
                              ! 
                              ! If a NAMELIST filename is specified to 
                              ! an optional argument *nmlfile* 
                              ! when "phy_hs94#PhyHsCreate" is used, 
                              ! this NAMELIST group is loaded from 
                              ! the file.


    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read
    character(TOKEN):: pos_nml
                              ! NAMELIST ɤ߹߻Υե. 
                              ! File position of NAMELIST read
    character(*), parameter:: subname = 'PhyHsNmlRead'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------

    !-----------------------------------------------------------------
    !  ʸ NAMELIST ѿ
    !  Substitute character arguments to NAMELIST group
    !-----------------------------------------------------------------
!!$    key00       = key00_

    !----------------------------------------------------------------
    !  NAMELIST եΥץ
    !  Open NAMELIST file
    !----------------------------------------------------------------
    call FileOpen( unit = unit_nml, & ! (out)
      & file = nmlfile, mode = 'r', & ! (in)
      & err = err )                   ! (out)
    if ( present_and_true(err) ) then
      stat = DC_ENOFILEREAD
      cause_c = nmlfile
      goto 999
    end if


    !-----------------------------------------------------------------
    !  NAMELIST ѿμ
    !  Get NAMELIST group
    !-----------------------------------------------------------------
    !-------------------------
    !  ʤɤμ
    !  Get coefficients etc.
!!$    rewind( unit_nml )
!!$    read( unit = unit_nml, & ! (in)
!!$      & nml = phy_hs94_nml, iostat = iostat_nml ) ! (out)
!!$    if ( iostat_nml == 0 ) then
!!$      call MessageNotify( 'M', subname, &
!!$        & 'NAMELIST group "%c" is loaded from "%c".', &
!!$        & c1 = 'phy_hs94_nml', c2 = trim(nmlfile) )
!!$      write(STDOUT, nml = phy_hs94_nml)
!!$    else
!!$      call MessageNotify( 'W', subname, &
!!$        & 'NAMELIST group "%c" is not found in "%c" (iostat=%d).', &
!!$        & c1 = 'phy_hs94_nml', c2 = trim(nmlfile), &
!!$        & i = (/iostat_nml/) )
!!$    end if

    !-------------------------
    !  ϥǡθ̾μ
    !  Get individual information of output data
    rewind( unit_nml )
    iostat_nml = 0
    pos_nml = ''
    do while ( trim(pos_nml) /= 'APPEND' .and. iostat_nml == 0 )

      name                   = ''
      file                   = ''
      call HstNmlInfoInquire( &
        & gthstnml = gthstnml, &             ! (in)
        & interval_value = interval_value, & ! (out)
        & interval_unit = interval_unit, &   ! (out)
        & precision = precision, &           ! (out)
        & average = average, &               ! (out)
        & fileprefix = fileprefix )          ! (out)

      read( unit = unit_nml, &                      ! (in)
        &    nml = phy_hs94_history_nml, & ! (out)
        & iostat = iostat_nml )                     ! (out)
      inquire( unit = unit_nml, & ! (in)
        &  position = pos_nml )   ! (out)

      if ( iostat_nml == 0 ) then
        call MessageNotify( 'M', subname, &
          & 'NAMELIST group "%c" is loaded from "%c".', &
          & c1='phy_hs94_history_nml', c2=trim(nmlfile) )
        write(STDOUT, nml = phy_hs94_history_nml)

        call HstNmlInfoAdd( &
          & gthstnml = gthstnml, &             ! (in)
          & name = name, &                     ! (in)
          & file = file, &                     ! (in)
          & interval_value = interval_value, & ! (in)
          & interval_unit = interval_unit, &   ! (in)
          & precision = precision, &           ! (in)
          & average = average, &               ! (in)
          & fileprefix = fileprefix )          ! (in)

      else
        call MessageNotify( 'W', subname, &
          & 'NAMELIST group "%c" is not found in "%c" any more (iostat=%d).', &
          & c1='phy_hs94_history_nml', c2=trim(nmlfile), &
          & i = (/iostat_nml/) )
      end if
    end do

    close( unit_nml )

    !-----------------------------------------------------------------
    !  NAMELIST ѿʸ
    !  Substitute NAMELIST group to character arguments
    !-----------------------------------------------------------------
!!$    key00_       = key00

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyHsNmlRead

end module phy_hs94
