!= dcpam_error ⥸塼Υƥȥץ
!
!= Test program for "dcpam_error"
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: dcpam_error_test.f90,v 1.8 2007-08-03 06:45:22 morikawa Exp $
! Tag Name::  $Name: dcpam4-20080427 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
! <b>Note that Japanese and English are described in parallel.</b>
!
! dcpam_error ⥸塼ưƥȤԤΥץǤ.
! ΥץबѥǤ뤳, Ӽ¹Ի
! ץबｪλ뤳ȤǧƤ.
!
! This program checks the operation of "dcpam_error" module.
! Confirm compilation and execution of this program.
!
program dcpam_error_test
  use dcpam_error, only: DC_NOERR, StoreError
  use dcpam_error, only: DCPAM_ENEGATIVE
  use dc_test, only: AssertEqual
  use dc_types, only: TOKEN
  use dc_string, only: StoA
  use dc_args, only: ARGS, Open, HelpMsg, Option, Debug, Help, Strict, Close
  implicit none

  !---------------------------------------------------------
  !  ¸ɽ, ǥ̾, °̾
  !  Title of a experiment, name of model, sub-organ
  !---------------------------------------------------------
  character(*), parameter:: title = &
    & 'dcpam_error_test $Name: dcpam4-20080427 $ :: ' // &
    & 'Test program of "dcpam_error" module'
  character(*), parameter:: source = &
    & 'dcpam4 ' // &
    & '(See http://www.gfd-dennou.org/library/dcpam)'
  character(*), parameter:: institution = &
    & 'GFD Dennou Club (See http://www.gfd-dennou.org)'

  !---------------------------------------------------------
  !  ѿ
  !  Work variables
  !---------------------------------------------------------
  type(ARGS):: arg            ! ޥɥ饤. 
                              ! Command line arguments
  logical:: OPT_namelist      ! -N, --namelist ץ̵ͭ. 
                              ! Existence of '-N', '--namelist' option
  character(TOKEN):: VAL_namelist
                              ! -N, --namelist ץ. 
                              ! Value of '-N', '--namelist' option
  logical :: err
  character(*), parameter :: subname = 'dcpam_error_test'
continue

  !---------------------------------------------------------
  !  ޥɥ饤ν
  !  Command line arguments handling
  !---------------------------------------------------------
  call Open( arg )
  call HelpMsg( arg, 'Title', title )
  call HelpMsg( arg, 'Usage', &
    & './dcpam_error_test [Options]' )
  call HelpMsg( arg, 'Source', source )
  call HelpMsg( arg, 'Institution', institution )
  call Option( arg, StoA('-N', '--namelist'), &
    & OPT_namelist, VAL_namelist, help = "NAMELIST filename" )
  call Debug( arg ) ; call Help( arg ) ; call Strict( arg, severe = .true. )
  call Close( arg )

  !---------------------------------------------------------
  !  StoreError ƥ
  !  Test of "StoreError"
  !---------------------------------------------------------
  call StoreError( DC_NOERR, subname )

  call StoreError( DC_NOERR, subname, err=err )
  call AssertEqual( 'StoreError Test 1', .false., err )

  call StoreError( DCPAM_ENEGATIVE, subname, cause_c='arg1', err=err )
  call AssertEqual( 'StoreError Test 2', .true., err )

!  call StoreError( DCPAM_ENEGATIVE, subname, cause_c='arg1' )

end program dcpam_error_test
