!= ѱѥ᥿ꥼ: ήĴ᥹
!
!= Cumulus parameterization: Convective adjustment scheme
!
! Authors::   Yukiko YAMADA, Yasuhiro MORIKAWA
! Version::   $Id: phy_cumulus_adjust.f90,v 1.9 2008-04-20 18:55:50 morikawa Exp $
! Tag Name::  $Name: dcpam4-20080427 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]   
!

module phy_cumulus_adjust
  !
  != ѱѥ᥿ꥼ: ήĴ᥹
  !
  != Cumulus parameterization: Convective adjustment scheme
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ήĴ᥹ˤ, ٤漾Ĵᤷޤ. 
  !
  ! Adjust temperature and specific humidity by 
  ! convective adjustment scheme.
  !
  !== Procedures List
  !
  ! Create        :: PHYCUMAD ѿν
  ! Close         :: PHYCUMAD ѿνλ
  ! PutLine       :: PHYCUMAD ѿ˳ǼƤΰ
  ! initialized   :: PHYCUMAD ѿꤵƤ뤫ݤ
  ! Cumulus       :: ٤漾Ĵ
  ! ------------  :: ------------
  ! Create        :: Constructor of "PHYCUMAD"
  ! Close         :: Deconstructor of "PHYCUMAD"
  ! PutLine       :: Print information of "PHYCUMAD"
  ! initialized   :: Check initialization of "PHYCUMAD"
  ! Cumulus       :: Adjust temperature and specific humidity
  !
  !== Usage
  !
  ! Ϥ, PHYCUMAD ѿ, Create ǽԤޤ. 
  ! Cumulus ѤƲ٤ȼ٤ĴԤޤ. 
  ! PHYCUMAD ѿνλˤ Close ѤƤ.
  !
  ! First, initialize "PHYCUMAD" by "Create". 
  ! In order to adjust temperature and specific humidity, use "Cumulus". 
  ! In order to terminate "PHYCUMAD", use "Close".
  !

  use dc_types, only: DP, TOKEN
  use phy_saturate_nha92, only: PHYSATNHA
  implicit none
  private
  public:: PHYCUMAD, Create, Close, PutLine, initialized, Cumulus

  type PHYCUMAD
    !
    ! ޤ, Create  "PHYCUMAD" ѿꤷƲ.
    ! ꤵ줿 "PHYCUMAD" ѿѤݤˤ,
    ! Close ˤäƽλԤäƤ.
    !
    ! Initialize "PHYCUMAD" variable by "Create" before usage.
    ! If you reuse "PHYCUMAD" variable again for another application, 
    ! terminate by "Close".
    !
    logical:: initialized = .false.     ! ե饰. 
                                        ! Initialization flag
    integer:: imax ! ٳʻ. 
                   ! Number of grid points in longitude
    integer:: jmax ! ٳʻ. 
                   ! Number of grid points in latitude
    integer:: kmax ! ľؿ. 
                   ! Number of vertical level
    real(DP):: Grav      ! $ g $ .      ϲ®.     Gravitational acceleration
    real(DP):: Cp        ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
    real(DP):: RAir      ! $ R $ .      絤.   Gas constant of air
    real(DP):: EL        ! $ L $ .      ζŷǮ. Latent heat of condensation of water vapor
    real(DP):: RVap      ! $ R_v $ .    . Gas constant of water vapor
    real(DP):: EpsV      ! $ \epsilon_v $ .        ʬ. Molecular weight ratio of water vapor
    real(DP):: ES0       ! $ e^{*} $ (273K) .      0 Ǥ˰¾. Saturation vapor pressure at 0 degrees C
    real(DP):: DelTime    ! $ \Delta t $ . ॹƥå. Time step

    real(DP):: CrtlRH
                              ! ׳м. 
                              ! Critical relative humidity
    integer:: IterationMax
                              ! ƥ졼. 
                              ! Number of iteration

    real(DP), pointer:: TempSatMax(:) =>null()
                              ! ԰εƸ. 
                              ! Admissible error of unstability

    !-----------------------------------
    !  ˰漾׻ѥ֥
    !  Object for calculation of saturation specific humidity
    type(PHYSATNHA):: phy_sat

  end type PHYCUMAD

  character(*), parameter:: version = &
    & '$Name: dcpam4-20080427 $' // &
    & '$Id: phy_cumulus_adjust.f90,v 1.9 2008-04-20 18:55:50 morikawa Exp $'

  interface Create
    module procedure PhyCumulusAdjustCreate
  end interface

  interface Close
    module procedure PhyCumulusAdjustClose
  end interface

  interface PutLine
    module procedure PhyCumulusAdjustPutLine
  end interface

  interface initialized
    module procedure PhyCumulusAdjustInitialized
  end interface

  interface NmlRead
    module procedure PhyCumulusAdjustNmlRead
  end interface

  interface Cumulus
    module procedure PhyCumulusAdjustCumulus
  end interface

!!$  interface Sample
!!$    module procedure PhyCumulusAdjustSample
!!$  end interface

contains

  subroutine PhyCumulusAdjustCreate( phy_cumad, &
    & imax, jmax, kmax, &
    & Grav, Cp, RAir, EL, RVap, EpsV, ES0, &
    & DelTime, &
    & nmlfile, err )
    !
    ! PHYCUMAD ѿνԤޤ.
    ! ¾Υ֥롼ѤɬΥ֥롼ˤä
    ! PHYCUMAD ѿꤷƤ.
    !
    ! ʤ, Ϳ줿 *phy_cumad* ˽ꤵƤ,
    ! ץϥ顼ȯޤ.
    !
    ! NAMELIST Ѥˤϰ *nmlfile*  NAMELIST ե̾
    ! ͿƤ. NAMELIST ѿξܺ٤˴ؤƤ 
    ! NAMELIST#phy_cumulus_adjust_nml 򻲾ȤƤ. 
    !
    ! Constructor of "PHYCUMAD".
    ! Initialize *phy_cumad* by this subroutine, 
    ! before other procedures are used, 
    !
    ! Note that if *phy_cumad* is already initialized 
    ! by this procedure, error is occurred.
    !
    ! In order to use NAMELIST, specify a NAMELIST filename to 
    ! argument *nmlfile*. See "NAMELIST#phy_cumulus_adjust_nml"
    ! for details about a NAMELIST group.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_present, only: present_and_not_empty, present_and_true
    use dc_message, only: MessageNotify
    use dc_error, only: StoreError, DC_NOERR, DC_EALREADYINIT, &
      & DC_EARGLACK, DC_ENEGATIVE, DC_ENOFILEREAD
    use phy_saturate_nha92, only: PhySatNhaCreate
    implicit none
    type(PHYCUMAD), intent(inout):: phy_cumad
    integer, intent(in):: imax ! ٳʻ. 
                   ! Number of grid points in longitude
    integer, intent(in):: jmax ! ٳʻ. 
                   ! Number of grid points in latitude
    integer, intent(in):: kmax ! ľؿ. 
                   ! Number of vertical level
    real(DP), intent(in):: Grav      ! $ g $ .      ϲ®.     Gravitational acceleration
    real(DP), intent(in):: Cp        ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
    real(DP), intent(in):: RAir      ! $ R $ .      絤.   Gas constant of air
    real(DP), intent(in):: EL        ! $ L $ .      ζŷǮ. Latent heat of condensation of water vapor
    real(DP), intent(in):: RVap      ! $ R_v $ .    . Gas constant of water vapor
    real(DP), intent(in):: EpsV      ! $ \epsilon_v $ .        ʬ. Molecular weight ratio of water vapor
    real(DP), intent(in):: ES0       ! $ e^{*} $ (273K) .      0 Ǥ˰¾. Saturation vapor pressure at 0 degrees C
    real(DP), intent(in):: DelTime    ! $ \Delta t $ . ॹƥå. Time step
    character(*), intent(in), optional:: nmlfile
                              ! NAMELIST ե̾. 
                              ! ΰ˶ʸʳͿ, 
                              ! ꤵ줿ե뤫 
                              ! NAMELIST ѿɤ߹ߤޤ. 
                              ! եɤ߹ʤˤϥ顼
                              ! ޤ.
                              !
                              ! NAMELIST ѿξܺ٤˴ؤƤ 
                              ! NAMELIST#phy_cumulus_adjust_nml 
                              ! 򻲾ȤƤ. 
                              !
                              ! NAMELIST file name. 
                              ! If nonnull character is specified to
                              ! this argument, 
                              ! NAMELIST group name is loaded from the 
                              ! file. 
                              ! If the file can not be read, 
                              ! an error occurs.
                              ! 
                              ! See "NAMELIST#phy_cumulus_adjust_nml" 
                              ! for details about a NAMELIST group.
                              ! 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyCumulusAdjustCreate'
  continue
    call BeginSub( subname, version )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( phy_cumad % initialized ) then
      stat = DC_EALREADYINIT
      cause_c = 'PHYCUMAD'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  Υå
    !  Validate arguments
    !-----------------------------------------------------------------
    if (imax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'imax'
      goto 999
    end if
    if (jmax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'jmax'
      goto 999
    end if
    if (kmax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'kmax'
      goto 999
    end if
    if (DelTime < 0.0_DP) then
      stat = DC_ENEGATIVE
      cause_c = 'DelTime'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  "PHYCUMAD" 
    !  Configure the settings for "PHYCUMAD"
    !-----------------------------------------------------------------
    phy_cumad % imax    = imax   
    phy_cumad % jmax    = jmax   
    phy_cumad % kmax    = kmax   
    phy_cumad % Grav    = Grav   
    phy_cumad % Cp      = Cp     
    phy_cumad % RAir    = RAir   
    phy_cumad % EL      = EL     
    phy_cumad % RVap    = RVap   
    phy_cumad % EpsV    = EpsV   
    phy_cumad % ES0     = ES0    
    phy_cumad % DelTime = DelTime

    !-------------------------
    !  ǥե
    !  Default values
!!$    phy_cumad % param_r = 0.0_DP
!!$    phy_cumad % param_c = 'hogehoge'

    !-------------------------
    !  ץʥ
    !  Values from optional arguments
!!$    phy_cumad % param_i = param_i
!!$    if ( present(param_r) )  phy_cumad % param_r = param_r
!!$    if ( present(param_c) )  phy_cumad % param_c = param_c

    !-------------------------
    !  NAMELIST 
    !  Values from NAMELIST

!!$    if ( present_and_not_empty(nmlfile) ) then
!!$      call MessageNotify( 'M', subname, &
!!$        & 'Loading NAMELIST file "%c" ...', &
!!$        & c1 = trim(nmlfile) )
!!$      call NmlRead ( nmlfile = nmlfile, &      ! (in)
!!$        & param_i = phy_cumad % param_i, &   ! (inout)
!!$        & param_r = phy_cumad % param_r, &   ! (inout)
!!$        & param_c_ = phy_cumad % param_c, &  ! (inout)
!!$        & err = err )                          ! (out)
!!$      if ( present_and_true(err) ) then
!!$        call MessageNotify( 'W', subname, &
!!$          & '"%c" can not be read.', &
!!$          & c1 = trim(nmlfile) )
!!$        stat = DC_ENOFILEREAD
!!$        cause_c = nmlfile
!!$        goto 999
!!$      end if
!!$    end if

    !-----------------------------------------------------------------
    !  ׳м٤԰εƸ
    !  Configure critical relative humidity and admissible error of unstability
    !-----------------------------------------------------------------
    phy_cumad % CrtlRH = 0.990_DP
    phy_cumad % IterationMax = 10

    allocate( phy_cumad % TempSatMax (1:phy_cumad % IterationMax) )

    phy_cumad % TempSatMax(1:phy_cumad % IterationMax) = &
      & (/ 0.01_DP, 0.02_DP, 0.02_DP, 0.05_DP, 0.05_DP, &
      &    0.10_DP, 0.10_DP, 0.20_DP, 0.20_DP, 0.40_DP  /)

    !-----------------------------------------------------------------
    !  ˰漾׻ѥ֥Ȥν
    !  Initialize object for calculation of saturation specific humidity
    !-----------------------------------------------------------------
    call PhySatNhaCreate( &
      & phy_sat_nha = phy_cumad % phy_sat, &     ! (out)
      & imax = imax, jmax = jmax, kmax = kmax, & ! (in)
      & EpsV = EpsV, &                           ! (in)
      & err = err )                              ! (out)

    !-----------------------------------------------------------------
    !  ͤΥå
    !  Validate setting values
    !-----------------------------------------------------------------
!!$    if ( phy_cumad % param_i < 0 ) then
!!$      stat = DC_ENEGATIVE
!!$      cause_c = 'param_i'
!!$      goto 999
!!$    end if


    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    phy_cumad % initialized = .true.
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyCumulusAdjustCreate

  subroutine PhyCumulusAdjustCumulus( phy_cumad, &
    & xyz_Temp, xyz_QVap, &
    & xyz_Press, xyr_Press, &
    & xy_Rain, xyz_DTempDt, xyz_DQVapDt, &
    & err )
    !
    ! ήĴ᥹ˤ, ٤漾Ĵᤷޤ. 
    !
    ! ʤ, Ϳ줿 *phy_cumad*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Adjust temperature and specific humidity by 
    ! convective adjustment scheme.
    !
    ! If *phy_cumad* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    use phy_saturate_nha92, only: CalcQVapSat, CalcDQVapSatDTemp
    implicit none
    type(PHYCUMAD), intent(inout):: phy_cumad
    real(DP), intent(inout):: xyz_Temp (0:phy_cumad%imax-1, 0:phy_cumad%jmax-1, 0:phy_cumad%kmax-1)
                              ! $ T $ .     . Temperature
    real(DP), intent(inout):: xyz_QVap (0:phy_cumad%imax-1, 0:phy_cumad%jmax-1, 0:phy_cumad%kmax-1)
                              ! $ q $ .     漾. Specific humidity
    real(DP), intent(in):: xyz_Press (0:phy_cumad%imax-1, 0:phy_cumad%jmax-1, 0:phy_cumad%kmax-1)
                              ! $ p $ .  (٥). 
                              ! Surface pressure (full level)
    real(DP), intent(in):: xyr_Press (0:phy_cumad%imax-1, 0:phy_cumad%jmax-1, 0:phy_cumad%kmax)
                              ! $ p $ .  (Ⱦ٥). 
                              ! Surface pressure (half level)
    real(DP), intent(out):: xy_Rain (0:phy_cumad%imax-1, 0:phy_cumad%jmax-1)
                              ! ߿. 
                              ! Precipitation
    real(DP), intent(out):: xyz_DTempDt (0:phy_cumad%imax-1, 0:phy_cumad%jmax-1, 0:phy_cumad%kmax-1)
                              ! ѲΨ. 
                              ! Temperature tendency
    real(DP), intent(out):: xyz_DQVapDt (0:phy_cumad%imax-1, 0:phy_cumad%jmax-1, 0:phy_cumad%kmax-1)
                              ! 漾ѲΨ. 
                              ! Specific humidity tendency
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: imax ! ٳʻ. 
                   ! Number of grid points in longitude
    integer:: jmax ! ٳʻ. 
                   ! Number of grid points in latitude
    integer:: kmax ! ľؿ. 
                   ! Number of vertical level
    real(DP):: Grav      ! $ g $ .      ϲ®.     Gravitational acceleration
    real(DP):: Cp        ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
    real(DP):: RAir      ! $ R $ .      絤.   Gas constant of air
    real(DP):: EL        ! $ L $ .      ζŷǮ. Latent heat of condensation of water vapor
    real(DP):: RVap      ! $ R_v $ .    . Gas constant of water vapor
    real(DP):: EpsV      ! $ \epsilon_v $ .        ʬ. Molecular weight ratio of water vapor
    real(DP):: ES0       ! $ e^{*} $ (273K) .      0 Ǥ˰¾. Saturation vapor pressure at 0 degrees C
    real(DP):: DelTime    ! $ \Delta t $ . ॹƥå. Time step

    real(DP):: CrtlRH
                              ! ׳м. 
                              ! Critical relative humidity
    integer:: IterationMax
                              ! ƥ졼. 
                              ! Number of iteration

    real(DP), allocatable:: TempSatMax(:)
                              ! ԰εƸ. 
                              ! Admissible error of unstability


    real(DP):: xyz_QVapB (0:phy_cumad%imax-1, 0:phy_cumad%jmax-1, 0:phy_cumad%kmax-1)
                              ! Ĵ漾. 
                              ! Specific humidity before adjust. 
    real(DP):: xyz_TempB (0:phy_cumad%imax-1, 0:phy_cumad%jmax-1, 0:phy_cumad%kmax-1)
                              ! Ĵβ. 
                              ! Temperature before adjust. 
    logical:: xy_Adjust (0:phy_cumad%imax-1, 0:phy_cumad%jmax-1)
                              ! Ĵᤵ줿ݤ?. 
                              ! Whether it was adjusted this time or not?
    logical:: xy_AdjustB (0:phy_cumad%imax-1, 0:phy_cumad%jmax-1)
                              ! Ĵᤵ줿ݤ?. 
                              ! Whether it was adjusted last time or not?
    real(DP):: xyz_DPressDz (0:phy_cumad%imax-1, 0:phy_cumad%jmax-1, 0:phy_cumad%kmax-1)
                              ! $ \DD{p}{z} $
                              !
    real(DP):: xyz_QVapSat (0:phy_cumad%imax-1, 0:phy_cumad%jmax-1, 0:phy_cumad%kmax-1)
                              ! ˰漾. 
                              ! Saturation specific humidity. 
    real(DP):: xyz_DDPressDDPress (0:phy_cumad%imax-1, 0:phy_cumad%jmax-1, 0:phy_cumad%kmax-1)
                              ! $ \DD{p_{k}}{p_{k-1}} $
                              !
    real(DP):: xyz_DPFact (0:phy_cumad%imax-1, 0:phy_cumad%jmax-1, 0:phy_cumad%kmax-1)
                              ! $ (R / C_p)
                              ! \frac{p_{k-1} - p_{k}}{2 p_{k-1/2}} $ . 
                              !
                              ! ե. 
                              ! Factor
    real(DP):: TempSat        ! $ S_t $ .
                              ! ˰². 
                              ! Saturation temperature
    real(DP):: DelTempSat
                              ! Ĵˤ˰²٤Ѳ. 
                              ! Saturation temperature variation by adjustment
    real(DP):: DelQVap
                              ! Ĵˤ漾Ѳ. 
                              ! Specific humidity variation by adjustment
    real(DP):: DelTempUpper
                              ! Ĵˤ벹 (k) Ѳ. 
                              ! Temperature (k) variation by adjustment
    real(DP):: DelTempLower
                              ! Ĵˤ벹 (k-1) Ѳ. 
                              ! Temperature (k-1) variation by adjustment
    real(DP):: DQVapSatDTempUpper
                              ! $ \DD{q^{*}} (k)}{T} $
    real(DP):: DQVapSatDTempLower
                              ! $ \DD{q^{*}} (k-1)}{T} $
    real(DP):: DHDTempUpper
                              ! $ 1 + \gamma_{k} =
                              ! 1 + \frac{L}{C_p} \DP{q^{*}}{T}_{k} $
    real(DP):: DHDTempLower
                              ! $ 1 + \gamma_{k-1} =
                              ! 1 + \frac{L}{C_p} \DP{q^{*}}{T}_{k-1} $
    logical:: Adjust
                              ! ΰˤư٤ǤĴᤵ줿ݤ?. 
                              ! Whether it was adjusted even once in global 
                              ! this time or not?

    integer:: Iteration
    integer:: i, j, k         ! DO 롼Ѻѿ
                              ! Work variables for DO loop

    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyCumulusAdjustCumulus'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_cumad % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYCUMAD'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *phy_cumad* ˳ǼƤͤμФ
    !  Fetch setting values stored in *phy_cumad*
    !-----------------------------------------------------------------
    imax    = phy_cumad % imax   
    jmax    = phy_cumad % jmax   
    kmax    = phy_cumad % kmax   
    Grav    = phy_cumad % Grav   
    Cp      = phy_cumad % Cp     
    RAir    = phy_cumad % RAir   
    EL      = phy_cumad % EL     
    RVap    = phy_cumad % RVap   
    EpsV    = phy_cumad % EpsV   
    ES0     = phy_cumad % ES0    
    DelTime = phy_cumad % DelTime

    CrtlRH       = phy_cumad % CrtlRH
    IterationMax = phy_cumad % IterationMax

    if ( allocated(TempSatMax) ) deallocate( TempSatMax )
    allocate( TempSatMax(1:IterationMax) )
    TempSatMax = phy_cumad % TempSatMax

    !-----------------------------------------------------------------
    !  Ĵ "QVap", "Temp" ¸
    !  Store "QVap", "Temp" before adjustment
    !-----------------------------------------------------------------
    xyz_QVapB  = xyz_QVap
    xyz_TempB  = xyz_Temp
    
    !-----------------------------------------------------------------
    !  եη׻
    !  Calculate factor
    !-----------------------------------------------------------------
    do k = 0, kmax - 1
      xyz_DPressDz(:,:,k) = xyr_Press(:,:,k) - xyr_Press(:,:,k+1)
    end do

    !-----------------------------------------------------------------
    !  ˰漾׻
    !  Calculate saturation specific humidity
    !-----------------------------------------------------------------
    call CalcQVapSat( phy_cumad % phy_sat, & ! (in)
      &    xyz_Temp = xyz_Temp, &            ! (in)
      &   xyz_Press = xyz_Press, &           ! (in)
      & xyz_QVapSat = xyz_QVapSat, &         ! (out)
      &         err = err )                  ! (out)

!!$    !-----------------------------------------------------------------
!!$    !  饦ڥμ˰漾׻
!!$    !  * 273 K λ˰¿ ES0 (= 611 Pa) ȤƤ
!!$    !    *  ,  , ¼ ε, 1981: 
!!$    !      絤ʳعֺ 2 ߿ȼ絤, ؽǲ, 249pp. 
!!$    !  Calculate saturated specific humidity with Clausius Clapeyron equation
!!$    !  * Saturation vapor pressure is ES0 (= 611 Pa) at 273 K
!!$    !-----------------------------------------------------------------
!!$    xyz_QVapSat = EpsV * ES0  &
!!$      & * exp( EL / RVap * ( 1.0_DP / 273.0_DP - 1.0_DP / xyz_Temp ) ) &
!!$      &    / xyz_Press

    do k = 1, kmax - 1
      xyz_DDPressDDPress(:,:,k) = xyz_DPressDz(:,:,k) / xyz_DPressDz(:,:,k-1)
      xyz_DPFact(:,:,k) = &
        &   RAir / Cp &
        &   * ( xyz_Press(:,:,k-1) - xyz_Press(:,:,k) ) &
        &   / xyr_Press(:,:,k) / 2.0_DP
    end do

    !-----------------------------------------------------------------
    !  Ĵ
    !  Adjustment
    !-----------------------------------------------------------------
    xy_AdjustB = .true.
    
    !-------------------------
    !  ƥ졼
    !  iteration
    do Iteration = 1, IterationMax
      xy_Adjust = .false.
      
      do k = 1, kmax-1
        do j = 0, jmax-1
          do i = 0, imax-1
            if ( xy_AdjustB(i,j) ) then
              
              TempSat = &
                &   xyz_Temp(i,j,k-1) - xyz_Temp(i,j,k) &
                & + ( xyz_QVapSat(i,j,k-1) - xyz_QVapSat(i,j,k) ) * EL / Cp &
                & - xyz_DPFact(i,j,k) * ( xyz_Temp(i,j,k-1) + xyz_Temp(i,j,k) )
              
              !-------------------------
              !  ԰Ǥʤ
              !  If it is unstable
              if ( TempSat > TempSatMax(Iteration) ) then

                !-------------------------
                !  .. , ˰¤Ƥʤ
                !  .. and, if it is saturated
                if ( ( xyz_QVap(i,j,k) / xyz_QVapSat(i,j,k) >= CrtlRH ) &
                  &  .and. &
                  &  ( xyz_QVap(i,j,k-1) / xyz_QVapSat(i,j,k-1) >= CrtlRH ) &
                  &    ) then
                  
                  DelQVap = &
                    &   xyz_DPressDz(i,j,k-1) &
                    &     * (xyz_QVap(i,j,k-1) - xyz_QVapSat(i,j,k-1) ) &
                    & + xyz_DPressDz(i,j,k) &
                    &     * (xyz_QVap(i,j,k) - xyz_QVapSat(i,j,k) ) 

                  call CalcDQVapSatDTemp( phy_cumad % phy_sat, &  ! (in)
                    &          Temp = xyz_Temp(i,j,k), &          ! (in)
                    &         Press = xyz_Press(i,j,k), &         ! (in)
                    & DQVapSatDTemp = DQVapSatDTempUpper )        ! (out)

                  call CalcDQVapSatDTemp( phy_cumad % phy_sat, &  ! (in)
                    &          Temp = xyz_Temp(i,j,k-1), &        ! (in)
                    &         Press = xyz_Press(i,j,k-1), &       ! (in)
                    & DQVapSatDTemp = DQVapSatDTempLower )        ! (out)
                  
                  DHDTempUpper = 1.0_DP + EL/Cp * DQVapSatDTempUpper
                  DHDTempLower = 1.0_DP + EL/Cp * DQVapSatDTempLower
                  
                  DelTempSat = &
                    &   TempSat &
                    & + ( 1.0_DP - xyz_DPFact(i,j,k) / DHDTempLower ) &
                    &     * EL/Cp * DelQVap / xyz_DPressDz(i,j,k-1)
                  
                  !-------------------------
                  !  ٤Ĵ
                  !  Adjust temperature
                  DelTempUpper = &
                    & DelTempSat &
                    & / ( & 
                    &       ( 1.0_DP + xyz_DDPressDDPress(i,j,k) ) &
                    &        * DHDTempUpper &
                    &     + xyz_DPFact(i,j,k) &
                    &        * ( 1.0_DP - xyz_DDPressDDPress(i,j,k)  &
                    &                       * DHDTempUpper / DHDTempLower ) &
                    &   )
                  
                  DelTempLower = &
                    & - DHDTempUpper / DHDTempLower &
                    &    * xyz_DDPressDDPress(i,j,k) * DelTempUpper &
                    & + EL / Cp * DelQVap & 
                    &    / ( xyz_DPressDz(i,j,k-1) * DHDTempLower )
                  
                  xyz_Temp(i,j,k)   = xyz_Temp(i,j,k) + DelTempUpper
                  xyz_Temp(i,j,k-1) = xyz_Temp(i,j,k-1) + DelTempLower
                  
                  !-------------------------
                  !  漾Ĵ
                  !  Adjust specific humidity
                  xyz_QVap(i,j,k) = &
                    &   xyz_QVapSat(i,j,k) &
                    & + DQVapSatDTempUpper * DelTempUpper

                  xyz_QVap(i,j,k-1) = &
                    &   xyz_QVapSat(i,j,k-1) &
                    & + DQVapSatDTempLower * DelTempLower

                  xyz_QVapSat(i,j,k)   = xyz_QVap(i,j,k)
                  xyz_QVapSat(i,j,k-1) = xyz_QVap(i,j,k-1)
                  
                  !-------------------------
                  !  Ĵᤷݤ?
                  !  Whether it was adjusted or not?
                  xy_Adjust(i,j) = .true.
                end if
                
              end if
              
            end if
          end do
        end do
      end do
      
      Adjust = .false.
      do i = 0, imax-1
        do j = 0, jmax-1
          xy_AdjustB(i,j) = xy_Adjust(i,j)
          Adjust          = Adjust .or. xy_Adjust(i,j)
        end do
      end do
      
      if ( .not. Adjust ) exit
      
    end do
    
    !-----------------------------------------------------------------
    !  漾ѲΨ, ѲΨ, ߿̤λ
    !  Calculate specific humidity tendency, temperature tendency, 
    !  precipitation
    !-----------------------------------------------------------------
    xy_Rain     = 0.0_DP
    xyz_DTempDt = 0.0_DP
    xyz_DQVapDt = 0.0_DP

    xyz_DQVapDt = xyz_DQVapDt & 
      & + ( xyz_QVap - xyz_QVapB ) / ( 2.0_DP * DelTime )

    xyz_DTempDt = xyz_DTempDt &
      & + ( xyz_Temp - xyz_TempB ) / ( 2.0_DP * DelTime )

    do k = 0, kmax-1
      xy_Rain = xy_Rain  &
        & + ( xyz_QVapB(:,:,k) - xyz_QVap(:,:,k) ) &
        &       * xyz_DPressDz(:,:,k) / Grav * EL / ( 2.0_DP * DelTime )
    end do

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    if ( allocated(TempSatMax) ) deallocate( TempSatMax )
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyCumulusAdjustCumulus

  subroutine PhyCumulusAdjustClose( phy_cumad, err )
    !
    ! PHYCUMAD ѿνλԤޤ.
    ! ʤ, Ϳ줿 *phy_cumad*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Deconstructor of "PHYCUMAD".
    ! Note that if *phy_cumad* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    use phy_saturate_nha92, only: PhySatNhaClose
    implicit none
    type(PHYCUMAD), intent(inout):: phy_cumad
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyCumulusAdjustClose'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_cumad % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYCUMAD'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  "PHYCUMAD" ξõ
    !  Clear the settings for "PHYCUMAD"
    !-----------------------------------------------------------------
    deallocate( phy_cumad % TempSatMax )

    !-----------------------------------------------------------------
    !  ˰漾׻ѥ֥Ȥνλ
    !  Terminate object for calculation of saturation specific humidity
    !-----------------------------------------------------------------
    call PhySatNhaClose( &
      & phy_sat_nha = phy_cumad % phy_sat, & ! (inout)
      & err = err )                          ! (out)

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    phy_cumad % initialized = .false.
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyCumulusAdjustClose

  subroutine PhyCumulusAdjustPutLine( phy_cumad, unit, indent, err )
    !
    !  *phy_cumad* ꤵƤޤ.
    ! ǥեȤǤϥåɸϤ˽Ϥޤ. 
    ! *unit* ֹꤹ뤳Ȥ, ѹ뤳ȤǽǤ.
    !
    ! Print information of *phy_cumad*.
    ! By default messages are output to standard output.
    ! Unit number for output can be changed by *unit* argument.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    use phy_saturate_nha92, only: PhySatNhaPutLine
    implicit none
    type(PHYCUMAD), intent(in):: phy_cumad
    integer, intent(in), optional:: unit
                              ! ֹ.
                              ! ǥեȤνɸ.
                              !
                              ! Unit number for output.
                              ! Default value is standard output.
    character(*), intent(in), optional:: indent
                              ! ɽåλ.
                              !
                              ! Indent of displayed messages.
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: out_unit
    integer:: indent_len
    character(STRING):: indent_str
    character(*), parameter:: subname = 'PhyCumulusAdjustPutLine'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( present(unit) ) then
      out_unit = unit
    else
      out_unit = STDOUT
    end if

    indent_len = 0
    indent_str = ''
    if ( present(indent) ) then
      if ( len(indent) /= 0 ) then
        indent_len = len(indent)
        indent_str(1:indent_len) = indent
      end if
    end if


    !-----------------------------------------------------------------
    !  "PHYCUMAD" ΰ
    !  Print the settings for "PHYCUMAD"
    !-----------------------------------------------------------------
    if ( phy_cumad % initialized ) then
      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & '#<PHYCUMAD:: @initialized=%y', &
        & l = (/phy_cumad % initialized/) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @imax=%d @jmax=%d @kmax=%d', &
        & i = (/phy_cumad % imax, phy_cumad % jmax, phy_cumad % kmax/) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @Grav=%f @Cp=%f @RAir=%f', &
        & d = (/ phy_cumad % Grav, phy_cumad % Cp, phy_cumad % RAir/) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @EL=%f @RVap=%f @EpsV=%f @ES0=%f', &
        & d = (/ phy_cumad % EL, phy_cumad % RVap, &
        &        phy_cumad % EpsV, phy_cumad % ES0/) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @DelTime=%f', &
        & d = (/phy_cumad % DelTime/) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @CrtlRH=%f @IterationMax=%d', &
        & d = (/ phy_cumad % CrtlRH/), &
        & i = (/ phy_cumad % IterationMax/) )

      call PutLine( phy_cumad % TempSatMax, unit = out_unit, &
        & lbounds = lbound(phy_cumad % TempSatMax), &
        & ubounds = ubound(phy_cumad % TempSatMax), &
        & indent = indent_str(1:indent_len) // &
        & ' @TempSatMax=' )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // ' @phy_sat=' )
      call PhySatNhaPutLine( &
        & phy_sat_nha = phy_cumad % phy_sat, &         ! (in)
        & unit = out_unit, &                           ! (in)
        & indent = indent_str(1:indent_len) // '  ', & ! (in)
        & err = err )                                  ! (out)

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & '>' )
    else
      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & '#<PHYCUMAD:: @initialized=%y>', &
        & l = (/phy_cumad % initialized/) )
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyCumulusAdjustPutLine

  logical function PhyCumulusAdjustInitialized( phy_cumad ) result(result)
    !
    ! *phy_cumad* ꤵƤˤ .true. ,
    ! ꤵƤʤˤ .false. ֤ޤ.
    !
    ! If *phy_cumad* is initialized, .true. is returned.
    ! If *phy_cumad* is not initialized, .false. is returned.
    !
    implicit none
    type(PHYCUMAD), intent(in):: phy_cumad
  continue
    result = phy_cumad % initialized
  end function PhyCumulusAdjustInitialized

  subroutine PhyCumulusAdjustNmlRead( nmlfile, &
!!$    & param_i, param_r, param_c_, &
    & err )
    !
    ! NAMELIST ե *nmlfile* ͤϤ뤿
    ! ֥롼Ǥ. Create ǸƤӽФ뤳Ȥ
    ! ꤷƤޤ.
    !
    ! ͤ NAMELIST եǻꤵƤʤˤ,
    ! Ϥ줿ͤΤޤ֤ޤ.
    !
    ! ʤ, *nmlfile* ˶ʸͿ줿, ޤ
    ! Ϳ줿 *nmlfile* ɤ߹ळȤǤʤ, 
    ! ץϥ顼ȯޤ.
    !
    ! This is an internal subroutine to input values from 
    ! NAMELIST file *nmlfile*. This subroutine is expected to be
    ! called by "Create".
    !
    ! A value not specified in NAMELIST file is returned
    ! without change.
    !
    ! If *nmlfile* is empty, or *nmlfile* can not be read, 
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_iounit, only: FileOpen
    use dc_message, only: MessageNotify
    use dc_present, only: present_and_true
    use dc_error, only: StoreError, DC_NOERR, DC_ENOFILEREAD
    implicit none
    character(*), intent(in):: nmlfile
                              ! NAMELIST ե̾. 
                              ! NAMELIST file name
!!$    integer, intent(inout):: param_i
!!$    real(DP), intent(inout):: param_r
!!$    character(*), intent(inout):: param_c_
!!$    character(TOKEN):: param_c
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

!!$    namelist /phy_cumulus_adjust_nml/ &
!!$      & param_i, param_r, param_c
                              ! phy_cumulus_adjust ⥸塼
                              ! NAMELIST ѿ̾.
                              !
                              ! phy_cumulus_adjust#Create Ѥݤ, 
                              ! ץʥ *nmlfile*  NAMELIST 
                              ! ե̾ꤹ뤳Ȥ, Υե뤫
                              !  NAMELIST ѿɤ߹ߤޤ.
                              !
                              ! NAMELIST group name for 
                              ! "phy_cumulus_adjust" module.
                              ! 
                              ! If a NAMELIST filename is specified to 
                              ! an optional argument *nmlfile* 
                              ! when "phy_cumulus_adjust#Create" is used, 
                              ! this NAMELIST group is loaded from 
                              ! the file.

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
!!$                              ! IOSTAT of NAMELIST read
    character(*), parameter:: subname = 'PhyCumulusAdjustNmlRead'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''



    !-----------------------------------------------------------------
    !  ʸ NAMELIST ѿ
    !  Substitute character arguments to NAMELIST group
    !-----------------------------------------------------------------
!!$    param_c = param_c_

    !----------------------------------------------------------------
    !  NAMELIST եΥץ
    !  Open NAMELIST file
    !----------------------------------------------------------------
    call FileOpen( unit = unit_nml, & ! (out)
      & file = nmlfile, mode = 'r', & ! (in)
      & err = err )                   ! (out)
    if ( present_and_true(err) ) then
      stat = DC_ENOFILEREAD
      cause_c = nmlfile
      goto 999
    end if


    !-----------------------------------------------------------------
    !  NAMELIST ѿμ
    !  Get NAMELIST group
    !-----------------------------------------------------------------
!!$    read( unit = unit_nml, & ! (in)
!!$      & nml = phy_cumulus_adjust_nml, iostat = iostat_nml ) ! (out)
!!$    if ( iostat_nml == 0 ) then
!!$      call MessageNotify( 'M', subname, &
!!$        & 'NAMELIST group "%c" is loaded from "%c".', &
!!$        & c1 = 'phy_cumulus_adjust_nml', c2 = trim(nmlfile) )
!!$      write(STDOUT, nml = phy_cumulus_adjust_nml)
!!$    else
!!$      call MessageNotify( 'W', subname, &
!!$        & 'NAMELIST group "%c" is not found in "%c" (iostat=%d).', &
!!$        & c1 = 'phy_cumulus_adjust_nml', c2 = trim(nmlfile), &
!!$        & i = (/iostat_nml/) )
!!$    end if

    close( unit_nml )

    !-----------------------------------------------------------------
    !  NAMELIST ѿʸ
    !  Substitute NAMELIST group to character arguments
    !-----------------------------------------------------------------
!!$    param_c_ = param_c

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyCumulusAdjustNmlRead

!!$  subroutine PhyCumulusAdjustSample( phy_cumad, err )
!!$    !--
!!$    ! PhyCumulusAdjustSample 򵭽ҤƤ.
!!$    !++
!!$    ! ʤ, Ϳ줿 *phy_cumad*  Create ˤäƽ
!!$    ! Ƥʤ, ץϥ顼ȯޤ.
!!$    !--
!!$    ! Describe brief of PhyCumulusAdjustSample
!!$    !++
!!$    ! If *phy_cumad* is not initialized by "Create" yet,
!!$    ! error is occurred.
!!$    !
!!$    use dc_trace, only: BeginSub, EndSub
!!$    use dc_string, only: PutLine, Printf
!!$    use dc_types, only: DP, STRING, TOKEN, STDOUT
!!$    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
!!$    implicit none
!!$    type(PHYCUMAD), intent(inout):: phy_cumad
!!$    logical, intent(out), optional:: err
!!$                              ! 㳰ѥե饰.
!!$                              ! ǥեȤǤ, μ³ǥ顼
!!$                              ! , ץ϶λޤ.
!!$                              !  *err* Ϳ,
!!$                              ! ץ϶λ, 
!!$                              ! *err*  .true. ޤ.
!!$                              !
!!$                              ! Exception handling flag. 
!!$                              ! By default, when error occur in 
!!$                              ! this procedure, the program aborts. 
!!$                              ! If this *err* argument is given, 
!!$                              ! .true. is substituted to *err* and 
!!$                              ! the program does not abort. 
!!$
!!$!!$    integer:: param_i
!!$!!$    real(DP):: param_r
!!$!!$    character(STRING):: param_c
!!$
!!$    !-----------------------------------
!!$    !  ѿ
!!$    !  Work variables
!!$    integer:: stat
!!$    character(STRING):: cause_c
!!$    character(*), parameter:: subname = 'PhyCumulusAdjustSample'
!!$  continue
!!$    call BeginSub( subname )
!!$    stat = DC_NOERR
!!$    cause_c = ''
!!$
!!$    !-----------------------------------------------------------------
!!$    !  Υå
!!$    !  Check initialization
!!$    !-----------------------------------------------------------------
!!$    if ( .not. phy_cumad % initialized ) then
!!$      stat = DC_ENOTINIT
!!$      cause_c = 'PHYCUMAD'
!!$      goto 999
!!$    end if
!!$
!!$    !-----------------------------------------------------------------
!!$    !  *phy_cumad* ˳ǼƤͤμФ
!!$    !  Fetch setting values stored in *phy_cumad*
!!$    !-----------------------------------------------------------------
!!$!!$    param_i = phy_cumad % param_i
!!$!!$    param_r = phy_cumad % param_r
!!$!!$    param_c = phy_cumad % param_c
!!$
!!$
!!$    !-----------------------------------------------------------------
!!$    !  λ, 㳰
!!$    !  Termination and Exception handling
!!$    !-----------------------------------------------------------------
!!$999 continue
!!$    call StoreError( stat, subname, err, cause_c )
!!$    call EndSub( subname )
!!$  end subroutine PhyCumulusAdjustSample

end module phy_cumulus_adjust
