!= ñǥ
!
!= Simple cloud model
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: cloud_simple.f90,v 1.8 2014/05/07 10:02:14 yot Exp $
! Tag Name::  $Name: dcpam5-20140630-2 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module cloud_simple
  !
  != ñǥ
  !
  != Simple cloud model
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ñǥˤη׻.
  !
  ! In this module, the amount of cloud is calculated by use of a simple
  ! cloud model.
  !
  !== Procedures List
  !
!!$  ! RadiationFluxDennouAGCM :: ͥեåη׻
!!$  ! ------------            :: ------------
!!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
  !
  !== NAMELIST
  !
  ! NAMELIST#cloud_simple_nml
  !

  ! ⥸塼 ; USE statements

  !
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! Double precision.
    &                 STRING, &  ! Strings.
    &                 TOKEN      ! Keywords.

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ.
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ.
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ.
                             ! Number of vertical level

  implicit none

  private


  ! ³
  ! Public procedure
  !
  public :: CloudSimple
  public :: CloudSimpleWithIce
  public :: CloudSimpleCalcCloudCover
  public :: CloudSimpleInit

  public :: CloudSimpleDivideWatAndIce


  ! ѿ
  ! Public variables
  !


  ! ѿ
  ! Private variables
  !
  logical , save        :: FlagSnow
                           ! A flag for snow

  integer , save        :: IDCloudCoverMethod
  integer , parameter   :: IDCloudCoverMethodConst    = 1
  integer , parameter   :: IDCloudCoverMethodRH       = 2

  integer , save        :: IDSnowMethod
  integer , parameter   :: IDSnowMethodKeyLLTemp      = 11
  integer , parameter   :: IDSnowMethodStepPC         = 12

  real(DP), save        :: CloudLifeTime
  real(DP), save        :: CloudWatLifeTime
  real(DP), save        :: CloudIceLifeTime

  real(DP), save        :: CloudCover

  real(DP), save        :: RHCrtl


  logical , save :: FlagPRCPEvap
  real(DP), save :: PRCPArea
    !                           a_p
  real(DP), save :: PRCPEvapArea
    !                           A = max( a_p - a, 0 )


  logical, save :: cloud_simple_inited = .false.
                              ! ե饰.
                              ! Initialization flag

  character(*), parameter:: module_name = 'cloud_simple'
                              ! ⥸塼̾.
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20140630-2 $' // &
    & '$Id: cloud_simple.f90,v 1.8 2014/05/07 10:02:14 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  !--------------------------------------------------------------------------------------

contains

  !--------------------------------------------------------------------------------------

  subroutine CloudSimple(                             &
    & xyr_Press, xyz_Press,                           & ! (in)
    & xyz_Temp,                                       & ! (inout)
    & xyz_DQH2OLiqDtCum, xyz_DQH2OLiqDtLSC,           & ! (in)
    & xyz_QH2OVap, xyz_QH2OLiq, xyz_DTempDtCond,      & ! (inout)
    & xy_RainCum, xy_SnowCum, xy_RainLsc, xy_SnowLsc  & ! (out)
    & )

    ! USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime            ! $ \Delta t $ [s]

    ! طϥ롼
    ! Cloud-related routines
    !
    use cloud_utils, only : &
      & CloudUtilsCalcPRCPKeyLLTemp3D


    real(DP), intent(in   ) :: xyr_Press        ( 0:imax-1, 1:jmax, 0:kmax )
    real(DP), intent(in   ) :: xyz_Press        ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(inout) :: xyz_Temp         ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(in   ) :: xyz_DQH2OLiqDtCum( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(in   ) :: xyz_DQH2OLiqDtLSC( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(inout) :: xyz_QH2OVap      ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(inout) :: xyz_QH2OLiq      ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(inout) :: xyz_DTempDtCond  ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(out  ) :: xy_RainCum       ( 0:imax-1, 1:jmax )
    real(DP), intent(out  ) :: xy_SnowCum       ( 0:imax-1, 1:jmax )
    real(DP), intent(out  ) :: xy_RainLsc       ( 0:imax-1, 1:jmax )
    real(DP), intent(out  ) :: xy_SnowLsc       ( 0:imax-1, 1:jmax )


    real(DP) :: xyz_QH2OLiqB( 0:imax-1, 1:jmax, 1:kmax )
    real(DP) :: xyz_DQRainDt( 0:imax-1, 1:jmax, 1:kmax )
    real(DP) :: xyz_DQSnowDt( 0:imax-1, 1:jmax, 1:kmax )

!!$    real(DP) :: xyz_DTempDtPrcpPCCum( 0:imax-1, 1:jmax, 1:kmax )
!!$    real(DP) :: xyz_DTempDtPrcpPCLsc( 0:imax-1, 1:jmax, 1:kmax )

    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. cloud_simple_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! Cloud optical depth
    !

    ! Numerical solution

!!$      xyz_DQCloudWaterDt = xyz_DQCloudWaterDt &
!!$        & - xyz_QCloudWater / ( CloudLifeTime + 1.0d-100 )


!      ( X_{t+1} - X_{t-1} ) / ( 2 \Delta t ) = Q - X_{t+1} / \tau
!
!      X_{t+1} / ( 2 \Delta t )  + X_{t+1} / \tau = X_{t-1} / ( 2 \Delta t ) + Q
!      ( 1 / ( 2 \Delta t )  + 1 / \tau ) X_{t+1} = X_{t-1} / ( 2 \Delta t ) + Q
!      X_{t+1} = ( X_{t-1} / ( 2 \Delta t ) + Q ) / ( 1 / ( 2 \Delta t )  + 1 / \tau ) 

!!$    xyz_QH2OLiq =                                                           &
!!$      &   (                                                                 &
!!$      &       xyz_QH2OLiq / ( 2.0_DP * DelTime )                            &
!!$      &     + xyz_DQH2OLiqDtCum + xyz_DQH2OLiqDtLSC                         &
!!$      &   )                                                                 &
!!$      & / ( 1.0_DP / ( 2.0_DP * DelTime ) + 1.0_DP / ( CloudLifeTime + 1.0d-100 ) )
!!$
!!$    call CloudUtilsCalcPRCPKeyLLTemp3D(          &
!!$      & xyr_Press, xyz_Temp, xyz_DQH2OLiqDtCum,  &  ! (in )
!!$      & xy_RainCum, xy_SnowCum                   &  ! (out)
!!$      & )
!!$    call CloudUtilsCalcPRCPKeyLLTemp3D(          &
!!$      & xyr_Press, xyz_Temp, xyz_DQH2OLiqDtLsc,  &  ! (in )
!!$      & xy_RainLsc, xy_SnowLsc                   &  ! (out)
!!$      & )
    !-----


    ! Analytical solution

    ! save cloud water before adjustment
    xyz_QH2OLiqB = xyz_QH2OLiq

    xyz_QH2OLiq =                                                                 &
      &   xyz_QH2OLiq * exp( - 2.0_DP * DelTime / ( CloudLifeTime + 1.0e-100_DP ) )  &
      & + ( xyz_DQH2OLiqDtCum + xyz_DQH2OLiqDtLSC ) * CloudLifeTime               &
      &   * ( 1.0_DP - exp( - 2.0_DP * DelTime / ( CloudLifeTime + 1.0e-100_DP ) ) )

    xyz_DQRainDt =                                                     &
      &   xyz_QH2OLiqB                                                 &
      & + ( xyz_DQH2OLiqDtCum + xyz_DQH2OLiqDtLSC ) * 2.0_DP * DelTime &
      & - xyz_QH2OLiq
    xyz_DQRainDt = xyz_DQRainDt / ( 2.0_DP * DelTime )



    select case ( IDSnowMethod )
    case ( IDSnowMethodKeyLLTemp )

      call CloudUtilsCalcPRCPKeyLLTemp3D(    &
        & xyr_Press, xyz_Temp, xyz_DQRainDt, &  ! (in )
        & xy_RainCum, xy_SnowCum             &  ! (out)
        & )
      xy_RainLsc = 0.0_DP
      xy_SnowLsc = 0.0_DP

    case ( IDSnowMethodStepPC )

      xyz_DQSnowDt = 0.0_DP

      call CloudSimpleCalcPRCPStepPC(      &
        & xyr_Press, xyz_Press,                  & ! (in   )
        & xyz_DQRainDt, xyz_DQSnowDt,            & ! (in   )
        & xyz_Temp, xyz_QH2OVap,                 & ! (inout)
        & xy_RainCum, xy_SnowCum       & ! (out  )
        & )
      xy_RainLsc = 0.0_DP
      xy_SnowLsc = 0.0_DP

    end select


  end subroutine CloudSimple

  !--------------------------------------------------------------------------------------

  subroutine CloudSimpleWithIce(                      &
    & xyr_Press, xyz_Press,                           & ! (in)
    & xyz_Temp,                                       & ! (inout)
!!$    & xyz_DQH2OLiqDtCum, xyz_DQH2OLiqDtLSC,           & ! (in)
    & xyz_QH2OVap, xyz_QH2OLiq, xyz_QH2OSol,          & ! (inout)
    & xyz_DTempDtCond,                                & ! (inout)
    & xy_RainCum, xy_SnowCum, xy_RainLsc, xy_SnowLsc  & ! (out)
    & )

    ! USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime            ! $ \Delta t $ [s]

    ! طϥ롼
    ! Cloud-related routines
    !
    use cloud_utils, only : &
      & CloudUtilsCalcPRCPKeyLLTemp3D


    real(DP), intent(in   ) :: xyr_Press        ( 0:imax-1, 1:jmax, 0:kmax )
    real(DP), intent(in   ) :: xyz_Press        ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(inout) :: xyz_Temp         ( 0:imax-1, 1:jmax, 1:kmax )
!!$    real(DP), intent(in   ) :: xyz_DQH2OLiqDtCum( 0:imax-1, 1:jmax, 1:kmax )
!!$    real(DP), intent(in   ) :: xyz_DQH2OLiqDtLSC( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(inout) :: xyz_QH2OVap     ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(inout) :: xyz_QH2OLiq      ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(inout) :: xyz_QH2OSol      ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(inout) :: xyz_DTempDtCond  ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(out  ) :: xy_RainCum       ( 0:imax-1, 1:jmax )
    real(DP), intent(out  ) :: xy_SnowCum       ( 0:imax-1, 1:jmax )
    real(DP), intent(out  ) :: xy_RainLsc       ( 0:imax-1, 1:jmax )
    real(DP), intent(out  ) :: xy_SnowLsc       ( 0:imax-1, 1:jmax )


    real(DP) :: xyz_TempB   ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP) :: xyz_QH2OVapB( 0:imax-1, 1:jmax, 1:kmax )
    real(DP) :: xyz_QH2OLiqB( 0:imax-1, 1:jmax, 1:kmax )
    real(DP) :: xyz_QH2OSolB( 0:imax-1, 1:jmax, 1:kmax )
    real(DP) :: xyz_DQH2OLiqDt( 0:imax-1, 1:jmax, 1:kmax )
    real(DP) :: xyz_DQH2OSolDt( 0:imax-1, 1:jmax, 1:kmax )
    real(DP) :: xyz_DQRainDt( 0:imax-1, 1:jmax, 1:kmax )
    real(DP) :: xyz_DQSnowDt( 0:imax-1, 1:jmax, 1:kmax )

!!$    real(DP) :: xyz_DTempDtPrcpPCCum( 0:imax-1, 1:jmax, 1:kmax )
!!$    real(DP) :: xyz_DTempDtPrcpPCLsc( 0:imax-1, 1:jmax, 1:kmax )

    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. cloud_simple_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    xyz_DQH2OLiqDt = 0.0_DP
    xyz_DQH2OSolDt = 0.0_DP


    ! Numerical solution

!!$      xyz_DQCloudWaterDt = xyz_DQCloudWaterDt &
!!$        & - xyz_QCloudWater / ( CloudLifeTime + 1.0e-100_DP )


!      ( X_{t+1} - X_{t-1} ) / ( 2 \Delta t ) = Q - X_{t+1} / \tau
!
!      X_{t+1} / ( 2 \Delta t )  + X_{t+1} / \tau = X_{t-1} / ( 2 \Delta t ) + Q
!      ( 1 / ( 2 \Delta t )  + 1 / \tau ) X_{t+1} = X_{t-1} / ( 2 \Delta t ) + Q
!      X_{t+1} = ( X_{t-1} / ( 2 \Delta t ) + Q ) / ( 1 / ( 2 \Delta t )  + 1 / \tau ) 

!!$    xyz_QH2OLiq =                                                           &
!!$      &   (                                                                 &
!!$      &       xyz_QH2OLiq / ( 2.0_DP * DelTime )                            &
!!$      &     + xyz_DQH2OLiqDtCum + xyz_DQH2OLiqDtLSC                         &
!!$      &   )                                                                 &
!!$      & / ( 1.0_DP / ( 2.0_DP * DelTime ) + 1.0_DP / ( CloudLifeTime + 1.0d-100 ) )
!!$
!!$    call CloudUtilsCalcPRCPKeyLLTemp3D(          &
!!$      & xyr_Press, xyz_Temp, xyz_DQH2OLiqDtCum,  &  ! (in )
!!$      & xy_RainCum, xy_SnowCum                   &  ! (out)
!!$      & )
!!$    call CloudUtilsCalcPRCPKeyLLTemp3D(          &
!!$      & xyr_Press, xyz_Temp, xyz_DQH2OLiqDtLsc,  &  ! (in )
!!$      & xy_RainLsc, xy_SnowLsc                   &  ! (out)
!!$      & )
    !-----


    ! Analytical solution

    ! save values before adjustment
    xyz_TempB    = xyz_Temp
    xyz_QH2OVapB = xyz_QH2OVap
    xyz_QH2OLiqB = xyz_QH2OLiq
    xyz_QH2OSolB = xyz_QH2OSol


    xyz_QH2OLiq =                                                                 &
      &   xyz_QH2OLiq * exp( - 2.0_DP * DelTime / ( CloudWatLifeTime + 1.0e-100_DP ) )  &
      & + xyz_DQH2OLiqDt * CloudWatLifeTime                                          &
      &   * ( 1.0_DP - exp( - 2.0_DP * DelTime / ( CloudWatLifeTime + 1.0e-100_DP ) ) )

    xyz_DQRainDt =                          &
      &   xyz_QH2OLiqB                      &
      & + xyz_DQH2OLiqDt * 2.0_DP * DelTime &
      & - xyz_QH2OLiq
    xyz_DQRainDt = xyz_DQRainDt / ( 2.0_DP * DelTime )


    xyz_QH2OSol =                                                                 &
      &   xyz_QH2OSol * exp( - 2.0_DP * DelTime / ( CloudIceLifeTime + 1.0e-100_DP ) )  &
      & + xyz_DQH2OSolDt * CloudIceLifeTime                                          &
      &   * ( 1.0_DP - exp( - 2.0_DP * DelTime / ( CloudIceLifeTime + 1.0e-100_DP ) ) )

    xyz_DQSnowDt =                         &
      &   xyz_QH2OSolB                      &
      & + xyz_DQH2OSolDt * 2.0_DP * DelTime &
      & - xyz_QH2OSol
    xyz_DQSnowDt = xyz_DQSnowDt / ( 2.0_DP * DelTime )



    select case ( IDSnowMethod )
    case ( IDSnowMethodKeyLLTemp )

      xyz_DQRainDt = xyz_DQRainDt + xyz_DQSnowDt
      !
      call CloudUtilsCalcPRCPKeyLLTemp3D(    &
        & xyr_Press, xyz_Temp, xyz_DQRainDt, &  ! (in )
        & xy_RainCum, xy_SnowCum             &  ! (out)
        & )
      xy_RainLsc = 0.0_DP
      xy_SnowLsc = 0.0_DP

    case ( IDSnowMethodStepPC )

      call CloudSimpleCalcPRCPStepPC(      &
        & xyr_Press, xyz_Press,                  & ! (in   )
        & xyz_DQRainDt, xyz_DQSnowDt,            & ! (in   )
        & xyz_Temp, xyz_QH2OVap,                 & ! (inout)
        & xy_RainCum, xy_SnowCum       & ! (out  )
        & )
      xy_RainLsc = 0.0_DP
      xy_SnowLsc = 0.0_DP

      call CloudSimpleConsChk(                           &
        & xyr_Press,                                           &
        & xyz_TempB, xyz_QH2OVapB, xyz_QH2OLiqB, xyz_QH2OSolB, &
        & xyz_Temp , xyz_QH2OVap , xyz_QH2OLiq , xyz_QH2OSol , &
        & xy_RainCum, xy_SnowCum                               &
        & )

    end select



  end subroutine CloudSimpleWithIce

  !--------------------------------------------------------------------------------------

  subroutine CloudSimpleCalcPRCPStepPC(      &
    & xyr_Press, xyz_Press,                  & ! (in   )
    & xyz_DQRainDt, xyz_DQSnowDt,            & ! (in   )
    & xyz_Temp, xyz_QH2OVap,                 & ! (inout)
    & xy_SurfRainFlux, xy_SurfSnowFlux       & ! (out  )
    & )

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime            ! $ \Delta t $ [s]

    ! ʪ
    ! Physical constants settings
    !
    use constants, only:  &
      & CpDry,            &
                              ! $ C_p $ [J kg-1 K-1].
                              ! 絤갵Ǯ.
                              ! Specific heat of air at constant pressure
      & Grav,             &
                              ! $ g $ [m s-2].
                              ! ϲ®.
                              ! Gravitational acceleration
      & LatentHeat,       &
                              ! $ L $ [J kg-1] .
                              ! ȯǮ.
                              ! Latent heat
      & LatentHeatFusion, &
                              ! $ L $ [J kg-1] .
                              ! ͻǮ.
                              ! Latent heat of fusion
      & EpsV
                              ! $ \epsilon_v $ .
                              ! ʬ.
                              ! Molecular weight of water vapor

    ! ȳɹ
    ! Setting constants of snow and sea ice
    !
    use constants_snowseaice, only: TempCondWater

    ! ˰漾λ
    ! Evaluate saturation specific humidity
    !
    use saturate, only: xyz_CalcQVapSat

    ! ˰漾λ
    ! Evaluate saturation specific humidity
    !
    use saturate_DennouAGCM, only: xyz_CalcQVapSatOnLiq => xyz_CalcQVapSat

    ! ˰漾λ
    ! Evaluate saturation specific humidity
    !
    use saturate_DennouAGCMOnIce, only: xyz_CalcQVapSatOnIce => xyz_CalcQVapSat


    real(DP), intent(in   ) :: xyr_Press       ( 0:imax-1, 1:jmax, 0:kmax )
    real(DP), intent(in   ) :: xyz_Press       ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(in   ) :: xyz_DQRainDt    ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(in   ) :: xyz_DQSnowDt    ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(inout) :: xyz_Temp        ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(inout) :: xyz_QH2OVap     ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(out  ) :: xy_SurfRainFlux ( 0:imax-1, 1:jmax )
    real(DP), intent(out  ) :: xy_SurfSnowFlux ( 0:imax-1, 1:jmax )


    ! ѿ
    ! Work variables
    !
    real(DP) :: xyz_DelMass( 0:imax-1, 1:jmax, 1:kmax )
    real(DP) :: MassMaxFreezeRate
    real(DP) :: MassFreezeRate
    real(DP) :: MassMaxMeltRate
    real(DP) :: MassMeltRate

    real(DP) :: VirTemp
    real(DP) :: aaa_QH2OVapSat(1,1,1)
    real(DP) :: QH2OVapSat
    real(DP) :: PRCPFlux
    real(DP) :: DelPRCPFlux
    real(DP) :: DelQH2OVap
    real(DP) :: LatentHeatLocal
    character(STRING) :: CharPhase

    integer  :: i
    integer  :: j
    integer  :: k
    integer  :: l


    ! ǧ
    ! Initialization check
    !
    if ( .not. cloud_simple_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    do k = 1, kmax
      xyz_DelMass(:,:,k) = ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
    end do

    ! Freezing and melting switching at temperature of TempCondWater
    xy_SurfRainFlux = 0.0_DP
    xy_SurfSnowFlux = 0.0_DP
    do j = 1, jmax
      do i = 0, imax-1
        do k = kmax, 1, -1

          xy_SurfRainFlux(i,j) = xy_SurfRainFlux(i,j) &
            & + xyz_DQRainDt(i,j,k) * xyz_DelMass(i,j,k)
          xy_SurfSnowFlux(i,j) = xy_SurfSnowFlux(i,j) &
            & + xyz_DQSnowDt(i,j,k) * xyz_DelMass(i,j,k)

          MassMaxFreezeRate =                               &
            &   CpDry * ( TempCondWater - xyz_Temp(i,j,k) ) &
            & * xyz_DelMass(i,j,k)                          &
            & / LatentHeatFusion                            &
            & / ( 2.0_DP * DelTime )
          if ( MassMaxFreezeRate >= 0.0_DP ) then
            ! freezing
            if ( xy_SurfRainFlux(i,j) >= MassMaxFreezeRate ) then
              MassFreezeRate = MassMaxFreezeRate
            else
              MassFreezeRate = xy_SurfRainFlux(i,j)
            end if
            xy_SurfRainFlux(i,j) = xy_SurfRainFlux(i,j) - MassFreezeRate
            xy_SurfSnowFlux(i,j) = xy_SurfSnowFlux(i,j) + MassFreezeRate
            xyz_Temp(i,j,k) = xyz_Temp(i,j,k)                          &
              & + LatentHeatFusion * MassFreezeRate * 2.0_DP * DelTime &
              &   / ( CpDry * xyz_DelMass(i,j,k) )
          else
            ! melting
            MassMaxMeltRate = - MassMaxFreezeRate
            if ( xy_SurfSnowFlux(i,j) >= MassMaxMeltRate ) then
              MassMeltRate = MassMaxMeltRate
            else
              MassMeltRate = xy_SurfSnowFlux(i,j)
            end if
            xy_SurfRainFlux(i,j) = xy_SurfRainFlux(i,j) + MassMeltRate
            xy_SurfSnowFlux(i,j) = xy_SurfSnowFlux(i,j) - MassMeltRate
            xyz_Temp(i,j,k) = xyz_Temp(i,j,k)                        &
              & - LatentHeatFusion * MassMeltRate * 2.0_DP * DelTime &
              &   / ( CpDry * xyz_DelMass(i,j,k) )
          end if


          if ( FlagPRCPEvap ) then
!!$            do l = 0, 0   ! for test
            do l = 1, 2
              select case ( l )
              case ( 0 ) ! mixture
                CharPhase = 'mixture'
                aaa_QH2OVapSat(1:1,1:1,1:1) = &
                  & xyz_CalcQVapSat     ( xyz_Temp(i:i,j:j,k:k), xyz_Press(i:i,j:j,k:k) )
                PRCPFlux = xy_SurfRainFlux(i,j)
              case ( 1 ) ! liquid
                CharPhase = 'liquid'
                aaa_QH2OVapSat(1:1,1:1,1:1) = &
                  & xyz_CalcQVapSatOnLiq( xyz_Temp(i:i,j:j,k:k), xyz_Press(i:i,j:j,k:k) )
                PRCPFlux = xy_SurfRainFlux(i,j)
              case ( 2 ) ! solid
                CharPhase = 'solid'
                aaa_QH2OVapSat(1:1,1:1,1:1) = &
                  & xyz_CalcQVapSatOnIce( xyz_Temp(i:i,j:j,k:k), xyz_Press(i:i,j:j,k:k) )
                PRCPFlux = xy_SurfSnowFlux(i,j)
              case default
                call MessageNotify( 'E', module_name, 'Unexpected number for select case.' )
              end select
              QH2OVapSat = aaa_QH2OVapSat(1,1,1)
              VirTemp = xyz_Temp(i,j,k) * ( 1.0_DP + ((( 1.0_DP / EpsV ) - 1.0_DP ) * xyz_QH2OVap(i,j,k)) )
              call CloudSimpleEvap1Grid( &
                & CharPhase,                                    &
                & xyz_DelMass(i,j,k), xyz_Press(i,j,k), xyz_QH2OVap(i,j,k), QH2OVapSat, VirTemp, &
                & PRCPFlux,                                                                      &
                & DelPRCPFlux                                       &
                & )
              select case ( l )
              case ( 0 ) ! mixture
                xy_SurfRainFlux(i,j) = PRCPFlux - DelPRCPFlux
                LatentHeatLocal      = LatentHeat
              case ( 1 ) ! liquid
                xy_SurfRainFlux(i,j) = PRCPFlux - DelPRCPFlux
                LatentHeatLocal      = LatentHeat
              case ( 2 ) ! solid
                xy_SurfSnowFlux(i,j) = PRCPFlux - DelPRCPFlux
                LatentHeatLocal      = LatentHeat + LatentHeatFusion
              end select
              DelQH2OVap = DelPRCPFlux * ( 2.0_DP * DelTime ) / xyz_DelMass(i,j,k)
              xyz_QH2OVap(i,j,k) = xyz_QH2OVap(i,j,k) + DelQH2OVap
              xyz_Temp(i,j,k) = xyz_Temp(i,j,k) - LatentHeatLocal * DelQH2OVap / CpDry
            end do
          end if

        end do
      end do
    end do


  end subroutine CloudSimpleCalcPRCPStepPC

  !--------------------------------------------------------------------------------------

  subroutine CloudSimpleEvap1Grid( &
    & CharPhase,                                    &
    & DelMass, Press, QH2OVap, QH2OVapSat, VirTemp, &
    & PRCP,                                         &
    & DelPRCPFlux                                   &
    & )

    ! ʪ
    ! Physical and mathematical constants settings
    !
    use constants0, only: &
      & PI                    ! $ \pi $ .
                              ! ߼Ψ.  Circular constant

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & Grav, &
                              ! $ g $ [m s-2].
                              ! ϲ®.
                              ! Gravitational acceleration
      & GasRDry
                              ! $ R $ [J kg-1 K-1].
                              ! 絤ε.
                              ! Gas constant of air


    character(*), intent(in ) :: CharPhase
    real(DP)    , intent(in ) :: DelMass
    real(DP)    , intent(in ) :: Press
    real(DP)    , intent(in ) :: QH2OVap
    real(DP)    , intent(in ) :: QH2OVapSat
    real(DP)    , intent(in ) :: VirTemp
    real(DP)    , intent(in ) :: PRCP
    real(DP)    , intent(out) :: DelPRCPFlux


    ! Parameters for evaporation of rain
    real(DP), parameter :: DensWater            = 1.0d3
    !                            rho_w
    !   Values below are from Kessler (1969)
    real(DP), parameter :: PRCPFallVelFactor0        = 130.0d0
    !                            K
    real(DP), parameter :: MedianDiameterFactor      = 3.67d0
    !                            C'
    real(DP), parameter :: PRCPDistFactor            = 1.0d7
    !                            N0
    real(DP), parameter :: PRCPEvapRatUnitDiamFactor = 2.24d3
    !                            C
    real(DP), parameter :: H2OVapDiffCoef            = 1.0d-5
    !                            Kd

    real(DP) :: PRCPFallVelRatio
    real(DP) :: PRCPFallVelFactor

    real(DP) :: Dens0
    !                            rho_0
    real(DP) :: V00
    !                            V_{00}
    real(DP) :: PRCPEvapFactor

    real(DP) :: Dens
    !                           rho
    real(DP) :: DensPRCP
    !                           (rho q_r)
!!$    real(DP) :: RainArea
!!$    !                           a_p
!!$    real(DP) :: RainEvapArea
!!$    !                           A = max( a_p - a, 0 )
!!$    real(DP) :: xy_CloudCover   (0:imax-1, 1:jmax)
!!$    !                           a
    real(DP) :: PRCPEvapRate

    real(DP) :: DelZ


    select case ( CharPhase )
    case ( 'liquid' )
      ! for liquid water
      PRCPFallVelRatio = 1.0_DP
    case ( 'solid' )
      ! for solid water (ice)
      PRCPFallVelRatio = 0.5_DP
    case ( 'mixture' )
      ! for mixture, this is only for test
      PRCPFallVelRatio = 1.0_DP
    case default
      call MessageNotify( 'E', module_name, 'Unexpected character for select case.' )
    end select
    !
    PRCPFallVelFactor = PRCPFallVelFactor0 * PRCPFallVelRatio

    ! Parameters for evaporation of rain
    Dens0 = 1013.0d2 / ( GasRDry * 300.0_DP )
    V00 = PRCPFallVelFactor * sqrt( MedianDiameterFactor ) &
      & / ( PI * DensWater * PRCPDistFactor )**(1.0d0/8.0d0)
    PRCPEvapFactor =                                      &
!      & RainEvapRatUnitDiamFactor * gamma( 13.0d0/5.0d0 ) &
      & PRCPEvapRatUnitDiamFactor * 1.429624558860304d0   &
      & * H2OVapDiffCoef * PRCPDistFactor**(7.0d0/20.0d0) &
      & / ( PI * DensWater )**(13.0d0/20.0d0)
    ! Values for evaporation of rain
    Dens = Press / ( GasRDry * VirTemp )

    DelZ = DelMass / Dens


!!$    RainArea   = RainArea
!!$    xy_CloudCover = CloudCover
!!$    xy_RainEvapArea = max( xy_RainArea - xy_CloudCover, 0.0_DP )
!!$    RainEvapArea = RainEvapArea

    DensPRCP =                                                   &
      & ( PRCP / ( PRCPArea + 1.0d-10 )                          &
      &   / ( V00 * sqrt( Dens0 / Dens ) ) )**(8.0d0/9.0d0)
    PRCPEvapRate =                                      &
      & Dens * PRCPEvapArea * PRCPEvapFactor            &
      &   * max( QH2OVapSat - QH2OVap, 0.0_DP )         &
      &   * DensPRCP**(13.0d0/20.0d0)

    ! PRCPEvapRate (kg m-3 s-1)
    ! DelZ         (m)
    ! DelPRCPFlux  (kg m-2 s-1)
    DelPRCPFlux = PRCPEvapRate * DelZ

    DelPRCPFlux = min( DelPRCPFlux, PRCP )


  end subroutine CloudSimpleEvap1Grid

  !--------------------------------------------------------------------------------------

  subroutine CloudSimpleConsChk(                           &
    & xyr_Press,                                           &
    & xyz_TempB, xyz_QH2OVapB, xyz_QH2OLiqB, xyz_QH2OSolB, &
    & xyz_Temp , xyz_QH2OVap , xyz_QH2OLiq , xyz_QH2OSol , &
    & xy_Rain, xy_Snow                                     &
    & )


    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime            ! $ \Delta t $ [s]

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & Grav, & 
                              ! $ g $ [m s-2]. 
                              ! ϲ®. 
                              ! Gravitational acceleration
      & CpDry, &
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure
      & LatentHeat, &
                              ! $ L $ [J kg-1] . 
                              ! ŷǮ. 
                              ! Latent heat of condensation
      & LatentHeatFusion
                              ! $ L $ [J kg-1] .
                              ! ͻǮ.
                              ! Latent heat of fusion

    real(DP), intent(in) :: xyr_Press   (0:imax-1, 1:jmax, 0:kmax)
    real(DP), intent(in) :: xyz_TempB   (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in) :: xyz_QH2OVapB(0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in) :: xyz_QH2OLiqB(0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in) :: xyz_QH2OSolB(0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in) :: xyz_Temp    (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in) :: xyz_QH2OVap (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in) :: xyz_QH2OLiq (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in) :: xyz_QH2OSol (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in) :: xy_Rain     (0:imax-1, 1:jmax)
    real(DP), intent(in) :: xy_Snow     (0:imax-1, 1:jmax)

    ! Local variables
    !
    real(DP) :: xyz_DelMass(0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xy_Val(0:imax-1, 1:jmax)
    real(DP) :: xy_SumB(0:imax-1, 1:jmax)
    real(DP) :: xy_Sum(0:imax-1, 1:jmax)
    real(DP) :: xy_Ratio(0:imax-1, 1:jmax)
    integer  :: i
    integer  :: j
    integer  :: k


    do k = 1, kmax
      xyz_DelMass(:,:,k) = ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
    end do

    xy_Sum = 0.0_DP
    do k = kmax, 1, -1
      xy_Val =   CpDry * xyz_TempB(:,:,k)               &
        &      + LatentHeat * xyz_QH2OVapB(:,:,k)       &
        &      - LatentHeatFusion * xyz_QH2OSolB(:,:,k)
      xy_Sum = xy_Sum + xy_Val * xyz_DelMass(:,:,k)
    end do

    xy_SumB = xy_Sum

    xy_Sum = 0.0_DP
    do k = kmax, 1, -1
      xy_Val =   CpDry * xyz_Temp (:,:,k)               &
        &      + LatentHeat * xyz_QH2OVap (:,:,k)       &
        &      - LatentHeatFusion * xyz_QH2OSol (:,:,k)
      xy_Sum = xy_Sum + xy_Val * xyz_DelMass(:,:,k)
    end do
    xy_Sum = xy_Sum - LatentHeatFusion * xy_Snow * 2.0_DP * DelTime

    xy_Ratio = ( xy_Sum - xy_SumB ) / ( xy_Sum + 1.0d-100 )
    do j = 1, jmax
      do i = 0, imax-1
        if ( abs( xy_Ratio(i,j) ) > 1.0d-10 ) then
          call MessageNotify( 'M', module_name, 'Modified condensate static energy is not conserved, %f.', d = (/ xy_Ratio(i,j) /) )
        end if
      end do
    end do



    xy_Sum = 0.0_DP
    do k = kmax, 1, -1
      xy_Val = xyz_QH2OVapB(:,:,k) + xyz_QH2OLiqB(:,:,k) + xyz_QH2OSolB(:,:,k)
      xy_Sum = xy_Sum + xy_Val * xyz_DelMass(:,:,k)
    end do

    xy_SumB = xy_Sum

    xy_Sum = 0.0_DP
    do k = kmax, 1, -1
      xy_Val = xyz_QH2OVap (:,:,k) + xyz_QH2OLiq (:,:,k) + xyz_QH2OSol (:,:,k)
      xy_Sum = xy_Sum + xy_Val * xyz_DelMass(:,:,k)
    end do
    xy_Sum = xy_Sum + ( xy_Rain + xy_Snow ) * 2.0_DP * DelTime

    xy_Ratio = ( xy_Sum - xy_SumB ) / ( xy_Sum + 1.0d-100 )
    do j = 1, jmax
      do i = 0, imax-1
        if ( abs( xy_Ratio(i,j) ) > 1.0d-10 ) then
          call MessageNotify( 'M', module_name, 'H2O mass is not conserved, %f.', d = (/ xy_Ratio(i,j) /) )
        end if
      end do
    end do


  end subroutine CloudSimpleConsChk

  !--------------------------------------------------------------------------------------

  subroutine CloudSimpleWithIce_OLD(                      &
    & xyr_Press,                                      & ! (in)
!!$    & xyz_DQH2OLiqDtCum, xyz_DQH2OLiqDtLSC,           & ! (in)
    & xyz_Temp,                                       & ! (inout)
    & xyz_QH2OLiq, xyz_QH2OSol,                       & ! (inout)
    & xyz_DTempDtCond,                                & ! (inout)
    & xy_RainCum, xy_SnowCum, xy_RainLsc, xy_SnowLsc  & ! (out)
    & )

    ! USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime            ! $ \Delta t $ [s]

    ! ʪ
    ! Physical constants settings
    !
    use constants, only:  &
      & CpDry,            &
                              ! $ C_p $ [J kg-1 K-1].
                              ! 絤갵Ǯ.
                              ! Specific heat of air at constant pressure
      & Grav,             &
                              ! $ g $ [m s-2].
                              ! ϲ®.
                              ! Gravitational acceleration
      & LatentHeatFusion
                              ! $ L $ [J kg-1] .
                              ! ͻǮ.
                              ! Latent heat of fusion

    ! ȳɹ
    ! Setting constants of snow and sea ice
    !
    use constants_snowseaice, only: TempCondWater

    ! طϥ롼
    ! Cloud-related routines
    !
    use cloud_utils, only : CloudUtilsWatFraction

    ! طϥ롼
    ! Cloud-related routines
    !
    use cloud_utils, only : CloudUtilsCalcPRCPKeyLLTemp3D


    real(DP), intent(in   ) :: xyr_Press        ( 0:imax-1, 1:jmax, 0:kmax )
!!$    real(DP), intent(in   ) :: xyz_DQH2OLiqDtCum( 0:imax-1, 1:jmax, 1:kmax )
!!$    real(DP), intent(in   ) :: xyz_DQH2OLiqDtLSC( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(inout) :: xyz_Temp         ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(inout) :: xyz_QH2OLiq      ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(inout) :: xyz_QH2OSol      ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(inout) :: xyz_DTempDtCond  ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(out  ) :: xy_RainCum       ( 0:imax-1, 1:jmax )
    real(DP), intent(out  ) :: xy_SnowCum       ( 0:imax-1, 1:jmax )
    real(DP), intent(out  ) :: xy_RainLsc       ( 0:imax-1, 1:jmax )
    real(DP), intent(out  ) :: xy_SnowLsc       ( 0:imax-1, 1:jmax )



    real(DP) :: xyz_TempB     ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP) :: xyz_QH2OLiqB  ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP) :: xyz_QH2OSolB  ( 0:imax-1, 1:jmax, 1:kmax )

    real(DP) :: xyz_DelMass      ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP) :: xyz_DTempDtFreeze( 0:imax-1, 1:jmax, 1:kmax )

    real(DP) :: xyz_WatFrac         ( 0:imax-1, 1:jmax, 1:kmax )

    real(DP) :: xyz_DQH2OLiqDt      ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP) :: xyz_DQH2OSolDt      ( 0:imax-1, 1:jmax, 1:kmax )
!!$    real(DP) :: xyz_DQH2OLiqDtCumLSC( 0:imax-1, 1:jmax, 1:kmax )
!!$    real(DP) :: xyz_DQH2OSolDtCumLSC( 0:imax-1, 1:jmax, 1:kmax )
!!$    real(DP) :: xyz_DQH2OLiqDtI2W   ( 0:imax-1, 1:jmax, 1:kmax )
!!$    real(DP) :: xyz_DQH2OSolDtW2I   ( 0:imax-1, 1:jmax, 1:kmax )

    real(DP) :: xyz_DQRainDt  ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP) :: xyz_DQSnowDt  ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP) :: xy_Rain       ( 0:imax-1, 1:jmax )
    real(DP) :: xy_Snow       ( 0:imax-1, 1:jmax )
    real(DP) :: TempTentative
    real(DP) :: Melt

    integer  :: i
    integer  :: j
    integer  :: k


    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. cloud_simple_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! save temperature, cloud water and ice before adjustment
    xyz_TempB    = xyz_Temp
    xyz_QH2OLiqB = xyz_QH2OLiq
    xyz_QH2OSolB = xyz_QH2OSol


    ! Temporal treatment
    ! These values are removed from arguments.
    xyz_DQH2OLiqDt = 0.0_DP
    xyz_DQH2OSolDt = 0.0_DP


    ! mass of an atmospheric layer
    do k = 1, kmax
      xyz_DelMass(:,:,k) = ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
    end do

    ! fraction of cloud water
!!$    call CloudUtilsWatFraction(      &
!!$      & xyz_Temp,                    & ! (in )
!!$      & xyz_WatFrac                  & ! (out)
!!$      & )

    ! partition cloud water production rate into water and ice
!!$    xyz_DQH2OLiqDtCumLSC = &
!!$      & ( xyz_DQH2OLiqDtCum + xyz_DQH2OLiqDtLSC ) * xyz_WatFrac
!!$    xyz_DQH2OSolDtCumLSC = &
!!$      & ( xyz_DQH2OLiqDtCum + xyz_DQH2OLiqDtLSC ) - xyz_DQH2OLiqDtCumLSC

    ! conversion rate from water to ice, and vice versa
!!$    xyz_DQH2OLiqDtI2W = &
!!$      & ( xyz_QH2OLiq + xyz_QH2OSol ) * xyz_WatFrac - xyz_QH2OLiq
!!$    xyz_DQH2OLiqDtI2W = xyz_DQH2OLiqDtI2W / ( 2.0_DP * DelTime )
!!$    xyz_DQH2OSolDtW2I = - xyz_DQH2OLiqDtI2W
!!$
!!$    xyz_DQH2OLiqDt = xyz_DQH2OLiqDtCumLSC + xyz_DQH2OLiqDtI2W
!!$    xyz_DQH2OSolDt = xyz_DQH2OSolDtCumLSC + xyz_DQH2OSolDtW2I


    ! temperature increase due to freezing
!!$    xyz_DTempDtFreeze = LatentHeatFusion * xyz_DQH2OSolDt / CpDry
!!$    xyz_Temp = xyz_Temp + xyz_DTempDtFreeze * 2.0_DP * DelTime

    xyz_QH2OLiq =                                                                 &
      &   xyz_QH2OLiq * exp( - 2.0_DP * DelTime / ( CloudWatLifeTime + 1.0e-100_DP ) )  &
      & + xyz_DQH2OLiqDt * CloudWatLifeTime                                          &
      &   * ( 1.0_DP - exp( - 2.0_DP * DelTime / ( CloudWatLifeTime + 1.0e-100_DP ) ) )

    xyz_DQRainDt =                                         &
      &   xyz_QH2OLiqB + xyz_DQH2OLiqDt * 2.0_DP * DelTime &
      & - xyz_QH2OLiq
    xyz_DQRainDt = xyz_DQRainDt / ( 2.0_DP * DelTime )


    xyz_QH2OSol =                                                                 &
      &   xyz_QH2OSol * exp( - 2.0_DP * DelTime / ( CloudIceLifeTime + 1.0e-100_DP ) )  &
      & + xyz_DQH2OSolDt * CloudIceLifeTime                                          &
      &   * ( 1.0_DP - exp( - 2.0_DP * DelTime / ( CloudIceLifeTime + 1.0e-100_DP ) ) )

    xyz_DQSnowDt =                                         &
      &   xyz_QH2OSolB + xyz_DQH2OSolDt * 2.0_DP * DelTime &
      & - xyz_QH2OSol
    xyz_DQSnowDt = xyz_DQSnowDt / ( 2.0_DP * DelTime )



!!$    xy_Rain = 0.0_DP
!!$    xy_Snow = 0.0_DP
!!$    do k = kmax, 1, -1
!!$      do j = 1, jmax
!!$        do i = 0, imax-1
!!$          xy_Rain(i,j) = xy_Rain(i,j)                               &
!!$            & + xyz_DQRainDt(i,j,k) * xyz_DelMass(i,j,k)
!!$          xy_Snow(i,j) = xy_Snow(i,j)                               &
!!$            & + xyz_DQSnowDt(i,j,k) * xyz_DelMass(i,j,k)
!!$
!!$          if ( xyz_Temp(i,j,k) > TempCondWater ) then
!!$            Melt = xy_Snow(i,j)
!!$            TempTentative = xyz_Temp(i,j,k)                  &
!!$              & - LatentHeatFusion * Melt * 2.0_DP * DelTime &
!!$              &   / ( CpDry * xyz_DelMass(i,j,k) )
!!$            if ( TempTentative < TempCondWater ) then
!!$              TempTentative = TempCondWater
!!$              Melt =                                          &
!!$                & CpDry * xyz_DelMass(i,j,k)                  &
!!$                &   * ( xyz_Temp(i,j,k) - TempTentative )     &
!!$                &   / ( LatentHeatFusion * 2.0_DP * DelTime )
!!$            end if
!!$            xyz_Temp(i,j,k) = TempTentative
!!$            xy_Rain(i,j) = xy_Rain(i,j) + Melt
!!$            xy_Snow(i,j) = xy_Snow(i,j) - Melt
!!$          end if
!!$
!!$        end do
!!$      end do
!!$    end do
!!$
!!$    xy_RainCum = xy_Rain
!!$    xy_SnowCum = xy_Snow
!!$    xy_RainLsc = 0.0_DP
!!$    xy_SnowLsc = 0.0_DP
!!$
!!$
!!$    xyz_DTempDtCond = xyz_DTempDtCond &
!!$      & + ( xyz_Temp - xyz_TempB ) / ( 2.0_DP * DelTime )



    ! Temporal treatment
    xyz_DQRainDt = xyz_DQRainDt + xyz_DQSnowDt

    call CloudUtilsCalcPRCPKeyLLTemp3D(    &
      & xyr_Press, xyz_Temp, xyz_DQRainDt, &  ! (in )
      & xy_RainCum, xy_SnowCum             &  ! (out)
      & )
    xy_RainLsc = 0.0_DP
    xy_SnowLsc = 0.0_DP


  end subroutine CloudSimpleWithIce_OLD

  !--------------------------------------------------------------------------------------

  subroutine CloudSimpleCalcCloudCover(  &
    & xyz_Press, xyz_Temp, xyz_QH2OTot,  & ! (in )
    & xyz_CloudCover                     & ! (out)
    & )

    ! USE statements
    !

    ! ˰漾λ
    ! Evaluate saturation specific humidity
    !
    use saturate, only: xyz_CalcQVapSat

    real(DP), intent(in ) :: xyz_Press     ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(in ) :: xyz_Temp      ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(in ) :: xyz_QH2OTot   ( 0:imax-1, 1:jmax, 1:kmax )
    real(DP), intent(out) :: xyz_CloudCover( 0:imax-1, 1:jmax, 1:kmax )


    real(DP) :: xyz_RH(0:imax-1, 1:jmax, 1:kmax)


    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. cloud_simple_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    select case ( IDCloudCoverMethod )
    case ( IDCloudCoverMethodConst )

      xyz_CloudCover = CloudCover

    case ( IDCloudCoverMethodRH )

      ! see Sundqvist et al. (1989), Del Genio et al. (1996)
      xyz_RH = xyz_QH2OTot / xyz_CalcQVapSat( xyz_Temp, xyz_Press )
      xyz_RH = min( xyz_RH, 1.0_DP )

      xyz_CloudCover = 1.0_DP - sqrt( ( 1.0_DP - xyz_RH ) / ( 1.0_DP - RHCrtl ) )

      xyz_CloudCover = max( xyz_CloudCover, 0.0_DP )
      xyz_CloudCover = min( xyz_CloudCover, 1.0_DP )

    end select


  end subroutine CloudSimpleCalcCloudCover

  !--------------------------------------------------------------------------------------

  subroutine CloudSimpleDivideWatAndIce(  &
    & xyz_Temp,                           & ! (in )
    & xyz_QH2OWatAndIce,                  & ! (in )
    & xyz_QH2OWat, xyz_QH2OIce            & ! (out)
    & )

    ! USE statements
    !

    ! طϥ롼
    ! Cloud-related routines
    !
    use cloud_utils, only : CloudUtilsWatFraction


    real(DP), intent(in ) :: xyz_Temp         (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in ) :: xyz_QH2OWatAndIce(0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(out) :: xyz_QH2OWat      (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(out) :: xyz_QH2OIce      (0:imax-1, 1:jmax, 1:kmax)


    real(DP) :: xyz_WatFrac(0:imax-1, 1:jmax, 1:kmax)

    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. cloud_simple_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    call CloudUtilsWatFraction(      &
      & xyz_Temp,                    & ! (in )
      & xyz_WatFrac                  & ! (out)
      & )

    xyz_QH2OWat = xyz_QH2OWatAndIce * xyz_WatFrac
    xyz_QH2OIce = xyz_QH2OWatAndIce * ( 1.0_DP - xyz_WatFrac )


  end subroutine CloudSimpleDivideWatAndIce

  !--------------------------------------------------------------------------------------

  subroutine CloudSimpleInit( &
    & ArgFlagSnow             &
    & )

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! ˰漾λ
    ! Evaluate saturation specific humidity
    !
    use saturate, only: SaturateInit

    ! 絬϶ŷ (ήŷ)
    ! Large scale condensation (non-convective condensation)
    !
    use lscond, only : LScaleCondInit

    ! طϥ롼
    ! Cloud-related routines
    !
    use cloud_utils, only : CloudUtilsInit


    ! ʸ ; Declaration statements
    !

    logical, intent(in) :: ArgFlagSnow


    character(STRING) :: CloudCoverMethod
    character(STRING) :: SnowMethod

    integer:: unit_nml        ! NAMELIST ե륪ץֹ.
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT.
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /cloud_simple_nml/ &
      & CloudLifeTime,       &
      & CloudWatLifeTime,    &
      & CloudIceLifeTime,    &
      & CloudCoverMethod,    &
      & SnowMethod,          &
      & RHCrtl,              &
      & CloudCover,          &
      & FlagPRCPEvap,        &
      & PRCPArea,            &
      & PRCPEvapArea
          !
          ! ǥեͤˤĤƤϽ³ "cloud_simple#CloudSimpleInit"
          ! Υɤ򻲾ȤΤ.
          !
          ! Refer to source codes in the initialization procedure
          ! "cloud_simple#CloudSimpleInit" for the default values.
          !

    ! ¹ʸ ; Executable statement
    !

    if ( cloud_simple_inited ) return


    FlagSnow = ArgFlagSnow


    ! ǥեͤ
    ! Default values settings
    !
    CloudLifeTime       = 3600.0_DP
    CloudWatLifeTime    = 3600.0_DP
    CloudIceLifeTime    = 3600.0_DP

    CloudCoverMethod    = 'Const'
!!$    CloudCoverMethod    = 'RH'

    SnowMethod          = 'KeyLLTemp'

    RHCrtl              = 0.8_DP

    CloudCover          = 1.0_DP

    FlagPRCPEvap        = .false.
    PRCPArea            = 0.5_DP
    PRCPEvapArea        = 0.5_DP


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml,                     & ! (in)
        & nml = cloud_simple_nml,         & ! (out)
        & iostat = iostat_nml )             ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if


    select case ( CloudCoverMethod )
    case ( 'Const' )
      IDCloudCoverMethod = IDCloudCoverMethodConst
    case ( 'RH' )
      IDCloudCoverMethod = IDCloudCoverMethodRH
    case default
      call MessageNotify( 'E', module_name,         &
        & 'CloudCoverMethod=<%c> is not supported.', &
        & c1 = trim(CloudCoverMethod) )
    end select


    select case ( SnowMethod )
    case ( 'KeyLLTemp' )
      IDSnowMethod = IDSnowMethodKeyLLTemp
    case ( 'StepPC' )
      IDSnowMethod = IDSnowMethodStepPC
    case default
      call MessageNotify( 'E', module_name,         &
        & 'SnowMethod=<%c> is not supported.', &
        & c1 = trim(SnowMethod) )
    end select



    ! Initialization of modules used in this module
    !

    ! ˰漾λ
    ! Evaluate saturation specific humidity
    !
    call SaturateInit

    ! 絬϶ŷ (ήŷ) (Manabe, 1965)
    ! Large scale condensation (non-convective condensation) (Le Treut and Li, 1991)
    !
    call LScaleCondInit( &
      & FlagSnow &
      & )

    ! طϥ롼
    ! Cloud-related routines
    !
    call CloudUtilsInit( &
      & FlagSnow         &
      & )


    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
!!$    call HistoryAutoAddVariable( 'EffCloudCover', &
!!$      & (/ 'lon ', 'lat ', 'time' /), &
!!$      & 'effective cloud cover', '1' )



    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, 'CloudLifeTime       = %f', d = (/ CloudLifeTime /) )
    call MessageNotify( 'M', module_name, 'CloudWatLifeTime    = %f', d = (/ CloudWatLifeTime /) )
    call MessageNotify( 'M', module_name, 'CloudIceLifeTime    = %f', d = (/ CloudIceLifeTime /) )
    call MessageNotify( 'M', module_name, 'CloudCoverMethod    = %c', c1 = trim(CloudCoverMethod) )
    call MessageNotify( 'M', module_name, 'SnowMethod          = %c', c1 = trim(SnowMethod) )
    call MessageNotify( 'M', module_name, 'RHCrtl              = %f', d = (/ RHCrtl /) )
    call MessageNotify( 'M', module_name, 'CloudCover          = %f', d = (/ CloudCover /) )
    call MessageNotify( 'M', module_name, 'FlagPRCPEvap        = %b', l = (/ FlagPRCPEvap /) )
    call MessageNotify( 'M', module_name, 'PRCPArea            = %f', d = (/ PRCPArea /) )
    call MessageNotify( 'M', module_name, 'PRCPEvapArea        = %f', d = (/ PRCPEvapArea /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )


    cloud_simple_inited = .true.

  end subroutine CloudSimpleInit

  !--------------------------------------------------------------------------------------

end module cloud_simple
