!= ɸǡ
!
!= Axes data settings
!
! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA
! Version::   $Id: axesset.F90,v 1.20 2014/05/07 09:39:21 murashin Exp $ 
! Tag Name::  $Name: dcpam5-20140630-2 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module axesset
  !
  != ɸǡ
  !
  != Axes data settings
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ɸǡꤪݴɤԤޤ. 
  ! 
  !  $ \varphi $ ӷ $ \lambda $ γʻ, 
  ! gridset ⥸塼ꤵʻ, 
  ! {SPMODEL 饤֥}[http://www.gfd-dennou.org/library/spmodel]
  ! ѤƷꤵޤ. 
  ! ٤γʻΰ֤ϥ, 
  ! ٤γʻΰֳ֤֤ˤȤ뤳Ȥˤʤޤ. 
  ! 
  ! ľҤγʻ, Ⱦ٥ (ؤü) ˤĤ 
  ! NAMELIST#Sigma ˻ꤷޤ. 
  ! ٥ (ؤ濴) , Ⱦ٥ constants 
  ! ⥸塼ꤵ봥絤갵Ǯ $ C_p $ 
  ! 絤ε $ R $ ѤƷꤷޤ. 
  ! ľҤγʻˤĤƤ, sigma_data ⥸塼ѰդƤ
  ! ΤѤ뤳ȤǽǤ. 
  !
  ! Axes data is set and stored. 
  !
  ! Grid points of latitude $ \varphi $ and longitude $ \lambda $ are
  ! determined 
  ! with number of grid points configured in "gridset" module
  ! by {SPMODEL Library}[http://www.gfd-dennou.org/library/spmodel/index.htm.en]
  ! Grid points of latitude becomes Gaussian latitude, 
  ! and grid points of latitude becomes equally spaced. 
  !
  !== Variables List
  !
  ! x_Lon               :: ٺɸ
  ! x_Lon_Weight        :: ٺɸŤ
  ! DeltaLon            :: ٳʻֳ
  ! InvDeltaLon         :: ٳʻֳ֤εտ
  ! y_Lat               :: ٺɸ
  ! y_Lat_Weight        :: ٺɸŤ
  ! z_Sigma             :: $ \sigma $ ٥ ()
  ! r_Sigma             :: $ \sigma $ ٥ (Ⱦ)
  ! z_DelSigma          :: $ \Delta \sigma $ ()
  ! r_DelSigma          :: $ \Delta \sigma $ (Ⱦ)
  ! w_Number            :: ڥȥǡźֹ
  ! spml_inited         :: SPML 饤֥νե饰
  ! ------------        :: ------------
  ! x_Lon               :: Longitude
  ! x_Lon_Weight        :: Weight of longitude
  ! DeltaLon            :: Interval of longitude grids
  ! InvDeltaLon         :: Inverse of DeltaLon
  ! y_Lat               :: Latitude
  ! y_Lat_Weight        :: Weight of latitude
  ! z_Sigma             :: Full $ \sigma $ level
  ! r_Sigma             :: Half $ \sigma $ level
  ! z_DelSigma          :: $ \Delta \sigma $ (Full)
  ! r_DelSigma          :: $ \Delta \sigma $ (Half)
  ! w_Number            :: Subscript of spectral data
  ! spml_inited         :: Initialization flag of SPML library
  !
  !== Procedures List
  !
  ! AxessetInit     :: ɸǡ
  ! AxessetFinalize :: λ (⥸塼ѿγդ)
  ! ------------    :: ------------
  ! AxessetInit     :: Settings of axes data
  ! AxessetFinalize :: Termination (deallocate variables in this module)
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: &
    &                nmax       , & ! ȿ. 
                                    ! Maximum truncated wavenumber
    &                imax       , & ! ٳʻ. 
                                    ! Number of grid points in longitude
    &                jmax_global, & ! ٳʻ (). 
                                    ! Number of grid points in latitude on whole globe
    &                jmax       , & ! ٳʻ. 
                                    ! Number of grid points in latitude
    &                kmax       , & ! ľؿ. 
                                    ! Number of vertical level
    &                kslmax         ! ϲαľؿ.
                                    ! Number of subsurface vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP,     & ! ټ¿. Double precision. 
                      STRING    ! ʸ. Strings.

  ! NAMELIST եϤ˴ؤ桼ƥƥ
  ! Utilities for NAMELIST file input
  !
  use namelist_util, only: MaxNmlArySize
                              ! NAMELIST ɤ߹κ祵. 
                              ! Maximum size of arrays loaded from NAMELIST

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: AxessetInit, AxessetFinalize

  ! ѿ
  ! Public variables
  !
  logical, save, public:: axesset_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  real(DP), allocatable, save, public:: x_Lon (:)
                              ! $ \lambda $ [rad.] . . Longitude
  real(DP), allocatable, save, public:: x_Lon_Weight (:)
                              ! $ \Delta \lambda $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of longitude
  real(DP), allocatable, save, public:: y_Lat (:)
                              ! $ \varphi $ [rad.] . . Latitude
  real(DP), allocatable, save, public:: y_Lat_Weight (:)
                              ! $ \Delta \varphi $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of latitude
  real(DP), allocatable, save, public:: z_Sigma (:)
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
  real(DP), allocatable, save, public:: r_Sigma (:)
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level
  real(DP), allocatable, save, public:: z_DelSigma (:)
                              ! $ \Delta \sigma $ (). 
                              ! $ \Delta \sigma $ (Full)
  real(DP), allocatable, save, public:: r_DelSigma (:)
                              ! $ \Delta \sigma $ (Ⱦ). 
                              ! $ \Delta \sigma $ (half)
  integer, allocatable, save, public:: w_Number (:)
                              ! ڥȥǡźֹ. 
                              ! Subscript of spectral data
  real(DP), allocatable, save, public:: z_SSDepth(:)
                              ! ϲγʻο
                              ! subsurface grid at midpoint of layer
  real(DP), allocatable, save, public:: r_SSDepth(:)
                              ! ϲؤζ̤ο
                              ! subsurface grid on interface of layer
  real(DP), save, public:: DeltaLon
                              ! ٳʻֳ. 
                              ! grid interval in longitude
  real(DP), save, public:: InvDeltaLon
                              ! ٳʻֳ֤εտ. 
                              ! Inverse of the grid interval in longitude
                              
                              

  logical, save, public:: spml_inited = .false.
                              ! SPML 饤֥νե饰. 
                              ! Initialization flag of SPML library

  character(STRING), parameter, public :: AxnameX   = 'lon'
                              ! axis name for x
  character(STRING), parameter, public :: AxnameY   = 'lat'
                              ! axis name for y
  character(STRING), parameter, public :: AxnameZ   = 'sig'
                              ! axis name for z
  character(STRING), parameter, public :: AxnameR   = 'sigm'
                              ! axis name for r
  character(STRING), parameter, public :: AxnameSSZ = 'ssz'
                              ! axis name for z (subsurface)
  character(STRING), parameter, public :: AxnameSSR = 'sszi'
                              ! axis name for r (subsurface)
  character(STRING), parameter, public :: AxnameWN  = 'wn'
                              ! axis name for wavenumber
  character(STRING), parameter, public :: AxnameT   = 'time'
                              ! axis name for t


  ! ѿ
  ! Private variables
  !
  real(DP), save:: Sigma (1:MaxNmlArySize)
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level
  real(DP), save:: Depth(1:MaxNmlArySize)
                              ! , ϲαľض
                              ! array for input, layer interface of subsurface 
                              ! vertical layer

  character(*), parameter:: module_name = 'axesset'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20140630-2 $' // &
    & '$Id: axesset.F90,v 1.20 2014/05/07 09:39:21 murashin Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  !--------------------------------------------------------------------------------------

  subroutine AxessetInit
    !
    ! axesset ⥸塼νԤޤ. 
    ! NAMELIST#axesset_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "axesset" module is initialized. 
    ! NAMELIST#axesset_nml is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical and mathematical constants settings
    !
    use constants0, only: PI      ! $ \pi $ .
                                  ! ߼Ψ.  Circular constant

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      &                  CpDry, & ! $ C_p $ [J kg-1 K-1]. 
                                  ! 絤갵Ǯ. 
                                  ! Specific heat of air at constant pressure
      &                  GasRDry  ! $ R $ [J kg-1 K-1]. 
                                  ! 絤ε. 
                                  ! Gas constant of air

    ! ʻȿ
    ! Number of grid points and maximum truncated wavenumber settings
    !
    use gridset, only: GridsetCheckNumberOfLatGrid

    ! SPMODEL 饤֥, ̾ĴȡѴˤ(¿б) 
    ! SPMODEL library, problems on sphere are solved with spherical harmonics 
    ! (multi layer is supported)
    !
#ifdef LIB_MPI
#ifdef SJPACK
    use wa_mpi_module_sjpack, only: wa_mpi_Initial, &
      & spml_x_Lon        => x_Lon, & 
                              ! $ \lambda $ [rad.] . . Longitude
      & spml_x_Lon_Weight => x_Lon_Weight, &
                              ! $ \Delta \lambda $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of longitude
      & spml_y_Lat        => v_Lat, &
                              ! $ \varphi $ [rad.] . . Latitude
      & spml_y_Lat_Weight => v_Lat_Weight, &
                              ! $ \Delta \varphi $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of latitude
      & spml_jc => jc
#else
    use wa_mpi_module, only: wa_mpi_Initial, &
      & spml_x_Lon        => x_Lon, & 
                              ! $ \lambda $ [rad.] . . Longitude
      & spml_x_Lon_Weight => x_Lon_Weight, &
                              ! $ \Delta \lambda $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of longitude
      & spml_y_Lat        => v_Lat, &
                              ! $ \varphi $ [rad.] . . Latitude
      & spml_y_Lat_Weight => v_Lat_Weight, &
                              ! $ \Delta \varphi $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of latitude
      & spml_jc => jc
#endif
#elif AXISYMMETRY
    use wa_zonal_module, only: wa_Initial, &
      & spml_x_Lon        => x_Lon, & 
                              ! $ \lambda $ [rad.] . . Longitude
      & spml_x_Lon_Weight => x_Lon_Weight, &
                              ! $ \Delta \lambda $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of longitude
      & spml_y_Lat        => y_Lat, &
                              ! $ \varphi $ [rad.] . . Latitude
      & spml_y_Lat_Weight => y_Lat_Weight
                              ! $ \Delta \varphi $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of latitude
#elif SJPACK
    use wa_module_sjpack, only: wa_Initial, &
      & spml_x_Lon        => x_Lon, & 
                              ! $ \lambda $ [rad.] . . Longitude
      & spml_x_Lon_Weight => x_Lon_Weight, &
                              ! $ \Delta \lambda $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of longitude
      & spml_y_Lat        => y_Lat, &
                              ! $ \varphi $ [rad.] . . Latitude
      & spml_y_Lat_Weight => y_Lat_Weight
                              ! $ \Delta \varphi $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of latitude
#elif AXISYMMETRY_SJPACK
    use wa_zonal_module_sjpack, only: wa_Initial, &
      & spml_x_Lon        => x_Lon, & 
                              ! $ \lambda $ [rad.] . . Longitude
      & spml_x_Lon_Weight => x_Lon_Weight, &
                              ! $ \Delta \lambda $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of longitude
      & spml_y_Lat        => y_Lat, &
                              ! $ \varphi $ [rad.] . . Latitude
      & spml_y_Lat_Weight => y_Lat_Weight
                              ! $ \Delta \varphi $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of latitude
#else
    use wa_module, only: wa_Initial, &
      & spml_x_Lon        => x_Lon, & 
                              ! $ \lambda $ [rad.] . . Longitude
      & spml_x_Lon_Weight => x_Lon_Weight, &
                              ! $ \Delta \lambda $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of longitude
      & spml_y_Lat        => y_Lat, &
                              ! $ \varphi $ [rad.] . . Latitude
      & spml_y_Lat_Weight => y_Lat_Weight
                              ! $ \Delta \varphi $ [rad.] . 
                              ! ٺɸŤ. 
                              ! Weight of latitude
#endif

    ! ľҥ٥ǡ
    ! Prepare vertical sigma level data
    !
    use sigma_data, only: SigmaDataGetHalf

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: &
      &                 STDOUT, &  ! ɸϤֹ. Unit number of standard output
      &                 TOKEN      ! .   Keywords. 

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! ʸ
    ! Character handling
    !
    use dc_string, only: CPrintf

    ! OpenMP
    !
    !$ use omp_lib


    ! ʸ ; Declaration statements
    !
    implicit none

    ! ѿ
    ! Work variables
    !
    logical:: flag_generate_sigma
                              ! ľؿΤΥե饰
                              ! Flag for generation of sigma levels internally
    integer:: i               ! ڥȥźֹǲ DO 롼Ѻѿ
                              ! Work variables for DO loop in subscript of spectral data
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction
    real(DP):: Kappa          ! $ \kappa = R / C_p $ .
                              ! 絤ˤ, 갵ǮФ.
                              ! Ratio of gas constant to specific heat in dry air

    real(DP):: LonInDeg       ! Longitude in unit of degree of a grid point in 1D mode
    real(DP):: LatInDeg       ! Latitude in unit of degree of a grid point in 1D mode

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    integer:: OMPNumThreads
                              ! OpenMP Ǥκ祹åɿ.
                              ! openmp_threads  1 礭ͤꤹ 
                              ! ISPACK[http://www.gfd-dennou.org/library/ispack/] 
                              ! εĴȡѴ OpenMP ׻
                              ! 롼Ѥ. ׻¹Ԥˤ,
                              ! ¹Ի˴Ķѿ OMP_NUM_THREADS 
                              !  OMPNumThreads ʲοꤹ
                              ! Υƥ˱ɬפȤʤ.
                              !
                              ! OMPNumThreads  1 礭ͤ
                              ! ꤷʤ׻롼ϸƤФʤ.

    character(TOKEN):: rank_str
                              ! 󥯿. Rank number
    integer:: myrank_mpi      ! ץ. Number of total processes
    integer:: nprocs_mpi      ! ȤΥץ. Number of my process
    integer:: ra              ! MPI Υ󥯿˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in rank number of MPI direction

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /axesset_nml/ &
      & Sigma, Depth, flag_generate_sigma, &
      & LonInDeg, LatInDeg
          !
          ! ǥեͤˤĤƤϽ³ "axesset#AxessetInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "axesset#AxessetInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( axesset_inited ) return


    !
    ! Set number of OpenMP threads
    !
    OMPNumThreads = 1
    !$ OMPNumThreads = omp_get_max_threads()


    ! դ
    ! Allocation
    !
    allocate( z_Sigma      (1:kmax)   )
    allocate( r_Sigma      (0:kmax)   )
    allocate( z_DelSigma   (1:kmax)   )
    allocate( r_DelSigma   (0:kmax)   )
    allocate( w_Number     (1:(nmax+1)**2) )

    allocate( r_SSDepth( 0:kslmax ) )
    allocate( z_SSDepth( 1:kslmax ) )

    ! ǥեͤ
    ! Default values settings
    !

    ! Sigma (Ⱦ٥) ν (̵) 
    ! Setting of initial value (invalid value) of "Sigma" (half level sigma)
    !
    Sigma = -999.0d0

    ! ϲؤζ̿ν (̵) 
    ! Setting of initial value (invalid value) of depth of subsurface layer interface
    !
    Depth = -999.0d0

    ! ľؿΤΥե饰
    ! Setting of flag for generation of sigma levels internally
    !
    flag_generate_sigma = .false.

    ! Longitude in unit of degree of a grid point in 1D mode
    !
    LonInDeg = 0.0_DP

    ! Latitude in unit of degree of a grid point in 1D mode
    !
    LatInDeg  = 0.0_DP

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &         ! (in)
        & nml = axesset_nml, &  ! (out)
        & iostat = iostat_nml ) ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if

    ! Sigma (Ⱦ٥) μư
    ! Automation setting of "Sigma" (half level sigma)
    !
    if ( all( Sigma == -999.0d0 ) ) then
      if ( flag_generate_sigma ) then
        call SigmaDataGetHalf( Sigma(1:kmax+1) ) ! (out)
      else
        call MessageNotify( 'E', module_name, &
          & '  Sigma levels have to be specified if flag_generate_sigma is not true.' )
      end if
    end if

    ! Sigma (Ⱦ٥) å
    ! Check "Sigma" (half level sigma)
    !
    if ( Sigma(1) /= 1.0_DP ) then
      call MessageNotify( 'E', module_name, '  Sigma(1) is not 1, but is %f', &
        & d = (/ Sigma(1) /) )
    end if
    if ( Sigma(kmax+1) /= 0.0_DP ) then
      call MessageNotify( 'E', module_name, '  Sigma(kmax+1) is not 0, but is %f', &
        & d = (/ Sigma(kmax+1) /) )
    end if
    do k = 1, kmax
      if ( Sigma(k+1) > Sigma(k) ) then
        call MessageNotify( 'M', module_name, '  Sigma(%d) = %f > Sigma(%d) = %f', &
            & i = (/ k+1, k /), d = (/ Sigma(k+1), Sigma(k) /) )
        call MessageNotify( 'E', module_name, '  Value of Sigma has to decrease with index.' )
      end if
    end do

    ! r_Sigma (Ⱦ٥) 
    ! Setting of "r_Sigma" (half level sigma)
    !
    r_Sigma(0:kmax) = Sigma(1:kmax+1)

    ! z_DelSigma (٥ $ \Delta \sigma $ ) 
    ! Setting of "z_DelSigma" (full level $ \Delta \sigma $ )
    !
    do k = 1, kmax
      z_DelSigma(k) = r_Sigma(k-1) - r_Sigma(k)
    enddo

    ! z_Sigma (٥) 
    ! Setting of "z_Sigma" (full level sigma)
    !
    Kappa = GasRDry / CpDry
    do k = 1, kmax
      z_Sigma(k) = &
        & ( &
        &   (   r_Sigma(k-1) ** ( 1.0_DP + Kappa ) &
        &     - r_Sigma(k)   ** ( 1.0_DP + Kappa ) &
        &   ) / ( z_DelSigma(k) * ( 1.0_DP + Kappa ) ) &
        & ) ** ( 1.0_DP / Kappa )
    enddo

    ! r_DelSigma (Ⱦ٥ $ \Delta \sigma $ ) 
    ! Setting of "r_DelSigma" (half level $ \Delta \sigma $ )
    !
    r_DelSigma(0)    = r_Sigma(0)    - z_Sigma(1)
    r_DelSigma(kmax) = z_Sigma(kmax) - r_Sigma(kmax)
    do k = 1, kmax - 1
      r_DelSigma(k) = z_Sigma(k) - z_Sigma(k+1)
    end do


    ! ϲؤζ̿Υå
    ! Check depth of subsurface layer interface
    !
    if ( all( Depth == -999.0d0 ) ) then
      Depth(0+1:kslmax+1 ) = 0.0_DP
      call MessageNotify( 'W', module_name, 'Depth is not found in namelist file.' )
    end if
    !
    if ( Depth(0+1) /= 0.0_DP ) then
      call MessageNotify( 'E', module_name, '  Depth(0) is not zero, but is %f', &
        & d = (/ Depth(0+1) /) )
    end if
    if ( kslmax >= 1 ) then
      if ( all( Depth(1+1:kslmax+1) >= 0.0_DP ) ) then
        do k = 0, kslmax
          call MessageNotify( 'M', module_name, '  Depth(%d) = %f', &
            & i = (/ k /), d = (/ Depth(k+1) /) )
        end do
        call MessageNotify( 'E', module_name, '  Depth has to be zero or negative.' )
      end if
    end if
    do k = 0, kslmax-1
      if ( Depth(k+1+1) > Depth(k+1) ) then
        call MessageNotify( 'M', module_name, '  Depth(%d) = %f > Depth(%d) = %f', &
            & i = (/ k+1, k /), d = (/ Depth(k+1+1), Depth(k+1) /) )
        call MessageNotify( 'E', module_name, '  Value of Depth has to decrease with index.' )
      end if
    end do

    r_SSDepth(0:kslmax) = Depth(1:kslmax+1)

    do k = 0, kslmax
      call MessageNotify( 'M', module_name, '  r_SSDepth(%d) = %f', &
        i = (/ k /), d = (/ r_SSDepth(k) /) )
    end do

    ! ϲαľؤ濴
    ! Set midpoint of subsurface grid
    !
    do k = 1, kslmax
      z_SSDepth( k ) = ( r_SSDepth( k-1 ) + r_SSDepth( k ) ) / 2.0d0
    end do

    ! ٷ٤
    ! Settings of longitude and latitude
    !
    allocate( x_Lon        (0:imax-1) )
    allocate( x_Lon_Weight (0:imax-1) )
    allocate( y_Lat        (1:jmax)   )
    allocate( y_Lat_Weight (1:jmax)   )

    if ( ( imax == 1 ) .and. ( jmax == 1 ) ) then

      x_Lon          = LonInDeg * PI / 180.0_DP
      x_Lon_Weight   = 1.0_DP
      y_Lat          = LatInDeg * PI / 180.0_DP
      y_Lat_Weight   = 1.0_DP

    else
      if ( .not. spml_inited ) then
#ifdef LIB_MPI
        call wa_mpi_Initial( nmax, imax, jmax_global, kmax, OMPNumThreads ) ! (in)
        ! Check number of latitudinal grid on each process
        call GridsetCheckNumberOfLatGrid( spml_jc )
#else
        call wa_Initial( nmax, imax, jmax_global, kmax, OMPNumThreads ) ! (in)
#endif
        spml_inited = .true.
      end if

      x_Lon          = spml_x_Lon
      x_Lon_Weight   = spml_x_Lon_Weight
      y_Lat          = spml_y_Lat
      y_Lat_Weight   = spml_y_Lat_Weight
    end if

    if ( imax /= 1  ) then
      ! DeltaLon, InvDeltaLonη׻
      ! Caluculate DeltaLon and InvDeltaLon
      DeltaLon = x_Lon(1) - x_Lon(0)
      InvDeltaLon = 1.0_DP/DeltaLon
    else
      DeltaLon = 0.0_DP
      InvDeltaLon = 0.0_DP ! not used
    endif



    ! ڥȥǡźֹ
    ! Settings of subscript of spectral data
    !
    do i = 1, size(w_Number)
      w_Number(i) = i
    end do

    ! 󥯤˴ؤμ
    ! Get information about rank
    !
    myrank_mpi = -1
    nprocs_mpi = 1
    rank_str = ''


    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )

#ifdef SJPACK
    call MessageNotify( 'M', module_name, 'SJPACK : %c', c1 = 'used.' )
#else
    call MessageNotify( 'M', module_name, 'SJPACK : %c', c1 = 'not used.' )
#endif

    call MessageNotify( 'M', module_name, 'OMPNumThreads = %d', i = (/OMPNumThreads/) )

    do ra = 0, nprocs_mpi - 1

      call MessageNotify( 'M', module_name, 'Axes:%c', c1 = trim(rank_str), rank_mpi = -1 )
      call MessageNotify( 'M', module_name, '  x_Lon(%d:%d) [deg.] = %*f', &
        & i = (/ 0, imax - 1/), &
        & d = format_print(x_Lon / PI * 180.0_DP, imax), &
        & n =(/ imax /), rank_mpi = -1 )
      call MessageNotify( 'M', module_name, '  y_Lat(%d:%d) [deg.] = %*f', &
        & i = (/ 1, jmax/), &
        & d = format_print(y_Lat / PI * 180.0_DP, jmax), &
        & n =(/ jmax /), rank_mpi = -1 )
      call MessageNotify( 'M', module_name, '  z_Sigma(%d:%d) = %*f', &
        & i = (/ 1, kmax /), &
        & d = format_print(z_Sigma, kmax), n =(/ kmax /), rank_mpi = -1 )
      call MessageNotify( 'M', module_name, '  r_Sigma(%d:%d) = %*f', &
        & i = (/ 0, kmax /), &
        & d = format_print(r_Sigma, kmax+1), n =(/ kmax+1 /), rank_mpi = -1 )
      call MessageNotify( 'M', module_name, '  w_Number(%d:%d) = %d .. %d', &
        & i = (/ 1, size(w_Number), 1, size(w_Number) /), rank_mpi = -1 )
  !
      call MessageNotify( 'M', module_name, 'Weight:' )
      call MessageNotify( 'M', module_name, '  x_Lon_Weight(%d:%d) = %*f', &
        & i = (/ 0, imax - 1/), &
        & d = format_print(x_Lon_Weight, imax), n =(/ imax /), rank_mpi = -1 )
      call MessageNotify( 'M', module_name, '  y_Lat_Weight(%d:%d) = %*f', &
        & i = (/ 1, jmax/), &
        & d = format_print(y_Lat_Weight, jmax), n =(/ jmax /), rank_mpi = -1 )
      call MessageNotify( 'M', module_name, '  z_DelSigma(%d:%d) = %*f', &
        & i = (/ 1, kmax /), &
        & d = format_print(z_DelSigma, kmax), n =(/ kmax /), rank_mpi = -1 )
      call MessageNotify( 'M', module_name, '' )
    end do

    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version), rank_mpi = -1 )

    axesset_inited = .true.

  end subroutine AxessetInit

  !--------------------------------------------------------------------------------------

  subroutine AxessetFinalize
    !
    ! ⥸塼ѿγդԤޤ. 
    !
    ! Deallocate variables in this module. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ¹ʸ ; Executable statement
    !

    if ( .not. axesset_inited ) return

    ! դ
    ! Deallocation
    !
    if ( allocated( z_Sigma    ) ) deallocate( z_Sigma    )
    if ( allocated( r_Sigma    ) ) deallocate( r_Sigma    )
    if ( allocated( z_DelSigma ) ) deallocate( z_DelSigma )
    if ( allocated( r_DelSigma ) ) deallocate( r_DelSigma )
    if ( allocated( w_Number   ) ) deallocate( w_Number   )

    if ( allocated( r_SSDepth ) ) deallocate( r_SSDepth )
    if ( allocated( z_SSDepth ) ) deallocate( z_SSDepth )

    if ( allocated( x_Lon        ) ) deallocate( x_Lon        )
    if ( allocated( x_Lon_Weight ) ) deallocate( x_Lon_Weight )
    if ( allocated( y_Lat        ) ) deallocate( y_Lat        )
    if ( allocated( y_Lat_Weight ) ) deallocate( y_Lat_Weight )

    axesset_inited = .false.

  end subroutine AxessetFinalize

  !--------------------------------------------------------------------------------------

  function format_print( ary, size ) result(result)
    !
    ! ɸϤƸ䤹褦ŬͭηȤ֤. 
    !
    ! Effective digit is reduced for output to standard output and returned. 
    !

    ! ʸ ; Declaration statements
    !
    implicit none
    integer, intent(in):: size
    real(DP), intent(in):: ary(size)
    real(DP):: result(size)

    ! ¹ʸ ; Executable statement
    !
    result(1:size) = int( ary(1:size) * 1000.0_DP ) / 1000.0_DP

  end function format_print

  !--------------------------------------------------------------------------------------

end module axesset
