subroutine ave( path, varname, im, jm, lon, lat, midlon, midlat, array )

  use vtype_module
  use ni3_module
  use netcdf

  implicit none

  character(*), intent(in ) :: path
  character(*), intent(in ) :: varname
  integer(i4b), intent(in ) :: im, jm
  real(dp)    , intent(in ) :: lon   ( im   ), lat   ( jm   )
  real(dp)    , intent(in ) :: midlon( im+1 ), midlat( jm+1 )
  real(dp)    , intent(out) :: array( im, jm )


  !
  ! local variables
  !
  character(extstr)         :: mode
  integer(i4b)              :: ncid, varid, status, st( 2 ), co( 2 )

  real(dp)                  :: fillvalue

  integer(i4b)              :: nx, ny
  real(dp)    , allocatable :: x( : ), y( : )
  real(dp)    , allocatable :: z1d( : )
  integer(i4b)              :: num( im, jm )
  integer(i4b)              ::  i,  j
  integer(i4b)              :: ii, jj

  integer :: ioh
  real(dp) :: lat1
  real(dp) :: lat2
  real(dp) :: lat3
  real(dp) :: lat4
  real(dp) :: a1
  real(dp) :: a2
  real(dp) :: a3
  real(dp) :: a4
  integer(i4b) :: jjs(im)
  integer(i4b) :: jjn(im)

  real(dp) :: latedge

  integer, parameter :: MinDataNum = 5

  logical :: FlagSmallNumData


  do j = 1, jm
    do i = 1, im
      num  ( i, j ) = 0
      array( i, j ) = 0.0d0
    end do
  end do


  !
  ! read the ETOPO2 data and average in Gaussian grid bins
  !

  mode = 'read'
  call ni3_open( path, mode, ncid )

  call ni3_inq_dimlen( ncid, 'lon', nx )
  call ni3_inq_dimlen( ncid, 'lat', ny )

  allocate( x( nx ), y( ny ), z1d( nx ) )

  call ni3_get_var( ncid, 'lon', x )
  call ni3_get_var( ncid, 'lat', y )

  call ni3_get_att( ncid, varname, '_FillValue', fillvalue )

  do j = 1, ny
    if ( mod( j, ny/10 ) == 1 ) write( 6, * ) j, ny

    status = nf90_inq_varid( ncid, varname, varid )
    call ni3_handle_err( status )

    st( 1 ) = 1 ; st( 2 ) = j ; co( 1 ) = nx ; co( 2 ) = 1
    status = nf90_get_var( ncid, varid, z1d, start = st, count = co )
    call ni3_handle_err( status )

    do i = 1, nx
      if(  ( x( i ) .lt.   0.0d0 ) .or. &
        &  ( x( i ) .gt. 360.0d0 ) .or. &
        &  ( y( j ) .lt. -90.0d0 ) .or. &
        &  ( y( j ) .gt.  90.0d0 ) ) then
        write( 6, * ) 'Longitude or latitude is out of range.'
        write( 6, * ) i, j, x( i ), y( j )
      end if


      if( x( i ) .ge. midlon( im+1 ) ) then
        ii = 1
      else
        find_ii: do ii = 1, im
          if(  ( x( i ) .ge. midlon( ii   ) ) .and. &
            &  ( x( i ) .lt. midlon( ii+1 ) ) ) exit
        end do find_ii
        if( ii .gt. im ) then
          write( 6, * ) 'lon is unexpected value'
          write( 6, * ) ii, im
          write( 6, * ) i, x( i )
          stop
        end if
      end if

      find_jj: do jj = 1, jm-1
        if(  ( y( j ) .ge. midlat( jj   ) ) .and. &
          &  ( y( j ) .lt. midlat( jj+1 ) ) ) exit
      end do find_jj
      if(  ( y( j ) .ge. midlat( jm   ) ) .and. &
        &  ( y( j ) .le. midlat( jm+1 ) ) ) then
        jj = jm
      end if


      if ( dble( z1d( i ) ) /= fillvalue ) then
        array( ii, jj ) = array( ii, jj ) + dble( z1d( i ) )
        num  ( ii, jj ) = num  ( ii, jj ) + 1
      end if


    end do

  end do

  call ni3_close( ncid )


  FlagSmallNumData = .false.
  do j = 1, jm
    do i = 1, im

      if( num( i, j ) > 0 ) then
        array( i, j ) = array( i, j ) / num( i, j )
      end if

      if( num( i, j ) < MinDataNum ) then
        FlagSmallNumData = .true.
      end if

    end do
  end do

  if ( FlagSmallNumData ) then
    write( 6, * ) '*****'
    write( 6, * ) '*****'
    write( 6, * ) '*****'
    write( 6, '(a,i1,a)' ) 'Warning: There are bins that contains data less than ', MinDataNum, '.'
    write( 6, * ) '*****'
    write( 6, * ) '*****'
    write( 6, * ) '*****'
  end if

  ! interpolation
  !   search for edge
  do i = 1, im
    do j = 1, jm/2
      if( num( i, j ) >= MinDataNum ) exit
    end do
    jjs(i) = j
    do j = jm, jm/2+1, -1
      if( num( i, j ) >= MinDataNum ) exit
    end do
    jjn(i) = j
  end do
  !   check latitude
  latedge = lat(1)
  do i = 1, im
    if ( latedge < lat(jjs(i)) ) latedge = lat(jjs(i))
  end do
  write( 6, * ) 'Northern most edge latitude in southern hemisphere: ', latedge
  if ( latedge /= lat(1) ) write( 6, * ) 'Interpolation will be performed in southern hemisphere.'
  latedge = lat(jm)
  do i = 1, im
    if ( latedge > lat(jjn(i)) ) latedge = lat(jjn(i))
  end do
  write( 6, * ) 'Southern most edge latitude in northern hemisphere: ', latedge
  if ( latedge /= lat(jm) ) write( 6, * ) 'Interpolation will be performed in northern hemisphere.'
  !
  !
  do i = 1, im
    ioh = mod(i+im/2-1,im)+1
    !
    lat1 = -90.0d0 - ( lat( jjs(ioh)+1 ) - ( -90.0d0 ) )
    lat2 = -90.0d0 - ( lat( jjs(ioh)   ) - ( -90.0d0 ) )
    lat3 = lat( jjs(i)   )
    lat4 = lat( jjs(i)+1 )
    a1   = array(ioh,jjs(ioh)+1)
    a2   = array(ioh,jjs(ioh)  )
    a3   = array(i  ,jjs(i  )  )
    a4   = array(i  ,jjs(i  )+1)
    do j = 1, jjs(i)-1
      array(i,j) = &
        &   ( ( lat2 - lat(j) ) * ( lat3 - lat(j) ) * ( lat4 - lat(j) ) ) &
        & / ( ( lat2 - lat1   ) * ( lat3 - lat1   ) * ( lat4 - lat1   ) ) &
        & * a1                                                            &
        & + ( ( lat1 - lat(j) ) * ( lat3 - lat(j) ) * ( lat4 - lat(j) ) ) &
        & / ( ( lat1 - lat2   ) * ( lat3 - lat2   ) * ( lat4 - lat2   ) ) &
        & * a2                                                            &
        & + ( ( lat1 - lat(j) ) * ( lat2 - lat(j) ) * ( lat4 - lat(j) ) ) &
        & / ( ( lat1 - lat3   ) * ( lat2 - lat3   ) * ( lat4 - lat3   ) ) &
        & * a3                                                            &
        & + ( ( lat1 - lat(j) ) * ( lat2 - lat(j) ) * ( lat3 - lat(j) ) ) &
        & / ( ( lat1 - lat4   ) * ( lat2 - lat4   ) * ( lat3 - lat4   ) ) &
        & * a4
    end do
    !
    lat1 = 90.0d0 + ( 90.0d0 - lat( jjn(ioh)-1) )
    lat2 = 90.0d0 + ( 90.0d0 - lat( jjn(ioh)  ) )
    lat3 = lat( jjn(i)   )
    lat4 = lat( jjn(i)-1 )
    a1   = array(ioh,jjn(ioh)-1)
    a2   = array(ioh,jjn(ioh)  )
    a3   = array(i  ,jjn(i  )  )
    a4   = array(i  ,jjn(i  )-1)
    do j = jm, jjn(i)+1, -1
      array(i,j) = &
        &   ( ( lat2 - lat(j) ) * ( lat3 - lat(j) ) * ( lat4 - lat(j) ) ) &
        & / ( ( lat2 - lat1   ) * ( lat3 - lat1   ) * ( lat4 - lat1   ) ) &
        & * a1                                                            &
        & + ( ( lat1 - lat(j) ) * ( lat3 - lat(j) ) * ( lat4 - lat(j) ) ) &
        & / ( ( lat1 - lat2   ) * ( lat3 - lat2   ) * ( lat4 - lat2   ) ) &
        & * a2                                                            &
        & + ( ( lat1 - lat(j) ) * ( lat2 - lat(j) ) * ( lat4 - lat(j) ) ) &
        & / ( ( lat1 - lat3   ) * ( lat2 - lat3   ) * ( lat4 - lat3   ) ) &
        & * a3                                                            &
        & + ( ( lat1 - lat(j) ) * ( lat2 - lat(j) ) * ( lat3 - lat(j) ) ) &
        & / ( ( lat1 - lat4   ) * ( lat2 - lat4   ) * ( lat3 - lat4   ) ) &
        & * a4
    end do
  end do


end subroutine ave

    !--------------------------------------------------------------------------

    subroutine ave_topog( im, jm, midlon, midlat, array )

      use vtype_module
      use ni3_module
      use netcdf

      implicit none

      integer(i4b), intent(in ) :: im, jm
      real(dp)    , intent(in ) :: midlon( im+1 ), midlat( jm+1 )
      real(dp)    , intent(out) :: array( im, jm )


      !
      ! local variables
      !
      character(extstr)         :: path, mode
      integer(i4b)              :: ncid, varid, status, st( 2 ), co( 2 )

      integer(i4b)              :: nx, ny
!!$      real(dp)    , allocatable :: tmp_arr( : )
      real(dp)    , allocatable :: x( : ), y( : )
      real(dp)    , allocatable :: z1d( : )
      integer(i4b)              :: num( im, jm )
      integer(i4b)              ::  i,  j
      integer(i4b)              :: ii, jj



      do j = 1, jm
         do i = 1, im
            num  ( i, j ) = 0
            array( i, j ) = 0.0d0
         end do
      end do


      !
      ! read the ETOPO2 data and average in Gaussian grid bins
      !

!      path = '../etopo2/ETOPO2v2c_f4.nc'
!!$      path = '../etopo1/ETOPO1_Ice_c_gmt4.nc'
!!$      path = "../topog_MGS_MOLA/ncfile/topog_MGS_MOLA_0.03125x0.03125.nc"
      path = "../topog_MGS_MOLA_lowres-2013-03-06/ncfile/topog_MGS_MOLA_0.03125x0.03125.nc"
      mode = 'read'
      call ni3_open( path, mode, ncid )

!!$      call ni3_inq_dimlen( ncid, 'x', nx )
!!$      call ni3_inq_dimlen( ncid, 'y', ny )
      call ni3_inq_dimlen( ncid, 'lon', nx )
      call ni3_inq_dimlen( ncid, 'lat', ny )

      allocate( x( nx ), y( ny ), z1d( nx ) )

!!$      call ni3_get_var( ncid, 'x', x )
!!$      call ni3_get_var( ncid, 'y', y )
      call ni3_get_var( ncid, 'lon', x )
      call ni3_get_var( ncid, 'lat', y )

!!$      allocate( tmp_arr( nx ) )
!!$      do i = 1, nx
!!$         tmp_arr( i ) = x( i )
!!$      end do
!!$      do i = 1, nx/2
!!$         x( i      ) = tmp_arr( i+nx/2 )
!!$         x( i+nx/2 ) = tmp_arr( i      ) + 360.0d0
!!$      end do

      do j = 1, ny
         write( 6, * ) j, ny

         status = nf90_inq_varid( ncid, 'topog', varid )
         call ni3_handle_err( status )

         st( 1 ) = 1 ; st( 2 ) = j ; co( 1 ) = nx ; co( 2 ) = 1
!!$         status = nf90_get_var( ncid, varid, tmp_arr, start = st, count = co )
         status = nf90_get_var( ncid, varid, z1d, start = st, count = co )
         call ni3_handle_err( status )

!!$         do i = 1, nx/2
!!$            z1d( i      ) = tmp_arr( i+nx/2 )
!!$            z1d( i+nx/2 ) = tmp_arr( i      )
!!$         end do


         do i = 1, nx
            if(  ( x( i ) .lt.   0.0d0 ) .or. &
                 ( x( i ) .gt. 360.0d0 ) .or. &
                 ( y( j ) .lt. -90.0d0 ) .or. &
                 ( y( j ) .gt.  90.0d0 ) ) then
               write( 6, * ) 'Longitude or latitude is out of range.'
               write( 6, * ) i, j, x( i ), y( j )
            end if


            if( x( i ) .ge. midlon( im+1 ) ) then
               ii = 1
            else
               find_ii: do ii = 1, im
                  if(  ( x( i ) .ge. midlon( ii   ) ) .and. &
                       ( x( i ) .lt. midlon( ii+1 ) ) ) exit
               end do find_ii
               if( ii .gt. im ) then
                  write( 6, * ) 'lon is unexpected value'
                  write( 6, * ) ii, im
                  write( 6, * ) i, x( i )
                  stop
               end if
            end if

            find_jj: do jj = 1, jm-1
               if(  ( y( j ) .ge. midlat( jj   ) ) .and. &
                    ( y( j ) .lt. midlat( jj+1 ) ) ) exit
            end do find_jj
            if(  ( y( j ) .ge. midlat( jm   ) ) .and. &
                 ( y( j ) .le. midlat( jm+1 ) ) ) then
               jj = jm
            end if

!            write( 6, * ) midlon( ii ), lon, midlon( ii+1 )
!            write( 6, * ) midlat( jj ), lat, midlat( jj+1 )


            array( ii, jj ) = array( ii, jj ) + dble( z1d( i ) )
            num  ( ii, jj ) = num  ( ii, jj ) + 1


!            write( *, * ) lon, lat, itopo( i )

         end do

      end do

      call ni3_close( ncid )

      do j = 1, jm
         do i = 1, im
            if( num( i, j ) .eq. 0 ) then
               write( 6, * ) 'Error: Number of data in bin is zero.'
               write( 6, * ) i, j
               stop
            end if
            array( i, j ) = array( i, j ) / num( i, j )
         end do
      end do


    end subroutine ave_topog

    !------------------------------------------------------------------------------------

    subroutine ave_albedo( im, jm, lon, lat, midlon, midlat, array )

      use vtype_module
      use ni3_module
      use netcdf

      implicit none

      integer(i4b), intent(in ) :: im, jm
      real(dp)    , intent(in ) :: lon   ( im   ), lat   ( jm   )
      real(dp)    , intent(in ) :: midlon( im+1 ), midlat( jm+1 )
      real(dp)    , intent(out) :: array( im, jm )


      !
      ! local variables
      !
      character(extstr)         :: path, mode
      integer(i4b)              :: ncid, varid, status, st( 2 ), co( 2 )

      real(dp)                  :: fillvalue

      integer(i4b)              :: nx, ny
!!$      real(dp)    , allocatable :: tmp_arr( : )
      real(dp)    , allocatable :: x( : ), y( : )
      real(dp)    , allocatable :: z1d( : )
      integer(i4b)              :: num( im, jm )
      integer(i4b)              ::  i,  j
      integer(i4b)              :: ii, jj

      integer :: ioh
      real(dp) :: lat1
      real(dp) :: lat2
      real(dp) :: lat3
      real(dp) :: lat4
      real(dp) :: a1
      real(dp) :: a2
      real(dp) :: a3
      real(dp) :: a4
      integer(i4b) :: jjs(im)
      integer(i4b) :: jjn(im)

      real(dp) :: latedge

      integer, parameter :: MinDataNum = 5

      logical :: FlagSmallNumData


      do j = 1, jm
         do i = 1, im
            num  ( i, j ) = 0
            array( i, j ) = 0.0d0
         end do
      end do


      !
      ! read the ETOPO2 data and average in Gaussian grid bins
      !

!      path = '../etopo2/ETOPO2v2c_f4.nc'
!!$      path = '../etopo1/ETOPO1_Ice_c_gmt4.nc'
!!$      path = "../topog_MGS_MOLA_1x1/out/topog_mgs_mola_1x1.nc"
!!$      path = "../albedo_ti_consortium/out/albedo_consortium.nc"
      path = "../albedo-2_MGS_MOLA/ncfiles/albedo_MGS_TES.nc"
      mode = 'read'
      call ni3_open( path, mode, ncid )

!!$      call ni3_inq_dimlen( ncid, 'x', nx )
!!$      call ni3_inq_dimlen( ncid, 'y', ny )
      call ni3_inq_dimlen( ncid, 'lon', nx )
      call ni3_inq_dimlen( ncid, 'lat', ny )

      allocate( x( nx ), y( ny ), z1d( nx ) )

!!$      call ni3_get_var( ncid, 'x', x )
!!$      call ni3_get_var( ncid, 'y', y )
      call ni3_get_var( ncid, 'lon', x )
      call ni3_get_var( ncid, 'lat', y )

      call ni3_get_att( ncid, 'albedo', '_FillValue', fillvalue )

!!$      allocate( tmp_arr( nx ) )
!!$      do i = 1, nx
!!$         tmp_arr( i ) = x( i )
!!$      end do
!!$      do i = 1, nx/2
!!$         x( i      ) = tmp_arr( i+nx/2 )
!!$         x( i+nx/2 ) = tmp_arr( i      ) + 360.0d0
!!$      end do

      do j = 1, ny
         write( 6, * ) j, ny

         status = nf90_inq_varid( ncid, 'albedo', varid )
         call ni3_handle_err( status )

         st( 1 ) = 1 ; st( 2 ) = j ; co( 1 ) = nx ; co( 2 ) = 1
!!$         status = nf90_get_var( ncid, varid, tmp_arr, start = st, count = co )
         status = nf90_get_var( ncid, varid, z1d, start = st, count = co )
         call ni3_handle_err( status )

!!$         do i = 1, nx/2
!!$            z1d( i      ) = tmp_arr( i+nx/2 )
!!$            z1d( i+nx/2 ) = tmp_arr( i      )
!!$         end do


         do i = 1, nx
            if(  ( x( i ) .lt.   0.0d0 ) .or. &
                 ( x( i ) .gt. 360.0d0 ) .or. &
                 ( y( j ) .lt. -90.0d0 ) .or. &
                 ( y( j ) .gt.  90.0d0 ) ) then
               write( 6, * ) 'Longitude or latitude is out of range.'
               write( 6, * ) i, j, x( i ), y( j )
            end if


            if( x( i ) .ge. midlon( im+1 ) ) then
               ii = 1
            else
               find_ii: do ii = 1, im
                  if(  ( x( i ) .ge. midlon( ii   ) ) .and. &
                       ( x( i ) .lt. midlon( ii+1 ) ) ) exit
               end do find_ii
               if( ii .gt. im ) then
                  write( 6, * ) 'lon is unexpected value'
                  write( 6, * ) ii, im
                  write( 6, * ) i, x( i )
                  stop
               end if
            end if

            find_jj: do jj = 1, jm-1
               if(  ( y( j ) .ge. midlat( jj   ) ) .and. &
                    ( y( j ) .lt. midlat( jj+1 ) ) ) exit
            end do find_jj
            if(  ( y( j ) .ge. midlat( jm   ) ) .and. &
                 ( y( j ) .le. midlat( jm+1 ) ) ) then
               jj = jm
            end if

!            write( 6, * ) midlon( ii ), lon, midlon( ii+1 )
!            write( 6, * ) midlat( jj ), lat, midlat( jj+1 )


            if ( dble( z1d( i ) ) /= fillvalue ) then
              array( ii, jj ) = array( ii, jj ) + dble( z1d( i ) )
              num  ( ii, jj ) = num  ( ii, jj ) + 1
            end if


!            write( *, * ) lon, lat, itopo( i )

         end do

      end do

      call ni3_close( ncid )


      FlagSmallNumData = .false.
      do j = 1, jm
        do i = 1, im

          if( num( i, j ) == 0 ) then
!!$            write( 6, * ) 'Error: Number of data in bin is zero.'
!!$            write( 6, * ) i, j
!!$            stop
          else
            array( i, j ) = array( i, j ) / num( i, j )
          end if

          if( num( i, j ) < MinDataNum ) then
            FlagSmallNumData = .true.
          end if

        end do
      end do

      if ( FlagSmallNumData ) then
        write( 6, * ) '*****'
        write( 6, * ) '*****'
        write( 6, * ) '*****'
!!$        write( 6, * ) 'Warning: There are bins that contains no data'
!!$        write( 6, * ) 'Warning: There are bins that contains data less than 5.'
        write( 6, '(a,i1,a)' ) 'Warning: There are bins that contains data less than ', MinDataNum, '.'
        write( 6, * ) '*****'
        write( 6, * ) '*****'
        write( 6, * ) '*****'
      end if

      ! interpolation
      !   search for edge
      do i = 1, im
        do j = 1, jm/2
          if( num( i, j ) >= MinDataNum ) exit
        end do
        jjs(i) = j
        do j = jm, jm/2+1, -1
          if( num( i, j ) >= MinDataNum ) exit
        end do
        jjn(i) = j
      end do
      !   check latitude
      latedge = -90.0d0
      do i = 1, im
        if ( latedge < lat(jjs(i)) ) latedge = lat(jjs(i))
      end do
      write( 6, * ) 'Northern most edge latitude in southern hemisphere: ', latedge
      latedge =  90.0d0
      do i = 1, im
        if ( latedge > lat(jjn(i)) ) latedge = lat(jjn(i))
      end do
      write( 6, * ) 'Southern most edge latitude in northern hemisphere: ', latedge
      !
      do i = 1, im
        ioh = mod(i+im/2-1,im)+1
        !
        lat1 = -90.0d0 - ( lat( jjs(ioh)+1 ) - ( -90.0d0 ) )
        lat2 = -90.0d0 - ( lat( jjs(ioh)   ) - ( -90.0d0 ) )
        lat3 = lat( jjs(i)   )
        lat4 = lat( jjs(i)+1 )
        a1   = array(ioh,jjs(ioh)+1)
        a2   = array(ioh,jjs(ioh)  )
        a3   = array(i  ,jjs(i  )  )
        a4   = array(i  ,jjs(i  )+1)
        do j = 1, jjs(i)-1
          array(i,j) = &
            &   ( ( lat2 - lat(j) ) * ( lat3 - lat(j) ) * ( lat4 - lat(j) ) ) &
            & / ( ( lat2 - lat1   ) * ( lat3 - lat1   ) * ( lat4 - lat1   ) ) &
            & * a1                                                            &
            & + ( ( lat1 - lat(j) ) * ( lat3 - lat(j) ) * ( lat4 - lat(j) ) ) &
            & / ( ( lat1 - lat2   ) * ( lat3 - lat2   ) * ( lat4 - lat2   ) ) &
            & * a2                                                            &
            & + ( ( lat1 - lat(j) ) * ( lat2 - lat(j) ) * ( lat4 - lat(j) ) ) &
            & / ( ( lat1 - lat3   ) * ( lat2 - lat3   ) * ( lat4 - lat3   ) ) &
            & * a3                                                            &
            & + ( ( lat1 - lat(j) ) * ( lat2 - lat(j) ) * ( lat3 - lat(j) ) ) &
            & / ( ( lat1 - lat4   ) * ( lat2 - lat4   ) * ( lat3 - lat4   ) ) &
            & * a4
        end do
        !
        lat1 = 90.0d0 + ( 90.0d0 - lat( jjn(ioh)-1) )
        lat2 = 90.0d0 + ( 90.0d0 - lat( jjn(ioh)  ) )
        lat3 = lat( jjn(i)   )
        lat4 = lat( jjn(i)-1 )
        a1   = array(ioh,jjn(ioh)-1)
        a2   = array(ioh,jjn(ioh)  )
        a3   = array(i  ,jjn(i  )  )
        a4   = array(i  ,jjn(i  )-1)
        do j = jm, jjn(i)+1, -1
          array(i,j) = &
            &   ( ( lat2 - lat(j) ) * ( lat3 - lat(j) ) * ( lat4 - lat(j) ) ) &
            & / ( ( lat2 - lat1   ) * ( lat3 - lat1   ) * ( lat4 - lat1   ) ) &
            & * a1                                                            &
            & + ( ( lat1 - lat(j) ) * ( lat3 - lat(j) ) * ( lat4 - lat(j) ) ) &
            & / ( ( lat1 - lat2   ) * ( lat3 - lat2   ) * ( lat4 - lat2   ) ) &
            & * a2                                                            &
            & + ( ( lat1 - lat(j) ) * ( lat2 - lat(j) ) * ( lat4 - lat(j) ) ) &
            & / ( ( lat1 - lat3   ) * ( lat2 - lat3   ) * ( lat4 - lat3   ) ) &
            & * a3                                                            &
            & + ( ( lat1 - lat(j) ) * ( lat2 - lat(j) ) * ( lat3 - lat(j) ) ) &
            & / ( ( lat1 - lat4   ) * ( lat2 - lat4   ) * ( lat3 - lat4   ) ) &
            & * a4
        end do
      end do


    end subroutine ave_albedo

    !------------------------------------------------------------------------------------

    subroutine ave_ti( im, jm, midlon, midlat, array )

      use vtype_module
      use ni3_module
      use netcdf

      implicit none

      integer(i4b), intent(in ) :: im, jm
      real(dp)    , intent(in ) :: midlon( im+1 ), midlat( jm+1 )
      real(dp)    , intent(out) :: array( im, jm )


      !
      ! local variables
      !
      character(extstr)         :: path, mode
      integer(i4b)              :: ncid, varid, status, st( 2 ), co( 2 )

      integer(i4b)              :: nx, ny
!!$      real(dp)    , allocatable :: tmp_arr( : )
      real(dp)    , allocatable :: x( : ), y( : )
      real(dp)    , allocatable :: z1d( : )
      integer(i4b)              :: num( im, jm )
      integer(i4b)              ::  i,  j
      integer(i4b)              :: ii, jj



      do j = 1, jm
         do i = 1, im
            num  ( i, j ) = 0
            array( i, j ) = 0.0d0
         end do
      end do


      !
      ! read the ETOPO2 data and average in Gaussian grid bins
      !

!      path = '../etopo2/ETOPO2v2c_f4.nc'
!!$      path = '../etopo1/ETOPO1_Ice_c_gmt4.nc'
!!$      path = "../topog_MGS_MOLA_1x1/out/topog_mgs_mola_1x1.nc"
      path = "../albedo_ti_consortium/out/ti_consortium.nc"
      mode = 'read'
      call ni3_open( path, mode, ncid )

!!$      call ni3_inq_dimlen( ncid, 'x', nx )
!!$      call ni3_inq_dimlen( ncid, 'y', ny )
      call ni3_inq_dimlen( ncid, 'lon', nx )
      call ni3_inq_dimlen( ncid, 'lat', ny )

      allocate( x( nx ), y( ny ), z1d( nx ) )

!!$      call ni3_get_var( ncid, 'x', x )
!!$      call ni3_get_var( ncid, 'y', y )
      call ni3_get_var( ncid, 'lon', x )
      call ni3_get_var( ncid, 'lat', y )

!!$      allocate( tmp_arr( nx ) )
!!$      do i = 1, nx
!!$         tmp_arr( i ) = x( i )
!!$      end do
!!$      do i = 1, nx/2
!!$         x( i      ) = tmp_arr( i+nx/2 )
!!$         x( i+nx/2 ) = tmp_arr( i      ) + 360.0d0
!!$      end do


      do j = 1, ny
         write( 6, * ) j, ny

         status = nf90_inq_varid( ncid, 'ti', varid )
         call ni3_handle_err( status )

         st( 1 ) = 1 ; st( 2 ) = j ; co( 1 ) = nx ; co( 2 ) = 1
!!$         status = nf90_get_var( ncid, varid, tmp_arr, start = st, count = co )
         status = nf90_get_var( ncid, varid, z1d, start = st, count = co )
         call ni3_handle_err( status )


!!$         do i = 1, nx
!!$           write( 60, * ) x(i), y(j), z1d(i)
!!$         end do
!!$         write( 60, * )

!!$         do i = 1, nx/2
!!$            z1d( i      ) = tmp_arr( i+nx/2 )
!!$            z1d( i+nx/2 ) = tmp_arr( i      )
!!$         end do


         do i = 1, nx
            if(  ( x( i ) .lt.   0.0d0 ) .or. &
                 ( x( i ) .gt. 360.0d0 ) .or. &
                 ( y( j ) .lt. -90.0d0 ) .or. &
                 ( y( j ) .gt.  90.0d0 ) ) then
               write( 6, * ) 'Longitude or latitude is out of range.'
               write( 6, * ) i, j, x( i ), y( j )
            end if


            if( x( i ) .ge. midlon( im+1 ) ) then
               ii = 1
            else
               find_ii: do ii = 1, im
                  if(  ( x( i ) .ge. midlon( ii   ) ) .and. &
                       ( x( i ) .lt. midlon( ii+1 ) ) ) exit
               end do find_ii
               if( ii .gt. im ) then
                  write( 6, * ) 'lon is unexpected value'
                  write( 6, * ) ii, im
                  write( 6, * ) i, x( i )
                  stop
               end if
            end if

            find_jj: do jj = 1, jm-1
               if(  ( y( j ) .ge. midlat( jj   ) ) .and. &
                    ( y( j ) .lt. midlat( jj+1 ) ) ) exit
            end do find_jj
            if(  ( y( j ) .ge. midlat( jm   ) ) .and. &
                 ( y( j ) .le. midlat( jm+1 ) ) ) then
               jj = jm
            end if

!            write( 6, * ) midlon( ii ), lon, midlon( ii+1 )
!            write( 6, * ) midlat( jj ), lat, midlat( jj+1 )


            array( ii, jj ) = array( ii, jj ) + dble( z1d( i ) )
            num  ( ii, jj ) = num  ( ii, jj ) + 1


!            write( *, * ) lon, lat, itopo( i )

         end do

      end do

      call ni3_close( ncid )

      do j = 1, jm
         do i = 1, im
            if( num( i, j ) .eq. 0 ) then
               write( 6, * ) 'Error: Number of data in bin is zero.'
               write( 6, * ) i, j
               stop
            end if
            array( i, j ) = array( i, j ) / num( i, j )
         end do
      end do


    end subroutine ave_ti

