!= ̲٤λʬɽ
! 
!= Time integration of surface temperature, correction of flux on surface
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: intg_surftemp.f90,v 1.5 2009-03-17 05:52:03 morikawa Exp $ 
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module intg_surftemp
  !
  != ̲٤λʬɽ
  ! 
  != Time integration of surface temperature, correction of flux on surface
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ̲٤λʬ, ¤Ӥ˼ƥå׻Ĺȥեå
  ! ͤ򻻽Ф뤿, ɽͽĹȥեåʬԤޤ. 
  ! 
  ! Time integration of surface temperature, and 
  ! correction of long wave flux on surface in order to 
  ! compute estimate value of long wave flux at next time step. 
  !
  !== Procedures List
  !
  ! IntegralSurfTemp   :: ̲٤λʬɽ
  ! ---------------    :: ---------------
  ! IntegralSurfTemp   :: Time integration of surface temperature, correction of flux on surface
  !
  !--
  !== NAMELIST
  !
  ! NAMELIST#intg_surftemp_nml
  !++

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: IntegralSurfTemp

  ! ѿ
  ! Public variables
  !
  logical, save, public:: intg_surftemp_inited = .false.
                              ! ե饰. 
                              ! Initialization flag


  ! ѿ
  ! Private variables
  !

  character(*), parameter:: module_name = 'intg_surftemp'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name:  $' // &
    & '$Id: intg_surftemp.f90,v 1.5 2009-03-17 05:52:03 morikawa Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !
  interface IntegralSurfTemp
    module procedure IntegralSurfTemp
  end interface

contains

  subroutine IntegralSurfTemp( &
    & xy_DSurfTempDt, &          ! (in)
    & xy_SurfTemp &              ! (inout)
    & )
    !
    ! ̲٤λʬɽԤޤ. 
    !
    ! Time integration of surface temperature, correction of flux on surface. 
    !
    !

    ! ⥸塼 ; USE statements
    !

    ! ʬʿѤ
    ! Operation for integral and average
    !
    use intavr_operate, only: AvrLonLat_xy

    ! 
    ! Time control
    !
    use timeset, only: DelTime, &  ! $ \Delta t $
      & TimesetClockStart, TimesetClockStop

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(in):: xy_DSurfTempDt (0:imax-1, 1:jmax)
                              ! ɽ̲ѲΨ. 
                              ! Surface temperature tendency
    real(DP), intent(inout):: xy_SurfTemp (0:imax-1, 1:jmax)
                              ! ɽ̲. 
                              ! Surface temperature

    ! ѿ
    ! Work variables
    !
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction


    ! ¹ʸ ; Executable statement
    !

    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )

    ! 
    ! Initialization
    !
    if ( .not. intg_surftemp_inited ) call IntgSurfTempInit

    ! ɽ̲ٻʬ
    ! Time integration of surface temperature
    !
    xy_SurfTemp(:,:) = xy_SurfTemp(:,:) + xy_DSurfTempDt(:,:) * DelTime

    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine IntegralSurfTemp

  !-------------------------------------------------------------------

  subroutine IntgSurfTempInit
    !
    ! intg_surftemp ⥸塼νԤޤ. 
    ! NAMELIST#intg_surftemp_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "intg_surftemp" module is initialized. 
    ! "NAMELIST#intg_surftemp_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ʸ ; Declaration statements
    !
    implicit none

!!$    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
!!$                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
!!$                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
!!$    namelist /intg_surftemp_nml/
          !
          ! ǥեͤˤĤƤϽ³ "intg_surftemp#IntgSurfTempInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "intg_surftemp#IntgSurfTempInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( intg_surftemp_inited ) return
    call InitCheck

    ! ǥեͤ
    ! Default values settings
    !

!!$    ! NAMELIST ɤ߹
!!$    ! NAMELIST is input
!!$    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml, &           ! (in)
!!$        & nml = intg_surftemp_nml, &  ! (out)
!!$        & iostat = iostat_nml )   ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$    end if

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    intg_surftemp_inited = .true.
  end subroutine IntgSurfTempInit

  !-------------------------------------------------------------------

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_util_inited

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: gridset_inited

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: constants_inited

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: axesset_inited

    ! 
    ! Time control
    !
    use timeset, only: timeset_inited

    ! ¹ʸ ; Executable statement
    !

    if ( .not. namelist_util_inited ) &
      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )

    if ( .not. gridset_inited ) &
      & call MessageNotify( 'E', module_name, '"gridset" module is not initialized.' )

    if ( .not. constants_inited ) &
      & call MessageNotify( 'E', module_name, '"constants" module is not initialized.' )

    if ( .not. axesset_inited ) &
      & call MessageNotify( 'E', module_name, '"axesset" module is not initialized.' )

    if ( .not. timeset_inited ) &
      & call MessageNotify( 'E', module_name, '"timeset" module is not initialized.' )

  end subroutine InitCheck

end module intg_surftemp
