!= ͥǡեץ
!
!= dcpam main program for generation of initial data file
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: init_data.F90,v 1.7 2009-03-18 09:24:41 morikawa Exp $
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

program init_data
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ͥǡեޤ. 
  !
  ! Initial data file is created. 
  !

  ! ⥸塼 ; USE statements
  !

  ! ͥǡ (ꥹȥǡ) 
  ! Prepare initial data (restart data)
  !
  use initial_data, only: InitDataGet

  ! ꥹȥǡ
  ! Restart data input/output
  !
  use restart_file_io, only: RestartFileOutPut

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING, &  ! ʸ.       Strings. 
    &                 TOKEN      ! .   Keywords. 

#ifdef LIB_MPI
  ! MPI 饤֥
  ! MPI library
  !
  use mpi
#endif

  ! ʸ ; Declaration statements
  !
  implicit none

  ! ͽѿ (ƥå $ t-\Delta t $ , $ t $ , $ t+\Delta t $ )
  ! Prediction variables  (Step $ t-\Delta t $ , $ t $ , $ t+\Delta t $ )
  !
  real(DP), allocatable:: xyz_U (:,:,:)
                              ! $ u $ .   ®. Eastward wind
  real(DP), allocatable:: xyz_V (:,:,:)
                              ! $ v $ .   ®. Northward wind
  real(DP), allocatable:: xyz_Temp (:,:,:)
                              ! $ T $ .   . Temperature
  real(DP), allocatable:: xyz_QVap (:,:,:)
                              ! $ q $ .   漾. Specific humidity
  real(DP), allocatable:: xy_Ps (:,:)
                              ! $ p_s $ . ɽ̵. Surface pressure

  ! ѿ
  ! Work variables
  !

  ! ¹ʸ ; Executable statement
  !

  ! ץν (֥롼)
  ! Initialization for the main program (Internal subroutine)
  !
  call MainInit

  ! ͥǡκ
  ! Generate initial data
  !
  call InitDataGet( &
    & xyz_U, xyz_V, xyz_Temp, xyz_QVap, xy_Ps )  ! (out)

  ! ͥǡν
  ! Output initial data
  !
  call RestartFileOutput( &
    & xyz_U, xyz_V, xyz_Temp, xyz_QVap, xy_Ps )  ! (in)

  ! ץνλ (֥롼)
  ! Termination for the main program (Internal subroutine)
  !
  call MainTerminate

contains

  !-------------------------------------------------------------------

  subroutine MainInit
    !
    ! ץν³. 
    !
    ! Initialization procedure for the main program. 
    !

#ifdef LIB_MPI
    ! å
    ! Message output
    !
    use dc_message, only: MessageSuppressMPI
#endif
    use dc_message, only: MessageNotify

    ! ޥɥ饤
    ! Command line option parser
    !
    use option_parser, only: OptParseInit

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: NmlutilInit

    ! 
    ! Time control
    !
    use timeset, only: TimesetInit
                              ! ƥå $ t $ λ. Time of step $ t $. 

    ! ϥեδܾ
    ! Management basic information for output files
    ! 
    use fileset, only: FilesetInit

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: GridsetInit, &
      &                imax, & ! ٳʻ. 
                               ! Number of grid points in longitude
      &                jmax, & ! ٳʻ. 
                               ! Number of grid points in latitude
      &                kmax    ! ľؿ. 
                               ! Number of vertical level

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: ConstantsInit

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: AxessetInit

    ! ꥹȥǡ
    ! Restart data input/output
    !
    use restart_file_io, only: RestartFileOpen, RestartFileGet

    ! ʸ ; Declaration statements
    !
    implicit none
    character(*), parameter:: prog_name = 'init_data'
                              ! ץ̾. 
                              ! Main program name
    character(*), parameter:: version = &
      & '$Name:  $' // &
      & '$Id: init_data.F90,v 1.7 2009-03-18 09:24:41 morikawa Exp $'
                              ! ץΥС
                              ! Main program version
    character(STRING):: brief
                              ! ¹ԥեδʷ
                              ! Brief account of executable file

#ifdef LIB_MPI
    integer :: myrank_mpi, nprocs_mpi, err_mpi
                              ! MPI νκݤ˻Ѥѿ. 
                              ! Variables used for initialization of MPI. 
#endif


    ! ¹ʸ ; Executable statement
    !

#ifdef LIB_MPI
    ! MPI 
    ! Initialization of MPI
    !
    CALL MPI_Init(err_mpi)
    CALL MPI_Comm_Rank(mpi_comm_world, myrank_mpi, err_mpi)
    CALL MPI_Comm_Size(mpi_comm_world, nprocs_mpi, err_mpi)
#endif

#ifdef LIB_MPI
    ! å
    ! Message output
    !
    call MessageSuppressMPI( rank = 0 )
#endif
    brief = 'Initial data generation'
    call MessageNotify( 'M', prog_name, 'Run: %c', c1 = trim(brief) )
    call MessageNotify( 'M', prog_name, '-- version = %c', c1 = trim(version) )

    ! ޥɥ饤
    ! Command line option parser
    !
    call OptParseInit(prog_name, brief)

    ! NAMELIST ե̾
    ! Input NAMELIST file name
    !
    call NmlutilInit

    ! 
    ! Time control
    !
    call TimesetInit

    ! ϥեδܾ
    ! Management basic information for output files
    ! 
    call FilesetInit

    ! ʻ
    ! Grid points settings
    !
    call GridsetInit

    ! ʪ
    ! Physical constants settings
    !
    call ConstantsInit

    ! ɸǡ
    ! Axes data settings
    !
    call AxessetInit

    ! ͽѿγ
    ! Allocation of prediction variables
    !
    allocate( xyz_U    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_V    (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_Temp (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xyz_QVap (0:imax-1, 1:jmax, 1:kmax) )
    allocate( xy_Ps    (0:imax-1, 1:jmax) )

    ! ͥǡ
    ! Initial data output
    !
    call RestartFileOpen( flag_init_data = .true. ) ! (in) optional

  end subroutine MainInit

  !-------------------------------------------------------------------

  subroutine MainTerminate
    !
    ! ץνλ³. 
    !
    ! Termination procedure for the main program. 
    !

    ! 
    ! Time control
    !
    use timeset, only: TimesetClose

    ! ꥹȥǡ
    ! Restart data input/output
    !
    use restart_file_io, only: RestartFileClose

    ! ʸ ; Declaration statements
    !
    implicit none
#ifdef LIB_MPI
    integer :: err_mpi
                              ! MPI νλκݤ˻Ѥѿ. 
                              ! Variable used for termination of MPI. 
#endif

    ! ¹ʸ ; Executable statement
    !

    ! ꥹȥǡե륯
    ! Close restart data input
    !
    call RestartFileClose

    ! λ
    ! Termination of time control
    !
    call TimesetClose

    ! ͽѿγղ
    ! Deallocation of prediction variables
    !
    deallocate( xyz_U    )
    deallocate( xyz_V    )
    deallocate( xyz_Temp )
    deallocate( xyz_QVap )
    deallocate( xy_Ps    )

#ifdef LIB_MPI
    ! MPI λ
    ! Termination of MPI
    !
    call MPI_Finalize(err_mpi)
#endif

  end subroutine MainTerminate

end program init_data
