#ファイルをルビーで消す
require 'optparse' #オプションを受け付けるようにする

figdir = 'figs'
figfile = Dir[ File.expand_path(figdir)+"/*"] #ディレクトリ内のファイルを絶対パスで受け取る
opt = OptionParser.new #オプションを受け取る
#figsがある時は削除するかを聞く. オプション-yをつけると宣告なしで削除する

opt.on('-y') {|option|  #オプション設定
  if option then
    if File.exists?(figdir) then
      figfile.each{ |file|
        next if /^\.+$/ =~ file
        File.delete(file)}
      Dir.rmdir(figdir)
    end
  end}
opt.parse! #オプション実行

if File.exists?(figdir) then
  p "already figs existed. Do you want to remove it ? y or n"
  figrm = gets.chop #キーボード入力の認識(gets) chop は改行を認識しない
  if figrm == "y" then
    figfile.each{ |file|
      next if /^\.+$/ =~ file
      File.delete(file)}
    Dir.rmdir(figdir)
    Dir::mkdir( figdir )
  else
    p "you choose n. stop script."
    exit(3)
  end 
else
    Dir::mkdir( figdir )
end

#--------------実行文----------------------
#p 'xy'
#system( 'ruby draw_2D_xy_ctl.rb' )
#p 'zm_y'
#system( 'ruby draw_2D_zm_y_ctl.rb' )
#p '3D'
#system( 'ruby draw_3D_zm_log_ctl.rb' )
#p 'time'
#system( 'ruby draw_2D_zm_t_ctl.rb' )
p 'lt'
system( 'ruby draw_2D_lt_ctl.rb' )
