# -*- coding: iso-2022-jp -*-
require 'gphys_const_v1.1'
require 'gphys_methods_v1.4'
require 'gphys_time'
require "numru/ggraph"
include NumRu
include NMath

dir = ARGV[0]
vname = ARGV[1]
iyrs = ARGV[2].to_i
iyre = ARGV[3].to_i
ls = ARGV[4].to_i
lse = ls + 5
title = 'Ls = '+ls.to_s+'-'+lse.to_s


if vname == 'MSF'
  vnameinfile = 'V'
elsif vname == 'ANGMOM'
  vnameinfile = 'U'
else
  vnameinfile = vname
end
gphys = GPhys::IO.open( 'sagyou.nc', vnameinfile )

if ls == 0 then
  gphyszm = gphys[false,0..236].mean(0,-1)
elsif ls == 90 then
  gphyszm = gphys[false,4642..4906].mean(0,-1)
#  gphysout = gphys.cut("Ls"=>ls)
else
  gphyszm = gphys.cut("Ls"=>ls..lse).mean(0,-1)
end
  rmiss = gphys.get_att('missing_value')[0]
#if lstime == 90 then
#  gphyszm = gphysls[false,4642]
#else
#  gphyszm = gphysls.cut("Ls"=>ls)
#end
#gphyszm = dcpam_ls3d('..', iyrs, iyre, ls, gphys )

if vname=="DOD067" then
p gphyszm
end
if vname == 'MSF'
  gphyszm = calc_msf( gphyszm )
elsif vname == 'ANGMOM'
  gphyszm = calc_angmom( gphyszm )
elsif vname == 'DustDensScledOptDep'
  gphyszm = gphyszm / 2.0
  gphyszm = gphyszm * 1e4
  gphyszm.long_name = "dust density-scaled optical depth at infrared"
  gphyszm.units = "1e-4 m2 kg-1"
end

# $B%l%Y%k!u%Q%?!<%s$rM[$K;XDj(B
# $B%Q%?%s$NJ}$,(B1$B$DB?"*!^!g$^$G(B
if vname == 'Temp'
# Earth
  levels = [170,180,190,200,210,220,230,240,250,260,270,280,290,300]
# Mars
  levels = [110,120,130,140,150,160,170,180,190,200,210,220,230,240]
  patterns = [10999,15999,20999,25999,30999,35999,40999,50999,60999,65999,70999,75999,80999,90999,95999]
elsif vname == 'U'
# Earth
#  levels = [-20,-18,-16,-14,-12,-10,-8,-6,-4,-2,0,2,4,6,8,10,12,14,16,18,20]
#  patterns = [10999, 14999, 20999, 24999, 30999, 34999, 40999, 44999, 50999, 54999, 55999, 59999, 65999, 69999, 75999, 79999, 85999, 89999, 95999, 99999]
# Mars
  levels = [-160,-140,-120,-100,-80,-60,-40,-20,0,20,40,60,80,100,120,140,160]
  patterns = [10999,15999,20999,25999,30999,35999,40999,45999,50999,55999,60999,65999,70999,75999,80999,85999,90999,95999]
elsif vname == 'MSF'
# Earth
#  levels = [-20e2,-17.5e2,-15e2,-12.5e2,-10e2,-7.5e2,-5e2,-2.5e2,0,2.5e2,5e2,7.5e2,10e2,12.5e2,15e2,17.5e2,20e2]
# Mars
  levels = [-20e0,-17.5e0,-15e0,-12.5e0,-10e0,-7.5e0,-5e0,-2.5e0,0,2.5e0,5e0,7.5e0,10e0,12.5e0,15e0,17.5e0,20e0]
  levels = [-40e0,-35e0,-30e0,-25e0,-20e0,-15e0,-10e0,-5e0,0,5e0,10e0,15e0,20e0,25e0,30e0,35e0,40e0]
  patterns = [10999,15999,20999,25999,30999,35999,40999,45999,50999,55999,60999,65999,70999,75999,80999,85999,90999,95999]
  levels = [-100e0,-90e0,-80e0,-70e0,-60e0,-50e0,-40e0,-30e0,-20e0,-10e0,0,10e0,20e0,30e0,40e0,50e0,60e0,70e0,80e0,90e0,100e0]
  patterns = [10999,15999,20999,25999,30999,32999,35999,40999,42999,45999,50999,55999,60999,65999,70999,75999,80999,82999,85999,90999,92999,95999]
elsif vname == 'ANGMOM'
# Earth
#  levels = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30]
#  patterns = [10999,15999,20999,25999,30999,35999,40999,45999,50999,55999,60999,65999,70999,75999,80999,85999,90999]
# Mars
  levels = [0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15]
  patterns = [10999,15999,20999,25999,30999,35999,40999,45999,50999,55999,60999,65999,70999,75999,80999,85999,90999]
elsif vname == 'QVap'
  levels = [1e-4,2e-3,4e-3,6e-3,8e-3,10e-3,12e-3,14e-3,16e-3,18e-3,20e-3]
  patterns = [1,10999,20999,30999,40999,50999,60999,65999,70999,80999,90999,95999]
elsif vname == 'DustDensScledOptDep'
  levels = [1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17]
  patterns = [10999,15999,20999,25999,30999,35999,40999,45999,50999,55999,60999,65999,70999,75999,80999,85999,90999,95999]
elsif vname == 'Dust'
  levels = [0.0e0, 0.0001, 0.0002, 0.0003, 0.0004, 0.0005, 0.0006, 0.0007, 0.0008, 0.0009, 0.0010, 0.0011, 0.0012, 0.0013, 0.0014, 0.0015, 0.0016, 0.0017, 0.0018, 0.0019, 0.0020, 0.0021, 0.0022, 0.0023]
  patterns = [0, 10999, 14999, 18999, 22999, 26999, 30999, 34999, 38999, 42999, 46999, 50999, 54999, 58999, 62999, 66999, 70999, 74999, 78999, 82999, 86999, 90999, 94999]
  #levels = [0.0e0, 0.0001, 0.0002, 0.0003, 0.0004, 0.0005, 0.0006, 0.0007, 0.0008, 0.0009, 0.0010, 0.0011, 0.0012, 0.0013, 0.0014, 0.0015, 0.0016, 0.0017, 0.0018, 0.0019, 0.0020, 0.0021, 0.0022, 0.0023]
  #patterns = [15999, 20999, 24999, 28999, 32999, 36999, 40999, 44999, 48999, 52999, 56999, 60999, 64999, 68999, 72999, 76999, 80999, 84999, 88999, 92999, 96999, 97999, 98999]
elsif vname == 'DOD067'
elsif vname == 'Vor'
  levels = [-3.20e-4, -2.90e-4, -2.60e-4, -2.30e-4, -2.00e-4, -1.70e-4, -1.40e-4, -1.10e-4, -0.80e-4, -0.50e-4, -0.20e-4, 0.0e0, 3.0e-5, 6.0e-5, 9.0e-5, 1.20e-4, 1.50e-4, 1.80e-4, 2.10e-4, 2.30e-4, 2.60e-4, 2.90e-4, 3.20e-4, 3.50e-4, 3.80e-4]
  patterns = [10999, 14999, 18999, 22999, 26999, 30999, 34999, 38999, 42999, 46999, 50999, 54999, #0,
 55999, 59999, 63999, 67999, 71999, 75999, 79999, 83999, 87999, 91999, 95999, 97999, 99999]
end

# Color map is changed for mass stream function.
if vname == 'U'
#  DCL.sgscmn(4)  # blue-cyan-white-yellow-red
  DCL.sgscmn(14) # blue-white-red
elsif vname == 'MSF'
  DCL.sgscmn(14) # blue-white-red
elsif vname == 'Vor'
  DCL.sgscmn(67) #BlRe
end


DCL.gropn(2)
#DCL.sldiv('y',2,2)           # 2x2$B$K2hLLJ,3d(B, 'y'=yoko: $B:8>e"*1&>e"*:82<(B...
DCL.sgpset('lcntl', false)   # $B@)8fJ8;z$r2r<a$7$J$$(B
DCL.sgpset('lfull',true)     # $BA42hLLI=<((B
DCL.uzfact(0.7)             # $B:BI8<4$NJ8;zNs%5%$%:$r(B 0.75 $BG\(B
DCL.sgpset('lfprop',true)    # $B%W%m%]!<%7%g%J%k%U%)%s%H$r;H$&(B

DCL.glpset('lmiss',true)
DCL.glpset('rmiss',rmiss)
#< GGraph $B$K$h$k(B $BIA2h(B >
# Earth
#GGraph.set_fig 'itr'=>2, 'viewport'=>[0.15,0.85,0.15,0.6], 'yrev'=>'units:Pa', 'window'=>[-90,90,1e5,1e3]
# Mars
#GGraph.set_fig 'itr'=>2, 'viewport'=>[0.15,0.85,0.15,0.6], 'yrev'=>'units:Pa', 'window'=>[-90,90,1e3,1e-1]
if vname=="DOD067" then
p "time is DOD067"
end
GGraph.set_fig 'itr'=>2, 'viewport'=>[0.15,0.85,0.15,0.6], 'yrev'=>'units:Pa', 'window'=>[-90,90,1e3,1e-2]
GGraph.set_axes('yside'=>'lr','xside'=>'tb')
GGraph.set_axes('xlabelint'=>30)

GGraph.tone( gphyszm, true, 'lev'=>levels, 'pat'=>patterns, 'annotate'=>false )
#if vname == 'V' || vname =='U'
#  GGraph.contour( gphyszm, false, 'lev'=>[0], 'index'=>3, 'annotate'=>false )
#end
GGraph.contour( gphyszm, false, 'lev'=>levels, 'index'=>3, 'annotate'=>false )
GGraph.color_bar

DCL::uxmttl('T', title, -1.0)

DCL.grcls
