#!/usr/bin/env ruby
# -*- coding: utf-8 -*-
#これはTauXB.ncとTauYB.ncから|Tau|を作るスクリプトである
# 2012/10/15 荻原弘尭

#-------------宣言文-------------------
require "numru/gphys"
include NumRu
include Math

#-------------ファイル定義--------------
ufilename = "../U.nc"
vfilename = "../V.nc"
windfilename = "../SurfWind.nc"
#-------------変数定義-------------------
u = GPhys::IO.open(ufilename, 'U')
v = GPhys::IO.open(vfilename, 'V')
imax,jmax,kmax,tmax = u.shape
xy_U = u[false,0,true]
xy_V = v[false,0,true]

xy_SurfWind = NArray.float(imax,jmax,tmax)
#--------------計算----------------------
p "test"
for t in 0..tmax-1
  for j in 0..jmax-1
    for i in 0..imax-1
       xy_SurfWind[i,j,t] =
       sqrt((xy_U[i,j,t].val[0])**2.0 + xy_V[i,j,t].val[0]**2.0)
    end
  end
end

wind = u.copy
wind.replace_val(xy_SurfWind)
wind.rename("SurfWind")
wind.set_att("long_name","surface wind")
wind.set_att("units","m s-1")

#-------------ファイル出力----------------
windfile=NetCDF.create(windfilename)
GPhys::IO.write(windfile,wind)
windfile.close
