!= Held and Suarez (1994) ˤ붯Ȼ
!
!= Forcing and dissipation suggested by Held and Suarez (1994)
!
! Authors::   Yasuhiro MORIKAWA, Yoshiyuki O. TAKAHASHI
! Version::   $Id: held_suarez_1994.f90,v 1.14 2012/04/27 11:24:45 noda Exp $ 
! Tag Name::  $Name: dcpam5-20140630-2 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module held_suarez_1994
  !
  != Held and Suarez (1994) ˤ붯Ȼ
  !
  != Forcing and dissipation suggested by Held and Suarez (1994)
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! Held and Suarez (1994) Ƥ봥絤 GCM ٥ޡѤ
  ! Ȼ׻ޤ. 
  ! Ϳ붯ȻȤ, پӾоξؤδñʥ˥塼ȥѤ, 
  ! ໤ɽ벼Υ쥤꡼໤Ѥޤ. 
  ! ܺ٤ʲ˵ޤ. 
  !
  ! Forcing and dissipation for dry air GCM benchmark
  ! suggested by Held and Suarez (1994) are caluclate.
  ! We use simple Newtonian relaxation of the temperature field to a
  ! zonally symmetric state and Rayleigh damping of low-level winds to
  ! represent boundary-layer friction.
  ! Their specifications are detailed as follows.
  !
  ! \[
  !    \left( \DP{\Dvect{v}}{t} \right)_{\mathrm{HS94}} = 
  !        - k_v (\sigma) \Dvect{v}, \] \[
  !    \left( \DP{T}{t} \right)_{\mathrm{HS94}} = 
  !        - k_T (\phi, \sigma) [T - T_{eq} (\phi,p)], \] \[
  !    T_{eq} = \mathrm{max}
  !     \left\{
  !        200 \mathrm{K}, 
  !        \left[
  !          315 \mathrm{K} - (\Delta T)_y \sin^2\phi 
  !                         - (\Delta \theta)_z 
  !                           \log \left(\frac{p}{p_0}\right) \cos^2\phi
  !        \right] \left(\frac{p}{p_0}\right)^\kappa
  !     \right\}, \] \[
  !    k_T = k_a + (k_s - k_a) 
  !          \mathrm{max} 
  !          \left(0, \frac{\sigma - \sigma_b}{1 - \sigma_b}\right) \cos^4\phi,
  !     \] \[
  !    k_v = k_f
  !          \mathrm{max} 
  !          \left(0, \frac{\sigma - \sigma_b}{1 - \sigma_b}\right),
  !     \] \[
  !    \sigma_b = 0.7, \qquad 
  !    k_f = 1 \mathrm{day}^{-1}, \qquad
  !    k_a = \Dinv{40} \mathrm{day}^{-1}, \qquad
  !    k_s = \Dinv{4} \mathrm{day}^{-1}, \] \[
  !    (\Delta T)_y = 60 \mathrm{K}, \qquad
  !    (\Delta \theta)_z = 10 \mathrm{K}, \qquad
  !    p_0 = 1000 \mathrm{hPa}, \qquad
  !    \kappa = \frac{R}{c_p}.
  ! \]
  !
  ! Forcing Ǥ, Ϳ줿®٤䲹 ( $ t+\Delta t$ ) 
  ! ФưʲΤ褦˶ȻŬѤޤ.
  !
  ! By Forcing, forcing and dissipation are applied to 
  ! given wind and temperature ($ t+\Delta t$ is expected) as follows.
  !
  ! \[
  !    \hat{\Dvect{v}}^{t+\Delta t} = 
  !      \Dvect{v}^{t+\Delta t} 
  !      + 2 \Delta t \left( \DP{\Dvect{v}}{t} \right)_{\mathrm{HS94}} \] \[
  !    \hat{T}^{t+\Delta t} = 
  !      T^{t+\Delta t} 
  !      + 2 \Delta t \left( \DP{T}{t} \right)_{\mathrm{HS94}}
  ! \]
  !
  !== Procedures List
  ! 
  ! Hs94Forcing   :: Ȼη׻
  ! Hs94Finalize  :: λ (⥸塼ѿγդ)
  ! ------------  :: ------------
  ! Hs94Forcing   :: Calculate forcing and dissipation
  ! Hs94Finalize  :: Termination (deallocate variables in this module)
  !
  !--
  !== NAMELIST
  !
  ! NAMELIST#held_suarez_1994_nml
  !++
  !== References
  !
  ! * Held, I. M., Suarez, M. J., 1994: 
  !   A proposal for the intercomparison of the dynamical cores of
  !   atmospheric general circuation models.
  !   <i>Bull. Am. Meteor. Soc.</i>, <b>75</b>, 1825--1830.
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 


  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public :: HS94Forcing
  public :: HS94Init
  public :: HS94Finalize

  ! ѿ
  ! Public variables
  !

  ! ѿ
  ! Private variables
  !
  logical, save :: held_suarez_1994_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  real(DP):: Kappa            ! $ \kappa = R/C_p $ .
                              ! 갵ǮФ. Ratio of gas constant to specific heat
  real(DP):: P0               ! $ p_0 $ .
  real(DP):: DelTempY         ! $ (\Delta T)_y $ .
                              ! ˤƻβٺ
  real(DP):: DelPotTempZ      ! $ (\Delta \theta)_z $ .
                              ! ƻˤľβ̺
  real(DP), allocatable:: z_kv (:)
                              ! $ k_v $ .
  real(DP), allocatable:: yz_kt (:,:)
                              ! $ k_T $ .

  character(*), parameter:: module_name = 'held_suarez_1994'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20140630-2 $' // &
    & '$Id: held_suarez_1994.f90,v 1.14 2012/04/27 11:24:45 noda Exp $'
                              ! ⥸塼ΥС
                              ! Module version

contains

  !--------------------------------------------------------------------------------------

  subroutine HS94Forcing( &
    & xyz_U,    xyz_V,    xyz_Temp, xy_Ps, & ! (in)
    & xyz_DUDt, xyz_DVDt, xyz_DTempDt &      ! (out)
    & )
    !
    ! ȤͿ줿® xyz_U, ® xyz_V, 
    !  xyz_Temp , 
    ! پӾоξؤδñʥ˥塼ȥѤ
    ! ໤ɽ벼Υ쥤꡼໤ˤ
    ! ®Ȳ٤ѲΨ, 
    ! xyz_DUDt, xyz_DVDt, xyz_DTempDt ֤ޤ. 
    !
    ! Tendencies by simple Newtonian relaxation of the temperature field to a
    ! zonally symmetric state and Rayleigh damping of low-level winds to
    ! represent boundary-layer friction are calculated 
    ! from eastward wind "xyz_U", northward wind "xyz_V", 
    ! temperature "xyz_Temp".
    ! And the tencencies are returned as 
    ! "xyz_DUDt", "xyz_DVDt", "xyz_DTempDt". 
    !
    !

    ! ⥸塼 ; USE statements
    !

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & y_Lat, &              ! $ \varphi $ [rad.] . . Latitude
      & z_Sigma               ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime, &            ! $ \Delta t $
      & TimeN, &              ! ƥå $ t $ λ. Time of step $ t $. 
      & TimesetClockStart, TimesetClockStop

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: xyz_U (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u $ . ®. 
                              ! Eastward wind
    real(DP), intent(in):: xyz_V (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v $ . ®. 
                              ! Northward wind
    real(DP), intent(in):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ . . 
                              ! Temperature
    real(DP), intent(in):: xy_Ps (0:imax-1, 1:jmax)
                              ! $ p_s $ . ɽ̵. 
                              ! Surface pressure
    real(DP), intent(out):: xyz_DUDt (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{u}{t} $ . ®Ѳ. 
                              ! Eastward wind tendency
    real(DP), intent(out):: xyz_DVDt (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{v}{t} $ . ®Ѳ. 
                              ! Northward wind tendency
    real(DP), intent(out):: xyz_DTempDt (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \DP{T}{t} $ . Ѳ. 
                              ! Temperature tendency

    ! ѿ
    ! Work variables
    !
    real(DP):: xyz_TempEQ (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T_{eq} $ . ʿղ. 
                              ! Equilibrium temperature
    real(DP):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ . . 
                              ! Pressure

    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement
    !

    ! ǧ
    ! Initialization check
    !
    if ( .not. held_suarez_1994_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if

    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )


    ! ® $ u $ ® $ v $ إ쥤꡼໤Ŭ
    ! Apply Rayleigh damping to eastward wind $ u $ and northward wind $ v $
    !
    do k = 1, kmax
      xyz_DUDt (:,:,k) = - z_kv (k) * xyz_U (:,:,k)
      xyz_DVDt (:,:,k) = - z_kv (k) * xyz_V (:,:,k)
    end do

    !  $ T $ إ˥塼ȥѤŬ
    ! Apply Newtonian relaxation to temperature $ T $
    !
    do k = 1, kmax
       xyz_Press(:,:,k) = z_Sigma(k) * xy_Ps
    enddo

    do j = 1, jmax
      xyz_TempEQ(:,j,:) = &
        & max( 200.0_DP, &
        &      (   315.0_DP &
        &        - DelTempY * sin( y_Lat(j) ) ** 2 &
        &        - DelPotTempZ * log( xyz_Press(:,j,:) / P0 ) &
        &                                 * cos( y_Lat(j) ) ** 2 &
        &      ) &
        &      * ( xyz_Press(:,j,:) / P0 ) ** Kappa &
        &     )
    end do

    do k = 1, kmax
      do j = 1, jmax
        xyz_DTempDt (:,j,k) = &
          & - yz_kt (j,k) * ( xyz_Temp (:,j,k) - xyz_TempEQ (:,j,k) )
      end do
    end do


    ! ҥȥǡ
    ! History data output
    !
    call HistoryAutoPut( TimeN, 'DUDtHS94',    xyz_DUDt )
    call HistoryAutoPut( TimeN, 'DVDtHS94',    xyz_DVDt )
    call HistoryAutoPut( TimeN, 'DTempDtHS94', xyz_DTempDt )
    call HistoryAutoPut( TimeN, 'TempEQHS94',  xyz_TempEQ )


    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine HS94Forcing

  !--------------------------------------------------------------------------------------

  subroutine HS94Init
    !
    ! held_suarez_1994 ⥸塼νԤޤ. 
    ! NAMELIST#held_suarez_1994_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "held_suarez_1994" module is initialized. 
    ! "NAMELIST#held_suarez_1994_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & GasRDry, &
                              ! $ R $ [J kg-1 K-1]. 
                              ! 絤ε. 
                              ! Gas constant of air
      & CpDry
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & y_Lat, &              ! $ \varphi $ [rad.] . . Latitude
      & z_Sigma               ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), parameter :: day_seconds = 86400.0_DP
                              ! 1 ÿ. 
                              ! Seconds in day. 
    real(DP):: SigmaB         ! $ \sigma_b $ .
                              ! ؾüι
    real(DP):: kf             ! $ k_f $ .
                              ! ɽ̤Ǥ Rayleigh ໤δ·
    real(DP):: ka             ! $ k_a $ .
                              ! 絤ؤˤ Newton Ѥδ·
    real(DP):: ks             ! $ k_s $ .
                              ! ƻɽ̤ˤ Newton Ѥδ·

    real(DP):: kfTimeScaleInDay
    real(DP):: kaTimeScaleInDay
    real(DP):: ksTimeScaleInDay

    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /held_suarez_1994_nml/ &
      & SigmaB, &
      & kfTimeScaleInDay, &
      & kaTimeScaleInDay, &
      & ksTimeScaleInDay
          !
          ! ǥեͤˤĤƤϽ³ "held_suarez_1994#HS94Init" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "held_suarez_1994#HS94Init" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( held_suarez_1994_inited ) return


    ! ǥեͤ
    ! Default values settings
    !
    SigmaB           =  0.7_DP
    kfTimeScaleInDay =  1.0_DP
    kaTimeScaleInDay = 40.0_DP
    ksTimeScaleInDay =  4.0_DP

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &                ! (in)
        & nml = held_suarez_1994_nml, &  ! (out)
        & iostat = iostat_nml )        ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!$      if ( iostat_nml == 0 ) write( STDOUT, nml = held_suarez_1994_nml )
    end if

    ! 
    ! Configure coefficients
    !
    Kappa = GasRDry / CpDry

    P0          = 1000.0e2_DP
    DelTempY    = 60.0_DP
    DelPotTempZ = 10.0_DP

!!$    kf     = 1.0_DP / day_seconds
!!$    ka     = 1.0_DP / ( 40.0_DP * day_seconds )
!!$    ks     = 1.0_DP / (  4.0_DP * day_seconds )
    kf     = 1.0_DP / ( kfTimeScaleInDay * day_seconds )
    ka     = 1.0_DP / ( kaTimeScaleInDay * day_seconds )
    ks     = 1.0_DP / ( ksTimeScaleInDay * day_seconds )

    allocate( z_kv (1:kmax) )
    z_kv = kf * max( 0.0_DP, &
      &              ( z_Sigma - SigmaB ) / ( 1.0_DP - SigmaB ) )

    allocate( yz_kt (1:jmax, 1:kmax) )

    do k = 1, kmax
      do j = 1, jmax
        yz_kt(j,k) = &
          & ka + ( ks - ka ) &
          &  * max( 0.0_DP, &
          &         ( z_Sigma(k) - SigmaB ) / ( 1.0_DP - SigmaB ) &
          &       ) * cos( y_Lat(j) ) ** 4
      end do
    end do


    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
    call HistoryAutoAddVariable( 'DUDtHS94', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'eastward wind tendency', 'm s-2' )
    call HistoryAutoAddVariable( 'DVDtHS94', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'northward wind tendency', 'm s-2' )
    call HistoryAutoAddVariable( 'DTempDtHS94', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'temperature tendency', 'K s-1' )
    call HistoryAutoAddVariable( 'TempEQHS94', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'equilibrium temperature', 'K' )

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, 'SigmaB           = %f', d = (/ SigmaB /) )
    call MessageNotify( 'M', module_name, 'kfTimeScaleInDay = %f', d = (/ kfTimeScaleInDay /) )
    call MessageNotify( 'M', module_name, 'kaTimeScaleInDay = %f', d = (/ kaTimeScaleInDay /) )
    call MessageNotify( 'M', module_name, 'ksTimeScaleInDay = %f', d = (/ ksTimeScaleInDay /) )

    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    held_suarez_1994_inited = .true.

  end subroutine HS94Init

  !--------------------------------------------------------------------------------------

  subroutine HS94Finalize
    !
    ! ⥸塼ѿγդԤޤ. 
    !
    ! Deallocate variables in this module. 
    !

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ¹ʸ ; Executable statement
    !

    if ( .not. held_suarez_1994_inited ) return

    ! դ
    ! Deallocation
    !
    if ( allocated( z_kv  ) ) deallocate( z_kv  )
    if ( allocated( yz_kt ) ) deallocate( yz_kt )

    held_suarez_1994_inited = .false.

  end subroutine HS94Finalize

  !--------------------------------------------------------------------------------------

end module held_suarez_1994
