!c Description: 
!c   ʬ黻
!c
!c Current Code Owner: 
!c   sugiyama@gfd-dennou.org
!c
!c Histry: 
!c   Version    Date          Comment
!c   -------    ----------    --------
!c   1.0        2003-11-19    ̰ϯ 
!c
!c Copyright (C) SUGIYAMA Ko-ichiro, 2003, All rights reserved

module if_bibun2
  interface bibun2

     subroutine bibun2_2d(type, var, var_bibun2)
       integer, intent(in)               :: type
       real(8), intent(in)               :: var(:,:)
       real(8), intent(out), allocatable :: var_bibun2(:,:)
     end subroutine bibun2_2d
     
  end interface bibun2
end module if_bibun2



subroutine bibun2_2d(type, var, var_bibun2)
  !--- ⥸塼ɤ߹
  use gridset

  !--- ۤηػ
  implicit none

  !--- ѿ
  integer, intent(in)               :: type
  real(8), intent(in)               :: var(:,:)
  real(8), intent(out), allocatable :: var_bibun2(:,:)

  !--- ѿ
  allocate(var_bibun2(-bm:im+bm, -bm:km+bm))
  var_bibun2 = 0.0d0

  select case (type)

  case (221)
     var_bibun2(-bm+1:im+bm-1,-bm:km+bm) =           &
          &  (                                       &
          &             var(-bm+2:im+bm,-bm:km+bm)   &
          &   - 2.0d0 * var(-bm+1:im+bm-1,-bm:km+bm) &
          &   +         var(-bm:im+bm-2,-bm:km+bm)   &
          &  ) / dx
     
  case (222)
     var_bibun2(-bm:im+bm,-bm+1:km+bm-1) =           & 
          &  (                                       &
          &             var(-bm:im+bm,-bm+2:km+bm)   &
          &   - 2.0d0 * var(-bm:im+bm,-bm+1:km+bm-1) &
          &   +         var(-bm:im+bm,-bm:km+bm-2)   &
          &  ) / dz
     
  case (331)
     var_bibun2(-bm+1:im+bm-1,-bm:km+bm) =           &
          &  (                                       &
          &             var(-bm+2:im+bm,-bm:km+bm)   &
          &   - 2.0d0 * var(-bm+1:im+bm-1,-bm:km+bm) &
          &   +         var(-bm:im+bm-2,-bm:km+bm)   &
          &  ) / dx
     
  case (332)
     var_bibun2(-bm:im+bm,-bm+1:km+bm-1) =           & 
          &  (                                       &
          &             var(-bm:im+bm,-bm+2:km+bm)   &
          &   - 2.0d0 * var(-bm:im+bm,-bm+1:km+bm-1) &
          &   +         var(-bm:im+bm,-bm:km+bm-2)   &
          &  ) / dz
     
  end select
  
end subroutine bibun2_2d

