!c Description: 
!c   ϳإǥ deepconv/arare
!c
!c Current Code Owner: 
!c   sugiyama@gfd-dennou.org
!c
!c Copyright (C) SUGIYAMA Ko-ichiro, 2004, All rights reserved

program arare
  use gt4_history
  use gridset, only: gridset_init, DimXMin, DimXMax, DimZMin, DimZMax, NZ
  use fileset, only: fileset_init
  use timeset, only: timeset_init, NstepTShort, DelTShort
  use physprm, only: physprm_init
  use expname, only: expname_init
  use prm_tmp, only: prm_tmp_init
  use linlib,  only: linlib_init
  use if_display

  implicit none

  real(8), allocatable  :: ss_Exner_A(:,:)
  real(8), allocatable  :: fs_VelX_A(:,:)
  real(8), allocatable  :: sf_VelZ_A(:,:)
  real(8), allocatable  :: ss_Exner_B(:,:)
  real(8), allocatable  :: fs_VelX_B(:,:)
  real(8), allocatable  :: sf_VelZ_B(:,:)
  real(8), allocatable  :: fs_Fx_B(:,:)
  real(8), allocatable  :: sf_Fz_B(:,:)
  real(8), allocatable  :: ss_Div_B(:,:)
  
  real(8)               :: Time
  integer               :: t

  type(gt_history) :: ss_reg, fs_reg, sf_reg
  type(gt_history) :: ss_dim, fs_dim, sf_dim
  

!!!
!!!
!!!
  !--- I/O ե̾ν
  call fileset_init
  
  !--- ʻν
  call gridset_init
  
  !--- ʬν
  call timeset_init
  
  !--- ʪ̤ν 
  call physprm_init

  !--- ¸̾ν
  call expname_init

  !--- Ȥꤢꤷؿ
  call prm_tmp_init

  !--- ׻饤֥ν
  call linlib_init(NZ)

  !--- ϥե
  call OpenRegFile
!  call OpenDimFile

!!!
!!! CFL Υå
!!!
  call cflchk


!!!
!!!γ, 
!!!  
  call ArareAlloc
  call ArareArrayInit

  !--- 
  call ArareDisturb


!!!
!!!׻
!!!
  !--- ȤꤢĹ֥ƥåפ̵
  fs_Fx_B = 0.0d0
  sf_Fz_B = 0.0d0


  !--- ǽλ
  Time = 0.0d0
  call OutputRegFile
!  call OutputDimFile

  !--- ûॹƥåפǤʬ
  do t = 1, NstepTShort
     Time = Time + DelTShort
     write(*,*) "Time: ", Time
     
     !--- ®٤μ«
     call VelDiv(fs_VelX_B, sf_VelZ_B, ss_Div_B)
     
     !--- ® u η׻
     call VelXHeVi(ss_Exner_B, ss_Div_B, fs_Fx_B, fs_VelX_B, fs_VelX_A)
     
     !--- ʡؿη׻
     call ExnerHeVi(   &
          & ss_Div_B, sf_Fz_B, fs_VelX_A, sf_VelZ_B, ss_Exner_B, ss_Exner_A)
     
     !--- ® w η׻
     call VelZHeVi(ss_Exner_B, ss_Exner_A, ss_Div_B, sf_Fz_B, sf_VelZ_B, sf_VelZ_A)
     
     !--- 롼פ󤹤ν
     ss_Exner_B  = ss_Exner_A 
     fs_VelX_B = fs_VelX_A
     sf_VelZ_B = sf_VelZ_A
     
     !--- ե
     call OutputRegFile
 !    call OutputDimFile
     
  end do
  
  !--- ϥեΥ
  call CloseRegFile
!  call CloseDimFile
  
  
contains
  
  subroutine ArareAlloc
    allocate(ss_Exner_A(DimXMin:DimXMax, DimZMin:DimZMax),  &
         & fs_VelX_A(DimXMin:DimXMax, DimZMin:DimZMax)  , &
         & sf_VelZ_A(DimXMin:DimXMax, DimZMin:DimZMax), &
         & ss_Exner_B(DimXMin:DimXMax, DimZMin:DimZMax), &
         & fs_VelX_B(DimXMin:DimXMax, DimZMin:DimZMax), &
         & sf_VelZ_B(DimXMin:DimXMax, DimZMin:DimZMax), &
         & fs_Fx_B(DimXMin:DimXMax, DimZMin:DimZMax), &
         & sf_Fz_B(DimXMin:DimXMax, DimZMin:DimZMax), &
         & ss_Div_B(DimXMin:DimXMax, DimZMin:DimZMax) )
  end subroutine ArareAlloc


  subroutine ArareArrayInit
    use prm_tmp, only: ss_ExnerBasicZ

    ss_Exner_A = ss_ExnerBasicZ
    ss_Exner_B = ss_Exner_A

    fs_VelX_A = 0.0d0
    fs_VelX_B = 0.0d0

    sf_VelZ_A = 0.0d0
    sf_VelZ_B = 0.0d0

    fs_Fx_B = 0.0d0
    sf_Fz_B = 0.0d0

    ss_Div_B = 0.0d0

    Time = 0.0d0
  end subroutine ArareArrayInit


  subroutine ArareDisturb
    use gridset, only: s_X, s_Z, Xmin, Xmax, Zmin, Zmax, &
         & DimXMin, DimXMax, DimZMin, DimZMax
    use physprm, only: pi

    integer :: i, k
    real(8) :: mu
    real(8) :: sigma

    !--- ʡؿξ
!    mu = ( Zmax - Zmin ) * 4.0d0 / 5.0d0
!    sigma = ( Zmax - Zmin ) / 20.0d0
!    
!    do k = DimZMin, DimZMax
!       ss_Exner_A(:,k) = ss_Exner_A(:,k) &
!            & + 1000.0d0 * ss_Exner_A(:,k) &
!           & * dexp(-((s_Z(k) - mu) / sigma)**2.0d0 / 2.0d0) &
!            & / (dsqrt(2.0d0 * pi) * sigma)
!    end do

   mu = ( Xmax - Xmin ) * 4.0d0  / 5.0d0
    sigma = ( Xmax - Xmin ) / 20.0d0
    
    do i = DimXMin, DimXMax
       ss_Exner_A(i,:) = ss_Exner_A(i,:) &
            & + 1000.0d0 * ss_Exner_A(i,:) &
            & * dexp(-((s_X(i) - mu) / sigma)**2.0d0 / 2.0d0) &
           & / (dsqrt(2.0d0 * pi) * sigma)
    end do

    ss_Exner_B = ss_Exner_A

  end subroutine ArareDisturb


  !--- gtool4 ϴϢ
  subroutine OpenRegFile
    use gridset, only: RegXMin, RegXMax, RegZMin, RegZMax, &
         & NX, NZ, f_X, f_Z, s_X, s_Z
    use expname, only: exptitle, expsrc, expinst
    use fileset, only: fs_RegFile, sf_RegFile, ss_RegFile
    
    ! ҥȥ꡼
    call HistoryCreate(                                    &
         & file = fs_RegFile,                               &
         & title = exptitle,                               &
         & source = expsrc,                                &
         & institution = expinst,                          &
         & dims=(/'x','z','t'/),                           &
         & dimsizes=(/NX+1, NZ, 0/),                       &
         & longnames=(/'X-coordinate',                     &
         &             'Z-coordinate',                     &
         &             'Time        '/),                   &
         & units=(/'m','m','s'/), origin=0.0,              &
         & interval=0.0, &
         & history = fs_reg)
    
    ! ѿ
    call HistoryPut('x', f_X(RegXMin: RegXMax), fs_reg)
    call HistoryPut('z', s_Z(RegXMin+1: RegXMax), fs_reg)
    
    ! ҥȥ꡼
    call HistoryCreate(                                    &
         & file = sf_RegFile,                               &
         & title = exptitle,                               &
         & source = expsrc,                                &
         & institution = expinst,                          &
         & dims=(/'x','z','t'/),                           &
         & dimsizes=(/NX, NZ+1, 0/),                       &
         & longnames=(/'X-coordinate',                     & 
         &             'Z-coordinate',                     &
         &             'Time        '/),                   &
         & units=(/'m','m','s'/),                          &
         & origin=0.0,                                     &
         & interval=0.0,                                   &
         & history = sf_reg)
    
    ! ѿ
    call HistoryPut('x', s_X(RegXMin+1: RegXMax), sf_reg)
    call HistoryPut('z', f_Z(RegXMin: RegXMax), sf_reg)

    ! ҥȥ꡼
    call HistoryCreate(                                  &
         & file = ss_RegFile,                            &         
         & title = exptitle,                             &
         & source = expsrc,                              &
         & institution = expinst,                        &
         & dims=(/'x','z','t'/),                         &
         & dimsizes=(/NX, NZ, 0/),                       &
         & longnames=(/'X-coordinate',                   &
         &             'Z-coordinate',                   &
         &             'Time        '/),                 &
         & units=(/'m','m','s'/), origin=0.0,            &
         & interval=0.0,                                 &
         & history = ss_reg)
    
    ! ѿ
    call HistoryPut('x', s_X(RegXMin+1: RegXMax), ss_reg)
    call HistoryPut('z', s_Z(RegXMin+1: RegXMax), ss_reg)
    
    ! ̵
    call HistoryAddVariable(                             &
         & varname='Exner', dims=(/'x','z','t'/),        &
         & longname='nondimensional pressure', units='1',&
         & xtype='double',                               & 
         & history = ss_reg)    
    ! ®
    call HistoryAddVariable(                            &
         & varname='VelX', dims=(/'x','z','t'/),             &
         & longname='zonal velocity',         &
         & units='m/s', xtype='double',                & 
         & history = fs_reg)        
    ! ®
    call HistoryAddVariable(                            &
         & varname='VelZ', dims=(/'x','z','t'/),             &
         & longname='vertical velocity',         &
         & units='m/s', xtype='double',                & 
         & history = sf_reg)    
    
  end subroutine OpenRegFile


  subroutine OutputRegFile
    use gridset, only: RegXMin, RegXMax, RegZMin, RegZMax

    call HistoryPut('t', Time, ss_reg)
    call HistoryPut('t', Time, fs_reg)
    call HistoryPut('t', Time, sf_reg)

    call HistoryPut('Exner', &
         & ss_Exner_A(RegXMin+1:RegXMax, RegZMin+1:RegZMax), ss_reg)
    call HistoryPut('VelX', &
         & fs_VelX_A(RegXMin:RegXMax, RegZMin+1:RegZMax), fs_reg)
    call HistoryPut('VelZ', &
         & sf_VelZ_A(RegXMin+1:RegXMax, RegZMin:RegZMax), sf_reg)
  end subroutine OutputRegFile
  
  subroutine CloseRegFile
    call HistoryClose( ss_reg )
    call HistoryClose( fs_reg )
    call HistoryClose( sf_reg )
  end subroutine CloseRegFile


  !--- gtool4 ϴϢ
  subroutine OpenDimFile
    use gridset, only: f_X, f_Z, s_X, s_Z
    use expname, only: exptitle, expsrc, expinst
    use fileset, only: fs_DimFile, sf_DimFile, ss_DimFile
    
    integer::   N
    
    N = size(f_X, 1)

    ! ҥȥ꡼
    call HistoryCreate(                                    &
         & file = fs_DimFile,                              &
         & title = exptitle,                               &
         & source = expsrc,                                &
         & institution = expinst,                          &
         & dims=(/'x','z','t'/),                           &
         & dimsizes=(/N, N, 0/),                           &
         & longnames=(/'X-coordinate',                     &
         &             'Z-coordinate',                     &
         &             'Time        '/),                   &
         & units=(/'m','m','s'/), origin=0.0,              &
         & interval=0.0, &
         & history = fs_dim)
    
    ! ѿ
    call HistoryPut('x', f_X, fs_dim)
    call HistoryPut('z', s_Z, fs_dim)
    
    ! ҥȥ꡼
    call HistoryCreate(                                    &
         & file = sf_DimFile,                              &
         & title = exptitle,                               &
         & source = expsrc,                                &
         & institution = expinst,                          &
         & dims=(/'x','z','t'/),                           &
         & dimsizes=(/N, N, 0/),                           &
         & longnames=(/'X-coordinate',                     & 
         &             'Z-coordinate',                     &
         &             'Time        '/),                   &
         & units=(/'m','m','s'/),                          &
         & origin=0.0,                                     &
         & interval=0.0,                                   &
         & history = sf_dim)
    
    ! ѿ
    call HistoryPut('x', s_X, sf_dim)
    call HistoryPut('z', f_Z, sf_dim)

    ! ҥȥ꡼
    call HistoryCreate(                                  &
         & file = ss_DimFile,                            &
         & title = exptitle,                             &
         & source = expsrc,                              &
         & institution = expinst,                        &
         & dims=(/'x','z','t'/),                         &
         & dimsizes=(/N, N, 0/),                         &
         & longnames=(/'X-coordinate',                   &
         &             'Z-coordinate',                   &
         &             'Time        '/),                 &
         & units=(/'m','m','s'/), origin=0.0,            &
         & interval=0.0,                                 &
         & history = ss_dim)
    
    ! ѿ
    call HistoryPut('x', s_X, ss_dim)
    call HistoryPut('z', s_Z, ss_dim)
    
    ! ̵
    call HistoryAddVariable(                             &
         & varname='Exner', dims=(/'x','z','t'/),        &
         & longname='nondimensional pressure', units='1',&
         & xtype='double',                               & 
         & history = ss_dim)    
    ! ®
    call HistoryAddVariable(                            &
         & varname='VelX', dims=(/'x','z','t'/),        &
         & longname='zonal velocity',                   &
         & units='m/s', xtype='double',                 & 
         & history = fs_dim)        
    ! ®
    call HistoryAddVariable(                            &
         & varname='VelZ', dims=(/'x','z','t'/),        &
         & longname='vertical velocity',                &
         & units='m/s', xtype='double',                 & 
         & history = sf_dim)    
    
  end subroutine OpenDimFile


  subroutine OutputDimFile
    call HistoryPut('t', Time, ss_dim)
    call HistoryPut('t', Time, fs_dim)
    call HistoryPut('t', Time, sf_dim)

    call HistoryPut('Exner', ss_Exner_A, ss_dim)
    call HistoryPut('VelX', fs_VelX_A, fs_dim)
    call HistoryPut('VelZ', sf_VelZ_A, sf_dim)
  end subroutine OutputDimFile
  
  subroutine CloseDimFile
    call HistoryClose( ss_dim )
    call HistoryClose( fs_dim )
    call HistoryClose( sf_dim )
  end subroutine CloseDimFile


end program arare
