!c Description: 
!c   ʬ黻
!c
!c Current Code Owner: 
!c   sugiyama@gfd-dennou.org
!c
!c Histry: 
!c   Version    Date          Comment
!c   -------    ----------    --------
!c   1.0        2004-08-12    ̰ϯ 
!c
!c Copyright (C) SUGIYAMA Ko-ichiro, 2004, All rights reserved


module if_diff2

  interface fs_d2x_fs
     function fs_d2x_fs(var)
       use gridset
       real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
       real(8)             :: fs_d2x_fs(DimXMin:DimXMax, DimZMin:DimZMax)
     end function fs_d2x_fs
  end interface

  interface fs_d2z_fs
     function fs_d2z_fs(var) 
       use gridset
       real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
       real(8)             :: fs_d2z_fs(DimXMin:DimXMax, DimZMin:DimZMax)
     end function fs_d2z_fs
  end interface

  interface sf_d2x_sf
     function sf_d2x_sf(var) 
       use gridset
       real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
       real(8)             :: sf_d2x_sf(DimXMin:DimXMax, DimZMin:DimZMax)
     end function sf_d2x_sf
  end interface

  interface sf_d2z_sf
     function sf_d2z_sf(var) 
       use gridset
       real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
       real(8)             :: sf_d2z_sf(DimXMin:DimXMax, DimZMin:DimZMax)
     end function sf_d2z_sf
  end interface

end module if_diff2


function fs_d2x_fs(var)
  use gridset
  implicit none

  real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8)             :: fs_d2x_fs(DimXMin:DimXMax, DimZMin:DimZMax)
  
  fs_d2x_fs = 0.0d0 
  fs_d2x_fs(DimXMin+1:DimXMax-1,DimZMin:DimZMax) =           &
       &  (                                       &
       &             var(DimXMin+2:DimXMax,DimZMin:DimZMax)   &
       &   - 2.0d0 * var(DimXMin+1:DimXMax-1,DimZMin:DimZMax) &
       &   +         var(DimXMin:DimXMax-2,DimZMin:DimZMax)   &
       &  ) / DelX  
end function fs_d2x_fs


function fs_d2z_fs(var) 
  use gridset
  implicit none

  real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8)             :: fs_d2z_fs(DimXMin:DimXMax, DimZMin:DimZMax)
  
  fs_d2z_fs = 0.0d0
  fs_d2z_fs(DimXMin:DimXMax,DimZMin+1:DimZMax-1) =           & 
       &  (                                       &
       &             var(DimXMin:DimXMax,DimZMin+2:DimZMax)   &
       &   - 2.0d0 * var(DimXMin:DimXMax,DimZMin+1:DimZMax-1) &
       &   +         var(DimXMin:DimXMax,DimZMin:DimZMax-2)   &
       &  ) / DelZ
end function fs_d2z_fs


function sf_d2x_sf(var) 
  use gridset
  implicit none

  real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8)             :: sf_d2x_sf(DimXMin:DimXMax, DimZMin:DimZMax)
  
  sf_d2x_sf = 0.0d0
  sf_d2x_sf(DimXMin+1:DimXMax-1,DimZMin:DimZMax) =           &
       &  (                                       &
       &             var(DimXMin+2:DimXMax,DimZMin:DimZMax)   &
       &   - 2.0d0 * var(DimXMin+1:DimXMax-1,DimZMin:DimZMax) &
       &   +         var(DimXMin:DimXMax-2,DimZMin:DimZMax)   &
       &  ) / DelX
end function sf_d2x_sf


function sf_d2z_sf(var) 
  use gridset
  implicit none

  real(8), intent(in) :: var(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8)             :: sf_d2z_sf(DimXMin:DimXMax, DimZMin:DimZMax)
    
  sf_d2z_sf = 0.0d0 
  sf_d2z_sf(DimXMin:DimXMax,DimZMin+1:DimZMax-1) =           & 
       &  (                                       &
       &             var(DimXMin:DimXMax,DimZMin+2:DimZMax)   &
       &   - 2.0d0 * var(DimXMin:DimXMax,DimZMin+1:DimZMax-1) &
       &   +         var(DimXMin:DimXMax,DimZMin:DimZMax-2)   &
       &  ) / DelZ
end function sf_d2z_sf
