!c Description: 
!c   Ȥꤢꤹ. ŪˤϻȤʤ⥸塼
!c
!c Current Code Owner: 
!c   sugiyama@gfd-dennou.org
!c
!c Copyright (C) SUGIYAMA Ko-ichiro, 2004, All rights reserved

module prm_tmp
  implicit none 
  save

  real(8), allocatable  :: ss_DensBasicZ(:,:)  ! 絤 mol μ
  real(8), allocatable  :: ss_CpBasicZ(:,:)    ! 갵Ǯ
  real(8), allocatable  :: ss_CvBasicZ(:,:)    ! Ǯ
  real(8), allocatable  :: ss_TempBasicZ(:,:)  ! ʿѲپ
  real(8), allocatable  :: ss_PressBasicZ(:,:) ! ʿѰϾ
  real(8), allocatable  :: ss_VthetaBasicZ(:,:)! ʿѲ
  real(8), allocatable  :: ss_ExnerBasicZ(:,:) ! ʿѾΥʡؿ
  real(8), allocatable  :: ss_VelSoundBasicZ(:,:)   ! ʿѾβ® 2 
  real(8)               :: alpha

contains

  subroutine prm_tmp_init
    use gridset, only: DimXMin, DimXMax, DimZMin, DimZMax
    use physprm, only: GasR, TempRef, PressRef, MolWtWet, MolWtDry
    use if_display
    
    !--- ν
    allocate( &
         & ss_DensBasicZ(DimXMin:DimXMax, DimZMin:DimZMax), &
         & ss_CpBasicZ(DimXMin:DimXMax, DimZMin:DimZMax), &
         & ss_CvBasicZ(DimXMin:DimXMax, DimZMin:DimZMax), &
         & ss_VthetaBasicZ(DimXMin:DimXMax, DimZMin:DimZMax), &
         & ss_TempBasicZ(DimXMin:DimXMax, DimZMin:DimZMax), &
         & ss_PressBasicZ(DimXMin:DimXMax, DimZMin:DimZMax), &
         & ss_ExnerBasicZ(DimXMin:DimXMax, DimZMin:DimZMax), &
         & ss_VelSoundBasicZ(DimXMin:DimXMax, DimZMin:DimZMax) )   
    
    !--- ȸη
!    alpha = 5.0d-6 * dx * dx / dts 
    alpha = 0.0d0

    !--- Ǯ
    ss_CpBasicZ = 1.004d3    ! 갵Ǯ
    ss_CvBasicZ = 7.17d2     ! Ǯ

    !--- 
    ss_TempBasicZ = TempRef

    !--- 
    ss_PressBasicZ = PressRef
    
    !--- ʡؿʿ
    ss_ExnerBasicZ = (ss_PressBasicZ / PressRef) ** ( GasR / ss_CpBasicZ)
!    call display(ss_ExnerBasicZ, "ss_ExnerBasicZ")
    
    !--- 
    ss_VthetaBasicZ = ss_TempBasicZ * MolWtWet / ( ss_ExnerBasicZ * MolWtDry )
!    call display(ss_VthetaBasicZ, "ss_VthetaBasicZ")
    
    !--- ̩
    ss_DensBasicZ &
         & = ss_PressBasicZ * ( ss_ExnerBasicZ ** (ss_CvBasicZ / GasR)) &
         &   / ( GasR * ss_VthetaBasicZ )
!    call display(ss_DensBasicZ, "ss_DensBasicZ")
    
    !--- ʿѾβ®
    ss_VelSoundBasicZ &
         & = ss_CpBasicZ * GasR * ss_ExnerBasicZ * ss_VthetaBasicZ * MolWtDry &
         &   / ( ss_CvBasicZ * MolWtWet )
    ss_VelSoundBasicZ = sqrt( ss_VelSoundBasicZ )
!    call display(ss_VelSoundBasicZ, "ss_VelSoundBasicZ")
    
  end subroutine prm_tmp_init


end module prm_tmp
