!c Description: 
!c   HE-VI $BK!$rMQ$$$?B.EY(B u $B$N7W;;(B. $BA0?J:9J,$G7W;;(B
!c
!c Current Code Owner: 
!c   sugiyama@gfd-dennou.org
!c
!c Copyright (C) SUGIYAMA Ko-ichiro, 2004, All rights reserved

subroutine VelXHeVi(ss_Exner_B, ss_Div_B, fs_Fx_B, fs_VelX_B, fs_VelX_A)

  !--- $B%b%8%e!<%k$NFI$_9~$_(B
  use gridset, only: DimXMin, DimXMax, DimZMin, DimZMax, fs_Bc
  use timeset, only: DelTShort
  use prm_tmp, only: ss_CpBasicZ, ss_VThetaBasicZ, alpha
  use if_avr, only: fs_avr_ss
  use if_diff, only: fs_dx_ss
  use if_boundary
  
  !--- $B0EL[$N7?@k8@6X;_(B
  implicit none
  
  !--- $BF~=PNOJQ?t(B
  real(8), intent(in)      :: ss_Exner_B(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8), intent(in)      :: ss_Div_B(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8), intent(in)      :: fs_Fx_B(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8), intent(in)      :: fs_VelX_B(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8), intent(out)     :: fs_VelX_A(DimXMin:DimXMax, DimZMin:DimZMax)
  
  !--- $BB.EY(B u
  fs_VelX_A =  fs_VelX_B &
       & - fs_avr_ss( ss_CpBasicZ * ss_VThetaBasicZ ) * DelTShort  &
       &   * ( fs_dx_ss( ss_Exner_B ) &
       &       - fs_dx_ss( alpha * ss_Div_B ) )  &
       & + fs_Fx_B * DelTShort 
  
  !--- $B6-3&>r7o(B
  call boundary(fs_Bc, fs_VelX_A)
  
end subroutine VelXHeVi
