!c Description: 
!c   HE-VI $BK!$rMQ$$$?B.EY(B w $B$N7W;;(B. $B8eB`:9J,$G7W;;(B
!c
!c Current Code Owner: 
!c   sugiyama@gfd-dennou.org
!c
!c Copyright (C) SUGIYAMA Ko-ichiro, 2004, All rights reserved

subroutine VelZHeVi(ss_Exner_B, ss_Exner_A, &
     & ss_Div_B, sf_Fz_B, sf_VelZ_B, sf_VelZ_A)

  !--- $B%b%8%e!<%k$NFI$_9~$_(B
  use gridset, only: DimXMin, DimXMax, DimZMin, DimZMax, sf_Bc
  use timeset, only: DelTShort, beta
  use prm_tmp, only: ss_CpBasicZ, ss_VThetaBasicZ, alpha
  use if_avr, only: sf_avr_ss
  use if_diff, only: sf_dz_ss
  use if_boundary
  use if_display
  
  !--- $B0EL[$N7?@k8@6X;_(B
  implicit none
  
  !--- $BF~=PNOJQ?t(B
  real(8), intent(in)      :: ss_Exner_B(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8), intent(in)      :: ss_Exner_A(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8), intent(in)      :: ss_Div_B(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8), intent(in)      :: sf_Fz_B(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8), intent(in)      :: sf_VelZ_B(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8), intent(out)     :: sf_VelZ_A(DimXMin:DimXMax, DimZMin:DimZMax)
  
  !--- $BB.EY(B u
  sf_VelZ_A =  sf_VelZ_B &
       & - sf_avr_ss( ss_CpBasicZ * ss_VThetaBasicZ ) * DelTShort  &
       &   * ( beta * sf_dz_ss( ss_Exner_A ) &
       &       + (1.0d0 - beta) * sf_dz_ss( ss_Exner_B )   &
       &       - sf_dz_ss( alpha * ss_Div_B ) )  &
       & + sf_Fz_B * DelTShort 

  !--- $B6-3&>r7o(B
  call boundary(sf_Bc, sf_VelZ_A)
  
end subroutine VelZHeVi
