C*********************************************************************
C *** RAYLEIGH FRICTION TOWARD UBAR(Z) ***
C*********************************************************************
C
      SUBROUTINE CLCORI
     I   ( U, V,  ICL,
     O     DUCORI, DVCORI,
     I     FCOLI, ZGRID,
     D     NX, NZ, NXB, NZB, NROT )
C
C*********************************************************************
      IMPLICIT REAL*8 ( A-H, O-Z )
C*********************************************************************
C
      DIMENSION
     \   U ( -2:NXB, -2:NZB, NROT ),
     \   V ( -2:NXB, -2:NZB, NROT )
      DIMENSION
     \   DUCORI( -2:NXB, -2:NZB ), DVCORI( -2:NXB, -2:NZB )
      DIMENSION
     \   FCOLI ( -2:NXB ),
     \   ZGRID ( -2:NZB )
      DIMENSION UAVE( 0:1000 )
C
C====================================================================
C
      DO 100 IZ = 0, NZ-1
         UAVE(IZ) = 0.0D0
      DO 101 IX = 1, NX
         UAVE(IZ) = UAVE(IZ) + U(IX,IZ,ICL)
  101 CONTINUE
         UAVE(IZ) = UAVE(IZ) / NX
  100 CONTINUE
C
      ADMOM = 1.0D-5
C
      DO 11 IZ = 0, NZ-1
         U0 = UBAR( ZGRID(IZ) )
      DO 11 IX = 1, NX
         DUCORI(IX,IZ) = - ADMOM * ( UAVE(IZ) - U0 )
         DVCORI(IX,IZ) =   0.0D0
   11 CONTINUE
C
      CALL BOUND ( DUCORI, NX, NZ, NXB, NZB, 1, 1, 1, 1 )
      CALL BOUND ( DVCORI, NX, NZ, NXB, NZB, 1, 1, 1, 1 )
C
C===================================================================
C
      RETURN
      E N D
