C*********************************************************************
C*********************************************************************
C
      SUBROUTINE MONITW
     O   ( WATOTL, WAVAPR, WALIQD,
     M     WCVTOL, WSVAPR, WSLIQD, XQFILL,
     I     QVAP  , QCLW  , QRAI  ,
     I     ICL   , TIME  ,
     B     DENS0 , FDZ   , QVAP0 ,
     G     DX    ,
     D     NX, NZ, NXB, NZB, NROT )
C
C*********************************************************************
      IMPLICIT REAL*8 ( A-H, O-Z )
C*********************************************************************
C
      DIMENSION
     \   QVAP ( -2:NXB, -2:NZB, NROT ),
     \   QCLW ( -2:NXB, -2:NZB, NROT ),
     \   QRAI ( -2:NXB, -2:NZB, NROT )
C
      DIMENSION
     \   DENS0( -2:NZB ), QVAP0( -2:NZB ), FDZ ( -2:NZB )
C
C=====================================================================
C
      IF ( TIME .EQ. 0.0D0 ) THEN
         TIOLD = 0.0D0
         WCVTOL = 0.0D0
         WSVAPR = 0.0D0
         WSLIQD = 0.0D0
         XQFILL = 0.0D0
      END IF
C
C---------------------------------------------------------------------
C     Volume integral of water vapor.
C---------------------------------------------------------------------
C
      WAVAPR= 0.0D0
C
      DO 11 IZ = 0, NZ-1
      DO 11 IX = 1, NX
         WAVAPR = WAVAPR +
     \     FDZ(IZ) * DX**2 * DENS0(IZ) * (QVAP(IX,IZ,ICL) + QVAP0(IZ) )
   11 CONTINUE
C
C---------------------------------------------------------------------
C     Volume integral of liquid water.
C---------------------------------------------------------------------
C
      WALIQD= 0.0D0
C
      DO 21 IZ = 0, NZ-1
      DO 21 IX = 1, NX
         WALIQD = WALIQD +
     \      FDZ(IZ) * DX**2 * DENS0(IZ)
     \              * ( QCLW(IX,IZ,ICL) + QRAI(IX,IZ,ICL) )
   21 CONTINUE
C
C---------------------------------------------------------------------
C     Volume integral of Total water.
C---------------------------------------------------------------------
C
      WATOTL = WAVAPR + WALIQD
C
C---------------------------------------------------------------------
C
      WRITE(6,*) '------------- Volume integral of water mass -------'
      WRITE(6,*) 'Total water       =', WATOTL
      WRITE(6,*) 'Water Vapor       =', WAVAPR
      WRITE(6,*) 'Liquid water      =', WALIQD
C
C---------------------------------------------------------------------
C
      WRITE(6,*) '----- Volume integral of water sink/source ---------'
      WRITE(6,*) 'from T=',TIOLD,'to T=', TIME
C
      WRITE(6,*) 'Net condensation     =', WCVTOL
      WRITE(6,*) 'Surface evaporation  =', WSVAPR
      WRITE(6,*) 'Surface precipitation=', WSLIQD
      WRITE(6,*) 'Filling of negative Q ', XQFILL
C
C---------------------------------------------------------------------
C
      TIOLD = TIME
C
      WCVTOL = 0.0D0
      WSVAPR = 0.0D0
      WSLIQD = 0.0D0
      XQFILL = 0.0D0
C
C=====================================================================
C
      RETURN
      END
