--- src/cgesdd.f	Thu Dec  5 19:51:33 2002
+++ debian/updates/src/cgesdd.f	Wed Dec  4 15:23:42 2002
@@ -1,10 +1,11 @@
-      SUBROUTINE CGESDD( JOBZ, M, N, A, LDA, S, U, LDU, VT, LDVT, WORK,
-     $                   LWORK, RWORK, IWORK, INFO )
+      SUBROUTINE CGESDD( JOBZ, M, N, A, LDA, S, U, LDU, VT, LDVT,
+     $                   WORK, LWORK, RWORK, IWORK, INFO )
 *
 *  -- LAPACK driver routine (version 3.0) --
 *     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
 *     Courant Institute, Argonne National Lab, and Rice University
-*     October 31, 1999
+*     June 30, 1999
+*     8-15-00:  Improve consistency of WS calculations (eca)
 *
 *     .. Scalar Arguments ..
       CHARACTER          JOBZ
@@ -119,12 +120,14 @@
 *          if JOBZ = 'S' or 'A',
 *                LWORK >= min(M,N)*min(M,N)+2*min(M,N)+max(M,N).
 *          For good performance, LWORK should generally be larger.
-*          If LWORK < 0 but other input arguments are legal, WORK(1)
-*          returns the optimal LWORK.
+*
+*          If LWORK = -1, a workspace query is assumed.  The optimal
+*          size for the WORK array is calculated and stored in WORK(1),
+*          and no other work except argument checking is performed.
 *
 *  RWORK   (workspace) REAL array, dimension (LRWORK)
-*          If JOBZ = 'N', LRWORK >= 7*min(M,N).
-*          Otherwise, LRWORK >= 5*min(M,N)*min(M,N) + 5*min(M,N)
+*          If JOBZ = 'N', LRWORK >= 5*min(M,N).
+*          Otherwise, LRWORK >= 5*min(M,N)*min(M,N) + 7*min(M,N)
 *
 *  IWORK   (workspace) INTEGER array, dimension (8*min(M,N))
 *
@@ -143,14 +146,16 @@
 *  =====================================================================
 *
 *     .. Parameters ..
+      INTEGER            LQUERV
+      PARAMETER          ( LQUERV = -1 )
       COMPLEX            CZERO, CONE
-      PARAMETER          ( CZERO = ( 0.0E0, 0.0E0 ),
-     $                   CONE = ( 1.0E0, 0.0E0 ) )
+      PARAMETER          ( CZERO = ( 0.0E+0, 0.0E+0 ),
+     $                   CONE = ( 1.0E+0, 0.0E+0 ) )
       REAL               ZERO, ONE
-      PARAMETER          ( ZERO = 0.0E0, ONE = 1.0E0 )
+      PARAMETER          ( ZERO = 0.0E+0, ONE = 1.0E+0 )
 *     ..
 *     .. Local Scalars ..
-      LOGICAL            LQUERY, WNTQA, WNTQAS, WNTQN, WNTQO, WNTQS
+      LOGICAL            WNTQA, WNTQAS, WNTQN, WNTQO, WNTQS
       INTEGER            BLK, CHUNK, I, IE, IERR, IL, IR, IRU, IRVT,
      $                   ISCL, ITAU, ITAUP, ITAUQ, IU, IVT, LDWKVT,
      $                   LDWRKL, LDWRKR, LDWRKU, MAXWRK, MINMN, MINWRK,
@@ -162,15 +167,17 @@
       REAL               DUM( 1 )
 *     ..
 *     .. External Subroutines ..
-      EXTERNAL           CGEBRD, CGELQF, CGEMM, CGEQRF, CLACP2, CLACPY, 
-     $                   CLACRM, CLARCM, CLASCL, CLASET, CUNGBR, CUNGLQ, 
-     $                   CUNGQR, CUNMBR, SBDSDC, SLASCL, XERBLA
+      EXTERNAL           CGEBRD, CGELQF, CGEMM, CGEQRF,
+     $                   CLACP2, CLACPY, CLACRM, CLARCM,
+     $                   CLASCL, CLASET, CUNGBR, CUNGLQ,
+     $                   CUNGQR, CUNMBR, SBDSDC, SLASCL,
+     $                   XERBLA
 *     ..
 *     .. External Functions ..
       LOGICAL            LSAME
       INTEGER            ILAENV
       REAL               CLANGE, SLAMCH
-      EXTERNAL           CLANGE, ILAENV, LSAME, SLAMCH
+      EXTERNAL           CLANGE, SLAMCH, ILAENV, LSAME
 *     ..
 *     .. Intrinsic Functions ..
       INTRINSIC          INT, MAX, MIN, SQRT
@@ -181,8 +188,8 @@
 *
       INFO = 0
       MINMN = MIN( M, N )
-      MNTHR1 = INT( MINMN*17.0E0 / 9.0E0 )
-      MNTHR2 = INT( MINMN*5.0E0 / 3.0E0 )
+      MNTHR1 = INT( MINMN*17.0 / 9.0 )
+      MNTHR2 = INT( MINMN*5.0 / 3.0 )
       WNTQA = LSAME( JOBZ, 'A' )
       WNTQS = LSAME( JOBZ, 'S' )
       WNTQAS = WNTQA .OR. WNTQS
@@ -190,7 +197,6 @@
       WNTQN = LSAME( JOBZ, 'N' )
       MINWRK = 1
       MAXWRK = 1
-      LQUERY = ( LWORK.EQ.-1 )
 *
       IF( .NOT.( WNTQA .OR. WNTQS .OR. WNTQO .OR. WNTQN ) ) THEN
          INFO = -1
@@ -221,19 +227,21 @@
          IF( M.GE.N ) THEN
 *
 *           There is no complex work space needed for bidiagonal SVD
-*           The real work space needed for bidiagonal SVD is BDSPAC,
-*           BDSPAC = 3*N*N + 4*N
+*           The real work space needed for bidiagonal SVD is BDSPAC
+*           for computing singular values and singular vectors; BDSPAN
+*           for computing singular values only.
+*           BDSPAC = 5*N*N + 7*N
+*           BDSPAN = MAX(7*N+4, 3*N+2+SMLSIZ*(SMLSIZ+8))
 *
             IF( M.GE.MNTHR1 ) THEN
                IF( WNTQN ) THEN
 *
 *                 Path 1 (M much larger than N, JOBZ='N')
 *
-                  WRKBL = N + N*ILAENV( 1, 'CGEQRF', ' ', M, N, -1,
-     $                    -1 )
-                  WRKBL = MAX( WRKBL, 2*N+2*N*
-     $                    ILAENV( 1, 'CGEBRD', ' ', N, N, -1, -1 ) )
-                  MAXWRK = WRKBL
+                  MAXWRK = N + N*ILAENV( 1, 'CGEQRF', ' ', M, N, -1,
+     $                     -1 )
+                  MAXWRK = MAX( MAXWRK, 2*N+2*N*
+     $                     ILAENV( 1, 'CGEBRD', ' ', N, N, -1, -1 ) )
                   MINWRK = 3*N
                ELSE IF( WNTQO ) THEN
 *
@@ -335,8 +343,11 @@
          ELSE
 *
 *           There is no complex work space needed for bidiagonal SVD
-*           The real work space needed for bidiagonal SVD is BDSPAC,
-*           BDSPAC = 3*M*M + 4*M
+*           The real work space needed for bidiagonal SVD is BDSPAC
+*           for computing singular values and singular vectors; BDSPAN
+*           for computing singular values only.
+*           BDSPAC = 5*M*M + 7*M
+*           BDSPAN = MAX(7*M+4, 3*M+2+SMLSIZ*(SMLSIZ+8))
 *
             IF( N.GE.MNTHR1 ) THEN
                IF( WNTQN ) THEN
@@ -447,24 +458,21 @@
             END IF
          END IF
          MAXWRK = MAX( MAXWRK, MINWRK )
+      END IF
+      IF( INFO.EQ.0 ) THEN
          WORK( 1 ) = MAXWRK
+         IF( LWORK.LT.MINWRK .AND. LWORK.NE.LQUERV )
+     $      INFO = -13
       END IF
 *
-      IF( LWORK.LT.MINWRK .AND. .NOT.LQUERY ) THEN
-         INFO = -13
-      END IF
+*     Quick returns
+*
       IF( INFO.NE.0 ) THEN
          CALL XERBLA( 'CGESDD', -INFO )
          RETURN
-      ELSE IF( LQUERY ) THEN
-         RETURN
       END IF
-*
-*     Quick return if possible
-*
+      IF( LWORK.EQ.LQUERV ) RETURN
       IF( M.EQ.0 .OR. N.EQ.0 ) THEN
-         IF( LWORK.GE.1 )
-     $      WORK( 1 ) = ONE
          RETURN
       END IF
 *
@@ -529,7 +537,7 @@
 *
 *              Perform bidiagonal SVD, compute singular values only
 *              (CWorkspace: 0)
-*              (RWorkspace: need BDSPAC)
+*              (RWorkspace: need BDSPAN)
 *
                CALL SBDSDC( 'U', 'N', N, S, RWORK( IE ), DUM, 1, DUM, 1,
      $                      DUM, IDUM, RWORK( NRWORK ), IWORK, INFO )
@@ -844,7 +852,7 @@
 *
 *              Compute singular values only
 *              (Cworkspace: 0)
-*              (Rworkspace: need BDSPAC)
+*              (Rworkspace: need BDSPAN)
 *
                CALL SBDSDC( 'U', 'N', N, S, RWORK( IE ), DUM, 1, DUM, 1,
      $                      DUM, IDUM, RWORK( NRWORK ), IWORK, INFO )
@@ -1040,7 +1048,7 @@
 *
 *              Compute singular values only
 *              (Cworkspace: 0)
-*              (Rworkspace: need BDSPAC)
+*              (Rworkspace: need BDSPAN)
 *
                CALL SBDSDC( 'U', 'N', N, S, RWORK( IE ), DUM, 1, DUM, 1,
      $                      DUM, IDUM, RWORK( NRWORK ), IWORK, INFO )
@@ -1205,8 +1213,8 @@
       ELSE
 *
 *        A has more columns than rows. If A has sufficiently more
-*        columns than rows, first reduce using the LQ decomposition
-*        (if sufficient workspace available)
+*        columns than rows, first reduce using the LQ decomposition (if
+*        sufficient workspace available)
 *
          IF( N.GE.MNTHR1 ) THEN
 *
@@ -1245,7 +1253,7 @@
 *
 *              Perform bidiagonal SVD, compute singular values only
 *              (CWorkspace: 0)
-*              (RWorkspace: need BDSPAC)
+*              (RWorkspace: need BDSPAN)
 *
                CALL SBDSDC( 'U', 'N', M, S, RWORK( IE ), DUM, 1, DUM, 1,
      $                      DUM, IDUM, RWORK( NRWORK ), IWORK, INFO )
@@ -1531,8 +1539,8 @@
 *              (CWorkspace: need M*M)
 *              (RWorkspace: 0)
 *
-               CALL CGEMM( 'N', 'N', M, N, M, CONE, WORK( IVT ), LDWKVT,
-     $                     VT, LDVT, CZERO, A, LDA )
+               CALL CGEMM( 'N', 'N', M, N, M, CONE, WORK( IVT ),
+     $                     LDWKVT, VT, LDVT, CZERO, A, LDA )
 *
 *              Copy right singular vectors of A from A to VT
 *
@@ -1567,7 +1575,7 @@
 *
 *              Compute singular values only
 *              (Cworkspace: 0)
-*              (Rworkspace: need BDSPAC)
+*              (Rworkspace: need BDSPAN)
 *
                CALL SBDSDC( 'L', 'N', M, S, RWORK( IE ), DUM, 1, DUM, 1,
      $                      DUM, IDUM, RWORK( NRWORK ), IWORK, INFO )
@@ -1763,7 +1771,7 @@
 *
 *              Compute singular values only
 *              (Cworkspace: 0)
-*              (Rworkspace: need BDSPAC)
+*              (Rworkspace: need BDSPAN)
 *
                CALL SBDSDC( 'L', 'N', M, S, RWORK( IE ), DUM, 1, DUM, 1,
      $                      DUM, IDUM, RWORK( NRWORK ), IWORK, INFO )
@@ -1934,9 +1942,15 @@
          IF( ANRM.GT.BIGNUM )
      $      CALL SLASCL( 'G', 0, 0, BIGNUM, ANRM, MINMN, 1, S, MINMN,
      $                   IERR )
+         IF( INFO.NE.0 .AND. ANRM.GT.BIGNUM )
+     $      CALL SLASCL( 'G', 0, 0, BIGNUM, ANRM, MINMN-1, 1,
+     $                   RWORK( IE ), MINMN, IERR )
          IF( ANRM.LT.SMLNUM )
      $      CALL SLASCL( 'G', 0, 0, SMLNUM, ANRM, MINMN, 1, S, MINMN,
      $                   IERR )
+         IF( INFO.NE.0 .AND. ANRM.LT.SMLNUM )
+     $      CALL SLASCL( 'G', 0, 0, SMLNUM, ANRM, MINMN-1, 1,
+     $                   RWORK( IE ), MINMN, IERR )
       END IF
 *
 *     Return optimal workspace in WORK(1)
