--- src/dgees.f	Thu Dec  5 19:51:35 2002
+++ debian/updates/src/dgees.f	Wed Dec  4 15:23:42 2002
@@ -5,6 +5,7 @@
 *     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
 *     Courant Institute, Argonne National Lab, and Rice University
 *     June 30, 1999
+*     8-15-00:  Improve consistency of WS calculations (eca)
 *
 *     .. Scalar Arguments ..
       CHARACTER          JOBVS, SORT
@@ -110,10 +111,9 @@
 *          The dimension of the array WORK.  LWORK >= max(1,3*N).
 *          For good performance, LWORK must generally be larger.
 *
-*          If LWORK = -1, then a workspace query is assumed; the routine
-*          only calculates the optimal size of the WORK array, returns
-*          this value as the first entry of the WORK array, and no error
-*          message related to LWORK is issued by XERBLA.
+*          If LWORK = -1, a workspace query is assumed.  The optimal
+*          size for the WORK array is calculated and stored in WORK(1),
+*          and no other work except argument checking is performed.
 *
 *  BWORK   (workspace) LOGICAL array, dimension (N)
 *          Not referenced if SORT = 'N'.
@@ -138,12 +138,13 @@
 *  =====================================================================
 *
 *     .. Parameters ..
+      INTEGER            LQUERV
+      PARAMETER          ( LQUERV = -1 )
       DOUBLE PRECISION   ZERO, ONE
       PARAMETER          ( ZERO = 0.0D0, ONE = 1.0D0 )
 *     ..
 *     .. Local Scalars ..
-      LOGICAL            CURSL, LASTSL, LQUERY, LST2SL, SCALEA, WANTST,
-     $                   WANTVS
+      LOGICAL            CURSL, LASTSL, LST2SL, SCALEA, WANTST, WANTVS
       INTEGER            HSWORK, I, I1, I2, IBAL, ICOND, IERR, IEVAL,
      $                   IHI, ILO, INXT, IP, ITAU, IWRK, K, MAXB,
      $                   MAXWRK, MINWRK
@@ -154,8 +155,8 @@
       DOUBLE PRECISION   DUM( 1 )
 *     ..
 *     .. External Subroutines ..
-      EXTERNAL           DCOPY, DGEBAK, DGEBAL, DGEHRD, DHSEQR, DLACPY,
-     $                   DLASCL, DORGHR, DSWAP, DTRSEN, XERBLA
+      EXTERNAL           DCOPY, DGEBAK, DGEBAL, DGEHRD, DHSEQR, DLABAD,
+     $                   DLACPY, DLASCL, DORGHR, DSWAP, DTRSEN, XERBLA
 *     ..
 *     .. External Functions ..
       LOGICAL            LSAME
@@ -171,7 +172,6 @@
 *     Test the input arguments
 *
       INFO = 0
-      LQUERY = ( LWORK.EQ.-1 )
       WANTVS = LSAME( JOBVS, 'V' )
       WANTST = LSAME( SORT, 'S' )
       IF( ( .NOT.WANTVS ) .AND. ( .NOT.LSAME( JOBVS, 'N' ) ) ) THEN
@@ -197,7 +197,7 @@
 *       the worst case.)
 *
       MINWRK = 1
-      IF( INFO.EQ.0 .AND. ( LWORK.GE.1 .OR. LQUERY ) ) THEN
+      IF( INFO.EQ.0 ) THEN
          MAXWRK = 2*N + N*ILAENV( 1, 'DGEHRD', ' ', N, 1, N, 0 )
          MINWRK = MAX( 1, 3*N )
          IF( .NOT.WANTVS ) THEN
@@ -216,19 +216,18 @@
             MAXWRK = MAX( MAXWRK, N+HSWORK, 1 )
          END IF
          WORK( 1 ) = MAXWRK
+         IF( LWORK.LT.MINWRK .AND. LWORK.NE.LQUERV )
+     $      INFO = -13
       END IF
-      IF( LWORK.LT.MINWRK .AND. .NOT.LQUERY ) THEN
-         INFO = -13
-      END IF
+*
+*     Quick returns
+*
       IF( INFO.NE.0 ) THEN
          CALL XERBLA( 'DGEES ', -INFO )
          RETURN
-      ELSE IF( LQUERY ) THEN
-         RETURN
       END IF
-*
-*     Quick return if possible
-*
+      IF( LWORK.EQ.LQUERV )
+     $   RETURN
       IF( N.EQ.0 ) THEN
          SDIM = 0
          RETURN
