!= Module ECCM
!
! Authors::   SUGIYAMA Koichiro, ODAKA Masatsugu
! Version::   $Id: eccm.f90,v 1.5 2011-06-03 06:11:22 sugiyama Exp $
! Tag Name::  $Name: arare5-20120511 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!ǮŪ˾徺뵤βٸΨ׻, ſ尵ʿդ鰵Ϥ
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!  * Ǯ, ʿʬ̤
!  * 顼٤­ʤΤ, 󥲥å. 
!
!== Future Plans
!

module ECCM

  !⥸塼ɤ߹
  use dc_types, only : DP
  use dc_trace, only : DbgMessage
  use dc_message, only: MessageNotify

  use gridset,only: kmin,       &!  Z β
    &                 kmax,       &!  Z ξ 
    &                 ncmax
  use axesset, only:  z_dz, r_dz      !
  use constants,only: MolWtDry,      &!
    &                 CpDryMol,      &!
    &                 TempSfc,       &!
    &                 PressSfc,      &!
    &                 Grav            !
  use chemcalc, only: SvapPress,        &!
    &                 LatentHeatPerMol, &!
    &                 ReactHeatNH4SHPerMol, &
    &                 DelMolFrNH4SH 
  use composition, only: CondNum,          &!ŷο
    &                 SpcWetID,         &!
    &                 IdxCG,            &!ŷ()ź
    &                 IdxCC,            &!ŷ()ź
    &                 GasNum,           &!Το
    &                 IdxNH3,           &!NH3()ź
    &                 IdxH2S             !H2S()ź
  use ChemData, only: GasRUniv        

  !ۤηػ
  implicit none

  !°λ
  private

  !ؿθ
  public ECCM_MolFr
  public ECCM_Stab
  public ECCM_Dry
  public ECCM_Wet

contains

!!!------------------------------------------------------------------------------!!!
  subroutine ECCM_Dry( a_MolFrIni, Humidity, z_Temp, z_Press, za_MolFr )
    !
    !== 
    !  * ǮٸΨ˱ä١ϤᡢФƻꤵ줿м٤Ȥʤ褦˶ŷʬΥ
    !  * Ǯϴ絤ΤΤɽ
    !    * ήΤˤǮϴʬΤΤɽƤ뤿
    !  * 絤ʿʬ̤ˤϼʬʬ̤
    !    * ήΤˤ, ʬʬ̤ϹθƤ뤿
    !
    
    !ۤηػ
    implicit none
    
    real(DP), intent(in) :: a_MolFrIni(1:ncmax)    !ǤΥ
    real(DP), intent(in) :: Humidity                !м ( Humidity <= 1.0 )
    real(DP), intent(out):: z_Temp(kmin:kmax) !
    real(DP), intent(out):: z_Press(kmin:kmax)!
    real(DP), intent(out):: za_MolFr(kmin:kmax, 1:ncmax) 
                                                   !ʬΨ
    real(DP)             :: SatPress                !˰¾
    real(DP)             :: VapPress                !
    real(DP)             :: DelMolFr
    integer             :: k, s

    !-------------------------------------------------------------
    ! ν
    !-------------------------------------------------------------
    !ɽ̤ʬ̤
    za_MolFr  = 1.0d-60
    za_MolFr(1, 1:ncmax) = a_MolFrIni(1:ncmax) 

    !ɽ̤Ǥβ(nx ,  DelZ / 2 )
    z_Temp    = 1.0d-60
    z_Temp(1) = TempSfc - Grav * MolWtDry &
      &               / CpDryMol * ( z_dz(1) * 5.0d-1 )

!    write(*,*) z_Temp(1)
    
    !ɽ̤Ǥΰ(1 ,  DelZ / 2 )
    z_Press    = 1.0d-60
    z_Press(1) = PressSfc *((TempSfc / z_Temp(1)) ** (- CpDryMol /  GasRUniv))

!    write(*,*) z_Press(1)
    
    !-----------------------------------------------------------
    ! (1) Ǯ˱ä٤
    ! (2) ſ尵ʿդ鰵Ϥ
    ! (3) (1),(2) βٰϤФ, Ȥм٤Ȥʤ
    !-----------------------------------------------------------    
    DtDz: do k = 1, kmax-1

      !(1)Ǯ˱ä k+1 Ǥβ٤׻
      z_Temp(k+1) = z_Temp(k) - Grav * MolWtDry / CpDryMol * r_dz(k)
      
      !ǰ
      if (z_Temp(k+1) <= 0.0d0 ) z_Temp(k+1) = z_Temp(k) 
      
      !(2)Ϥſ尵ʿդ׻
      z_Press(k+1) =                                                  &
        &  z_Press(k) * ((z_Temp(k) / z_Temp(k+1)) ** (- CpDryMol / GasRUniv)) 

      !(3)η׻
      !  ޤϥѲʤΤȤƥͿ
      !  ˰¾ʿȤʿվŬѤƤ
      za_MolFr(k+1,:) = za_MolFr(k,:)
      
      do s = 1, CondNum      
        !˰¾
        SatPress = SvapPress( SpcWetID(IdxCC(s)), z_Temp(k+1) )        
        
        !ΥʬΨѤƸߤξ׻
        VapPress = za_MolFr(k,IdxCG(s)) * z_Press(k+1)
        
        !˰¾ȰϤ鸽ߤΥ׻
        if ( VapPress > SatPress ) then         
          za_MolFr(k+1,IdxCG(s)) = max(SatPress * Humidity / z_Press(k+1), 1.0d-16)
        end if
      end do
      
      !NH4SH ʿվ
      if ( IdxNH3 /= 0 ) then 
        DelMolFr =                                              &
          & max (                                               &
          &    DelMolFrNH4SH(                                   &
          &         z_Temp(k+1), z_Press(k+1),                  &
          &         za_MolFr(k+1,IdxNH3), za_MolFr(k+1,IdxH2S), &
          &         Humidity                                    &
          &      ),                                             &
          &    0.0d0                                            &
          &  )
        za_MolFr(k+1,IdxNH3) = za_MolFr(k+1,IdxNH3) - DelMolFr
        za_MolFr(k+1,IdxH2S) = za_MolFr(k+1,IdxH2S) - DelMolFr
      end if
      
    end do DtDz
    
  end subroutine ECCM_Dry


!!------------------------------------------------------------------------------!!!
  subroutine ECCM_Wet( a_MolFrIni, Humidity, z_Temp, z_Press, za_MolFr )
    !
    !== 
    !  * ǮٸΨ˱ä١ϤᡢФƻꤵ줿м٤Ȥʤ褦˶ŷʬΥ
    !  * Ǯϴ絤ΤΤɽ
    !    * ήΤˤǮϴʬΤΤɽƤ뤿
    !  * 絤ʿʬ̤ˤϼʬʬ̤
    !    * ήΤˤ, ʬʬ̤ϹθƤ뤿
    !
    
    !ۤηػ
    implicit none
    
    real(DP), intent(in) :: a_MolFrIni(1:ncmax)    !ǤΥ
    real(DP), intent(in) :: Humidity                !м ( Humidity <= 1.0 )
    real(DP), intent(out):: z_Temp(kmin:kmax) !
    real(DP), intent(out):: z_Press(kmin:kmax)!
                                                   !ʿʬ
    real(DP), intent(out):: za_MolFr(kmin:kmax, 1:ncmax) 
                                                   !ʬΨ
    real(DP)             :: SatPress                !˰¾
    real(DP)             :: VapPress                !
    real(DP)             :: DelMolFr
    real(DP)             :: a_MolFr(ncmax)         !κ
    integer             :: k, s

    real(DP)             :: Temp1, Press1, DTempDZ1
    real(DP)             :: Temp2, Press2, DTempDZ2
    real(DP)             :: Temp3, Press3, DTempDZ3
    real(DP)             :: Temp4, Press4, DTempDZ4
    real(DP)             :: DTempDZ
    
    !-------------------------------------------------------------
    ! ν
    !-------------------------------------------------------------
    !ɽ̤ʬ̤
    za_MolFr  = 1.0d-60
    za_MolFr(1, 1:ncmax)   = a_MolFrIni(1:ncmax) 
    
    !ɽ̤Ǥβ(1 ,  DelZ / 2 )
    z_Temp          = 1.0d-60
    z_Temp(1) = TempSfc - Grav * MolWtDry  &
      &               / CpDryMol * ( z_dz(1) * 5.0d-1 )
    
    !ɽ̤Ǥΰ(1 ,  DelZ / 2 )
    z_Press           = 1.0d-60
    z_Press(1)  = &
      & PressSfc *((TempSfc / z_Temp(1)) ** (- CpDryMol /  GasRUniv))
    
    !-----------------------------------------------------------
    ! ǮΨ dT/dz η׻. 
    !-----------------------------------------------------------    
    DtDz: do k = 1, kmax-1
      
      !
      za_MolFr(k+1,:) = za_MolFr(k,:)
      
      !----------------------------------------------------
      !ǮΨ󥲥åˡѤƷ׻
      !----------------------------------------------------
      ! (0)  k Ǥͤݴ
      Temp1  = z_Temp(k)
      Press1 = z_Press(k)
      a_MolFr  = za_MolFr(k,:)

      ! (1)  k ǤͤѤƲѲ׻
      call ECCM_DTempDZ( Temp1, Press1, r_dz(k), a_MolFr, DTempDZ1 )

      ! (2) (1) ǵ᤿ͤѤ,  k + k/2 ǤͤѤƲѲ׻
      !     ΤȤ, ʬ̤ѲʤΤȤ.
      Temp2  = Temp1 + DTempDZ1 * r_dz(k) * 5.0d-1
      Press2 =                                     &
        & Press1 * ((Temp1 / Temp3) ** (Grav * MolWtDry / (GasRUniv * DTempDZ2))) 
      call ECCM_DTempDZ( Temp2, Press2, r_dz(k), a_MolFr, DTempDZ2 )

      ! (3) (2) ǵ᤿ͤѤ,  k + k/2 ǤͤѤƲѲ׻
      !     ΤȤ, ʬ̤ѲʤΤȤ.
      Temp3  = Temp1 + DTempDZ2 * r_dz(k) * 5.0d-1
      Press3 =                                                                   &
        & Press1 * ((Temp1 / Temp3) ** (Grav * MolWtDry / (GasRUniv * DTempDZ2)))
      call ECCM_DTempDZ( Temp3, Press3, r_dz(k), a_MolFr, DTempDZ3 )
      
      ! (4) (3) ǵ᤿ͤѤ,  k + k ǤͤѤƲѲ׻
      !     ΤȤ, ʬ̤ѲʤΤȤ.
      Temp4  = Temp1 + DTempDZ3 * r_dz(k)
      Press4 =                                               &
        & Press1 * ((Temp1 / Temp4) ** (Grav * MolWtDry / (GasRUniv * DTempDZ3)))
      call ECCM_DTempDZ( Temp4, Press4, r_dz(k), a_MolFr, DTempDZ4 )
      
      ! (5) ǽŪʷ
      DTempDZ = (DTempDZ1 + DTempDZ2 * 2.0d0 + DTempDZ3 * 2.0d0 + DTempDZ4) / 6.0d0

      !----------------------------------------------------
      !줿ٸΨ겹٤ȰϤ
      !----------------------------------------------------
      !٤׻
      z_Temp(k+1) = z_Temp(k) + DTempDz * r_dz(k)

      !ǰ
      if(z_Temp(k+1) < 0.0d0) z_Temp(k+1) = z_Temp(k) 
      
      !Ϥſ尵ʿդ׻
      z_Press(k+1) =                                                  &
        &  z_Press(k) * ( ( z_Temp(k) / z_Temp(k+1))                  &
        &    ** (Grav * MolWtDry / ( DTempDZ * GasRUniv ) ) )
      
      !----------------------------------------------------
      !η׻
      !----------------------------------------------------
      do s = 1, CondNum      
        !˰¾
        SatPress = SvapPress( SpcWetID(IdxCC(s)), z_Temp(k+1) )
        
        !ΥʬΨѤƸߤξ׻
        VapPress = za_MolFr(k,IdxCG(s)) * z_Press(k+1)
        
        !˰¾ȰϤ鸽ߤΥ׻
        if ( VapPress > SatPress ) then         
          za_MolFr(k+1,IdxCG(s)) = max(SatPress * Humidity / z_Press(k+1), 1.0d-16)
        end if
      end do
      
      !NH4SH ʿվ
      if ( IdxNH3 /= 0 ) then 
        DelMolFr =                                              &
          & max (                                               &
          &    DelMolFrNH4SH(                                   &
          &         z_Temp(k+1), z_Press(k+1),                  &
          &         za_MolFr(k+1,IdxNH3), za_MolFr(k+1,IdxH2S),       &
          &         Humidity                                    &
          &      ),                                             &
          &    0.0d0                                            &
          &  )
        za_MolFr(k+1,IdxNH3) = za_MolFr(k+1,IdxNH3) - DelMolFr
        za_MolFr(k+1,IdxH2S) = za_MolFr(k+1,IdxH2S) - DelMolFr
      end if
      
    end do DtDz
    
  end subroutine ECCM_Wet

!!!------------------------------------------------------------------------------!!!
  subroutine ECCM_MolFr( a_MolFrIni, Humidity, z_Temp, z_Press, za_MolFr )
    !
    ! Ϳ줿٤Ф, ǮŪ˾徺˼¸
    ! Υץե
    !

    
    !ۤηػ
    implicit none
    
    real(DP), intent(in) :: a_MolFrIni(1:ncmax)
    real(DP), intent(in) :: Humidity
    real(DP), intent(in) :: z_Temp(kmin:kmax)
    real(DP), intent(in) :: z_Press(kmin:kmax)
    real(DP), intent(out):: za_MolFr(kmin:kmax, 1:ncmax)
    
    real(DP)             :: DelMolFr
    integer             :: k, s
    

    !-----------------------------------------------------------
    ! ν
    !-----------------------------------------------------------
    do s = 1, ncmax
      za_MolFr(:,s) = a_MolFrIni(s) 
    end do

    !-----------------------------------------------------------
    ! ǮΨ dT/dz η׻. 
    !-----------------------------------------------------------
    do k = 1, kmax

      za_MolFr(k,:) = za_MolFr(k-1,:)
      
      !------------------------------------------------------------
      !NH4SH ʳβؼʿվ
      !------------------------------------------------------------
      do s = 1, CondNum

        !
        !ΥƥåפǤΥĶ뤳ȤϤʤ
        za_MolFr(k,IdxCG(s)) =                                 &
          & min(                                                &
          &       za_MolFr(k-1,IdxCG(s)),                      &
          &       SvapPress( SpcWetID(IdxCC(s)), z_Temp(k) ) &
          &        * Humidity / z_Press(k)                      &
          &      )
        
      end do

      !------------------------------------------------------------
      !NH4SH ʿվ
      !------------------------------------------------------------
      if ( IdxNH3 /= 0 ) then 
        
        !Ѳ. 
        !Ȥꤢ NH4SH Ф˰ 1.0 Ȥ(ȴ...).
        DelMolFr =                                            &
          & max (                                             &
          &    DelMolFrNH4SH(                                 &
          &      z_Temp(k), z_Press(k),                       &
          &      za_MolFr(k,IdxNH3), za_MolFr(k,IdxH2S), Humidity   &
          &     ),                                            &
          &    0.0d0                                          &
          &  )
        
        za_MolFr(k,IdxNH3) = za_MolFr(k,IdxNH3) - DelMolFr 
        za_MolFr(k,IdxH2S) = za_MolFr(k,IdxH2S) - DelMolFr
      end if
      
    end do
  end subroutine ECCM_MolFr

!!!------------------------------------------------------------------------------!!!
  subroutine ECCM_DTempDZ( Temp, Press, DelZ, MolFr, DTempDZ )
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in) :: Temp
    real(DP), intent(in) :: Press
    real(DP), intent(in) :: DelZ
    real(DP), intent(inout) :: MolFr(0:ncmax)    !ʬΨ
    real(DP), intent(out):: DTempDZ
    real(DP)            :: ReactHeat
    real(DP)            :: Heat(ncmax)
    real(DP)            :: DelMolFr
    real(DP)            :: SatPress
    real(DP)            :: VapPress
    real(DP)            :: Humidity
    real(DP)            :: A, B
    integer             :: s

    !
    DTempDZ      = 0.0d0
    ReactHeat    = 0.0d0
    Heat         = 0.0d0
    DelMolFr     = 0.0d0
    SatPress     = 0.0d0
    VapPress     = 0.0d0

    !------------------------------------------------------------
    !NH4SH ʳβؼʿվ
    !------------------------------------------------------------
    do s = 1, CondNum      
      
      !˰¾
      SatPress = SvapPress( SpcWetID(IdxCC(s)), Temp )
      
      !Ǯ. 
      Heat(IdxCG(s)) = LatentHeatPerMol( SpcWetID(IdxCC(s)), Temp )
      
      !ΥʬΨѤƸߤξ׻
      VapPress = MolFr(IdxCG(s)) * Press
      
      !˰¾ŷ̵ͭ
      if ( VapPress < SatPress ) then         
        !ŷ뤷ƤʤΤǮʤ.
        Heat(IdxCG(s)) = 0.0d0          

      else      

        !˰¾ȰϤ鸽ߤΥ׻
        MolFr(IdxCG(s)) = max(SatPress / Press, 1.0d-16)

      end if
    end do
    
    !------------------------------------------------------------
    !NH4SH ʿվ
    !------------------------------------------------------------
    if ( IdxNH3 /= 0 ) then 
      
      Humidity = 1.0d0
      DelMolFr =                                            &
        & max (                                             &
        &    DelMolFrNH4SH(                                 &
        &         Temp, Press, MolFr(IdxNH3), MolFr(IdxH2S),&
        &         Humidity                                  &
        &      ),                                           &
        &    0.0d0                                          &
        &  )
      MolFr(IdxNH3) = MolFr(IdxNH3) - DelMolFr
      MolFr(IdxH2S) = MolFr(IdxH2S) - DelMolFr

      ReactHeat = ReactHeatNH4SHPerMol * DelMolFr
    end if
    
    !------------------------------------------------------------
    !ٸۤ׻
    !------------------------------------------------------------
    !.  Temp(i) ɾ
    A = dot_product( Heat(1:ncmax), MolFr(1:ncmax)) &
      &  / ( GasRUniv * Temp )
    B = dot_product(( Heat(1:ncmax) ** 2.0d0), MolFr(1:ncmax)) &
      &  / ( CpDryMol * GasRUniv * ( Temp ** 2.0d0 ) )
    
    !ǮٸΨ
    DTempDZ = - Grav * MolWtDry * (1.0d0 + A) / (CpDryMol * (1.0d0 + B))  &
      &       + ReactHeat / (CpDryMol * DelZ)
    
  end subroutine ECCM_DTempDZ

!!!------------------------------------------------------------------------------!!!
  subroutine ECCM_Stab( xyz_PTemp, xyz_Exner, xyzf_QMix )

    use gridset,only: imin,       &!  X β
      &                 imax,       &!  X ξ 
      &                 jmin,       &!  Y β
      &                 jmax,       &!  Y ξ 
      &                 kmin,       &!  Z β
      &                 kmax,       &!  Z ξ 
      &                 ncmax          !
    use basicset,only:  &
      &                 xyz_ExnerBZ,   &!
      &                 xyz_PTempBZ, &! 
      &                 xyzf_QMixBZ
    use constants,only: MolWtDry,      &!
      &                 CpDry,         &!
      &                 Grav          
    use composition,only:  MolWtWet
    use axesset, only : xyz_avr_xyr
    use xyz_deriv_module,only : xyr_dz_xyz
    
    implicit none

    real(DP), intent(in)  :: xyz_PTemp(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)  :: xyz_Exner(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(in)  :: xyzf_QMix(imin:imax,jmin:jmax,kmin:kmax, ncmax)

    real(DP) :: xyz_Stab(imin:imax,jmin:jmax,kmin:kmax)
    real(DP) :: xyz_StabTemp(imin:imax,jmin:jmax,kmin:kmax)
    real(DP) :: xyz_StabMolWt(imin:imax,jmin:jmax,kmin:kmax)

    real(DP)   :: xyzf_MolFrAll(imin:imax,jmin:jmax,kmin:kmax,ncmax)
    real(DP)   :: xyz_TempAll(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)   :: xyz_MolWtWet(imin:imax,jmin:jmax,kmin:kmax)
    integer    :: i, j, k, s

    xyz_TempAll = (xyz_PTemp + xyz_PTempBZ) * (xyz_Exner + xyz_ExnerBZ)
    do s = 1, ncmax
      xyzf_MolFrAll(:,:,:,s) =                          &
        &   (xyzf_QMix(:,:,:,s) + xyzf_QMixBZ(:,:,:,s)) &
        &   * MolWtDry / MolWtWet(s) 
    end do
    
    do k = kmin, kmax
    do j = jmin, jmax
    do i = imin, imax
      xyz_MolWtWet(i,j,k) = &
        &     dot_product( MolWtWet(1:GasNum), xyzf_MolFrAll(i,j,k,1:GasNum) )
    end do
    end do
    end do
    
    xyz_StabTemp =                                               &
      &         Grav / xyz_TempAll                               &
      &           * (   xyz_avr_xyr( xyr_dz_xyz( xyz_TempAll ) ) &
      &               + Grav / CpDry ) 
    xyz_StabMolWt =                                              &
      &       - Grav * xyz_avr_xyr( xyr_dz_xyz( xyz_MolWtWet ) ) &
      &         / MolWtDry 
    xyz_Stab = xyz_StabTemp + xyz_StabMolWt

    where (xyz_Stab < 1.0d-7) 
      xyz_Stab = 1.0d-7
    end where

  end subroutine ECCM_Stab

end module ECCM
