!= Module Composition
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: composition.f90,v 1.4 2011-06-21 07:24:22 sugiyama Exp $ 
! Tag Name::  $Name: arare5-20120511 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
! ǥѤʪŪ뤿ѿȷ⥸塼
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!

module composition
  !
  ! ǥѤʪŪ뤿ѿȷ⥸塼
  !
  
  !⥸塼ɤ߹
  use dc_types,   only: DP, STRING
  use dc_iounit,  only: FileOpen
  use dc_message, only: MessageNotify
  use mpi_wrapper,only: myrank
  use ChemData,   only: ChemData_OneSpcID, &!ؼ ID
    &                   ChemData_MolWt      !ʬ
  use gridset,    only: ncmax  !ؼο
  use namelist_util, only: namelist_filename

  !ۤηػ
  implicit none
  
  !°
  private

  !ѿ
  integer, save, public :: GasNum       = 0   ! ο
  integer, save, public :: CloudNum     = 0   ! ο  
  integer, save, public :: RainNum      = 0   ! ο
  integer, save, public :: IdxG(10)     = 0   ! Τź
  integer, save, public :: IdxC(10)     = 0   ! ź
  integer, save, public :: IdxR(10)     = 0   ! ź  
  integer, save, public :: CondNum      = 0   ! ŷο
  integer, save, public :: IdxCG(10)    = 0   ! ŷ()ź
  integer, save, public :: IdxCC(10)    = 0   ! ŷ()ź
  integer, save, public :: IdxCR(10)    = 0   ! ŷ()ź
  integer, save, public :: RactNum      = 0   ! ȿο
  integer, save, public :: IdxNH3       = 0   ! NH3 ()ź
  integer, save, public :: IdxH2S       = 0   ! H2S ()ź
  integer, save, public :: IdxNH4SHc    = 0   ! NH4SH ()ź
  integer, save, public :: IdxNH4SHr    = 0   ! NH4SH ()ź
!  integer, save, public :: ncmax           = 1   ! ŷʪο
  integer, allocatable  :: SpcWetID(:)        !ʬβؼID
  real(DP), allocatable :: MolWtWet(:)        !ʬʬ  
  real(DP)              :: SpcWetMolFr(10)    !ʬβؼ¸
  character(STRING)     :: SpcWetSymbol(10)   !ʬβؼ̾  

  integer, allocatable  :: IDGas(:)           !βؼID
  integer, allocatable  :: IDCloud(:)         !βؼID
  integer, allocatable  :: IDRain(:)          !βؼID

  save   SpcWetID, MolWtWet, SpcWetMolFr, SpcWetSymbol
  save   IDGas, IDCloud, IDRain
  public SpcWetID, MolWtWet, SpcWetMolFr, SpcWetSymbol
  public IDGas, IDCloud, IDRain
  public composition_init
  
contains
  
  subroutine composition_init
    !=
    !
    !NameList ե뤫.
    !Υ֥롼, ؾνԤäƤ
    !
    !=Žʬμ갷ˤĤ
    !
    !׻ѤŽʬξ basicset.f90 
    !SpcWetSymbol  SpcWetID ݴɤƤ
    ! 
    ! Symbol:  H2O-g, NH3-g, H2S-g, H2O-l-Cloud, H2O-l-Rain, NH4SH-s-Cloud, NH4SH-s-Rain
    ! ID:      5,     8,     10,    7,           7,          11,            11
    !
    !ID ֹ(ChemData_SpcID) ChemData.f90 Ƥ
    !
    !嵭ξ򸵤, Υ롼Ǥϰʲξ.  
    !
    !  * ƥƥ꡼˴ޤޤʪο
    !
    !    GasNum = 3,  CloudNum = 2, RainNum = 2
    !  
    !  * ƥƥ꡼ź. ΤѤ.
    !
    !    IdxG = 1, 2, 3, 0, 0, 0, ...
    !    IdxC = 4, 6, 0, 0, 0, 0, ...
    !    IdxR = 5, 7, 0, 0, 0, 0, ...
    !
    !  * ŷ(Condensation)ʪο, ź. 
    !    嵭Ǥ H2O ζŷΤߤ
    !
    !    CondNum = 1
    !    IdxCG = 1, 0, 0, 0, 0, 0, ...
    !    IdxCC = 4, 0, 0, 0, 0, 0, ...
    !    IdxCR = 5, 0, 0, 0, 0, 0, ...
    !
    !  * NH4SH ȿ˴Ϳʪź
    !
    !    IdxNH3    = 2
    !    IdxH2S    = 3
    !    IdxNH4SHc = 6
    !    IdxNH4SHr = 7
    !
    !ѤʤʬˤϥƤ. 
    !
    
    !ۤηػ
    implicit none
      
    !ѿ
    character(20), allocatable   :: Symbol(:)   !
    integer                      :: SpcWetNum   !ʬβؼο
    integer                      :: s, s1, s2
    integer                      :: n1, n2, n3
    integer                      :: unit
    integer                      :: num

    !-----------------------------------------------------------------
    ! NAMELIST 
    !
    NAMELIST /composition_nml/ SpcWetSymbol, SpcWetMolFr

    SpcWetSymbol = '' 
    SpcWetMolFr  = 0.0d0
    
    call FileOpen(unit, file=namelist_filename, mode='r')
    read(unit, NML=composition_nml)
    close(unit)

    !----------------------------------------------------------
    ! ʬ ID 
    !
    !ʬθĿ
    SpcWetNum = count(SpcWetSymbol /= "")
    if (SpcWetNum /= ncmax) then 
      call MessageNotify( "E", "basicset: ", "SpcWetNum is not equal to ncmax." )
    end if
    
    !γ
    allocate(SpcWetID(SpcWetNum), Symbol(SpcWetNum), MolWtWet(SpcWetNum))

    !SpcWetSymbol ʸ󤫤, -Rain, -Cloud Τ Symbol Ȥݴ
    do s = 1, SpcWetNum
      n1 = index(SpcWetSymbol(s), '-Cloud' )
      n2 = index(SpcWetSymbol(s), '-Rain' )
      n3 = max(n1, n2)
      if (n3 == 0) then
        Symbol(s) = SpcWetSymbol(s)
      else
        Symbol(s) = SpcWetSymbol(s)(1:n3-1)
      end if
    end do
    
    !ؼ ID 
    do s =1, SpcWetNum
      SpcWetID(s) = ChemData_OneSpcID( Symbol(s) )
    end do
    
    !ʬ̤ݴ
    do s = 1, SpcWetNum
      MolWtWet(s) = ChemData_MolWt(SpcWetID(s))
    end do


    !-----------------------------------------------------------
    ! γȵΤ ID Ȥ
    !
    !, , ȤʬΥ. 
    SelectCloud: do s = 1, ncmax
      
      !'-g' Ȥʸ󤬴ޤޤΤθĿ
      n1 = index(SpcWetSymbol(s), '-g' )
      if (n1 /= 0) then
        GasNum        = GasNum + 1
        IdxG(GasNum)   = s
      end if
      
      !'Cloud' Ȥʸ󤬴ޤޤΤθĿ
      n2 = index(SpcWetSymbol(s), '-Cloud' )
      if (n2 /= 0) then
        CloudNum         = CloudNum + 1
        IdxC(CloudNum)  = s
      end if

      !'Rain' Ȥʸ󤬴ޤޤΤθĿ
      n3 = index(SpcWetSymbol(s), '-Rain' )
      if (n3 /= 0) then
        RainNum         = RainNum + 1
        IdxR(RainNum)   = s
      end if

    end do SelectCloud


    !ŷФ, ȱȤФ. 
    SelectCond: do s = 1, ncmax
      
      ! NH4SH ¸ߤ
      if ( trim(SpcWetSymbol(s)) == 'NH4SH-s-Cloud' ) then 
        RactNum           = 1
        cycle SelectCond
      end if
      
      !'Cloud' Ȥʸ󤬴ޤޤΤθĿ
      n2 = index(SpcWetSymbol(s), '-Cloud' )
      if (n2 /= 0) then
        CondNum          = CondNum  + 1
        IdxCC(CondNum)   = s

        do s1 = 1, ncmax
          if ( trim(SpcWetSymbol(s1)) == trim(SpcWetSymbol(s)(1:n2-3)//'-g') ) then 
            IdxCG(CondNum)   = s1
          end if
        end do
        
        do s2 = 1, ncmax
          if ( trim(SpcWetSymbol(s2)) == trim(SpcWetSymbol(s)(1:n2-1)//'-Rain') ) then 
            IdxCR(CondNum)   = s2
          end if
        end do
      end if
      
    end do SelectCond
    
    !-----------------------------------------------------------
    ! β˥, ӥ˥βǤ ID 
    !
    do s = 1, ncmax
      if ( trim(SpcWetSymbol(s)) == 'NH4SH-s-Cloud' ) then 

        IdxNH4SHc = s

        do s1 = 1, ncmax
          if ( trim(SpcWetSymbol(s1)) == 'NH3-g' ) then 
            IdxNH3 = s1
          end if
        end do

        do s2 = 1, ncmax
          if ( trim(SpcWetSymbol(s2)) == 'H2S-g' ) then 
            IdxH2S = s2
          end if
        end do

      end if
      
      if ( trim(SpcWetSymbol(s)) == 'NH4SH-s-Rain' ) then 
        IdxNH4SHr = s
      end if

    end do
        
    !-----------------------------------------------------------
    ! ID Ȥ
    !
    allocate(IDGas(CondNum), IDCloud(CondNum), IDRain(CondNum))
    do s = 1, CondNum
      IDGas(s)   = SpcWetID(IdxCG(s))
      IDCloud(s) = SpcWetID(IdxCC(s))
      IDRain(s)  = SpcWetID(IdxCR(s))
    end do

    !-----------------------------------------------------------
    ! ǧ
    !
    if (myrank == 0) then
      call MessageNotify( "M", &
        &  "composition_init","GasNum   = %d", i=(/GasNum/)   )
      call MessageNotify( "M", &
        & "composition_init", "CloudNum = %d", i=(/CloudNum/) )    
      call MessageNotify( "M", &
        & "composition_init", "RainNum  = %d", i=(/RainNum/)  ) 
      call MessageNotify( "M", &
        & "composition_init", "CondNum  = %d", i=(/CondNum/)  )    
      call MessageNotify( "M", &
        & "composition_init", "RactNum  = %d", i=(/RactNum/)  ) 
      call MessageNotify( "M", &
        & "composition_init", "IdxNH3 = %d",   i=(/IdxNH3/)   )
      call MessageNotify( "M", &
        & "composition_init", "IdxH2S = %d",   i=(/IdxH2S/)   )
      call MessageNotify( "M", &
        & "composition_init", "IdxNH4SHc = %d", i=(/IdxNH4SHc/) )
      call MessageNotify( "M", &
        & "composition_init", "IdxNH4SHr = %d", i=(/IdxNH4SHr/) )
      Num = count(IdxG /= 0)
      write(*,*) "*** MESSAGE [composition_init] ***  IdxG  = ", IdxG(1:Num)
      write(*,*) "*** MESSAGE [composition_init] ***  IdxC  = ", IdxC(1:Num)
      write(*,*) "*** MESSAGE [composition_init] ***  IdxR  = ", IdxR(1:Num)
      Num = count(IdxCG /= 0)
      write(*,*) "*** MESSAGE [composition_init] ***  IdxCG = ", IdxCG(1:Num)
      write(*,*) "*** MESSAGE [composition_init] ***  IdxCC = ", IdxCC(1:Num)
      write(*,*) "*** MESSAGE [composition_init] ***  IdxCR = ", IdxCR(1:Num)
      
      do s = 1, SpcWetNum
        call MessageNotify( "M", &
          & "composition_init", "SpcWetID = %d",     i=(/SpcWetID(s)/) )
        call MessageNotify( "M", &
          & "composition_init", "SpcWetSymbol = %c", c1=trim(SpcWetSymbol(s)) )
        call MessageNotify( "M", &
          & "composition_init", "SpcWetMolFr = %f",  d=(/SpcWetMolFr(s)/) )
        call MessageNotify( "M", &
          & "composition_init", "MolWtWet = %f",     d=(/MolWtWet(s)/) )
      end do
    end if
  end subroutine composition_init

end module composition
