!= Module HeatFlux
!
! Authors::   ODAKA Masatsugu, TAKAHASHI Yoshiyuki
! Version::   $Id: surfaceflux_bulk.f90,v 1.16 2012-07-30 05:55:06 odakker Exp $
! Tag Name::  $Name: arare5-20120828 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!

module Surfaceflux_bulk
  !
  != ǤΥեåη׻⥸塼
  !
  != Surface flux
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! Louis et al. (1982) ˡ˴Ťɽ̥եå׻. 
  !
  ! Surface fluxes are calculated by using the scheme by Louis et al. (1982). 
  !
  !== References
  !
  ! Louis, J-F., M. Tiedtke, and J-F. Geleyn, 
  ! A short history of the PBL parameterization at ECMWF, 
  ! Workshop on Planetary Boundary Layer Parameterization, 59-80, ECMWF, Reading, U.K., 
  ! 1982.
  !== Variable List
  !
  !== Procedures List
  !

  ! ⥸塼; USE statement
  !  

  ! GTOOL ѿȼ³
  ! GTOOL variables and procedures
  !
  use dc_types, only: DP, STRING
  use dc_iounit, only: FileOpen
  use dc_message, only: MessageNotify
  use gtool_historyauto, only: HistoryAutoAddVariable, HistoryAutoPut

  ! ѿ
  ! Parallel processing variable 
  !       
  Use mpi_wrapper,only: myrank

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imin, & ! x 󲼸 
    &                      & ! Upper limit of array in x
    &                imax, & ! x  
    &                      & ! Lower limit of array in x
    &                jmin, & ! y 󲼸 
    &                      & ! Upper limit of array in y
    &                jmax, & ! y  
    &                      & ! Lower limit of array in y
    &                kmin, & ! z 󲼸 
    &                      & ! Upper limit of array in z
    &                kmax, & ! z  
    &                      & ! Lower limit of array in z
    &                nx,   & ! x ʻ 
    &                      & ! Number of grid point in x
    &                ny,   & ! y ʻ 
    &                      & ! Number of grid point in y
    &                nz,   & ! z ʻ 
    &                      & ! Number of grid point in z
    &                ncmax   ! ο       
                             ! Number of spices

  ! ɸȱ黻
  ! Axes and operator settings
  !
  use axesset, only: z_dz,        & ! z ʻֳ 
    &                             & ! Grid size in z
    &                xyz_avr_pyz, & ! ʿ
    &                             & ! Average operator
    &                xyz_avr_xqz, & ! ʿ
    &                             & ! Average operator
    &                pyz_avr_xyz, & ! ʿ
    &                             & ! Average operator
    &                xqz_avr_xyz    ! ʿ
                                    ! Average operator

  ! ܾѿ
  ! Basic state variables
  !
  use basicset, only: xyz_ExnerBZ,  & ! ϴؿ
    &                               & ! Exner function
    &                 xyz_PressBZ,  & ! 
    &                               & ! Pressure
    &                 xyz_PTempBZ,  & ! 
    &                               & ! Potential temperature
    &                 xyz_TempBZ,   & ! 
    &                               & ! Temperature
    &                 xyzf_QMixBZ,  & ! 
    &                               & ! Mixing ration
    &                 xyz_DensBZ      ! ̩    
                                      ! Density

  ! 
  ! Constatns
  !
  use constants, only: Grav,       & ! ϲ®
    &                              & ! Gravity
    &                  MolWtDry,   & ! ʬ 
    &                              & ! Molecular weight of dry air
    &                  PressBasis, & ! ̤δవ
    &                              & ! Reference pressure
    &                  TempSfc,    & ! ɽ̲
    &                              & ! Surface temperature
    &                  PressSfc,   & ! ɽ̵
    &                              & ! Surface pressure
    &                  CpDry,      & ! 갵Ǯ 
    &                              & ! Specific heat of dry air
    &                  GasRDry       ! 
                                     ! Gas constant of dry air

  use constants0, only: FKarm        ! ޥ
                                     ! Karmann constant

  ! ˴ؤѿ
  ! Setting for atmospheric composition
  ! 
  use composition, only: IdxCG,       & ! ŷ()ź 
    &                                 & ! Index of vapor
    &                    IdxCC,       & ! ŷ()ź 
    &                                 & ! Index of cloud
    &                    SpcWetID,    & !ŷʬβؼID
    &                                 & ! ID number of moist condensation spices
    &                    CondNum,     & ! ο
    &                                 & ! Number of cloud component
    &                    MolWtWet,    & ! ŷʬʬ
    &                                 & ! Molecular weight of moist air
    &                    SpcWetSymbol   ! ŷʬβؼ̾
                                        ! Chemical formula of condensation spices

  ! ̷׻˴ؤ
  ! Settings for chemical calculation
  !
  use chemcalc, only: SvapPress ! ˰¾
                                ! Saturation vapor pressure

  ! NAMELIST ˴ؤ
  ! Settings for NAMELIST
  !
  use namelist_util, only: namelist_filename ! NAMELIST ե̾
                                             ! NAMELIST file name
  ! ˴ؤ
  ! Setting for time
  !
  use timeset, only:  TimeN !  t 
                            ! Time "t"

  ! Ѳ
  ! Tendency of variable
  use DExnerDt, only: xy_DExnerDt_xy_xyf ! D$\pi$/Dt


  ! ۤηػ
  ! Implicit none
  !
  implicit none

  ! °λ
  !
  private

  ! ³
  ! Public procedure
  !
  public surfaceflux_bulk_init
  public surfaceflux_bulk_forcing

  ! ѿ
  ! Privete variables
  ! 
  logical, save:: FlagConstBulkCoef
                            ! Flag for using constant bulk coefficient
  logical, save:: FlagUseOfBulkCoefInNeutralCond
                            ! Flag for using bulk coefficient in neutral condition
  real(DP), save:: ConstBulkCoef
                            ! Х륯. 
                            ! Steady value of bulk coefficient
  real(DP), save :: VelMinForRi = 1.0d-8 
                            ! 㡼ɿ׻®ٲ
                            ! Lower limit of velocity for Ri
  real(DP), save :: SfcRoughLength = 1.0d-2
                            ! Ĺ
                            ! Roughness length
  real(DP), save :: VelBulkCoefMin = 0.0d0
                            ! $ u $ Х륯Ǿ. 
                            ! Minimum value of $ u $ bulk coefficient
  real(DP), save :: TempBulkCoefMin = 0.0d0
                            ! $ T $ Х륯Ǿ. 
                            ! Minimum value of $ T $ bulk coefficient
  real(DP), save :: QmixBulkCoefMin = 0.0d0
                            ! $ q $ Х륯Ǿ. 
                            ! Minimum value of $ q $ bulk coefficient
  real(DP), save :: VelBulkCoefMax = 1.0d2
                            ! $ u $ Х륯. 
                            ! Maximum value of $ u $ bulk coefficient
  real(DP), save :: TempBulkCoefMax = 1.0d2
                            ! $ T $ Х륯. 
                            ! Maximum value of $ T $ bulk coefficient
  real(DP), save :: QmixBulkCoefMax = 1.0d2
                            ! $ q $ Х륯. 
                            ! Maximum value of $ q $ bulk coefficient

  real(DP), save :: PTempFluxMin = 0.0d0
                            ! ̥եåǾ. 
                            ! Minimum value of potential temp. flux
  real(DP), save :: ExnerFluxMin = 0.0d0
                            ! ϴؿեåǾ. 
                            ! Minimum value of exner function flux
  real(DP), save :: QmixFluxMin = 0.0d0
                            ! եåǾ. 
                            ! Minimum value of mixing ratio flux
  real(DP), save  :: Vel0 = 0.0d0  ! ؤǤοʿ®ٿ夲
                                   ! 

  character(*), parameter:: module_name = 'surfaceflux_bulk'
                                   ! ⥸塼̾.
                                   ! Module name

contains
!!!------------------------------------------------------------------------!!!
  subroutine Surfaceflux_Bulk_init
    !
    ! NAMELIST ɬפʾɤ߼, ִϢѿԤ. 
    !

    ! ۤηػ
    ! Implicit none
    !
    implicit none

    ! ѿ
    ! Work variables
    !
    integer    :: l,   & ! ˲ DO 롼Ѻѿ
      &                & ! Work variables for DO loop in dimension of constituents
      &           unit   ! ֹ
                         ! Device number 

    !---------------------------------------------------------------
    ! NAMELIST 
    !
    NAMELIST /surfaceflux_bulk_nml/ &
      &  FlagConstBulkCoef,                                 &
      &  FlagUseOfBulkCoefInNeutralCond, ConstBulkCoef,     &
      ! 
      &  VelMinForRi, SfcRoughLength, Vel0,                 &
      !
      &  VelBulkCoefMin, TempBulkCoefMin, QmixBulkCoefMin,  &
      &  VelBulkCoefMax, TempBulkCoefMax, QmixBulkCoefMax             


    call FileOpen(unit, file=namelist_filename, mode='r')
    read(unit, NML=surfaceflux_bulk_nml)
    close(unit)  

    if (myrank == 0) then 
      call MessageNotify( "M", module_name, "SfcRoughLength = %f",  &
        &  d=(/SfcRoughLength/))
      call MessageNotify( "M", module_name, "VelMinForRi = %f",     &
        &  d=(/VelMinForRi/) )
      call MessageNotify( "M", module_name, "Vel0 = %f", d=(/Vel0/))

      call MessageNotify( 'M', module_name, "FlagConstBulkCoef              = %b", l = (/ FlagConstBulkCoef /) )
      call MessageNotify( 'M', module_name, "FlagUseOfBulkCoefInNeutralCond = %b", l = (/ FlagUseOfBulkCoefInNeutralCond /) )
      call MessageNotify( 'M', module_name, "ConstBulkCoef   = %f", &
        &  d = (/ ConstBulkCoef   /) )
      call MessageNotify( 'M', module_name, "VelBulkCoefMin  = %f", &
        &  d = (/ VelBulkCoefMin  /) )
      call MessageNotify( 'M', module_name, "TempBulkCoefMin = %f", &
        &  d = (/ TempBulkCoefMin /) )
      call MessageNotify( 'M', module_name, "QmixBulkCoefMin = %f", &
        &  d = (/ QmixBulkCoefMin /) )
      call MessageNotify( "M", module_name, "VelBulkCoefMax = %f",  &
        &  d=(/VelBulkCoefMax/))
      call MessageNotify( "M", module_name, "TempBulkCoefMax = %f", &
        &  d=(/TempBulkCoefMax/))
      call MessageNotify( "M", module_name, "QmixBulkCoefMax = %f", &
        &  d=(/QmixBulkCoefMax/))
    end if

    call HistoryAutoAddVariable(      &
      & varname='PTempSfcFlux',       &
      & dims=(/'x','y','t'/),         &
      & longname='surface potential temperature flux (heat flux divided by density and specific heat)', &
      & units='K.m.s-1',             &
      & xtype='float')

    call HistoryAutoAddVariable(      &
      & varname='ExnerSfcFlux',       &
      & dims=(/'x','y','t'/),         &
      & longname='surface exner function flux (heat flux divided by density and specific heat)', &
      & units='s-1',             &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='VelXSfcFlux',    &
      & dims=(/'x','y','t'/),     &
      & longname='surface flux of x-component of velocity (momentum flux divided by density)', &
      & units='m2.s-2',           &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='VelYSfcFlux',    &
      & dims=(/'x','y','t'/),     &
      & longname='surface flux of y-component of velocity (momentum flux divided by density)', &
      & units='m2.s-2',           &
      & xtype='float')

    do l = 1, ncmax
      call HistoryAutoAddVariable(  &
        & varname=trim(SpcWetSymbol(l))//'_SfcFlux', & 
        & dims=(/'x','y','t'/),     &
        & longname='surface flux of '          &
        &           //trim(SpcWetSymbol(l))//' mixing ratio (mass flux divided by density)',  &
        & units='m.s-1',    &
        & xtype='float')
    end do


    call HistoryAutoAddVariable(  &
      & varname='PTempSfc',         &
      & dims=(/'x','y','z','t'/), &
      & longname='potential temperature tendency by surface flux', &
      & units='K.s-1',            &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='ExnerSfc',         &
      & dims=(/'x','y','z','t'/), &
      & longname='exner function tendency by surface flux', &
      & units='K.s-1',            &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='VelXSfc',         &
      & dims=(/'x','y','z','t'/), &
      & longname='x-component velocity tendency by surface flux', &
      & units='m.s-2',            &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='VelYSfc',         &
      & dims=(/'x','y','z','t'/), &
      & longname='y-component velocity tendency by surface flux', &
      & units='m.s-2',            &
      & xtype='float')

    do l = 1, ncmax
      call HistoryAutoAddVariable(  &
        & varname=trim(SpcWetSymbol(l))//'_Sfc', & 
        & dims=(/'x','y','z','t'/),     &
        & longname=trim(SpcWetSymbol(l))//' mixing ratio tendency by surface flux',  &
        & units='s-1',    &
        & xtype='float')
    end do


    call HistoryAutoAddVariable(       &
      & varname='SfcHeatFlux',         &
      & dims=(/'x','y','t'/),          &
      & longname='surface heat flux',  &
      & units='W.m-2',                 &
      & xtype='float')

    call HistoryAutoAddVariable(                      &
      & varname='SfcXMomFlux',                        &
      & dims=(/'x','y','t'/),                         &
      & longname='surface x-component momentum flux', &
      & units='kg.m-2.s-1',                           &
      & xtype='float')

    call HistoryAutoAddVariable(                      &
      & varname='SfcYMomFlux',                        &
      & dims=(/'x','y','t'/),                         &
      & longname='surface y-component momentum flux', &
      & units='kg.m-2.s-1',                           &
      & xtype='float')

    do l = 1, ncmax
      call HistoryAutoAddVariable(                               &
        & varname=trim(SpcWetSymbol(l))//'_SfcMassFlux',         &
        & dims=(/'x','y','t'/),                              &
        & longname=trim(SpcWetSymbol(l))//' surface mass flux',  &
        & units='kg.m-2.s-1',                                    &
        & xtype='float')
    end do

  end subroutine Surfaceflux_Bulk_init
!!!------------------------------------------------------------------------!!!
  subroutine Surfaceflux_Bulk_forcing( &
    &   pyz_VelX, xqz_VelY, xyz_PTemp, xyz_Exner, xyzf_QMix, &
    &   pyz_DVelXDt, xqz_DVelYDt, xyz_DPTempDt, xyz_DExnerDt, xyzf_DQMixDt &
    & )
    ! 
    ! Υեåˤ벹٤ѲΨ,
    ! Х륯ˡ˴ŤƷ׻.
    !

    ! ۤηػ
    ! Implicit none
    !
    implicit none

    ! ѿ
    ! variables
    !
    real(DP), intent(in)   :: pyz_VelX(imin:imax,jmin:jmax,kmin:kmax)
                              ! ʿ®
                              ! X-component velocity
    real(DP), intent(in)   :: xqz_VelY(imin:imax,jmin:jmax,kmin:kmax)
                              ! ʿ®
                              ! Y-component velocity
    real(DP), intent(in)   :: xyz_PTemp(imin:imax,jmin:jmax,kmin:kmax)
                              ! 
                              ! Potential temperature
    real(DP), intent(in)   :: xyz_Exner(imin:imax,jmin:jmax,kmin:kmax)
                              ! ϴؿ
                              ! Exner function
    real(DP), intent(in)   :: xyzf_QMix(imin:imax,jmin:jmax,kmin:kmax, ncmax)
                              ! 
                              ! Mixing ration
    real(DP), intent(inout):: pyz_DVelXDt(imin:imax,jmin:jmax,kmin:kmax)
                              ! ®ѲΨ
                              ! X-component velocity tendency
    real(DP), intent(inout):: xqz_DVelYDt(imin:imax,jmin:jmax,kmin:kmax)
                              ! ®ѲΨ
                              ! Y-component velocity tendency
    real(DP), intent(inout):: xyz_DPTempDt(imin:imax,jmin:jmax,kmin:kmax)
                              ! ̻ѲΨ
                              ! Potential tempreture tendency
    real(DP), intent(inout):: xyz_DExnerDt(imin:imax,jmin:jmax,kmin:kmax)
                              ! ϴؿѲΨ
                              ! Exner function tendency
    real(DP), intent(inout):: xyzf_DQMixDt(imin:imax,jmin:jmax,kmin:kmax, ncmax)
                              ! ѲΨ
                              ! Mixing ratio tendency

    ! ѿ
    ! Work variables
    real(DP) :: xy_SurfBulkRiNum(imin:imax,jmin:jmax)
                              ! Х륯㡼ɥ
                              ! Bulk Richardson number
    real(DP) :: xy_SurfRoughLength(imin:imax,jmin:jmax)
                              ! Ĺ
                              ! Roughness length
    real(DP) :: xy_SurfVelBulkCoef(imin:imax,jmin:jmax)
                              ! Х륯(ư)
                              ! Bulk coefficient for momentum
    real(DP) :: xy_SurfTempBulkCoef(imin:imax,jmin:jmax)
                              ! Х륯(Ǯ)
                              ! Bulk coefficient for heat
    real(DP) :: xy_SurfQmixBulkCoef(imin:imax,jmin:jmax)
                              ! Х륯()
                              ! Bulk coefficient for mixing ratio
    real(DP) :: py_VelXflux (imin:imax,jmin:jmax)
                              ! x ®٥եå
                              ! velocity flux in x
    real(DP) :: xq_VelYflux (imin:imax,jmin:jmax)
                              ! y ®٥եå
                              ! celocity flux in y
    real(DP) :: xy_PTempFlux(imin:imax,jmin:jmax)
                              ! ̥եå
                              ! potential temperature flux
    real(DP) :: xy_ExnerFlux(imin:imax,jmin:jmax)
                              !
                              !
    real(DP) :: xyf_QMixFlux(imin:imax,jmin:jmax,ncmax)
                              ! ŷʬեå
                              ! Mixing ratio flux
    real(DP) :: xyz_VelX(imin:imax,jmin:jmax,kmin:kmax)
                              ! ʿ® (xyz ʻ)
                              ! X-component velocity (xyz grid)
    real(DP) :: xyz_VelY(imin:imax,jmin:jmax,kmin:kmax)
                              ! ʿ® (xyz ʻ)
                              ! Y-component velocity (xyz grid)
    real(DP) :: xyz_AbsVel(imin:imax,jmin:jmax,kmin:kmax)
                              ! ʿ® (xyz ʻ)
                              ! Absolute value of horizontal velocity (xyz grid)
    real(DP) :: pyz_AbsVel(imin:imax,jmin:jmax,kmin:kmax)
                              ! ʿ® (pyz ʻ)
                              ! Absolute value of horizontal velocity (pyz grid)
    real(DP) :: xqz_AbsVel(imin:imax,jmin:jmax,kmin:kmax)
                              ! ʿ® (xqz ʻ)
                              ! Absolute value of horizontal velocity (xqz grid)
    real(DP) :: xyz_PTempAll(imin:imax,jmin:jmax,kmin:kmax)
                              ! (ܾ + )
                              ! Total value of potential temperature
    real(DP) :: xyz_ExnerAll (imin:imax,jmin:jmax,kmin:kmax)
                              ! ϴؿ(ܾ + )
                              ! Total value of exner function
    real(DP) :: xyzf_QMixAll(imin:imax,jmin:jmax,kmin:kmax, ncmax)
                              ! (ܾ + )
                              ! Total value of mixing ratios
    real(DP) :: xy_DPTempDtBulk(imin:imax,jmin:jmax)
                              ! Ѳ()
                              ! potential temperature tendency by surface flux
    real(DP) :: xy_DExnerDtBulk(imin:imax,jmin:jmax)
                              ! Ѳ(ϴؿ)
                              ! Exner function tendency by surface flux
    real(DP) :: xyf_DQMixDtBulk(imin:imax,jmin:jmax, ncmax)
                              ! Ѳ()
                              ! Mixing ratio tendency by surface flux
    real(DP) :: py_DVelXDtBulk (imin:imax,jmin:jmax)
                              ! Ѳ(U)
                              ! x-component velocity tendency by surface flux
    real(DP) :: xq_DVelYDtBulk (imin:imax,jmin:jmax)
                              ! Ѳ(V)
                              ! y-component velocity tendency by surface flux
    real(DP) :: xyz_DPTempDtBulk(imin:imax,jmin:jmax,kmin:kmax)
                              ! Ѳ()
                              ! potential temperature tendency by surface flux
    real(DP) :: xyz_DExnerDtBulk(imin:imax,jmin:jmax,kmin:kmax)
                              ! Ѳ(ϴؿ)
                              ! Exner function tendency by surface flux
    real(DP) :: xyzf_DQMixDtBulk(imin:imax,jmin:jmax,kmin:kmax, ncmax)
                              ! Ѳ()
                              ! Mixing ratio tendency by surface flux
    real(DP) :: pyz_DVelXDtBulk (imin:imax,jmin:jmax,kmin:kmax)
                              ! Ѳ(U)
                              ! x-component velocity tendency by surface flux
    real(DP) :: xqz_DVelYDtBulk (imin:imax,jmin:jmax,kmin:kmax)
                              ! Ѳ(V)
                              ! y-component velocity tendency by surface flux
    real(DP) :: ExnerBZSfc    ! ɽ̰ϴؿ 
                              ! Basic state Exner function at the surface
    real(DP) :: xy_PressSfc(imin:imax,jmin:jmax)
                              ! Total pressure at the surface
    integer  :: kz            ! ź
                              ! Arrzy index
    integer  :: s             ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in dimension of constituen                         

    ! 
    ! Initialization
    ! 
    kz = 1

    ! Ĺλ
    ! Specify surface length
    xy_SurfRoughLength = SfcRoughLength

    ! ̤η׻
    ! Calculate total value of thermodynamic variables
    ! 
    xyz_PTempAll  = xyz_PTemp + xyz_PTempBZ
    xyz_ExnerAll  = xyz_Exner + xyz_ExnerBZ
    xyzf_QMixAll  = xyzf_QMix + xyzf_QMixBZ

    ! Perturbation component of Exner function at the surface is assumed 
    ! to be same as that at the lowest layer. (YOT, 2011/09/03)
    ! 
    ExnerBZSfc    = (PressSfc / PressBasis) ** (GasRDry / CpDry)
    xy_PressSfc   = (PressBasis * xyz_ExnerAll(:,:,kz))**(CpDry / GasRDry)

    ! xyz ʻ®٤η׻
    ! Calculate velocities at xyz grid points
    !
    xyz_VelX = xyz_avr_pyz(pyz_VelX)
    xyz_VelY = xyz_avr_xqz(xqz_VelY)

    ! ʿ®ͤη׻
    ! Calculate of absoluto horizontal velocities
    ! 
    xyz_AbsVel = SQRT( xyz_VelX**2 + xyz_VelY**2 + Vel0**2 )
    pyz_AbsVel = pyz_avr_xyz(xyz_AbsVel)
    xqz_AbsVel = xqz_avr_xyz(xyz_AbsVel)

    ! Х륯 $ R_i $ 
    ! Calculate bulk $ R_i $
    !
    xy_SurfBulkRiNum =                                 &
      &   Grav / ( xyz_PTempAll(:,:,1) )               & 
      &   * ( xyz_PTempAll(:,:,1)                      &
      &     -TempSfc / (ExnerBZSfc + xyz_Exner(:,:,1)))&
      &   / max( xyz_AbsVel(:,:,1), VelMinForRi )**2   &
      &   * z_dz(1) * 0.5d0

    ! Х륯η׻
    ! Bulk coefficients are calculated.
    ! 
    call BulkCoef( &
      & xy_SurfBulkRiNum,    & ! (in)
      & xy_SurfRoughLength,  & ! (in)
      & xy_SurfVelBulkCoef,  & ! (out)
      & xy_SurfTempBulkCoef, & ! (out)
      & xy_SurfQmixBulkCoef  & ! (out)
      & )
    ! եåη׻
    ! Surface fluxes are calculated. 
    !
    xy_PTempFlux = - xy_SurfTempBulkCoef * xyz_AbsVel(:,:,kz)  &
      & * ( xyz_PTempAll(:,:,kz) - TempSfc / ( ExnerBZSfc + xyz_Exner(:,:,kz) ) )

    xyf_QMixFlux = 0.0d0
    do s = 1, CondNum
      xyf_QMixFlux(:,:,IdxCG(s)) =                                 &
        &     - xy_SurfQmixBulkCoef * xyz_AbsVel(:,:,kz)           &
        &       * (                                                &
        &            xyzf_QMixAll(:,:,kz,s)                        &
        &          - SvapPress( SpcWetID(IdxCC(s)), TempSfc )      &
        &             / ( xy_PressSfc )                            &
        &             * (MolWtWet(IdxCG(s)) / MolWtDry)            &
        &         )
    end do
    !
    xy_ExnerFlux = xy_DExnerDt_xy_xyf(xy_PTempFlux, xyf_QMixFlux, kz)
    !
    py_VelXFlux = - xy_SurfVelBulkCoef * pyz_AbsVel(:,:,kz) * pyz_VelX(:,:,kz)
    !
    xq_VelYFlux = - xy_SurfVelBulkCoef * xqz_AbsVel(:,:,kz) * xqz_VelY(:,:,kz)


    ! եåβͤ
    ! Set lower limit of surface fluxes
    ! 
    xy_PTempFlux = max( PTempFluxMin, xy_PTempFlux )
    xy_ExnerFlux = max( ExnerFluxMin, xy_ExnerFlux )
    xyf_QMixFlux = max( QMixFluxMin, xyf_QMixFlux )


    ! ɽեåˤѲ׻
    ! Tendencies by surface fluxes (convergences of fluxes) are calculated.
    !
    xy_DPTempDtBulk = - ( 0.0d0 - xy_PTempFlux ) / z_dz(kz)
    !
    xy_DExnerDtBulk = - ( 0.0d0 - xy_ExnerFlux ) / z_dz(kz)
    !
    xyf_DQMixDtBulk = - ( 0.0d0 - xyf_QMixFlux ) / z_dz(kz)
    !
    py_DVelXDtBulk = - ( 0.0d0 - py_VelXFlux ) / z_dz(kz)
    !
    xq_DVelYDtBulk = - ( 0.0d0 - xq_VelYFlux ) / z_dz(kz)

    
    ! سǼ
    ! Add tendency by surface flux convergence
    !
    xyz_DPTempDt(:,:,kz) = xyz_DPTempDt(:,:,kz) + xy_DPTempDtBulk
    xyz_DExnerDt(:,:,kz) = xyz_DExnerDt(:,:,kz) + xy_DExnerDtBulk
    do s = 1, ncmax
      xyzf_DQMixDt(:,:,kz,s) = xyzf_DQMixDt(:,:,kz,s) + xyf_DQMixDtBulk(:,:,s)
    end do
    pyz_DVelXDt (:,:,kz) = pyz_DVelXDt (:,:,kz) + py_DVelXDtBulk
    xqz_DVelYDt (:,:,kz) = xqz_DVelYDt (:,:,kz) + xq_DVelYDtBulk

    ! 
    ! Output
    !
    xyz_DPTempDtBulk = 0.0d0
    xyz_DExnerDtBulk = 0.0d0
    xyzf_DQMixDtBulk = 0.0d0
    pyz_DVelXDtBulk  = 0.0d0
    xqz_DVelYDtBulk  = 0.0d0

    xyz_DPTempDtBulk(:,:,kz) = xy_DPTempDtBulk
    xyz_DExnerDtBulk(:,:,kz) = xy_DExnerDtBulk
    do s = 1, ncmax
      xyzf_DQMixDtBulk(:,:,kz,s) = xyf_DQMixDtBulk(:,:,s)
    end do
    pyz_DVelXDtBulk (:,:,kz) = py_DVelXDtBulk
    xqz_DVelYDtBulk (:,:,kz) = xq_DVelYDtBulk
    !
    call HistoryAutoPut(TimeN, 'PTempSfc', xyz_DPTempDtBulk(1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'ExnerSfc', xyz_DExnerDtBulk(1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'VelXSfc',  pyz_DVelXDtBulk (1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'VelYSfc',  xqz_DVelYDtBulk (1:nx,1:ny,1:nz))
    do s = 1, ncmax
      call HistoryAutoPut(TimeN, trim(SpcWetSymbol(s))//'_Sfc', &
        & xyzf_DQMixDtBulk(1:nx,1:ny,1:nz,s))
    end do


    call HistoryAutoPut(TimeN, 'PTempSfcFlux', xy_PTempFlux(1:nx,1:ny))
    call HistoryAutoPut(TimeN, 'ExnerSfcFlux', xy_ExnerFlux(1:nx,1:ny))
    call HistoryAutoPut(TimeN, 'VelXSfcFlux',  py_VelXFlux (1:nx,1:ny))
    call HistoryAutoPut(TimeN, 'VelYSfcFlux',  xq_VelYFlux (1:nx,1:ny))
    do s = 1, ncmax
      call HistoryAutoPut(TimeN, trim(SpcWetSymbol(s))//'_SfcFlux', &
        & xyf_QMixFlux(1:nx,1:ny,s))
    end do

    call HistoryAutoPut(TimeN, 'SfcHeatFlux', &
      & CpDry * xyz_DensBZ(1:nx,1:ny,1) * xy_PTempFlux(1:nx,1:ny) &
      &   * ( ExnerBZSfc + xyz_Exner(1:nx,1:ny,1) ) )
    call HistoryAutoPut(TimeN, 'SfcXMomFlux', &
      & xyz_DensBZ(1:nx,1:ny,1) * py_VelXFlux (1:nx,1:ny))
    call HistoryAutoPut(TimeN, 'SfcYMomFlux', &
      & xyz_DensBZ(1:nx,1:ny,1) * xq_VelYFlux (1:nx,1:ny))
    do s = 1, ncmax
      call HistoryAutoPut(TimeN, trim(SpcWetSymbol(s))//'_SfcMassFlux', &
        & xyz_DensBZ(1:nx,1:ny,1) * xyf_QMixFlux(1:nx,1:ny,s))
    end do

  end subroutine Surfaceflux_Bulk_forcing
!!!------------------------------------------------------------------------!!!
  subroutine BulkCoef(     & 
    & xy_SurfBulkRiNum,    & ! (in)
    & xy_SurfRoughLength,  & ! (in)
    & xy_SurfVelBulkCoef,  & ! (out)
    & xy_SurfTempBulkCoef, & ! (out)
    & xy_SurfQmixBulkCoef  & ! (out)
    & )


    implicit none

    real(DP),intent(in) :: xy_SurfBulkRiNum(imin:imax,jmin:jmax)
                              ! Х륯㡼ɥ
                              ! Bulk Richardson number
    real(DP),intent(in) :: xy_SurfRoughLength(imin:imax,jmin:jmax)
                              ! Ĺ
                              ! Roughness length
    real(DP),intent(out) :: xy_SurfVelBulkCoef(imin:imax,jmin:jmax)
                              ! Х륯(ư)
                              ! Bulk coefficient for momentum
    real(DP),intent(out) :: xy_SurfTempBulkCoef(imin:imax,jmin:jmax)
                              ! Х륯(Ǯ)
                              ! Bulk coefficient for heat
    real(DP),intent(out) :: xy_SurfQmixBulkCoef(imin:imax,jmin:jmax)
                              ! Х륯()
                              ! Bulk coefficient for mixing ratio

    ! ѿ
    ! Work variables
    !
    real(DP) :: xy_SurfBulkCoefInNeutCond(imin:imax, jmin:jmax)

    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude

    ! ¹ʸ ; Executable statement
    !
    if ( FlagConstBulkCoef ) then

      ! Use of constant bulk coefficient
      !

      xy_SurfVelBulkCoef  = ConstBulkCoef
      xy_SurfTempBulkCoef = ConstBulkCoef
      xy_SurfQmixBulkCoef = ConstBulkCoef

    else

      ! Parameterization by Louis et al. (1981)
      !
      ! ΩХ륯η׻
      ! Calculate bulk coefficient in neutral condition
      !
      xy_SurfBulkCoefInNeutCond  = &
        & ( FKarm &
        & / log ( z_dz(1) / xy_SurfRoughLength ) )**2

      if ( FlagUseOfBulkCoefInNeutralCond ) then

        ! ΩǤΥХ륯
        ! Set bulk coefficient in neutral condition
        !

        xy_SurfVelBulkCoef  = xy_SurfBulkCoefInNeutCond
        xy_SurfTempBulkCoef = xy_SurfBulkCoefInNeutCond

        xy_SurfQmixBulkCoef = xy_SurfTempBulkCoef

      else

        do j = jmin, jmax
          do i = imin, imax

            if ( xy_SurfBulkRiNum(i,j) > 0.0_DP ) then 

              xy_SurfVelBulkCoef(i,j) =                                        &
                &   xy_SurfBulkCoefInNeutCond(i,j)                             &
                &   / (   1.0_DP                                               &
                &       + 10.0_DP * xy_SurfBulkRiNum(i,j)                      &
                &         / sqrt( 1.0_DP + 5.0_DP * xy_SurfBulkRiNum(i,j) )    &
                &     )

              xy_SurfTempBulkCoef(i,j) =                                       &
                &   xy_SurfBulkCoefInNeutCond(i,j)                             &
                &   / (   1.0_DP                                               &
                &       + 15.0_DP * xy_SurfBulkRiNum(i,j)                      &
                &         * sqrt( 1.0_DP + 5.0_DP * xy_SurfBulkRiNum(i,j) )    &
                &     )

              xy_SurfQmixBulkCoef(i,j) = xy_SurfTempBulkCoef(i,j)

            else

              xy_SurfVelBulkCoef(i,j) =                                       &
                &   xy_SurfBulkCoefInNeutCond(i,j)                            &
                &   * (   1.0_DP                                              &
                &       - 10.0_DP * xy_SurfBulkRiNum(i,j)                     &
                &           / (   1.0_DP                                      &
                &             + 75.0_DP * xy_SurfBulkCoefInNeutCond(i,j)      &
                &               * sqrt( - z_dz(1)  &
                &                         / xy_SurfRoughLength(i,j)           &
                &                         * xy_SurfBulkRiNum(i,j)             &
                &                     )                                       &
                &           )                                                 &
                &     )

              xy_SurfTempBulkCoef(i,j) =                                      &
                &   xy_SurfBulkCoefInNeutCond(i,j)                            &
                &   * (   1.0_DP                                              &
                &       - 15.0_DP * xy_SurfBulkRiNum(i,j)                     &
                &         / (   1.0_DP                                        &
                &             + 75.0_DP * xy_SurfBulkCoefInNeutCond(i,j)      &
                &               * sqrt( - z_dz(1) &
                &                         / xy_SurfRoughLength(i,j)           &
                &                         * xy_SurfBulkRiNum(i,j)             &
                &                     )                                       &
                &           )                                                 &
                &     )

              xy_SurfQmixBulkCoef(i,j) = xy_SurfTempBulkCoef(i,j)
    
           end if
         end do
        end do
      end if
    end if

    ! /Ǿ Ƚ
    ! Measure maximum/minimum
    !
    do i = imin, imax
      do j = jmin, jmax

        xy_SurfVelBulkCoef(i,j)  = &
          & max( min( xy_SurfVelBulkCoef(i,j), VelBulkCoefMax ), &
          &      VelBulkCoefMin )

        xy_SurfTempBulkCoef(i,j) = &
          & max( min( xy_SurfTempBulkCoef(i,j), TempBulkCoefMax ), &
          &      TempBulkCoefMin )

        xy_SurfQmixBulkCoef(i,j) = &
          & max( min( xy_SurfQmixBulkCoef(i,j), QmixBulkCoefMax ), &
          &      QmixBulkCoefMin )

      end do
    end do

  end subroutine BulkCoef
!!!------------------------------------------------------------------------!!!  
end module Surfaceflux_bulk
