!= Module TimeSet
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
! Version::   $Id: timeset.f90,v 1.9 2012-01-12 11:53:10 sugiyama Exp $ 
! Tag Name::  $Name: arare5-20120828 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!Ϳ줿 NAMELIST ե뤫, ˴ؤ, 
!ݴɤ뤿ѿ⥸塼
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!
!

module timeset
  !
  !Ϳ줿 NAMELIST ե뤫, ˴ؤ, 
  !ݴɤ뤿ѿ⥸塼
  !
  
  !⥸塼ɤ߹
  use dc_types,   only: DP, STRING
  use dc_iounit,  only: FileOpen
  use dc_message, only: MessageNotify
  use mpi_wrapper, only: myrank
  use namelist_util, only: namelist_filename
  
  !ۤηػ
  implicit none

  !°
  private
  
  ! Public Interface
  real(DP), save, public  :: TimeA                   ! t + \del t
  real(DP), save, public  :: TimeN                   ! t
  real(DP), save, public  :: TimeB                   ! t - \del t
  real(DP), save, public  :: DelTimeLong  = 2.0d0    !Ĺॹƥå
  real(DP), save          :: DelTimeLongSave  = 2.0d0 !Ĺॹƥå
  real(DP), save, public  :: DelTimeShort = 2.0d-1   !ûॹƥå
  real(DP), save, public  :: RestartTime  = 0.0d0    !׻ϻ
  real(DP), save, public  :: IntegPeriod  = 3600.0d0 !ʬ
  real(DP), save, public  :: EndTime      = 3600.0d0 !׻λ
  real(DP), save, public  :: DelTimeOutput= 2.0d0    !ϥॹƥå
  real(DP), save, public  :: tfil         = 1.0d-1   !λ֥ե륿η
  real(DP), parameter     :: tfilSave     = 1.0d-1   !λ֥ե륿η
  integer,  save, public  :: NstepShort = 20         !ûॹƥåפΥƥå׿
  integer,  save          :: NstepShortSave = 20     !ûॹƥåפΥƥå׿
  integer,  save, public  :: NstepOutput    = 20     !ꥹȥեؤν
  logical,  save, public  :: FlagInitialRun = .false.    !
  
  ! 
  public timeset_init, TimesetDelTimeHalf, TimesetProgress

contains
   
  subroutine timeset_init()
    !
    !NAMELIST ɬפʾɤ߼, ִϢѿԤ. 
    !

    !ۤηػ
    implicit none

    !ѿ
    integer    :: unit

    !---------------------------------------------------------------    
    ! NAMELIST 
    !
    NAMELIST /timeset_nml/ &
      & DelTimeLong, DelTimeShort, IntegPeriod, RestartTime, DelTimeOutput
    
    call FileOpen(unit, file=namelist_filename, mode='r')
    read(unit, NML=timeset_nml)
    close(unit)

    ! ׻λ
    !
    EndTime = RestartTime + IntegPeriod
    
    ! ॹƥåפ
    !   ¿γ껻ʤΤ, ǰΰ٤. 
    !    
    NstepShort = 2 * ( nint( DelTimeLong * 1.0d2 ) / nint( DelTimeShort * 1.0d2 ) )

    ! ֹߤ
    !   ͤݴɤƤ
    DelTimeLongSave = DelTimeLong
    NstepShortSave  = NstepShort

    ! ꥹȥե񤭽Фߥ
    !
    NstepOutput = nint( DelTimeOutput * 1.0d2 ) / nint( DelTimeLong * 1.0d2 )

    ! 
    !
    TimeB = RestartTime - DelTimeLong
    TimeN = RestartTime
    TimeA = RestartTime + DelTimeLong      
    
    ! ꥹȤݤ. ꥹȤʤ  .false.
    !
    if ( nint( RestartTime * 1.0d2 ) == 0 ) then 
      FlagInitialRun = .true.
    else
      FlagInitialRun = .false.
    end if

    !---------------------------------------------------------------
    ! ǧ
    !
    if (myrank == 0) then
      call MessageNotify( "M", &
        & "timeset_init", "DelTimeLong  = %f", d=(/DelTimeLong/) )
      call MessageNotify( "M", &
        & "timeset_init", "DelTimeShort = %f", d=(/DelTimeShort/) )
      call MessageNotify( "M", &
        & "timeset_init", "Restarttime  = %f", d=(/Restarttime/)  )
      call MessageNotify( "M", &
        & "timeset_init", "IntegPeriod  = %f", d=(/IntegPeriod/) )
      call MessageNotify( "M", &
        & "timeset_init", "EndTime      = %f", d=(/EndTime/) )
      call MessageNotify( "M", &
        & "timeset_init", "DelTimeOutput= %f", d=(/DelTimeOutput/) )
      call MessageNotify( "M", &
        & "timeset_init", "NstepShort   = %d", i=(/NstepShort/) )
      call MessageNotify( "M", &
        & "timeset_init", "NstepOutput  = %d", i=(/NstepOutput/) )
    end if
    
  end subroutine timeset_init


  subroutine TimesetDelTimeHalf    

    implicit none

    ! ǽΰܤϥ顼ǲ󤹤Τ, 
    ! ĹֹߤȾʬˤ, û֤ǲ󤹥롼ײȾʬˤ.
    ! Asselin λ֥ե륿η򥼥Ȥ. 
    !
    TimeB       = TimeN
    DelTimeLong = DelTimeLongSave * 0.5d0
    NstepShort  = NstepShortSave  / 2
    tfil        = 0.0d0

    !---------------------------------------------------------------
    ! ǧ
    !
    if (myrank == 0) then
      call MessageNotify( "M", &
        & "timeset_init", "Initial DelTimeLong  = %f", d=(/DelTimeLong/) )
      call MessageNotify( "M", &
        & "timeset_init", "Initial NstepShort   = %d", i=(/NstepShort/) )
!      call MessageNotify( "M", &
!        & "timeset_init", "Asselin Time Filter coefficient = %d", d=(/tfil/) )
!      write(*,*) tfil
    end if    

  end subroutine TimesetDelTimeHalf
  
  subroutine TimesetProgress

    implicit none

    ! ľ 
    !
    DelTimeLong = DelTimeLongSave
    NstepShort  = NstepShortSave

    ! ʤ
    !
    TimeB = TimeN
    TimeN = TimeA
    TimeA = TimeA + DelTimeLong

    ! Asselin λ֥ե륿η
    tfil = tfilSave

  end subroutine TimesetProgress
  
end module timeset
