# Title: Ruby script drawing contour map for deepconv/arare5 output data 
#
# History: 2011/09/27 (Masatsugu Odaka)
#
require "numru/ggraph"
include NumRu

file = 'denscurrent-dry_VelZ.nc'
varname = 'VelZ'


var = GPhys::IO.open(file, varname)
time  = GPhys::IO.open(file, 't').val

GGraph.set_linear_contour_options( 'min'=>-25.0, 'max'=>25.0, \
                                   'interval'=>2.0 ) 
GGraph.set_linear_tone_options( 'min'=>-25.0, 'max'=>25.0, \
                                   'interval'=>1.0 ) 

# <Open DCL>
#DCL.swlset( 'ldump', true )
DCL.sgpset( 'lfull', true )
DCL.uzfact(0.7)
DCL.gropn(1)
GGraph.set_fig('viewport'=>[0.1,0.85,0.3,0.5])


for i in 0...time.length do
# <Drawing data by GGraph>
  GGraph.tone( var.cut(25600..44800,0,0..6400, time[i]), true, \
               'title'=>'W', 'annot'=>true)
  GGraph.contour( var.cut(25600..44800,0,0..6400, time[i]), false )
  GGraph.color_bar( 'labelintv'=>10, 'tickintv'=>5, 'landscape'=>true)
end

# <Close DCL>
DCL.grcls
