#= Makefile for deepconv/arare reference mannual.
#
# Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
# Version::   $Id: index.rd,v 1.5 2014-03-04 08:09:15 sugiyama Exp $
# Tag Name::  $Name:  $
# Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
# License::   See COPYRIGHT[link:../../COPYRIGHT]
#
#
########################################################################
#
=begin TOPLINK
[((<English|URL:index.htm.en>)) |
((<Japanese|URL:index.htm>))]
[((<GFD Dennou Club|URL:http://www.gfd-dennou.org>)) |
((<deepconv Project|URL:http://www.gfd-dennou.org/library/deepconv>))]
=end TOPLINK

=begin JA

= deepconv/arare5 ɥ

=end JA
=begin EN

= Deepconv/arare5 Documents

=end EN

=begin JA

== Ϥ

* ((<Ѿդȥ饤󥹵|URL:../CREDITS.htm>))
* ((<󥹥ȡμ|URL:../INSTALL.htm>))

== 塼ȥꥢ

* ((<餯 deepconv|URL:tutorial/gokuraku.htm>))
* ((<餯餯 deepconv|URL:tutorial/rakuraku.htm>))
#* ((<ɥե|URL:./code_reference.htm>))

== ޥ˥奢

* ((<ǥ|URL:./dai1bu/pub/teishiki.pdf>))
* ((<Υǥ|URL:./dai2bu/pub/main.pdf>))

=end JA


=begin EN

== Note 

The deepconv/arare5 is a developing model. And documentations are
mainly written in Japanese, and translated into English. The work is
always in progress and incomplete. If you have found inconvenience,
please report to ../htmltools/dcstaff_email.png

== Introduction

* ((<Precautionary statement and Licence terms|URL:../CREDITS.htm.en>))
* ((<"Deepconv/arare installation guide"|URL:../INSTALL.htm.en>))

== Tutorial

* ((<"Deepconv/arare user's guide: Basic"|URL:tutorial/gokuraku.htm>))
* ((<"Deepconv/arare user's guide: Advanced cource"|URL:tutorial/rakuraku.htm>))
* ((<"Introduction to NAMLIST file for Deepconv/arare"|URL:tutorial/namelist.htm>))
* ((<Source code reference|URL:./code_reference.htm.en>))

== Manual 

* ((<Basic equations|URL:./dai1bu/pub/teishiki.pdf>)) (sorry, Japanese only)
* ((<Discritization Methods|URL:./dai2bu/pub/main.pdf>)) (sorry, Japanese only)

=end EN


