module gms_input_func_var
  use datatype
  use mem_manager
  implicit none
  interface input_func_var
    module procedure input_func_var_x
    module procedure input_func_var_y
    module procedure input_func_var_z
    module procedure input_func_var_xy
    module procedure input_func_var_xz
    module procedure input_func_var_yz
    module procedure input_func_var_xyz
  end interface

contains
  subroutine input_func_var_x(func, var)
    type(var_x), intent(in) :: var
    integer :: i
    external func 
    real(8):: func 
        do i = 0, pub1 - plb1 - var%grid(1)
        work_x(i + var%grid(1), 1, 1,  var%id) & 
           = func( &
                    x_minimum + dx * (i + 0.5D0 * var%grid(1))  & 
                  ) 
        end do
    end subroutine input_func_var_x

  subroutine input_func_var_y(func, var)
    type(var_y), intent(in) :: var
    integer :: j
    external func 
    real(8):: func 
      do j = 0, pub2 - plb2 - var%grid(2)
        work_y(1, j + var%grid(2), 1,  var%id) & 
           = func( &
                    y_minimum + dy * (j + 0.5D0 * var%grid(2))  & 
                  ) 
      end do 
    end subroutine input_func_var_y

  subroutine input_func_var_z(func, var)
    type(var_z), intent(in) :: var
    integer :: k
    external func 
    real(8):: func 
    do k = 0, pub3 - plb3 - var%grid(3)
        work_z(1, 1, k + var%grid(3),  var%id) & 
           = func( &
                    z_minimum + dz * (k + 0.5D0 * var%grid(3))  & 
                  ) 
    end do
    end subroutine input_func_var_z

  subroutine input_func_var_xy(func, var)
    type(var_xy), intent(in) :: var
    integer :: i
    integer :: j
    external func 
    real(8):: func 
      do j = 0, pub2 - plb2 - var%grid(2)
        do i = 0, pub1 - plb1 - var%grid(1)
        work_xy(i + var%grid(1), j + var%grid(2), 1,  var%id) & 
           = func( &
                    x_minimum + dx * (i + 0.5D0 * var%grid(1)), &
                    y_minimum + dy * (j + 0.5D0 * var%grid(2))  & 
                  ) 
        end do
      end do 
    end subroutine input_func_var_xy

  subroutine input_func_var_xz(func, var)
    type(var_xz), intent(in) :: var
    integer :: i
    integer :: k
    external func 
    real(8):: func 
    do k = 0, pub3 - plb3 - var%grid(3)
        do i = 0, pub1 - plb1 - var%grid(1)
        work_xz(i + var%grid(1), 1, k + var%grid(3),  var%id) & 
           = func( &
                    x_minimum + dx * (i + 0.5D0 * var%grid(1)), &
                    z_minimum + dz * (k + 0.5D0 * var%grid(3))  & 
                  ) 
        end do
    end do
    end subroutine input_func_var_xz

  subroutine input_func_var_yz(func, var)
    type(var_yz), intent(in) :: var
    integer :: j
    integer :: k
    external func 
    real(8):: func 
    do k = 0, pub3 - plb3 - var%grid(3)
      do j = 0, pub2 - plb2 - var%grid(2)
        work_yz(1, j + var%grid(2), k + var%grid(3),  var%id) & 
           = func( &
                    y_minimum + dy * (j + 0.5D0 * var%grid(2)), &
                    z_minimum + dz * (k + 0.5D0 * var%grid(3))  & 
                  ) 
      end do 
    end do
    end subroutine input_func_var_yz

  subroutine input_func_var_xyz(func, var)
    type(var_xyz), intent(in) :: var
    integer :: i
    integer :: j
    integer :: k
    external func 
    real(8):: func 
    do k = 0, pub3 - plb3 - var%grid(3)
      do j = 0, pub2 - plb2 - var%grid(2)
        do i = 0, pub1 - plb1 - var%grid(1)
        work_xyz(i + var%grid(1), j + var%grid(2), k + var%grid(3),  var%id) & 
           = func( &
                    x_minimum + dx * (i + 0.5D0 * var%grid(1)), &
                    y_minimum + dy * (j + 0.5D0 * var%grid(2)), &
                    z_minimum + dz * (k + 0.5D0 * var%grid(3))  & 
                  ) 
        end do
      end do 
    end do
    end subroutine input_func_var_xyz

end module gms_input_func_var
