! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.

subroutine ANAttrInquire(var, attrname, xtype)
    use an_types, only: AN_VARIABLE, an_variable_entry
    use an_vartable, only: vtable_lookup
    use an_generic, only: ANXTypeName
    use an_file, only: INQUIRE
    use netcdf_f77, only: NF_MAX_NAME, nf_inq_atttype, NF_NOERR
    use dc_url, only: GT_PLUS
    implicit none
    type(AN_VARIABLE), intent(in):: var
    character(len=*), intent(in):: attrname
    character(len=*), intent(out), optional:: xtype
    type(an_variable_entry):: ent
    integer:: varid, i_xtype, stat
    character(len=NF_MAX_NAME):: anam
    stat = vtable_lookup(var, ent)
    if (stat /= NF_NOERR) return
    if (present(xtype)) then
        call inquire(var, attrname, varid, anam)
        stat = nf_inq_atttype(ent%fileid, varid, anam, xtype=i_xtype)
        if (stat /= NF_NOERR) i_xtype = 0
        call ANXTypeName(i_xtype, xtype)
    endif
end subroutine

! ºݤ˥Ȥ˻Ȥ varid, attrname 
! attrname Ƭ '+' ---> °ؼ
! attrname Ƭ '-' ---> ѿ°°νǸ
! ѤȤ use an_file, only: inquire Ƥ
!
subroutine ANAttrInquirePlus(var, attrname, varid, nf_attrname)
    use an_types, only: AN_VARIABLE, an_variable_entry
    use an_vartable, only: vtable_lookup
    use dc_url, only: GT_PLUS
    use netcdf_f77, only: NF_GLOBAL, nf_noerr, nf_inq_attlen
    type(AN_VARIABLE), intent(in):: var
    character(len=*), intent(in):: attrname
    integer, intent(out):: varid
    type(an_variable_entry):: ent
    character(len=*), intent(out):: nf_attrname
    integer:: stat, n
    stat = vtable_lookup(var, ent)
    if (stat /= NF_NOERR) return
    if (attrname(1:1) == GT_PLUS) then
        varid = NF_GLOBAL
        nf_attrname = attrname(2: )
    else if (attrname(1:1) == '-') then
        varid = ent%varid
        nf_attrname = attrname(2: )
        stat = nf_inq_attlen(ent%fileid, varid, nf_attrname, n)
        if (stat == NF_NOERR) return
        varid = NF_GLOBAL
    else
        varid = ent%varid
        nf_attrname = attrname
    endif
end subroutine
