!= 
!= Set time
!
! Authors::   Yasuhiro MORIKAWA, Eizi TOYODA
! Version::   $Id: historysettime.F90,v 1.3 2009-05-31 14:36:34 morikawa Exp $
! Tag Name::  $Name: gtool5-20090729 $
! Copyright:: Copyright (C) GFD Dennou Club, 2000-2009. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
  subroutine HistorySetTime(time, history, difftime)
    !
    !== 
    !
    ! Ū˻ԤʤΥ֥롼Ǥ
    ! Υ֥롼ѤˡHistoryCreate ˤ꤬ɬפǤ
    ! Υ֥롼Ѥ HistoryCreate  *interval* ̵
    ! ˤʤΤդƤ
    !
    !--
    ! ꤷƤ֤ǡᤷޤ᤿ꡣ
    ! ʤƤ֤ϸ򤷤ʤ褦ˤʤäƤ롣
    !++
    !
    use gtool_history_types, only: GT_HISTORY, GT_HISTORY_AXIS, GT_HISTORY_VARINFO, GT_HISTORY_ATTR
    use gtool_history_internal, only: default
    use gtdata_generic, only: Slice, Put, Get
    use gtdata_types, only: GT_VARIABLE
    use dc_date_generic, only: DCDiffTimeCreate, operator(<), operator(>), &
      & EvalByUnit, min, max, DCDiffTimePutLine
    use dc_date_types, only: DC_DIFFTIME
    use dc_trace, only: BeginSub, EndSub, DbgMessage, Debug
    use dc_types, only: STRING, TOKEN, DP
#ifdef LIB_MPI
    use mpi
#endif
    implicit none
    real, intent(in), optional:: time
                              ! 
                              ! 
                              ! Ǹ "" Ȥϡ
                              ! HistoryCreate  *dims*  "0"
                              ! Ȼꤵ줿ΤǤ
                              ! ⤷郎Ƥ
                              ! ϡ Υ֥롼
                              ! ϲθ̤ڤܤޤ
                              ! 
    type(GT_HISTORY), intent(inout), optional, target:: history
                              ! ϥե˴ؤ
                              ! Ǽ¤
                              ! 
                              ! ˻ꤹΤϡ
                              ! HistoryCreate ˤäƽ
                              ! ƤʤФʤޤ
                              ! 
    type(DC_DIFFTIME), intent(in), optional:: difftime
                              !  (dc_date_types#DC_DIFFTIME )
                              ! 
                              ! Ǹ "" Ȥϡ
                              ! HistoryCreate  *dims*  "0"
                              ! Ȼꤵ줿ΤǤ
                              ! ⤷郎Ƥ
                              ! ϡ Υ֥롼
                              ! ϲθ̤ڤܤޤ
                              ! 

    type(GT_HISTORY), pointer:: hst =>null()
    type(GT_VARIABLE):: var
    real, pointer:: buffer(:) =>null()
    type(DC_DIFFTIME):: dt
    real(DP):: timew
    logical:: err
#ifdef LIB_MPI
    integer:: err_mpi
#endif
    character(*), parameter:: subname = "HistorySetTime"
  continue
    call BeginSub(subname)

    if (present(history)) then
      hst => history
    else
      hst => default
    endif

    if ( present(time) ) call DbgMessage('time=%r', r = (/time/) )
    if ( present(difftime) .and. Debug() ) then
      timew = EvalByUnit( difftime, '', hst % unlimited_units_symbol )
      call DbgMessage('time=%f', d = (/timew/) )
    end if

    if (hst % unlimited_index == 0) then
      goto 999
    endif
    var = hst % dimvars(hst % unlimited_index)
    hst % dim_value_written(hst % unlimited_index) = .true.

    if ( present(difftime) ) then
      dt = difftime
      timew = EvalByUnit( dt, '', hst % unlimited_units_symbol )
    elseif ( present(time) ) then
      call DCDiffTimeCreate( dt, &                 ! (out)
        & time, '', hst % unlimited_units_symbol ) ! (in)
      timew = time
    end if

    if (      dt < hst % oldest &
      &  .or. dt > hst % newest &
      &  .or. hst % count(2) == 0 ) then

      hst % count(:) = maxval(hst % count(:)) + 1
      hst % newest = max(hst % newest, dt)
      hst % oldest = min(hst % oldest, dt)

#ifdef LIB_MPI
      if ( .not. hst % mpi_gather &
        &  .or. ( hst % mpi_gather .and. hst % mpi_myrank == 0 ) ) then
#endif

      call Slice(var, 1, start=hst % count(1), count=1)
      timew = EvalByUnit( dt, '', hst % unlimited_units_symbol )
      call Put(var, (/timew/), 1, err)
      if (err) call DumpError()

#ifdef LIB_MPI
      end if
#endif

      goto 999
    endif

#ifdef LIB_MPI
    if ( .not. hst % mpi_gather &
      &  .or. ( hst % mpi_gather .and. hst % mpi_myrank == 0 ) ) then
#endif

    call Slice(var, 1, start=1, count=hst % count(2))
    call Get(var, buffer, err)
    hst % count(1:1) = minloc(abs(buffer - timew))
    deallocate(buffer)

#ifdef LIB_MPI

      if ( hst % mpi_gather .and. hst % mpi_myrank == 0 ) then
        call MPI_Bcast( hst % count(1:1), 1, MPI_INTEGER, 0, MPI_COMM_WORLD, err_mpi )
      end if

    elseif ( hst % mpi_gather .and. hst % mpi_myrank /= 0 ) then
      call MPI_Bcast( hst % count(1:1), 1, MPI_INTEGER, 0, MPI_COMM_WORLD, err_mpi )
    end if
#endif

999 continue
    call EndSub(subname)
  end subroutine HistorySetTime
