subroutine GDNcFileSync(fileid, stat)
  use gtdata_netcdf_file_types, only: GD_NC_FILE_ID_ENTRY
  use gtdata_netcdf_file_internal, only: id_head, id_used
  use gtdata_netcdf_file_generic, only: GDNcFileDataMode
  use netcdf_f77, only: nf_sync, NF_NOERR
  use dc_error
  integer, intent(in), optional:: fileid
  integer, intent(out), optional:: stat
  integer:: ncid, mystat
  type(GD_NC_FILE_ID_ENTRY), pointer:: identptr
continue
  mystat = NF_NOERR
  if (present(fileid)) then
    ncid = fileid
    mystat = GDNcFileDataMode(ncid)
    if (mystat /= NF_NOERR) goto 999
    mystat = nf_sync(ncid)
  else if (id_used) then
    identptr => id_head
    do
      if (.not. associated(identptr)) exit
      ncid = identptr % id
      mystat = GDNcFileDataMode(ncid)
      if (mystat /= NF_NOERR) exit
      mystat = nf_sync(ncid)
      if (mystat /= NF_NOERR) exit
      identptr => identptr % next
    enddo
  endif
999 continue
  ! ȯŪˤ StoreError ʤStoreError  SysdepAbort
  ! ƤФǽ뤿Ǥ롣
  if (present(stat)) stat = mystat
end subroutine GDNcFileSync

