!= gtool_historyauto ν
!= Initialization of gtool_historyauto
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: historyautocreate.f90,v 1.7 2010-01-16 14:14:16 morikawa Exp $
! Tag Name::  $Name: gtool5-20101006 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved. 
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
  subroutine HistoryAutoCreate3( &
    & title, source, institution, &           ! (in)
    & dims, dimsizes, longnames, units, &     ! (in)
    & origin, terminus, &                     ! (in)
    & xtypes, conventions, gt_version, &      ! (in) optional
    & all_output, &                           ! (in) optional
    & file_prefix, &                          ! (in) optional
    & namelist_filename, &                    ! (in) optional
    & interval, &                             ! (in) optional
    & slice_start, slice_end, slice_stride, & ! (in) optional
    & space_average, &                        ! (in) optional
    & time_average, &                         ! (in) optional
    & newfile_interval, &                     ! (in) optional
    & rank, &                                 ! (in) optional
    & origin_date, origin_date_invalid, &     ! (in) optional
    & start_date, cal, &                      ! (in) optional
    & flag_mpi_gather, flag_mpi_split &       ! (in) optional
    & )
    !
    ! ʣΥǡϤԤνԤޤ. 
    !
    !  HistoryAutoCreate ˤ, ǥǽϤ
    ! ѿ¸ɸɸŤߤʤɤƤꤷƤ. 
    !
    ! all_output  .true. Ϳ,
    ! namelist_filename Ϳʤ (ʸͿ) ˤ, 
    ! HistoryAutoAddVariable ϿƤѿϤޤ. 
    !  namelist_filename  NAMELIST ե̾Ϳˤ, 
    !  NAMELIST ե뤫ϤΥ󥪥դ, 
    ! ϥե̾, ϴֳ֤ʤɤѹǽǤ. 
    ! ѹǽʹܤ˴ؤƤ NAMELIST#gtool_historyauto_nml 
    ! 򻲾ȤƲ. 
    !
    ! interval, origin, terminus, slice_start, slice_end, slice_stride,
    ! space_average, time_average, newfile_interval 
    ! ʤɤϥǥեͤȤƻѤޤ. 
    ! ͤ HistoryAutoAddVariable 
    ! NAMELIST#gtool_historyauto_nml Ǿ񤭤ޤ. 
    ! (ͥ٤⤤Τ NAMELIST#gtool_historyauto_nml ,
    ! HistoryAutoAddVariable ΰ, 
    ! HistoryAutoCreate ΰ νǤ). 
    !
    !
    ! Initialization for multiple history data output 
    !
    ! Set all axes and their weights depended by variables 
    ! output from numerical models to this "HistoryAutoCreate". 
    !
    ! All variables registered by "HistoryAutoAddVariable" 
    ! are output if .true. is given to "all_output" or 
    ! "namelist_filename" is not given (or blanks are given)
    ! On the other hand, if a filename of NAMELIST file is 
    ! given to "namelist_filename", on/off of output, 
    ! output filename and output interval, etc. can be changed 
    ! from the NAMELIST file. 
    ! For available items, see "NAMELIST#gtool_historyauto_nml". 
    !
    ! Settings about 
    ! "interval", "origin", "terminus", "slice_start", "slice_end", "slice_stride",
    ! "space_average", "time_average", "newfile_interval" 
    ! etc. are used as default values. 
    ! Their set values are overwritten by 
    ! "HistoryAutoAddVariable" or 
    ! "NAMELIST#gtool_historyauto_nml". 
    ! ("NAMELIST#gtool_historyauto_nml" is high priority, 
    ! arguments of "HistoryAutoAddVariable" are medium, 
    ! arguments of "HistoryAutoCreate" are low). 
    !
    use gtool_historyauto_internal, only: initialized, version, sub_sname, &
      & zero_time, numdims, &
      & title_save, source_save, institution_save, conventions_save, &
      & gt_version_save, rank_save, save_mpi_split, save_mpi_gather, &
      & time_unit_bycreate, time_unit_suffix, gthst_axes, data_axes, &
      & all_output_save, gthstnml, cal_save
    use gtool_history, only: HistoryAxisCreate, HistoryAxisAddAttr
    use gtool_history_nmlinfo_generic, only: HstNmlInfoCreate, HstNmlInfoAdd, &
      & HstNmlInfoEndDefine, HstNmlInfoPutLine, HstNmlInfoAllNameValid, &
      & HstNmlInfoInquire
    use dc_trace, only: BeginSub, EndSub
    use dc_error, only: StoreError, DC_NOERR, DC_EALREADYINIT, &
      & GT_EARGSIZEMISMATCH, HST_ENOTIMEDIM, DC_ENEGATIVE
    use netcdf_f77, only: NF_EMAXDIMS, NF_MAX_DIMS
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_present, only: present_and_not_empty, present_and_true, &
      & present_select
    use dc_calendar, only: DC_CAL, DC_CAL_DATE, &
      & DCCalDateInquire, DCCalInquire, DCCalDefault
    use dc_date, only: DCDiffTimeCreate, EvalbyUnit, toChar, toCharCal, Eval
    use dc_date_types, only: DC_DIFFTIME, DC_DATETIME
    use dc_message, only: MessageNotify
    use dc_iounit, only: FileOpen
    use dc_types, only: DP, STRING, TOKEN
    implicit none
    character(*), intent(in):: title
                              ! ǡΤɽ. 
                              ! Title of entire data
    character(*), intent(in):: source
                              ! ǡݤμ. 
                              ! Source of data file
    character(*), intent(in):: institution
                              ! եǽŪѹȿ/Ŀ. 
                              ! Institution or person that changes files for the last time
    character(*), intent(in):: dims(:)
                              ! ̾. 
                              ! 
                              ! 礭¤Ϥޤ.
                              ! ġμʸ dc_types#TOKEN ޤ.
                              ! ʸ
                              ! ƱǤʤФʤޤ.
                              ! ­ʤʸʬ϶
                              ! äƤ.
                              ! 
                              ! Names of dimensions.
                              ! 
                              ! Length of array is unlimited. 
                              ! Limits of numbers of characters of each 
                              ! dimensions are "dc_types#TOKEN". 
                              ! Numbers of characters in this array
                              ! must be same. 
                              ! Make up a deficit with blanks. 
                              ! 
    integer, intent(in):: dimsizes (:)
                              ! dims ǻꤷ줾μ礭. 
                              ! 
                              ! 礭 dims 礭
                              ! ɬפޤ.  '0' (Υ) 
                              ! Ȥμ ̵¼ (unlimited
                              ! dimension) Ȥʤޤ. (gtool_history 
                              ! Ǥϻ֤μФ̵¼
                              ! Ѥ뤳ȤꤷƤޤ). , 
                              ! 1 Ĥ NetCDF ե (С 3) 
                              ! Ϻ 1 Ĥ̵¼ƤʤΤ, 
                              ! 2 ʾ '0' ꤷʤǤ. 
                              ! ξ,  gtool4 ǡϤޤ.
                              ! 
                              ! Lengths of dimensions specified with "dims". 
                              ! 
                              ! Length of this array must be same as 
                              ! length of "dim".  If '0' (zero) is 
                              ! specified, the dimension is treated as 
                              ! unlimited dimension.  
                              ! (In "gtool_history", unlimited dimension is 
                              ! expected to be used as time). 
                              ! Note that one NetCDF file (version 3) 
                              ! can not have two or more unlimited 
                              ! dimensions, so that do not specify '0' 
                              ! to two or more places. In that case, 
                              ! gtoo4 data is not output currently 
                              ! 
    character(*), intent(in):: longnames (:)
                              ! dims ǻꤷ줾μ̾. 
                              !
                              ! 礭 dims 礭
                              ! ɬפޤ. ʸ
                              !  dc_types#STRING ޤ.
                              ! ʸ
                              ! ƱǤʤФʤޤ.
                              ! ­ʤʸʬ϶䤤ޤ.
                              ! 
                              ! Names of dimensions specified with "dims". 
                              !
                              ! Length of this array must be same as 
                              ! length of "dim".  
                              ! Limits of numbers of characters are 
                              ! "dc_types#STRING". 
                              ! Numbers of characters in this array
                              ! must be same. 
                              ! Make up a deficit with blanks. 
                              ! 
    character(*), intent(in):: units(:)
                              ! dims ǻꤷ줾μñ. 
                              !
                              ! 礭 dims 礭
                              ! ɬפޤ. ʸ
                              !  dc_types#STRING ޤ.
                              ! ʸ
                              ! ƱǤʤФʤޤ.
                              ! ­ʤʸʬ϶䤤ޤ.
                              ! 
                              ! Units of dimensions specified with "dims". 
                              !
                              ! Length of this array must be same as 
                              ! length of "dim".  
                              ! Limits of numbers of characters are 
                              ! "dc_types#STRING". 
                              ! Numbers of characters in this array
                              ! must be same. 
                              ! Make up a deficit with blanks. 
                              ! 
    type(DC_DIFFTIME), intent(in):: origin
                              ! ϳϻ. 
                              !
                              ! Start time of output. 
                              !
    type(DC_DIFFTIME), intent(in):: terminus
                              ! Ͻλ. 
                              !
                              ! End time of output. 
                              ! 
    character(*), intent(in),  optional:: xtypes(:)
                              ! dims ǻꤷ줾
                              ! Υǡ. 
                              !
                              ! ǥեȤ float (ñټ¿)
                              ! Ǥ. ͭʤΤ,
                              ! double (ټ¿), 
                              ! int () Ǥ. ꤷʤ
                              ! , ̵ʷꤷˤ,
                              ! float Ȥʤޤ. ʤ, 礭
                              !  *dims* 礭ɬפ
                              ! ޤ. ʸ
                              ! ƱǤʤФʤޤ.
                              ! ­ʤʸʬ϶䤤ޤ.
                              !
                              ! Data types of dimensions specified 
                              ! with "dims". 
                              !
                              ! Default value is "float" (single precision). 
                              ! Other valid values are 
                              ! "double" (double precision), 
                              ! "int" (integer). 
                              ! If no value or invalid value is specified, 
                              ! "float" is applied. 
                              ! Length of this array must be same as 
                              ! length of "dim".  
                              ! Numbers of characters in this array
                              ! must be same. 
                              ! Make up a deficit with blanks. 
                              ! 
    character(*), intent(in), optional:: conventions
                              ! Ϥե netCDF
                              ! 
                              !
                              ! ά,
                              ! ⤷϶ʸͿ,
                              ! Ϥ netCDF 
                              ! Conventions °
                              ! gtool4_netCDF_Conventions
                              ! ưŪͿޤ.
                              ! 
                              ! NetCDF conventions of output file. 
                              !
                              ! If this argument is omitted or, 
                              ! blanks are given,
                              ! gtool4_netCDF_Conventions is given to 
                              ! attribute "Conventions" of an output file
                              ! automatically. 
                              ! 
    character(*), intent(in), optional:: gt_version
                              ! gtool4 netCDF ΥС
                              !
                              ! ά, gt_version °
                              ! κǿǤΥСʥС
                              ! gtool4_netCDF_version
                              ! Ϳޤ.
                              ! (,  conventions 
                              ! gtool4_netCDF_Conventions
                              ! ʳͿ
                              ! gt_version °ޤ).
                              ! 
                              ! Version of gtool4 netCDF Conventions. 
                              !
                              ! If this argument is omitted, 
                              ! latest version number of gtool4 netCDF 
                              ! Conventions is given to attribute 
                              ! "gt_version" of an output file 
                              ! (However, gtool4_netCDF_Conventions is 
                              ! not given to an argument "conventions", 
                              ! attribute "gt_version" is not created).
                              ! 
    logical, intent(in), optional:: all_output
                              ! ϿѿƽϤ뤿Υե饰. 
                              !
                              ! .true. ꤹ, 
                              ! HistoryAutoAddVariable Ͽ줿
                              ! ѿƽϤ褦ˤʤޤ. 
                              !
                              ! *namelist_filename* ꤵ
                              ! ˤ, ǥեȤ .false. Ȥʤޤ. 
                              ! ξˤ, 
                              ! *namelist_filename* ˻ꤵ줿 
                              ! NAMELIST ե뤫ɤ߹ޤ
                              ! NAMELIST#gtool_historyauto_nml
                              ! ǻꤵ줿ѿΤ߽Ϥޤ.
                              !
                              ! *namelist_filename* ꤵʤ
                              ! ˤ, .true. Ȥʤޤ. 
                              !
                              !
                              ! Flag for output all registered variables. 
                              ! 
                              ! When .true. is specified, 
                              ! all variables registered by
                              ! "HistoryAutoAddVariable" are output. 
                              ! 
                              ! If *namelist_filename* is specified, 
                              ! default value becomes .false. .
                              ! In this case, 
                              ! only variables specified in 
                              ! "NAMELIST#gtool_historyauto_nml"
                              ! loaded from a NAMELIST file
                              ! *namelist_filename*. 
                              ! 
                              ! If *namelist_filename* is not specified, 
                              ! this value becomes .true. .
                              ! 
    character(*), intent(in), optional:: file_prefix
                              ! ǡΥե̾Ƭ. 
                              ! Prefixes of history data filenames
    character(*), intent(in), optional:: namelist_filename
                              ! NAMELIST ե̾. 
                              !
                              ! ά, ⤷϶ʸͿ, 
                              ! NAMELIST եɤ߹ߤޤ. 
                              ! 
                              ! Name of NAMELIST file. 
                              !
                              ! If this argument is omitted, 
                              ! or blanks are specified, 
                              ! no NAMELIST file is loaded. 
                              ! 
    type(DC_DIFFTIME), intent(in), optional:: interval
                              ! ϻֳִ. 
                              !
                              ! ά, 
                              ! ưŪ 1.0 [sec] ꤵޤ.
                              !
                              ! Interval of output time. 
                              !
                              ! If this argument is omitted, 
                              ! 1.0 [sec] is specified 
                              ! automatically. 
                              ! 
    integer, intent(in), optional:: slice_start(:)
                              ! γ. 
                              !
                              ! ά, ɸǡγꤵޤ.
                              ! 
                              ! Start points of spaces. 
                              ! 
                              ! If this argument is omitted, 
                              ! start points of dimensions are set. 
                              ! 
    integer, intent(in), optional:: slice_end(:)
                              ! νλ. 
                              !
                              ! ά, ⤷ͤͿ, 
                              ! ɸǡνλꤵޤ.
                              ! 
                              ! End points of spaces. 
                              ! 
                              ! If this argument is omitted or
                              ! negative value is specified, 
                              ! end points of dimensions are set. 
                              ! 
    integer, intent(in), optional:: slice_stride(:)
                              ! ι. 
                              !
                              ! ά, 1 ꤵޤ.
                              ! 
                              ! Strides of spaces
                              ! 
                              ! If this argument is omitted, 
                              ! 1 is set. 
                              ! 
    logical, intent(in), optional:: space_average(:)
                              ! ʿѲΥե饰. 
                              !
                              ! .true. ꤵɸФʿѲ
                              ! Ԥޤ. 
                              ! ά, .false. ꤵޤ.
                              ! 
                              ! Flag of average. 
                              ! 
                              ! Axes specified .true. are averaged. 
                              ! If this argument is omitted, 
                              ! .false. is set. 
                              ! 
    logical, intent(in), optional:: time_average
                              ! ϥǡλʿѥե饰. 
                              ! ǥեȤ .false. 
                              ! Flag for time average of output data
                              ! Default value is .false.
    integer, intent(in), optional:: newfile_interval
                              ! եʬֳִ. 
                              !
                              ! ά, 
                              ! ؤΥեʬԤޤ. 
                              !
                              ! Interval of time of separation of a file. 
                              !
                              ! If this argument is omitted, 
                              ! a files is not separated in time direction.
                              ! 
    character(*), intent(in), optional:: rank
                              ! 󥯤̾. 
                              !
                              ! Name of a rank. 
                              !
    type(DC_DATETIME), intent(in), optional:: origin_date
                              ! ϳ. 
                              ! ΰѻͽΤ, start_date ѤƲ. 
                              !
                              ! Start date of output. 
                              ! Use "start_date" because this argument is obsolete.
                              !
    logical, intent(in), optional:: origin_date_invalid
                              ! .true. Ϳ, origin_date ̵ˤޤ. 
                              !
                              ! If ".true." is given, "origin_date" is ignored. 
    type(DC_CAL_DATE), intent(in), optional:: start_date
                              ! ϳ. 
                              !
                              ! Start date of output. 
                              !
    type(DC_CAL), intent(in), optional:: cal
                              ! . 
                              ! ꤷʤ, dc_calendar ⥸塼
                              ! ǥեȤ񤬻Ѥޤ. 
                              !
                              ! Calendar. 
                              ! If this argument is specified, default calendar in 
                              ! "dc_calendar" module is used. 
                              !
    logical, intent(in), optional:: flag_mpi_gather
                              ! MPI ѻ, ƥΡɤ HistoryPut
                              ! ͿǡĤΥե礷ƽ
                              ! ˤ .true. ͿƤ. 
                              ! ǥեȤ .false. Ǥ. 
                              ! 
                              ! .true. Ϳ, HistoryPutAxisMPI
                              ! ΤμǡͿƤ. 
                              !
                              ! When MPI is used, if ".true." is given, 
                              ! data given to "HistoryPut" on each node
                              ! is integrated and output to one file. 
                              ! Default value is ".false.".
                              ! 
                              ! If .true. is given, give data of axes in
                              ! whole area to "HistoryPutAxisMPI"
                              ! 
    logical, intent(in), optional:: flag_mpi_split
                              ! MPI ѻ, ƥΡɤ HistoryPut
                              ! Ϳǡ򤽤줾̾Υե
                              ! Ϥˤ .true. ͿƤ. 
                              ! ǥեȤ .false. Ǥ. 
                              !
                              ! When MPI is used, if ".true." is given, 
                              ! data given to "HistoryPut" on each node
                              ! is split into discrete files. 
                              ! Default value is ".false.".
                              ! 


    ! NAMELIST ѿ ; NAMELIST group of variables
    character(STRING):: Name
                              ! ѿ̾. 
                              ! ξˤ, ¾ͤ
                              ! gtool_historyauto ⥸塼ˤ
                              ! ϤǡƤ
                              ! ǥեͤȤʤޤ. 
                              ! 
                              ! "Data1,Data2" Τ褦˥ޤǶڤäʣ
                              ! ѿꤹ뤳ȤǽǤ. 
                              ! 
                              ! Variable identifier. 
                              ! If blank is given, other values are 
                              ! used as default values of output data 
                              ! in "gtool_historyauto". 
                              ! 
                              ! Multiple variables can be specified 
                              ! as "Data1,Data2" too. Delimiter is comma. 
    character(STRING):: File
                              ! ϥե̾. 
                              ! ϥǥեͤȤƤϻѤޤ. 
                              ! *Name* ͤꤵƤΤͭǤ. 
                              ! 
                              ! Output file name. 
                              ! This is not used as default value. 
                              ! This value is valid only when *Name* is 
                              ! specified. 

    real(DP):: IntValue
                              ! ǡνϴֳ֤ο. 
                              ! ͤͿ, Ϥ޻ߤޤ. 
                              ! Numerical value for interval of history data output
                              ! Negative values suppresses output.
    character(TOKEN):: IntUnit
                              ! ǡνϴֳ֤ñ. 
                              ! Unit for interval of history data output
    character(TOKEN):: Precision
                              ! ǡ. 
                              ! ǥեȤ float (ñټ¿)
                              ! Ǥ. ͭʤΤ,
                              ! double (ټ¿), 
                              ! int () Ǥ. ꤷʤ
                              ! , ̵ʷꤷˤ,
                              ! float Ȥʤޤ. 
                              ! 
                              ! Precision of history data
                              ! Default value is "float" (single precision). 
                              ! Other valid values are 
                              ! "double" (double precision), 
                              ! "int" (integer). 
                              ! If no value or invalid value is specified, 
                              ! "float" is applied. 
    character(STRING):: FilePrefix
                              ! ǡΥե̾Ƭ. 
                              ! Prefixes of history data filenames
    logical:: TimeAverage
                              ! ϥǡλʿѥե饰. 
                              ! 
                              ! ".true." Ϳ, ʿͤϤޤ. 
                              ! 
                              ! Flag for time average of output data
                              ! 
                              ! If ".ture." is specified, 
                              ! time average values are output. 
                              ! 
    logical:: AllOutput
                              ! ϿѿƽϤ뤿Υե饰. 
                              ! Flag for output all registered variables. 
    real(DP):: OriginValue
                              ! ϳϻ. 
                              ! Start time of output. 
    character(TOKEN):: OriginUnit
                              ! ϳϻñ. 
                              ! Unit of start time of output. 
    real(DP):: TerminusValue
                              ! Ͻλ. 
                              ! End time of output. 
    character(TOKEN):: TerminusUnit
                              ! Ͻλñ. 
                              ! Unit of end time of output. 
    integer:: SliceStart(1:NF_MAX_DIMS)
                              ! γ. 
                              ! Start points of spaces. 
    integer:: SliceEnd(1:NF_MAX_DIMS)
                              ! νλ. 
                              !
                              ! ά, ⤷ͤͿ, 
                              ! ɸǡνλꤵޤ.
                              ! 
                              ! End points of spaces. 
                              ! 
                              ! If this argument is omitted or
                              ! negative value is specified, 
                              ! end points of dimensions are set. 
                              ! 
    integer:: SliceStride(1:NF_MAX_DIMS)
                              ! ι. 
                              ! Strides of spaces. 
    logical:: SpaceAverage(1:NF_MAX_DIMS)
                              ! ʿѤΥե饰. 
                              ! Flag of spatial average. 
    integer:: NewFileIntValue
                              ! եʬֳִ֤ο. 
                              ! Numerical value for interval of time of separation of a file. 
    character(TOKEN):: NewFileIntUnit
                              ! եʬֳִ֤ñ. 
                              ! Unit of interval of time of separation of a file. 

    namelist /gtool_historyauto_nml/ &
      & Name, File, &
      & IntValue, IntUnit, &
      & Precision, &
      & FilePrefix, &
      & TimeAverage, AllOutput, &
      & OriginValue, OriginUnit, &
      & TerminusValue, TerminusUnit, &
      & SliceStart, SliceEnd, SliceStride, SpaceAverage, &
      & NewFileIntValue, NewFileIntUnit
                              ! gtool_historyauto ⥸塼Υǡ
                              ! NAMELIST ѿ̾. 
                              !
                              ! gtool_historyauto_generic#HistoryAutoCreate
                              ! Ѥݤ, ץʥ *namelist_filename* 
                              !  NAMELIST ե̾ꤹ뤳Ȥ, 
                              ! Υե뤫餳 NAMELIST ѿ
                              ! ɤ߹ߤޤ. 
                              !
                              ! NAMELIST group name for 
                              ! history data of "gtool_historyauto" module. 
                              ! 
                              ! If a NAMELIST filename is specified to 
                              ! an optional argument *namelist_filename* when 
                              ! "gtool_historyauto_generic#HistoryAutoCreate" 
                              ! is used, this NAMELIST group is 
                              ! loaded from the file. 


    ! ѿ ; Work variables
    integer:: blank_index
    integer:: stat
    character(STRING):: cause_c
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read
    character(TOKEN):: pos_nml
                              ! NAMELIST ɤ߹߻Υե. 
                              ! File position of NAMELIST read
    integer:: i, j
    character(TOKEN):: my_xtype

    real(DP):: interval_work, origin_work, terminus_work
    integer:: date_day
    real(DP):: date_sec
    integer:: msnot_rank
    character(STRING):: date_str
    character(TOKEN):: cal_str, cal_type
    integer:: origin_year, origin_month, origin_day, origin_hour, origin_min
    real(DP):: origin_sec
    integer:: month_in_year, hour_in_day, min_in_hour
    integer, pointer:: day_in_month(:) =>null()
    real(DP):: sec_in_min
    character(*), parameter:: subname = "HistoryAutoCreate3"
  continue
    call BeginSub(subname, version = version)
    stat = DC_NOERR
    cause_c = ""

    ! Υ֥롼 2 ٸƤФ줿饨顼
    ! Error is occurred when this subroutine is called twice
    !
    if ( initialized ) then
      stat = DC_EALREADYINIT
      cause_c = 'gtool_historyauto'
      goto 999
    end if

    ! äκ. 
    ! Create zero seconds
    !
    zero_time = 0.0_DP
!!$    call DCDiffTimeCreate( &
!!$      & zero_time, &        ! (out)
!!$      & sec = 0.0_DP  )     ! (in)

    ! ο˴ؤ륨顼
    ! Error handling for number of dimensions
    !
    numdims = size(dims)

    if ( size(dimsizes) /= numdims ) then
      cause_c = 'dimsizes, dims'
    elseif ( size(longnames) /= numdims ) then
      cause_c = 'longnames, dims'
    elseif ( size(units) /= numdims ) then
      cause_c = 'units, dims'
    endif
    if ( trim(cause_c) /= "" ) then
      stat = GT_EARGSIZEMISMATCH
      goto 999
    end if

    if ( numdims > NF_MAX_DIMS ) then
      stat = NF_EMAXDIMS
      goto 999
    end if

    ! Ａ˴ؤ륨顼
    ! Error handling for time dimension
    !
    if ( dimsizes(numdims) /= 0 ) then
      call MessageNotify( 'W', subname, &
        & 'time dimension must be specified to the last of "dims"' )
      stat = HST_ENOTIMEDIM
      goto 999
    end if

    ! ϥեδܥ᥿ǡݴ
    ! Save basic meta data for output file
    !
    title_save       = title
    source_save      = source
    institution_save = institution

    conventions_save = ''
    if ( present(conventions) ) conventions_save = conventions

    gt_version_save = ''
    if ( present(gt_version) ) gt_version_save = gt_version

    rank_save = ''
    if ( present(rank) ) rank_save = rank

    ! MPI ˴ؤݴ
    ! Save information about MPI
    !
    save_mpi_split  = present_and_true( flag_mpi_split )
    save_mpi_gather = present_and_true( flag_mpi_gather )

    msnot_rank = -1
    if ( save_mpi_gather ) msnot_rank = 0

    ! ñ̤Υå
    ! Check units of time
    !
    time_unit_bycreate = units(numdims)
    time_unit_suffix = ''
    blank_index = index( trim( adjustl(time_unit_bycreate) ), ' ' )
    if ( blank_index > 1  ) then
      time_unit_suffix = time_unit_bycreate(blank_index+1:)
      time_unit_bycreate = time_unit_bycreate(1:blank_index-1)
    end if

    ! ɸǡݴ
    ! Save axes data
    !
    do i = 1, numdims
      my_xtype = ''
      if ( present(xtypes) ) then
        if ( size(xtypes) >= i ) then
          my_xtype = xtypes(i)
        end if
      end if

      call HistoryAxisCreate( &
        &     axis = gthst_axes(i), &                     ! (out)
        &     name = dims(i),       size = dimsizes(i), & ! (in)
        & longname = longnames(i), units = units(i), &    ! (in)
        &    xtype = my_xtype )                           ! (in)

      allocate( data_axes(i) % a_axis( dimsizes(i) ) )
      data_axes(i) % a_axis = (/ ( real( j, DP ), j = 1, dimsizes(i) ) /)

    end do

    ! Ͽ
    ! Register calendar
    !
    if ( present(cal) ) then
      cal_save = cal
    else
      call DCCalDefault( cal_save )
    end if

    ! λ
    ! Specify date
    !
    if ( present(start_date) ) then

      call DCCalDateInquire( &
        & date_str = date_str, &   ! (out)
        & date     = start_date, & ! (in) optional
        & cal      = cal &         ! (in) optional
        !    & , zone = "+09:00" &
        & )        ! (in) optional

      call DCCalDateInquire( &
        & origin_year, origin_month, origin_day, & ! (out) optional
        & origin_hour, origin_min,   origin_sec, & ! (out) optional
        & date     = start_date, & ! (in) optional
        & cal      = cal &         ! (in) optional
        & )

      call DCCalInquire( &
        & cal_str, &                          ! (out) optional
        & month_in_year    = month_in_year, & ! (out) optional
        & day_in_month_ptr = day_in_month , & ! (out) optional
        & hour_in_day      = hour_in_day  , & ! (out) optional
        & min_in_hour      = min_in_hour  , & ! (out) optional
        & sec_in_min       = sec_in_min   , & ! (out) optional
        & cal = cal_save )                    ! (in) optional

      ! ϵξΤ units ° "since ..." ղ
      !
      select case ( trim(cal_str) )
      case ( 'gregorian' )
        time_unit_suffix = trim(time_unit_suffix) // &
          & ' since ' // trim(date_str)
      case ( 'julian' )
        time_unit_suffix = trim(time_unit_suffix) // &
          & ' since ' // trim(date_str)
      case ( 'noleap' )
        time_unit_suffix = trim(time_unit_suffix) // &
          & ' since ' // trim(date_str)
      case ( '360day' )
        time_unit_suffix = trim(time_unit_suffix) // &
          & ' since ' // trim(date_str)
      case ( 'cyclic' )
        time_unit_suffix = trim(time_unit_suffix) // &
          & ' since ' // trim(date_str)
      end select

      ! Ϳ
      !
      call HistoryAxisAddAttr( &
        & axis = gthst_axes(numdims), &    ! (inout)
        & attrname = 'origin', &           ! (in)
        & value = 'origin_year origin_month origin_day ' // &
        &         'origin_hour origin_min origin_sec' )    ! (in)

      call HistoryAxisAddAttr( gthst_axes(numdims), 'origin_year',  origin_year )
      call HistoryAxisAddAttr( gthst_axes(numdims), 'origin_month', origin_month )
      call HistoryAxisAddAttr( gthst_axes(numdims), 'origin_day',   origin_day )
      call HistoryAxisAddAttr( gthst_axes(numdims), 'origin_hour',  origin_hour )
      call HistoryAxisAddAttr( gthst_axes(numdims), 'origin_min',   origin_min )

      ! Ϳ
      !
      call HistoryAxisAddAttr( &
        & axis = gthst_axes(numdims), &    ! (inout)
        & attrname = 'calendar', &         ! (in)
        & value = cal_str )                ! (in)

      if ( trim(cal_str) == 'user_defined' ) then
        call HistoryAxisAddAttr( gthst_axes(numdims), 'month_in_year', month_in_year )
        call HistoryAxisAddAttr( gthst_axes(numdims), 'day_in_month',  day_in_month )
        call HistoryAxisAddAttr( gthst_axes(numdims), 'hour_in_day',   hour_in_day )
        call HistoryAxisAddAttr( gthst_axes(numdims), 'min_in_hour',   min_in_hour )
        call HistoryAxisAddAttr( gthst_axes(numdims), 'sec_in_min',    sec_in_min )
      end if

      deallocate( day_in_month )

    elseif ( present(origin_date) &
      &  .and. .not. present_and_true(origin_date_invalid) ) then
      call Eval( origin_date, &            ! (in)
        & day = date_day, sec = date_sec ) ! (out)
      if ( date_day /= 0 .or. date_sec /= 0.0 ) then
        time_unit_suffix = trim(time_unit_suffix) // &
          & ' since ' // toChar(origin_date)

        call HistoryAxisAddAttr( &
          & axis = gthst_axes(numdims), &    ! (inout)
          & attrname = 'calendar', &         ! (in)
          & value = toCharCal(origin_date) ) ! (in)

      end if
    end if

    ! ϿѿƽϤ뤿Υե饰ݴ
    ! Save flag for output all registered variables
    !
    if ( present(all_output) ) all_output_save = all_output
    if ( .not. present_and_not_empty(namelist_filename) ) all_output_save = .true.
    AllOutput = all_output_save

    ! ϻֳִ֤Υǥե
    ! Configure default interval of output time
    !
    if ( all_output_save ) then
      if ( present(interval) ) then
        interval_work = EvalbyUnit( interval, time_unit_bycreate )
      else
        interval_work = 1.0
      end if
    else
      interval_work = - 1.0
    end if

    ! ϳϡλΥǥե
    ! Configure default origin/terminus time of output
    !
    origin_work = EvalbyUnit( origin, 'sec' )
    terminus_work = EvalbyUnit( terminus, time_unit_bycreate )

    ! gtool_historyauto_nml إǥեͤ
    ! Configure default values for "gtool_historyauto_nml"
    !
    call HstNmlInfoCreate( gthstnml ) ! (out)

    call HstNmlInfoAdd( &
      & gthstnml = gthstnml, &                  ! (inout)
      & name = '', &                            ! (in) optional
      & precision = 'float', &                  ! (in) optional
      & fileprefix = file_prefix, &             ! (in) optional
      & interval_value = interval_work, &       ! (in) optional
      & interval_unit  = time_unit_bycreate, &  ! (in) optional
      & origin_value   = origin_work, &         ! (in) optional
      & origin_unit    = 'sec', &               ! (in) optional
!!$      & origin_unit    = time_unit_bycreate, &  ! (in) optional
      & terminus_value = terminus_work, &       ! (in) optional
      & terminus_unit  = time_unit_bycreate, &  ! (in) optional
      & time_average = time_average, &          ! (in) optional
      & slice_start  = slice_start, &           ! (in) optional
      & slice_end    = slice_end, &             ! (in) optional
      & slice_stride = slice_stride, &          ! (in) optional
      & space_average = space_average, &        ! (in) optional
      & newfile_intvalue = newfile_interval, &  ! (in) optional
      & newfile_intunit = time_unit_bycreate )  ! (in) optional

    ! NAMELIST եɤ߹
    ! Load NAMELIST file
    !
    if ( present_and_not_empty(namelist_filename) ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)
      
      iostat_nml = 0
      pos_nml = ''

      call MessageNotify( 'M', sub_sname, '----- "gtool_historyauto_nml" is loaded from "%c" -----', &
        & c1 = trim(namelist_filename), rank_mpi = msnot_rank )

      do while ( trim(pos_nml) /= 'APPEND' .and. iostat_nml == 0 )

        Name = ''
        File = ''
        call HstNmlInfoInquire( &
          & gthstnml = gthstnml, &             ! (in)
          & interval_value = IntValue, &       ! (out) optional
          & interval_unit = IntUnit, &         ! (out) optional
          & precision = Precision, &           ! (out) optional
          & time_average = TimeAverage, &      ! (out) optional
          & origin_value   = OriginValue, &    ! (out) optional
          & origin_unit    = OriginUnit, &     ! (out) optional
          & terminus_value = TerminusValue, &  ! (out) optional
          & terminus_unit  = TerminusUnit, &   ! (out) optional
          & slice_start  = SliceStart, &       ! (out) optional
          & slice_end    = SliceEnd, &         ! (out) optional
          & slice_stride = SliceStride, &      ! (out) optional
          & space_average = SpaceAverage, &    ! (out) optional
          & newfile_intvalue = NewFileIntValue, & ! (out) optional
          & newfile_intunit  = NewFileIntUnit, &  ! (out) optional
          & fileprefix = FilePrefix )          ! (out) optional

        read( unit = unit_nml, &            ! (in)
          &    nml = gtool_historyauto_nml, & ! (out)
          & iostat = iostat_nml )           ! (out)
        inquire( unit = unit_nml, & ! (in)
          &  position = pos_nml )   ! (out)

        if ( iostat_nml == 0 ) then

          ! NAMELIST Ϳ줿̵ͤʾ, ǥեͤ
          ! Default values are used when values from NAMELIST are invalid
          !
          if ( .not. IntValue > 0.0 ) then
            IntValue = interval_work
            IntUnit  = time_unit_bycreate
          end if
          if ( .not. OriginValue > 0.0 ) then
            OriginValue = origin_work
            OriginUnit  = 'sec'
          end if
          if ( .not. TerminusValue > 0.0 ) then
            TerminusValue = terminus_work
            TerminusUnit  = time_unit_bycreate
          end if

          ! Ͽ
          ! Register information
          !
          call HstNmlInfoAdd( &
            & gthstnml = gthstnml, &             ! (inout)
            & name = Name, &                     ! (in) optional
            & file = File, &                     ! (in) optional
            & interval_value = IntValue, &       ! (in) optional
            & interval_unit = IntUnit, &         ! (in) optional
            & precision = Precision, &           ! (in) optional
            & time_average = TimeAverage, &      ! (in) optional
            & origin_value   = OriginValue, &    ! (in) optional
            & origin_unit    = OriginUnit, &     ! (in) optional
            & terminus_value = TerminusValue, &  ! (in) optional
            & terminus_unit  = TerminusUnit, &   ! (in) optional
            & slice_start  = SliceStart, &       ! (in) optional
            & slice_end    = SliceEnd, &         ! (in) optional
            & slice_stride = SliceStride, &      ! (in) optional
            & space_average = SpaceAverage, &    ! (in) optional
            & newfile_intvalue = NewFileIntValue, & ! (in) optional
            & newfile_intunit  = NewFileIntUnit, &  ! (in) optional
            & fileprefix = FilePrefix )          ! (in) optional

          ! ϿѿƽϤ뤿Υե饰ݴ
          ! Save flag for output all registered variables
          !
          if ( trim(Name) == '' ) then
            all_output_save = AllOutput
          end if

          !  ; Print
          !
          if ( trim(File) == '' ) File = trim(FilePrefix) // '<Name>.nc'

          if ( trim(Name) == '' ) then
            call MessageNotify( 'M', sub_sname, 'Global Settings:', rank_mpi = msnot_rank )
            call MessageNotify( 'M', sub_sname, '  AllOutput       = %b', l  = (/ AllOutput   /), rank_mpi = msnot_rank )
            call MessageNotify( 'M', sub_sname, '  FilePrefix      = %c', c1 = trim(FilePrefix   ), rank_mpi = msnot_rank )
          else
            call MessageNotify( 'M', sub_sname, 'Individual Settings:', rank_mpi = msnot_rank )
            call MessageNotify( 'M', sub_sname, '  Name            = %c', c1 = trim(Name           ), rank_mpi = msnot_rank )
            call MessageNotify( 'M', sub_sname, '  File            = %c', c1 = trim(File           ), rank_mpi = msnot_rank )
          end if
          call MessageNotify( 'M', sub_sname, '  Interval        = %f [%c]', &
            & d = (/ IntValue /), c1 = trim( IntUnit ), rank_mpi = msnot_rank )
          call MessageNotify( 'M', sub_sname, '  Precision       = %c', c1 = trim(Precision    ), rank_mpi = msnot_rank )
          call MessageNotify( 'M', sub_sname, '  TimeAverage     = %b', l  = (/ TimeAverage   /), rank_mpi = msnot_rank )
          call MessageNotify( 'M', sub_sname, '  Origin          = %f [%c]', &
            & d = (/ OriginValue /), c1 = trim( OriginUnit ), rank_mpi = msnot_rank )
          call MessageNotify( 'M', sub_sname, '  Terminus        = %f [%c]', &
            & d = (/ TerminusValue /), c1 = trim( TerminusUnit ), rank_mpi = msnot_rank )
          call MessageNotify( 'M', sub_sname, '  SliceStart      = (/ %*d /)', &
            &                                i = SliceStart(1:numdims-1), n = (/ numdims-1 /), rank_mpi = msnot_rank )
          call MessageNotify( 'M', sub_sname, '  SliceEnd        = (/ %*d /)', &
            &                                i = SliceEnd(1:numdims-1), n = (/ numdims-1 /), rank_mpi = msnot_rank )
          call MessageNotify( 'M', sub_sname, '  SliceStride     = (/ %*d /)', &
            &                                i = SliceStride(1:numdims-1), n = (/ numdims-1 /), rank_mpi = msnot_rank )
          call MessageNotify( 'M', sub_sname, '  SpaceAverage    = (/ %*b /)', &
            &                                l = SpaceAverage(1:numdims-1), n = (/ numdims-1 /), rank_mpi = msnot_rank )
          call MessageNotify( 'M', sub_sname, '  NewFileInterval = %d [%c]', &
            & i = (/ NewFileIntValue /), c1 = trim( NewFileIntUnit ), rank_mpi = msnot_rank )
          call MessageNotify( 'M', sub_sname, '', rank_mpi = msnot_rank )

        else
          call MessageNotify( 'M', sub_sname, '----- loading is finished (iostat=%d) -----', &
            & i = (/iostat_nml/), rank_mpi = msnot_rank )
        end if
      end do

      close( unit_nml )


    ! NAMELIST եɤ߹ޤʤ
    ! NAMELIST file is not loaded
    !
    else
      call MessageNotify( 'M', sub_sname, '----- "gtool_historyauto_nml" is not loaded" -----', rank_mpi = msnot_rank )
      Name = ''
      File = ''
      call HstNmlInfoInquire( &
        & gthstnml = gthstnml, &             ! (in)
        & interval_value = IntValue, &       ! (out) optional
        & interval_unit = IntUnit, &         ! (out) optional
        & precision = Precision, &           ! (out) optional
        & time_average = TimeAverage, &      ! (out) optional
        & origin_value   = OriginValue, &    ! (out) optional
        & origin_unit    = OriginUnit, &     ! (out) optional
        & terminus_value = TerminusValue, &  ! (out) optional
        & terminus_unit  = TerminusUnit, &   ! (out) optional
        & slice_start  = SliceStart, &       ! (out) optional
        & slice_end    = SliceEnd, &         ! (out) optional
        & slice_stride = SliceStride, &      ! (out) optional
        & space_average = SpaceAverage, &    ! (out) optional
        & newfile_intvalue = NewFileIntValue, & ! (out) optional
        & newfile_intunit  = NewFileIntUnit, &  ! (out) optional
        & fileprefix = FilePrefix )          ! (out) optional

      !  ; Print
      !
      call MessageNotify( 'M', sub_sname, 'Global Settings:', rank_mpi = msnot_rank )
      call MessageNotify( 'M', sub_sname, '  AllOutput       = %b', l  = (/ AllOutput   /), rank_mpi = msnot_rank )
      call MessageNotify( 'M', sub_sname, '  FilePrefix      = %c', c1 = trim(FilePrefix   ), rank_mpi = msnot_rank )
      call MessageNotify( 'M', sub_sname, '  Interval        = %f [%c]', &
        & d = (/ IntValue /), c1 = trim( IntUnit ), rank_mpi = msnot_rank )
      call MessageNotify( 'M', sub_sname, '  Precision       = %c', c1 = trim(Precision    ), rank_mpi = msnot_rank )
      call MessageNotify( 'M', sub_sname, '  TimeAverage     = %b', l  = (/ TimeAverage   /), rank_mpi = msnot_rank )
      call MessageNotify( 'M', sub_sname, '  Origin          = %f [%c]', &
        & d = (/ OriginValue /), c1 = trim( OriginUnit ), rank_mpi = msnot_rank )
      call MessageNotify( 'M', sub_sname, '  Terminus        = %f [%c]', &
        & d = (/ TerminusValue /), c1 = trim( TerminusUnit ), rank_mpi = msnot_rank )
      call MessageNotify( 'M', sub_sname, '  SliceStart      = (/ %*d /)', &
        &                                i = SliceStart(1:numdims-1), n = (/ numdims-1 /), rank_mpi = msnot_rank )
      call MessageNotify( 'M', sub_sname, '  SliceEnd        = (/ %*d /)', &
        &                                i = SliceEnd(1:numdims-1), n = (/ numdims-1 /), rank_mpi = msnot_rank )
      call MessageNotify( 'M', sub_sname, '  SliceStride     = (/ %*d /)', &
            &                                i = SliceStride(1:numdims-1), n = (/ numdims-1 /), rank_mpi = msnot_rank )
      call MessageNotify( 'M', sub_sname, '  SpaceAverage    = (/ %*b /)', &
        &                                l = SpaceAverage(1:numdims-1), n = (/ numdims-1 /), rank_mpi = msnot_rank )
      call MessageNotify( 'M', sub_sname, '  NewFileInterval = %d [%c]', &
        & i = (/ NewFileIntValue /), c1 = trim( NewFileIntUnit ), rank_mpi = msnot_rank )
      call MessageNotify( 'M', sub_sname, '' , rank_mpi = msnot_rank)

    end if

    ! λ, 㳰
    ! Termination and Exception handling
    !
    initialized = .true.

999 continue
    call StoreError(stat, subname, cause_c = cause_c)
    call EndSub(subname, 'stat=%d', i = (/stat/) )
  end subroutine HistoryAutoCreate3

  !-------------------------------------------------------------------

  subroutine HistoryAutoCreate2( &
    & title, source, institution, &           ! (in)
    & dims, dimsizes, longnames, units, &     ! (in)
    & xtypes, conventions, gt_version,&       ! (in) optional
    & all_output, &                           ! (in) optional
    & file_prefix, &                          ! (in) optional
    & namelist_filename, &                    ! (in) optional
    & interval, origin, terminus, &           ! (in) optional
    & slice_start, slice_end, slice_stride, & ! (in) optional
    & space_average, &                        ! (in) optional
    & time_average, &                         ! (in) optional
    & newfile_interval, &                     ! (in) optional
    & rank, &                                 ! (in) optional
    & origin_date, origin_date_invalid, &     ! (in) optional
    & start_date, cal, &                      ! (in) optional
    & flag_mpi_gather, flag_mpi_split &       ! (in) optional
    & )
    !
    ! ʣΥҥȥǡϤԤνԤޤ. 
    !
    !  HistoryAutoCreate ˤ, ǥǽϤ
    ! ѿ¸ɸɸŤߤʤɤƤꤷƤ. 
    !
    ! all_output  .true. Ϳ,
    ! namelist_filename Ϳʤ (ʸͿ) ˤ, 
    ! HistoryAutoAddVariable ϿƤѿϤޤ. 
    !  namelist_filename  NAMELIST ե̾Ϳˤ, 
    !  NAMELIST ե뤫ϤΥ󥪥դ, 
    ! ϥե̾, ϴֳ֤ʤɤѹǽǤ. 
    ! ѹǽʹܤ˴ؤƤ NAMELIST#gtool_historyauto_nml 
    ! 򻲾ȤƲ. 
    !
    ! interval, origin, terminus, slice_start, slice_end, slice_stride,
    ! space_average, time_average, newfile_interval 
    ! ʤɤϥǥեͤȤƻѤޤ. 
    ! ͤ HistoryAutoAddVariable 
    ! NAMELIST#gtool_historyauto_nml Ǿ񤭤ޤ. 
    ! (ͥ٤⤤Τ NAMELIST#gtool_historyauto_nml ,
    ! HistoryAutoAddVariable ΰ, 
    ! HistoryAutoCreate ΰ νǤ). 
    !
    !
    ! Initialization for multiple history data output 
    !
    ! Set all axes and their weights depended by variables 
    ! output from numerical models to this "HistoryAutoCreate". 
    !
    ! All variables registered by "HistoryAutoAddVariable" 
    ! are output if .true. is given to "all_output" or 
    ! "namelist_filename" is not given (or blanks are given)
    ! On the other hand, if a filename of NAMELIST file is 
    ! given to "namelist_filename", on/off of output, 
    ! output filename and output interval, etc. can be changed 
    ! from the NAMELIST file. 
    ! For available items, see "NAMELIST#gtool_historyauto_nml". 
    !
    ! Settings about 
    ! "interval", "origin", "terminus", "slice_start", "slice_end", "slice_stride",
    ! "space_average", "time_average", "newfile_interval" 
    ! etc. are used as default values. 
    ! Their set values are overwritten by 
    ! "HistoryAutoAddVariable" or 
    ! "NAMELIST#gtool_historyauto_nml". 
    ! ("NAMELIST#gtool_historyauto_nml" is high priority, 
    ! arguments of "HistoryAutoAddVariable" are medium, 
    ! arguments of "HistoryAutoCreate" are low). 
    !
    use gtool_historyauto_generic, only: HistoryAutoCreate
    use gtool_historyauto_internal, only: initialized, numdims, time_unit_bycreate, time_unit_suffix
    use gtool_history, only: HistoryAxisCreate
    use gtool_history_nmlinfo_generic, only: HstNmlInfoCreate, HstNmlInfoAdd, &
      & HstNmlInfoEndDefine, HstNmlInfoPutLine, HstNmlInfoAllNameValid, &
      & HstNmlInfoInquire
    use dc_trace, only: BeginSub, EndSub
    use dc_error, only: StoreError, DC_NOERR, DC_EALREADYINIT, &
      & GT_EARGSIZEMISMATCH, HST_ENOTIMEDIM
    use netcdf_f77, only: NF_EMAXDIMS, NF_MAX_DIMS
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_present, only: present_and_not_empty, present_and_true, &
      & present_select
    use dc_calendar, only: DC_CAL, DC_CAL_DATE
    use dc_date, only: DCDiffTimeCreate, EvalbyUnit
    use dc_date_types, only: DC_DIFFTIME, DC_DATETIME
    use dc_message, only: MessageNotify
    use dc_iounit, only: FileOpen
    use dc_types, only: DP, STRING, TOKEN
    implicit none
    character(*), intent(in):: title
                              ! ǡΤɽ. 
                              ! Title of entire data
    character(*), intent(in):: source
                              ! ǡݤμ. 
                              ! Source of data file
    character(*), intent(in):: institution
                              ! եǽŪѹȿ/Ŀ. 
                              ! Institution or person that changes files for the last time
    character(*), intent(in):: dims(:)
                              ! ̾. 
                              ! 
                              ! 礭¤Ϥޤ.
                              ! ġμʸ dc_types#TOKEN ޤ.
                              ! ʸ
                              ! ƱǤʤФʤޤ.
                              ! ­ʤʸʬ϶
                              ! äƤ.
                              ! 
                              ! Names of dimensions.
                              ! 
                              ! Length of array is unlimited. 
                              ! Limits of numbers of characters of each 
                              ! dimensions are "dc_types#TOKEN". 
                              ! Numbers of characters in this array
                              ! must be same. 
                              ! Make up a deficit with blanks. 
                              ! 
    integer, intent(in):: dimsizes (:)
                              ! dims ǻꤷ줾μ礭. 
                              ! 
                              ! 礭 dims 礭
                              ! ɬפޤ.  '0' (Υ) 
                              ! Ȥμ ̵¼ (unlimited
                              ! dimension) Ȥʤޤ. (gtool_history 
                              ! Ǥϻ֤μФ̵¼
                              ! Ѥ뤳ȤꤷƤޤ). , 
                              ! 1 Ĥ NetCDF ե (С 3) 
                              ! Ϻ 1 Ĥ̵¼ƤʤΤ, 
                              ! 2 ʾ '0' ꤷʤǤ. 
                              ! ξ,  gtool4 ǡϤޤ.
                              ! 
                              ! Lengths of dimensions specified with "dims". 
                              ! 
                              ! Length of this array must be same as 
                              ! length of "dim".  If '0' (zero) is 
                              ! specified, the dimension is treated as 
                              ! unlimited dimension.  
                              ! (In "gtool_history", unlimited dimension is 
                              ! expected to be used as time). 
                              ! Note that one NetCDF file (version 3) 
                              ! can not have two or more unlimited 
                              ! dimensions, so that do not specify '0' 
                              ! to two or more places. In that case, 
                              ! gtoo4 data is not output currently 
                              ! 
    character(*), intent(in):: longnames (:)
                              ! dims ǻꤷ줾μ̾. 
                              !
                              ! 礭 dims 礭
                              ! ɬפޤ. ʸ
                              !  dc_types#STRING ޤ.
                              ! ʸ
                              ! ƱǤʤФʤޤ.
                              ! ­ʤʸʬ϶䤤ޤ.
                              ! 
                              ! Names of dimensions specified with "dims". 
                              !
                              ! Length of this array must be same as 
                              ! length of "dim".  
                              ! Limits of numbers of characters are 
                              ! "dc_types#STRING". 
                              ! Numbers of characters in this array
                              ! must be same. 
                              ! Make up a deficit with blanks. 
                              ! 
    character(*), intent(in):: units(:)
                              ! dims ǻꤷ줾μñ. 
                              !
                              ! 礭 dims 礭
                              ! ɬפޤ. ʸ
                              !  dc_types#STRING ޤ.
                              ! ʸ
                              ! ƱǤʤФʤޤ.
                              ! ­ʤʸʬ϶䤤ޤ.
                              ! 
                              ! Units of dimensions specified with "dims". 
                              !
                              ! Length of this array must be same as 
                              ! length of "dim".  
                              ! Limits of numbers of characters are 
                              ! "dc_types#STRING". 
                              ! Numbers of characters in this array
                              ! must be same. 
                              ! Make up a deficit with blanks. 
                              ! 
    character(*), intent(in),  optional:: xtypes(:)
                              ! dims ǻꤷ줾
                              ! Υǡ. 
                              !
                              ! ǥեȤ float (ñټ¿)
                              ! Ǥ. ͭʤΤ,
                              ! double (ټ¿), 
                              ! int () Ǥ. ꤷʤ
                              ! , ̵ʷꤷˤ,
                              ! float Ȥʤޤ. ʤ, 礭
                              !  *dims* 礭ɬפ
                              ! ޤ. ʸ
                              ! ƱǤʤФʤޤ.
                              ! ­ʤʸʬ϶䤤ޤ.
                              !
                              ! Data types of dimensions specified 
                              ! with "dims". 
                              !
                              ! Default value is "float" (single precision). 
                              ! Other valid values are 
                              ! "double" (double precision), 
                              ! "int" (integer). 
                              ! If no value or invalid value is specified, 
                              ! "float" is applied. 
                              ! Length of this array must be same as 
                              ! length of "dim".  
                              ! Numbers of characters in this array
                              ! must be same. 
                              ! Make up a deficit with blanks. 
                              ! 
    character(*), intent(in), optional:: conventions
                              ! Ϥե netCDF
                              ! 
                              !
                              ! ά,
                              ! ⤷϶ʸͿ,
                              ! Ϥ netCDF 
                              ! Conventions °
                              ! gtool4_netCDF_Conventions
                              ! ưŪͿޤ.
                              ! 
                              ! NetCDF conventions of output file. 
                              !
                              ! If this argument is omitted or, 
                              ! blanks are given,
                              ! gtool4_netCDF_Conventions is given to 
                              ! attribute "Conventions" of an output file
                              ! automatically. 
                              ! 
    character(*), intent(in), optional:: gt_version
                              ! gtool4 netCDF ΥС
                              !
                              ! ά, gt_version °
                              ! κǿǤΥСʥС
                              ! gtool4_netCDF_version
                              ! Ϳޤ.
                              ! (,  conventions 
                              ! gtool4_netCDF_Conventions
                              ! ʳͿ
                              ! gt_version °ޤ).
                              ! 
                              ! Version of gtool4 netCDF Conventions. 
                              !
                              ! If this argument is omitted, 
                              ! latest version number of gtool4 netCDF 
                              ! Conventions is given to attribute 
                              ! "gt_version" of an output file 
                              ! (However, gtool4_netCDF_Conventions is 
                              ! not given to an argument "conventions", 
                              ! attribute "gt_version" is not created).
                              ! 
    logical, intent(in), optional:: all_output
                              ! ϿѿƽϤ뤿Υե饰. 
                              !
                              ! .true. ꤹ, 
                              ! HistoryAutoAddVariable Ͽ줿
                              ! ѿƽϤ褦ˤʤޤ. 
                              !
                              ! *namelist_filename* ꤵ
                              ! ˤ, ǥեȤ .false. Ȥʤޤ. 
                              ! ξˤ, 
                              ! *namelist_filename* ˻ꤵ줿 
                              ! NAMELIST ե뤫ɤ߹ޤ
                              ! NAMELIST#gtool_historyauto_nml
                              ! ǻꤵ줿ѿΤ߽Ϥޤ.
                              !
                              ! *namelist_filename* ꤵʤ
                              ! ˤ, .true. Ȥʤޤ. 
                              !
                              !
                              ! Flag for output all registered variables. 
                              ! 
                              ! When .true. is specified, 
                              ! all variables registered by
                              ! "HistoryAutoAddVariable" are output. 
                              ! 
                              ! If *namelist_filename* is specified, 
                              ! default value becomes .false. .
                              ! In this case, 
                              ! only variables specified in 
                              ! "NAMELIST#gtool_historyauto_nml"
                              ! loaded from a NAMELIST file
                              ! *namelist_filename*. 
                              ! 
                              ! If *namelist_filename* is not specified, 
                              ! this value becomes .true. .
                              ! 
    character(*), intent(in), optional:: file_prefix
                              ! ҥȥǡΥե̾Ƭ. 
                              ! Prefixes of history data filenames
    character(*), intent(in), optional:: namelist_filename
                              ! NAMELIST ե̾. 
                              !
                              ! ά, ⤷϶ʸͿ, 
                              ! NAMELIST եɤ߹ߤޤ. 
                              ! 
                              ! Name of NAMELIST file. 
                              !
                              ! If this argument is omitted, 
                              ! or blanks are specified, 
                              ! no NAMELIST file is loaded. 
                              ! 
    real, intent(in), optional:: interval
                              ! ϻֳִ. 
                              !
                              ! ά, 
                              ! ưŪ 1.0 [sec] ꤵޤ.
                              !
                              ! Interval of output time. 
                              !
                              ! If this argument is omitted, 
                              ! 1.0 [sec] is specified 
                              ! automatically. 
                              ! 
    real, intent(in), optional:: origin
                              ! ϳϻ. 
                              !
                              ! ά, ưŪ 0.0 [sec] 
                              ! ꤵޤ.
                              ! 
                              ! Start time of output. 
                              !
                              ! If this argument is omitted, 
                              ! 0.0 [sec] is specified
                              ! automatically. 
                              ! 
    real, intent(in), optional:: terminus
                              ! Ͻλ. 
                              !
                              ! ά, ͥǥμ¹Ԥλޤ
                              ! ϤԤޤ. 
                              ! 
                              ! End time of output. 
                              !
                              ! If this argument is omitted, 
                              ! output is continued until a numerical model
                              ! is finished. 
                              ! 
    integer, intent(in), optional:: slice_start(:)
                              ! γ. 
                              !
                              ! ά, ɸǡγꤵޤ.
                              ! 
                              ! Start points of spaces. 
                              ! 
                              ! If this argument is omitted, 
                              ! start points of dimensions are set. 
                              ! 
    integer, intent(in), optional:: slice_end(:)
                              ! νλ. 
                              !
                              ! ά, ɸǡνλꤵޤ.
                              ! 
                              ! End points of spaces. 
                              ! 
                              ! If this argument is omitted, 
                              ! End points of dimensions are set. 
                              ! 
    integer, intent(in), optional:: slice_stride(:)
                              ! ι. 
                              !
                              ! ά, 1 ꤵޤ.
                              ! 
                              ! Strides of spaces
                              ! 
                              ! If this argument is omitted, 
                              ! 1 is set. 
                              ! 
    logical, intent(in), optional:: space_average(:)
                              ! ʿѲΥե饰. 
                              !
                              ! .true. ꤵɸФʿѲ
                              ! Ԥޤ. 
                              ! ά, .false. ꤵޤ.
                              ! 
                              ! Flag of average. 
                              ! 
                              ! Axes specified .true. are averaged. 
                              ! If this argument is omitted, 
                              ! .false. is set. 
                              ! 
    logical, intent(in), optional:: time_average
                              ! ϥǡλʿѥե饰. 
                              ! ǥեȤ .false. 
                              ! Flag for time average of output data
                              ! Default value is .false.
    integer, intent(in), optional:: newfile_interval
                              ! եʬֳִ. 
                              !
                              ! ά, 
                              ! ؤΥեʬԤޤ. 
                              !
                              ! Interval of time of separation of a file. 
                              !
                              ! If this argument is omitted, 
                              ! a files is not separated in time direction.
                              ! 
    character(*), intent(in), optional:: rank
                              ! 󥯤̾. 
                              ! ʸͿˤ̵뤵ޤ. 
                              !
                              ! Name of a rank. 
                              ! If blank is given, this argument is ignored. 
                              !
    type(DC_DATETIME), intent(in), optional:: origin_date
                              ! ϳ. 
                              ! ΰѻͽΤ, start_date ѤƲ. 
                              !
                              ! Start date of output. 
                              ! Use "start_date" because this argument is obsolete.
                              !
    logical, intent(in), optional:: origin_date_invalid
                              ! .true. Ϳ, origin_date ̵ˤޤ. 
                              !
                              ! If ".true." is given, "origin_date" is ignored. 
                              !
    type(DC_CAL_DATE), intent(in), optional:: start_date
                              ! ϳ. 
                              !
                              ! Start date of output. 
                              !
    type(DC_CAL), intent(in), optional:: cal
                              ! . 
                              ! ꤷʤ, dc_calendar ⥸塼
                              ! ǥեȤ񤬻Ѥޤ. 
                              !
                              ! Calendar. 
                              ! If this argument is specified, default calendar in 
                              ! "dc_calendar" module is used. 
                              !
    logical, intent(in), optional:: flag_mpi_gather
                              ! MPI ѻ, ƥΡɤ HistoryPut
                              ! ͿǡĤΥե礷ƽ
                              ! ˤ .true. ͿƤ. 
                              ! ǥեȤ .false. Ǥ. 
                              ! 
                              ! .true. Ϳ, HistoryPutAxisMPI
                              ! ΤμǡͿƤ. 
                              !
                              ! When MPI is used, if ".true." is given, 
                              ! data given to "HistoryPut" on each node
                              ! is integrated and output to one file. 
                              ! Default value is ".false.".
                              ! 
                              ! If .true. is given, give data of axes in
                              ! whole area to "HistoryPutAxisMPI"
                              ! 
    logical, intent(in), optional:: flag_mpi_split
                              ! MPI ѻ, ƥΡɤ HistoryPut
                              ! Ϳǡ򤽤줾̾Υե
                              ! Ϥˤ .true. ͿƤ. 
                              ! ǥեȤ .false. Ǥ. 
                              !
                              ! When MPI is used, if ".true." is given, 
                              ! data given to "HistoryPut" on each node
                              ! is split into discrete files. 
                              ! Default value is ".false.".
                              ! 
    integer:: blank_index
    type(DC_DIFFTIME):: interval_difftime, origin_difftime, terminus_difftime
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = "HistoryAutoCreate2"
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ""

    ! Υ֥롼 2 ٸƤФ줿饨顼 
    ! Error is occurred when this subroutine is called twice
    !
    if ( initialized ) then
      stat = DC_EALREADYINIT
      cause_c = 'gtool_historyauto'
      goto 999
    end if

    ! ο˴ؤ륨顼
    ! Error handling for number of dimensions
    !
    numdims = size(dims)

    if ( size(dimsizes) /= numdims ) then
      cause_c = 'dimsizes, dims'
    elseif ( size(longnames) /= numdims ) then
      cause_c = 'longnames, dims'
    elseif ( size(units) /= numdims ) then
      cause_c = 'units, dims'
    endif
    if ( trim(cause_c) /= "" ) then
      stat = GT_EARGSIZEMISMATCH
      goto 999
    end if

    if ( numdims > NF_MAX_DIMS ) then
      stat = NF_EMAXDIMS
      goto 999
    end if

    ! Ａ˴ؤ륨顼
    ! Error handling for time dimension
    !
    if ( dimsizes(numdims) /= 0 ) then
      call MessageNotify( 'W', subname, &
        & 'time dimension must be specified to the last of "dims"' )
      stat = HST_ENOTIMEDIM
      goto 999
    end if

    ! ñ̤Υå
    ! Check units of time
    !
    time_unit_bycreate = units(numdims)
    time_unit_suffix = ''
    blank_index = index( trim( adjustl(time_unit_bycreate) ), ' ' )
    if ( blank_index > 1  ) then
      time_unit_suffix = time_unit_bycreate(blank_index+1:)
      time_unit_bycreate = time_unit_bycreate(1:blank_index-1)
    end if

    ! ϻֳִ֤Υǥե
    ! Configure default interval of output time
    !
    if ( present(interval) ) then
      call DCDiffTimeCreate( &
        & interval_difftime, &           ! (out)
        & interval, time_unit_bycreate ) ! (in)
    else
      call DCDiffTimeCreate( &
        & interval_difftime, &      ! (out)
        & 1.0, time_unit_bycreate ) ! (in)
    end if

    ! ϳϡλΥǥե
    ! Configure default origin/terminus time of output
    !
    if ( present(origin) ) then
      call DCDiffTimeCreate( &
        & origin_difftime, &           ! (out)
        & origin, time_unit_bycreate ) ! (in)
    else
      call DCDiffTimeCreate( &
        & origin_difftime, &           ! (out)
        & 0.0, time_unit_bycreate )    ! (in)
    end if

    if ( present(terminus) ) then
      call DCDiffTimeCreate( &
        & terminus_difftime, &           ! (out)
        & terminus, time_unit_bycreate ) ! (in)
    else
      call DCDiffTimeCreate( &
        & terminus_difftime, &       ! (out)
        & -1.0, time_unit_bycreate )  ! (in)
    end if

    ! HistoryAutoCreate1 θƤӽФ
    ! Call "HistoryAutoCreate1"
    !
    call HistoryAutoCreate( &
      & title = title, source = source, &        ! (in)
      & institution = institution, &             ! (in)
      & dims = dims, dimsizes = dimsizes, &      ! (in)
      & longnames = longnames, units = units, &  ! (in)
      &      origin = origin_difftime, &         ! (in)
      &    terminus = terminus_difftime, &       ! (in)
      &      xtypes = xtypes, &                  ! (in) optional
      & conventions = conventions, &             ! (in) optional
      &  gt_version = gt_version, &              ! (in) optional
      &  all_output = all_output, &              ! (in) optional
      & file_prefix = file_prefix, &             ! (in) optional
      & namelist_filename = namelist_filename, & ! (in) optional
      &      interval = interval_difftime, &     ! (in) optional
      &   slice_start = slice_start, &           ! (in) optional
      &     slice_end = slice_end, &             ! (in) optional
      &  slice_stride = slice_stride, &          ! (in) optional
      & space_average = space_average, &         ! (in) optional
      &  time_average = time_average, &          ! (in) optional
      & newfile_interval = newfile_interval, &   ! (in) optional
      & rank = rank, &                           ! (in) optional
      & origin_date = origin_date, &                 ! (in) optional
      & origin_date_invalid = origin_date_invalid, & ! (in) optional
      & start_date = start_date, &                   ! (in) optional
      & cal = cal, &                                 ! (in) optional
      & flag_mpi_gather = flag_mpi_gather, &         ! (in) optional
      & flag_mpi_split = flag_mpi_split )            ! (in) optional

999 continue
    call StoreError(stat, subname, cause_c = cause_c)
    call EndSub(subname)
  end subroutine HistoryAutoCreate2

  !-------------------------------------------------------------------

  subroutine HistoryAutoCreate1( &
    & title, source, institution, &           ! (in)
    & dims, dimsizes, longnames, units, &     ! (in)
    & origin, terminus, &                     ! (in)
    & xtypes, conventions, gt_version, &      ! (in) optional
    & all_output, &                           ! (in) optional
    & file_prefix, &                          ! (in) optional
    & namelist_filename, &                    ! (in) optional
    & interval, &                             ! (in) optional
    & slice_start, slice_end, slice_stride, & ! (in) optional
    & space_average, &                        ! (in) optional
    & time_average, &                         ! (in) optional
    & newfile_interval, &                     ! (in) optional
    & rank, &                                 ! (in) optional
    & origin_date, origin_date_invalid, &     ! (in) optional
    & start_date, cal, &                      ! (in) optional
    & flag_mpi_gather, flag_mpi_split &       ! (in) optional
    & )
    !
    ! ʣΥǡϤԤνԤޤ. 
    !
    !  HistoryAutoCreate ˤ, ǥǽϤ
    ! ѿ¸ɸɸŤߤʤɤƤꤷƤ. 
    !
    ! all_output  .true. Ϳ,
    ! namelist_filename Ϳʤ (ʸͿ) ˤ, 
    ! HistoryAutoAddVariable ϿƤѿϤޤ. 
    !  namelist_filename  NAMELIST ե̾Ϳˤ, 
    !  NAMELIST ե뤫ϤΥ󥪥դ, 
    ! ϥե̾, ϴֳ֤ʤɤѹǽǤ. 
    ! ѹǽʹܤ˴ؤƤ NAMELIST#gtool_historyauto_nml 
    ! 򻲾ȤƲ. 
    !
    ! interval, origin, terminus, slice_start, slice_end, slice_stride,
    ! space_average, time_average, newfile_interval 
    ! ʤɤϥǥեͤȤƻѤޤ. 
    ! ͤ HistoryAutoAddVariable 
    ! NAMELIST#gtool_historyauto_nml Ǿ񤭤ޤ. 
    ! (ͥ٤⤤Τ NAMELIST#gtool_historyauto_nml ,
    ! HistoryAutoAddVariable ΰ, 
    ! HistoryAutoCreate ΰ νǤ). 
    !
    !
    ! Initialization for multiple history data output 
    !
    ! Set all axes and their weights depended by variables 
    ! output from numerical models to this "HistoryAutoCreate". 
    !
    ! All variables registered by "HistoryAutoAddVariable" 
    ! are output if .true. is given to "all_output" or 
    ! "namelist_filename" is not given (or blanks are given)
    ! On the other hand, if a filename of NAMELIST file is 
    ! given to "namelist_filename", on/off of output, 
    ! output filename and output interval, etc. can be changed 
    ! from the NAMELIST file. 
    ! For available items, see "NAMELIST#gtool_historyauto_nml". 
    !
    ! Settings about 
    ! "interval", "origin", "terminus", "slice_start", "slice_end", "slice_stride",
    ! "space_average", "time_average", "newfile_interval" 
    ! etc. are used as default values. 
    ! Their set values are overwritten by 
    ! "HistoryAutoAddVariable" or 
    ! "NAMELIST#gtool_historyauto_nml". 
    ! ("NAMELIST#gtool_historyauto_nml" is high priority, 
    ! arguments of "HistoryAutoAddVariable" are medium, 
    ! arguments of "HistoryAutoCreate" are low). 
    !
    use gtool_historyauto_internal, only: initialized, version, sub_sname, &
      & zero_time, numdims, &
      & title_save, source_save, institution_save, conventions_save, &
      & gt_version_save, rank_save, save_mpi_split, save_mpi_gather, &
      & time_unit_bycreate, time_unit_suffix, gthst_axes, data_axes, &
      & all_output_save, gthstnml, cal_save
    use gtool_history, only: HistoryAxisCreate, HistoryAxisAddAttr
    use gtool_history_nmlinfo_generic, only: HstNmlInfoCreate, HstNmlInfoAdd, &
      & HstNmlInfoEndDefine, HstNmlInfoPutLine, HstNmlInfoAllNameValid, &
      & HstNmlInfoInquire
    use dc_trace, only: BeginSub, EndSub
    use dc_error, only: StoreError, DC_NOERR, DC_EALREADYINIT, &
      & GT_EARGSIZEMISMATCH, HST_ENOTIMEDIM, DC_ENEGATIVE
    use netcdf_f77, only: NF_EMAXDIMS, NF_MAX_DIMS
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_present, only: present_and_not_empty, present_and_true, &
      & present_select
    use dc_calendar, only: DC_CAL, DC_CAL_DATE, &
      & DCCalDateInquire, DCCalInquire, DCCalDefault, DCCalConvertByUnit
    use dc_date, only: DCDiffTimeCreate, EvalbyUnit, toChar, toCharCal, Eval
    use dc_date_types, only: DC_DIFFTIME, DC_DATETIME
    use dc_message, only: MessageNotify
    use dc_iounit, only: FileOpen
    use dc_types, only: DP, STRING, TOKEN
    implicit none
    character(*), intent(in):: title
                              ! ǡΤɽ. 
                              ! Title of entire data
    character(*), intent(in):: source
                              ! ǡݤμ. 
                              ! Source of data file
    character(*), intent(in):: institution
                              ! եǽŪѹȿ/Ŀ. 
                              ! Institution or person that changes files for the last time
    character(*), intent(in):: dims(:)
                              ! ̾. 
                              ! 
                              ! 礭¤Ϥޤ.
                              ! ġμʸ dc_types#TOKEN ޤ.
                              ! ʸ
                              ! ƱǤʤФʤޤ.
                              ! ­ʤʸʬ϶
                              ! äƤ.
                              ! 
                              ! Names of dimensions.
                              ! 
                              ! Length of array is unlimited. 
                              ! Limits of numbers of characters of each 
                              ! dimensions are "dc_types#TOKEN". 
                              ! Numbers of characters in this array
                              ! must be same. 
                              ! Make up a deficit with blanks. 
                              ! 
    integer, intent(in):: dimsizes (:)
                              ! dims ǻꤷ줾μ礭. 
                              ! 
                              ! 礭 dims 礭
                              ! ɬפޤ.  '0' (Υ) 
                              ! Ȥμ ̵¼ (unlimited
                              ! dimension) Ȥʤޤ. (gtool_history 
                              ! Ǥϻ֤μФ̵¼
                              ! Ѥ뤳ȤꤷƤޤ). , 
                              ! 1 Ĥ NetCDF ե (С 3) 
                              ! Ϻ 1 Ĥ̵¼ƤʤΤ, 
                              ! 2 ʾ '0' ꤷʤǤ. 
                              ! ξ,  gtool4 ǡϤޤ.
                              ! 
                              ! Lengths of dimensions specified with "dims". 
                              ! 
                              ! Length of this array must be same as 
                              ! length of "dim".  If '0' (zero) is 
                              ! specified, the dimension is treated as 
                              ! unlimited dimension.  
                              ! (In "gtool_history", unlimited dimension is 
                              ! expected to be used as time). 
                              ! Note that one NetCDF file (version 3) 
                              ! can not have two or more unlimited 
                              ! dimensions, so that do not specify '0' 
                              ! to two or more places. In that case, 
                              ! gtoo4 data is not output currently 
                              ! 
    character(*), intent(in):: longnames (:)
                              ! dims ǻꤷ줾μ̾. 
                              !
                              ! 礭 dims 礭
                              ! ɬפޤ. ʸ
                              !  dc_types#STRING ޤ.
                              ! ʸ
                              ! ƱǤʤФʤޤ.
                              ! ­ʤʸʬ϶䤤ޤ.
                              ! 
                              ! Names of dimensions specified with "dims". 
                              !
                              ! Length of this array must be same as 
                              ! length of "dim".  
                              ! Limits of numbers of characters are 
                              ! "dc_types#STRING". 
                              ! Numbers of characters in this array
                              ! must be same. 
                              ! Make up a deficit with blanks. 
                              ! 
    character(*), intent(in):: units(:)
                              ! dims ǻꤷ줾μñ. 
                              !
                              ! 礭 dims 礭
                              ! ɬפޤ. ʸ
                              !  dc_types#STRING ޤ.
                              ! ʸ
                              ! ƱǤʤФʤޤ.
                              ! ­ʤʸʬ϶䤤ޤ.
                              ! 
                              ! Units of dimensions specified with "dims". 
                              !
                              ! Length of this array must be same as 
                              ! length of "dim".  
                              ! Limits of numbers of characters are 
                              ! "dc_types#STRING". 
                              ! Numbers of characters in this array
                              ! must be same. 
                              ! Make up a deficit with blanks. 
                              ! 
    real(DP), intent(in):: origin
                              ! ϳϻ. 
                              !
                              ! Start time of output. 
                              !
    real(DP), intent(in):: terminus
                              ! Ͻλ. 
                              !
                              ! End time of output. 
                              ! 
    character(*), intent(in),  optional:: xtypes(:)
                              ! dims ǻꤷ줾
                              ! Υǡ. 
                              !
                              ! ǥեȤ float (ñټ¿)
                              ! Ǥ. ͭʤΤ,
                              ! double (ټ¿), 
                              ! int () Ǥ. ꤷʤ
                              ! , ̵ʷꤷˤ,
                              ! float Ȥʤޤ. ʤ, 礭
                              !  *dims* 礭ɬפ
                              ! ޤ. ʸ
                              ! ƱǤʤФʤޤ.
                              ! ­ʤʸʬ϶䤤ޤ.
                              !
                              ! Data types of dimensions specified 
                              ! with "dims". 
                              !
                              ! Default value is "float" (single precision). 
                              ! Other valid values are 
                              ! "double" (double precision), 
                              ! "int" (integer). 
                              ! If no value or invalid value is specified, 
                              ! "float" is applied. 
                              ! Length of this array must be same as 
                              ! length of "dim".  
                              ! Numbers of characters in this array
                              ! must be same. 
                              ! Make up a deficit with blanks. 
                              ! 
    character(*), intent(in), optional:: conventions
                              ! Ϥե netCDF
                              ! 
                              !
                              ! ά,
                              ! ⤷϶ʸͿ,
                              ! Ϥ netCDF 
                              ! Conventions °
                              ! gtool4_netCDF_Conventions
                              ! ưŪͿޤ.
                              ! 
                              ! NetCDF conventions of output file. 
                              !
                              ! If this argument is omitted or, 
                              ! blanks are given,
                              ! gtool4_netCDF_Conventions is given to 
                              ! attribute "Conventions" of an output file
                              ! automatically. 
                              ! 
    character(*), intent(in), optional:: gt_version
                              ! gtool4 netCDF ΥС
                              !
                              ! ά, gt_version °
                              ! κǿǤΥСʥС
                              ! gtool4_netCDF_version
                              ! Ϳޤ.
                              ! (,  conventions 
                              ! gtool4_netCDF_Conventions
                              ! ʳͿ
                              ! gt_version °ޤ).
                              ! 
                              ! Version of gtool4 netCDF Conventions. 
                              !
                              ! If this argument is omitted, 
                              ! latest version number of gtool4 netCDF 
                              ! Conventions is given to attribute 
                              ! "gt_version" of an output file 
                              ! (However, gtool4_netCDF_Conventions is 
                              ! not given to an argument "conventions", 
                              ! attribute "gt_version" is not created).
                              ! 
    logical, intent(in), optional:: all_output
                              ! ϿѿƽϤ뤿Υե饰. 
                              !
                              ! .true. ꤹ, 
                              ! HistoryAutoAddVariable Ͽ줿
                              ! ѿƽϤ褦ˤʤޤ. 
                              !
                              ! *namelist_filename* ꤵ
                              ! ˤ, ǥեȤ .false. Ȥʤޤ. 
                              ! ξˤ, 
                              ! *namelist_filename* ˻ꤵ줿 
                              ! NAMELIST ե뤫ɤ߹ޤ
                              ! NAMELIST#gtool_historyauto_nml
                              ! ǻꤵ줿ѿΤ߽Ϥޤ.
                              !
                              ! *namelist_filename* ꤵʤ
                              ! ˤ, .true. Ȥʤޤ. 
                              !
                              !
                              ! Flag for output all registered variables. 
                              ! 
                              ! When .true. is specified, 
                              ! all variables registered by
                              ! "HistoryAutoAddVariable" are output. 
                              ! 
                              ! If *namelist_filename* is specified, 
                              ! default value becomes .false. .
                              ! In this case, 
                              ! only variables specified in 
                              ! "NAMELIST#gtool_historyauto_nml"
                              ! loaded from a NAMELIST file
                              ! *namelist_filename*. 
                              ! 
                              ! If *namelist_filename* is not specified, 
                              ! this value becomes .true. .
                              ! 
    character(*), intent(in), optional:: file_prefix
                              ! ǡΥե̾Ƭ. 
                              ! Prefixes of history data filenames
    character(*), intent(in), optional:: namelist_filename
                              ! NAMELIST ե̾. 
                              !
                              ! ά, ⤷϶ʸͿ, 
                              ! NAMELIST եɤ߹ߤޤ. 
                              ! 
                              ! Name of NAMELIST file. 
                              !
                              ! If this argument is omitted, 
                              ! or blanks are specified, 
                              ! no NAMELIST file is loaded. 
                              ! 
    real(DP), intent(in), optional:: interval
                              ! ϻֳִ. 
                              !
                              ! ά, 
                              ! ưŪ 1.0 [sec] ꤵޤ.
                              !
                              ! Interval of output time. 
                              !
                              ! If this argument is omitted, 
                              ! 1.0 [sec] is specified 
                              ! automatically. 
                              ! 
    integer, intent(in), optional:: slice_start(:)
                              ! γ. 
                              !
                              ! ά, ɸǡγꤵޤ.
                              ! 
                              ! Start points of spaces. 
                              ! 
                              ! If this argument is omitted, 
                              ! start points of dimensions are set. 
                              ! 
    integer, intent(in), optional:: slice_end(:)
                              ! νλ. 
                              !
                              ! ά, ⤷ͤͿ, 
                              ! ɸǡνλꤵޤ.
                              ! 
                              ! End points of spaces. 
                              ! 
                              ! If this argument is omitted or
                              ! negative value is specified, 
                              ! end points of dimensions are set. 
                              ! 
    integer, intent(in), optional:: slice_stride(:)
                              ! ι. 
                              !
                              ! ά, 1 ꤵޤ.
                              ! 
                              ! Strides of spaces
                              ! 
                              ! If this argument is omitted, 
                              ! 1 is set. 
                              ! 
    logical, intent(in), optional:: space_average(:)
                              ! ʿѲΥե饰. 
                              !
                              ! .true. ꤵɸФʿѲ
                              ! Ԥޤ. 
                              ! ά, .false. ꤵޤ.
                              ! 
                              ! Flag of average. 
                              ! 
                              ! Axes specified .true. are averaged. 
                              ! If this argument is omitted, 
                              ! .false. is set. 
                              ! 
    logical, intent(in), optional:: time_average
                              ! ϥǡλʿѥե饰. 
                              ! ǥեȤ .false. 
                              ! Flag for time average of output data
                              ! Default value is .false.
    integer, intent(in), optional:: newfile_interval
                              ! եʬֳִ. 
                              !
                              ! ά, 
                              ! ؤΥեʬԤޤ. 
                              !
                              ! Interval of time of separation of a file. 
                              !
                              ! If this argument is omitted, 
                              ! a files is not separated in time direction.
                              ! 
    character(*), intent(in), optional:: rank
                              ! 󥯤̾. 
                              !
                              ! Name of a rank. 
                              !
    type(DC_DATETIME), intent(in), optional:: origin_date
                              ! ϳ. 
                              ! ΰѻͽΤ, start_date ѤƲ. 
                              !
                              ! Start date of output. 
                              ! Use "start_date" because this argument is obsolete.
                              !
    logical, intent(in), optional:: origin_date_invalid
                              ! .true. Ϳ, origin_date ̵ˤޤ. 
                              !
                              ! If ".true." is given, "origin_date" is ignored. 
    type(DC_CAL_DATE), intent(in), optional:: start_date
                              ! ϳ. 
                              !
                              ! Start date of output. 
                              !
    type(DC_CAL), intent(in), optional:: cal
                              ! . 
                              ! ꤷʤ, dc_calendar ⥸塼
                              ! ǥեȤ񤬻Ѥޤ. 
                              !
                              ! Calendar. 
                              ! If this argument is specified, default calendar in 
                              ! "dc_calendar" module is used. 
                              !
    logical, intent(in), optional:: flag_mpi_gather
                              ! MPI ѻ, ƥΡɤ HistoryPut
                              ! ͿǡĤΥե礷ƽ
                              ! ˤ .true. ͿƤ. 
                              ! ǥեȤ .false. Ǥ. 
                              ! 
                              ! .true. Ϳ, HistoryPutAxisMPI
                              ! ΤμǡͿƤ. 
                              !
                              ! When MPI is used, if ".true." is given, 
                              ! data given to "HistoryPut" on each node
                              ! is integrated and output to one file. 
                              ! Default value is ".false.".
                              ! 
                              ! If .true. is given, give data of axes in
                              ! whole area to "HistoryPutAxisMPI"
                              ! 
    logical, intent(in), optional:: flag_mpi_split
                              ! MPI ѻ, ƥΡɤ HistoryPut
                              ! Ϳǡ򤽤줾̾Υե
                              ! Ϥˤ .true. ͿƤ. 
                              ! ǥեȤ .false. Ǥ. 
                              !
                              ! When MPI is used, if ".true." is given, 
                              ! data given to "HistoryPut" on each node
                              ! is split into discrete files. 
                              ! Default value is ".false.".
                              ! 


    ! NAMELIST ѿ ; NAMELIST group of variables
    character(STRING):: Name
                              ! ѿ̾. 
                              ! ξˤ, ¾ͤ
                              ! gtool_historyauto ⥸塼ˤ
                              ! ϤǡƤ
                              ! ǥեͤȤʤޤ. 
                              ! 
                              ! "Data1,Data2" Τ褦˥ޤǶڤäʣ
                              ! ѿꤹ뤳ȤǽǤ. 
                              ! 
                              ! Variable identifier. 
                              ! If blank is given, other values are 
                              ! used as default values of output data 
                              ! in "gtool_historyauto". 
                              ! 
                              ! Multiple variables can be specified 
                              ! as "Data1,Data2" too. Delimiter is comma. 
    character(STRING):: File
                              ! ϥե̾. 
                              ! ϥǥեͤȤƤϻѤޤ. 
                              ! *Name* ͤꤵƤΤͭǤ. 
                              ! 
                              ! Output file name. 
                              ! This is not used as default value. 
                              ! This value is valid only when *Name* is 
                              ! specified. 

    real(DP):: IntValue
                              ! ǡνϴֳ֤ο. 
                              ! ͤͿ, Ϥ޻ߤޤ. 
                              ! Numerical value for interval of history data output
                              ! Negative values suppresses output.
    character(TOKEN):: IntUnit
                              ! ǡνϴֳ֤ñ. 
                              ! Unit for interval of history data output
    character(TOKEN):: Precision
                              ! ǡ. 
                              ! ǥեȤ float (ñټ¿)
                              ! Ǥ. ͭʤΤ,
                              ! double (ټ¿), 
                              ! int () Ǥ. ꤷʤ
                              ! , ̵ʷꤷˤ,
                              ! float Ȥʤޤ. 
                              ! 
                              ! Precision of history data
                              ! Default value is "float" (single precision). 
                              ! Other valid values are 
                              ! "double" (double precision), 
                              ! "int" (integer). 
                              ! If no value or invalid value is specified, 
                              ! "float" is applied. 
    character(STRING):: FilePrefix
                              ! ǡΥե̾Ƭ. 
                              ! Prefixes of history data filenames
    logical:: TimeAverage
                              ! ϥǡλʿѥե饰. 
                              ! 
                              ! ".true." Ϳ, ʿͤϤޤ. 
                              ! 
                              ! Flag for time average of output data
                              ! 
                              ! If ".ture." is specified, 
                              ! time average values are output. 
                              ! 
    logical:: AllOutput
                              ! ϿѿƽϤ뤿Υե饰. 
                              ! Flag for output all registered variables. 
    real(DP):: OriginValue
                              ! ϳϻ. 
                              ! Start time of output. 
    character(TOKEN):: OriginUnit
                              ! ϳϻñ. 
                              ! Unit of start time of output. 
    real(DP):: TerminusValue
                              ! Ͻλ. 
                              ! End time of output. 
    character(TOKEN):: TerminusUnit
                              ! Ͻλñ. 
                              ! Unit of end time of output. 
    integer:: SliceStart(1:NF_MAX_DIMS)
                              ! γ. 
                              ! Start points of spaces. 
    integer:: SliceEnd(1:NF_MAX_DIMS)
                              ! νλ. 
                              !
                              ! ά, ⤷ͤͿ, 
                              ! ɸǡνλꤵޤ.
                              ! 
                              ! End points of spaces. 
                              ! 
                              ! If this argument is omitted or
                              ! negative value is specified, 
                              ! end points of dimensions are set. 
                              ! 
    integer:: SliceStride(1:NF_MAX_DIMS)
                              ! ι. 
                              ! Strides of spaces. 
    logical:: SpaceAverage(1:NF_MAX_DIMS)
                              ! ʿѤΥե饰. 
                              ! Flag of spatial average. 
    integer:: NewFileIntValue
                              ! եʬֳִ֤ο. 
                              ! Numerical value for interval of time of separation of a file. 
    character(TOKEN):: NewFileIntUnit
                              ! եʬֳִ֤ñ. 
                              ! Unit of interval of time of separation of a file. 

    namelist /gtool_historyauto_nml/ &
      & Name, File, &
      & IntValue, IntUnit, &
      & Precision, &
      & FilePrefix, &
      & TimeAverage, AllOutput, &
      & OriginValue, OriginUnit, &
      & TerminusValue, TerminusUnit, &
      & SliceStart, SliceEnd, SliceStride, SpaceAverage, &
      & NewFileIntValue, NewFileIntUnit
                              ! gtool_historyauto ⥸塼Υǡ
                              ! NAMELIST ѿ̾. 
                              !
                              ! gtool_historyauto_generic#HistoryAutoCreate
                              ! Ѥݤ, ץʥ *namelist_filename* 
                              !  NAMELIST ե̾ꤹ뤳Ȥ, 
                              ! Υե뤫餳 NAMELIST ѿ
                              ! ɤ߹ߤޤ. 
                              !
                              ! NAMELIST group name for 
                              ! history data of "gtool_historyauto" module. 
                              ! 
                              ! If a NAMELIST filename is specified to 
                              ! an optional argument *namelist_filename* when 
                              ! "gtool_historyauto_generic#HistoryAutoCreate" 
                              ! is used, this NAMELIST group is 
                              ! loaded from the file. 


    ! ѿ ; Work variables
    integer:: blank_index
    integer:: stat
    character(STRING):: cause_c
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read
    character(TOKEN):: pos_nml
                              ! NAMELIST ɤ߹߻Υե. 
                              ! File position of NAMELIST read
    integer:: i, j
    character(TOKEN):: my_xtype

    real(DP):: interval_work, origin_work, terminus_work
    integer:: date_day
    real(DP):: date_sec
    integer:: msnot_rank
    character(STRING):: date_str
    character(TOKEN):: cal_str, cal_type
    integer:: origin_year, origin_month, origin_day, origin_hour, origin_min
    real(DP):: origin_sec
    integer:: month_in_year, hour_in_day, min_in_hour
    integer, pointer:: day_in_month(:) =>null()
    real(DP):: sec_in_min
    character(*), parameter:: subname = "HistoryAutoCreate1"
  continue
    call BeginSub(subname, version = version)
    stat = DC_NOERR
    cause_c = ""

    ! Υ֥롼 2 ٸƤФ줿饨顼
    ! Error is occurred when this subroutine is called twice
    !
    if ( initialized ) then
      stat = DC_EALREADYINIT
      cause_c = 'gtool_historyauto'
      goto 999
    end if

    ! äκ. 
    ! Create zero seconds
    !
    zero_time = 0.0_DP
!!$    call DCDiffTimeCreate( &
!!$      & zero_time, &        ! (out)
!!$      & sec = 0.0_DP  )     ! (in)

    ! ο˴ؤ륨顼
    ! Error handling for number of dimensions
    !
    numdims = size(dims)

    if ( size(dimsizes) /= numdims ) then
      cause_c = 'dimsizes, dims'
    elseif ( size(longnames) /= numdims ) then
      cause_c = 'longnames, dims'
    elseif ( size(units) /= numdims ) then
      cause_c = 'units, dims'
    endif
    if ( trim(cause_c) /= "" ) then
      stat = GT_EARGSIZEMISMATCH
      goto 999
    end if

    if ( numdims > NF_MAX_DIMS ) then
      stat = NF_EMAXDIMS
      goto 999
    end if

    ! Ａ˴ؤ륨顼
    ! Error handling for time dimension
    !
    if ( dimsizes(numdims) /= 0 ) then
      call MessageNotify( 'W', subname, &
        & 'time dimension must be specified to the last of "dims"' )
      stat = HST_ENOTIMEDIM
      goto 999
    end if

    ! ϥեδܥ᥿ǡݴ
    ! Save basic meta data for output file
    !
    title_save       = title
    source_save      = source
    institution_save = institution

    conventions_save = ''
    if ( present(conventions) ) conventions_save = conventions

    gt_version_save = ''
    if ( present(gt_version) ) gt_version_save = gt_version

    rank_save = ''
    if ( present(rank) ) rank_save = rank

    ! MPI ˴ؤݴ
    ! Save information about MPI
    !
    save_mpi_split  = present_and_true( flag_mpi_split )
    save_mpi_gather = present_and_true( flag_mpi_gather )

    msnot_rank = -1
    if ( save_mpi_gather ) msnot_rank = 0

    ! ñ̤Υå
    ! Check units of time
    !
    time_unit_bycreate = units(numdims)
    time_unit_suffix = ''
    blank_index = index( trim( adjustl(time_unit_bycreate) ), ' ' )
    if ( blank_index > 1  ) then
      time_unit_suffix = time_unit_bycreate(blank_index+1:)
      time_unit_bycreate = time_unit_bycreate(1:blank_index-1)
    end if

    ! ɸǡݴ
    ! Save axes data
    !
    do i = 1, numdims
      my_xtype = ''
      if ( present(xtypes) ) then
        if ( size(xtypes) >= i ) then
          my_xtype = xtypes(i)
        end if
      end if

      call HistoryAxisCreate( &
        &     axis = gthst_axes(i), &                     ! (out)
        &     name = dims(i),       size = dimsizes(i), & ! (in)
        & longname = longnames(i), units = units(i), &    ! (in)
        &    xtype = my_xtype )                           ! (in)

      allocate( data_axes(i) % a_axis( dimsizes(i) ) )
      data_axes(i) % a_axis = (/ ( real( j, DP ), j = 1, dimsizes(i) ) /)

    end do

    ! Ͽ
    ! Register calendar
    !
    if ( present(cal) ) then
      cal_save = cal
    else
      call DCCalDefault( cal_save )
    end if

    ! λ
    ! Specify date
    !
    if ( present(start_date) ) then

      call DCCalDateInquire( &
        & date_str = date_str, &   ! (out)
        & date     = start_date, & ! (in) optional
        & cal      = cal &         ! (in) optional
        !    & , zone = "+09:00" &
        & )

      call DCCalDateInquire( &
        & origin_year, origin_month, origin_day, & ! (out) optional
        & origin_hour, origin_min,   origin_sec, & ! (out) optional
        & date     = start_date, & ! (in) optional
        & cal      = cal &         ! (in) optional
        & )

      call DCCalInquire( &
        & cal_str, &                          ! (out) optional
        & month_in_year    = month_in_year, & ! (out) optional
        & day_in_month_ptr = day_in_month , & ! (out) optional
        & hour_in_day      = hour_in_day  , & ! (out) optional
        & min_in_hour      = min_in_hour  , & ! (out) optional
        & sec_in_min       = sec_in_min   , & ! (out) optional
        & cal = cal_save )                    ! (in) optional

      ! ϵξΤ units ° "since ..." ղ
      !
      select case ( trim(cal_str) )
      case ( 'gregorian' )
        time_unit_suffix = trim(time_unit_suffix) // &
          & ' since ' // trim(date_str)
      case ( 'julian' )
        time_unit_suffix = trim(time_unit_suffix) // &
          & ' since ' // trim(date_str)
      case ( 'noleap' )
        time_unit_suffix = trim(time_unit_suffix) // &
          & ' since ' // trim(date_str)
      case ( '360day' )
        time_unit_suffix = trim(time_unit_suffix) // &
          & ' since ' // trim(date_str)
      case ( 'cyclic' )
        time_unit_suffix = trim(time_unit_suffix) // &
          & ' since ' // trim(date_str)
      end select

      ! Ϳ
      !
      call HistoryAxisAddAttr( &
        & axis = gthst_axes(numdims), &    ! (inout)
        & attrname = 'origin', &           ! (in)
        & value = 'origin_year origin_month origin_day ' // &
        &         'origin_hour origin_min origin_sec' )    ! (in)

      call HistoryAxisAddAttr( gthst_axes(numdims), 'origin_year',  origin_year )
      call HistoryAxisAddAttr( gthst_axes(numdims), 'origin_month', origin_month )
      call HistoryAxisAddAttr( gthst_axes(numdims), 'origin_day',   origin_day )
      call HistoryAxisAddAttr( gthst_axes(numdims), 'origin_hour',  origin_hour )
      call HistoryAxisAddAttr( gthst_axes(numdims), 'origin_min',   origin_min )

      ! Ϳ
      !
      call HistoryAxisAddAttr( &
        & axis = gthst_axes(numdims), &    ! (inout)
        & attrname = 'calendar', &         ! (in)
        & value = cal_str )                ! (in)

      if ( trim(cal_str) == 'user_defined' ) then
        call HistoryAxisAddAttr( gthst_axes(numdims), 'month_in_year', month_in_year )
        call HistoryAxisAddAttr( gthst_axes(numdims), 'day_in_month',  day_in_month )
        call HistoryAxisAddAttr( gthst_axes(numdims), 'hour_in_day',   hour_in_day )
        call HistoryAxisAddAttr( gthst_axes(numdims), 'min_in_hour',   min_in_hour )
        call HistoryAxisAddAttr( gthst_axes(numdims), 'sec_in_min',    sec_in_min )
      end if

      deallocate( day_in_month )

    elseif ( present(origin_date) &
      &  .and. .not. present_and_true(origin_date_invalid) ) then
      call Eval( origin_date, &            ! (in)
        & day = date_day, sec = date_sec ) ! (out)
      if ( date_day /= 0 .or. date_sec /= 0.0 ) then
        time_unit_suffix = trim(time_unit_suffix) // &
          & ' since ' // toChar(origin_date)

        call HistoryAxisAddAttr( &
          & axis = gthst_axes(numdims), &    ! (inout)
          & attrname = 'calendar', &         ! (in)
          & value = toCharCal(origin_date) ) ! (in)

      end if
    end if

    ! ϿѿƽϤ뤿Υե饰ݴ
    ! Save flag for output all registered variables
    !
    if ( present(all_output) ) all_output_save = all_output
    if ( .not. present_and_not_empty(namelist_filename) ) all_output_save = .true.
    AllOutput = all_output_save

    ! ϻֳִ֤Υǥե
    ! Configure default interval of output time
    !
    if ( all_output_save ) then
      if ( present(interval) ) then
        interval_work = interval
!        interval_work = EvalbyUnit( interval, time_unit_bycreate )
      else
        interval_work = 1.0
      end if
    else
      interval_work = - 1.0
    end if

    ! ϳϡλΥǥե
    ! Configure default origin/terminus time of output
    !
    origin_work = &
      & DCCalConvertByUnit( origin, time_unit_bycreate, 'sec', cal_save )
    terminus_work = terminus

!    origin_work = EvalbyUnit( origin, 'sec' )
!    terminus_work = EvalbyUnit( terminus, time_unit_bycreate )

    ! gtool_historyauto_nml إǥեͤ
    ! Configure default values for "gtool_historyauto_nml"
    !
    call HstNmlInfoCreate( gthstnml ) ! (out)

    call HstNmlInfoAdd( &
      & gthstnml = gthstnml, &                  ! (inout)
      & name = '', &                            ! (in) optional
      & precision = 'float', &                  ! (in) optional
      & fileprefix = file_prefix, &             ! (in) optional
      & interval_value = interval_work, &       ! (in) optional
      & interval_unit  = time_unit_bycreate, &  ! (in) optional
      & origin_value   = origin_work, &         ! (in) optional
      & origin_unit    = 'sec', &               ! (in) optional
!!$      & origin_unit    = time_unit_bycreate, &  ! (in) optional
      & terminus_value = terminus_work, &       ! (in) optional
      & terminus_unit  = time_unit_bycreate, &  ! (in) optional
      & time_average = time_average, &          ! (in) optional
      & slice_start  = slice_start, &           ! (in) optional
      & slice_end    = slice_end, &             ! (in) optional
      & slice_stride = slice_stride, &          ! (in) optional
      & space_average = space_average, &        ! (in) optional
      & newfile_intvalue = newfile_interval, &  ! (in) optional
      & newfile_intunit = time_unit_bycreate )  ! (in) optional

    ! NAMELIST եɤ߹
    ! Load NAMELIST file
    !
    if ( present_and_not_empty(namelist_filename) ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)
      
      iostat_nml = 0
      pos_nml = ''

      call MessageNotify( 'M', sub_sname, '----- "gtool_historyauto_nml" is loaded from "%c" -----', &
        & c1 = trim(namelist_filename), rank_mpi = msnot_rank )

      do while ( trim(pos_nml) /= 'APPEND' .and. iostat_nml == 0 )

        Name = ''
        File = ''
        call HstNmlInfoInquire( &
          & gthstnml = gthstnml, &             ! (in)
          & interval_value = IntValue, &       ! (out) optional
          & interval_unit = IntUnit, &         ! (out) optional
          & precision = Precision, &           ! (out) optional
          & time_average = TimeAverage, &      ! (out) optional
          & origin_value   = OriginValue, &    ! (out) optional
          & origin_unit    = OriginUnit, &     ! (out) optional
          & terminus_value = TerminusValue, &  ! (out) optional
          & terminus_unit  = TerminusUnit, &   ! (out) optional
          & slice_start  = SliceStart, &       ! (out) optional
          & slice_end    = SliceEnd, &         ! (out) optional
          & slice_stride = SliceStride, &      ! (out) optional
          & space_average = SpaceAverage, &    ! (out) optional
          & newfile_intvalue = NewFileIntValue, & ! (out) optional
          & newfile_intunit  = NewFileIntUnit, &  ! (out) optional
          & fileprefix = FilePrefix )          ! (out) optional

        read( unit = unit_nml, &            ! (in)
          &    nml = gtool_historyauto_nml, & ! (out)
          & iostat = iostat_nml )           ! (out)
        inquire( unit = unit_nml, & ! (in)
          &  position = pos_nml )   ! (out)

        if ( iostat_nml == 0 ) then

          ! NAMELIST Ϳ줿̵ͤʾ, ǥեͤ
          ! Default values are used when values from NAMELIST are invalid
          !
          if ( .not. IntValue > 0.0 ) then
            IntValue = interval_work
            IntUnit  = time_unit_bycreate
          end if
          if ( .not. OriginValue > 0.0 ) then
            OriginValue = origin_work
            OriginUnit  = 'sec'
          end if
          if ( .not. TerminusValue > 0.0 ) then
            TerminusValue = terminus_work
            TerminusUnit  = time_unit_bycreate
          end if

          ! Ͽ
          ! Register information
          !
          call HstNmlInfoAdd( &
            & gthstnml = gthstnml, &             ! (inout)
            & name = Name, &                     ! (in) optional
            & file = File, &                     ! (in) optional
            & interval_value = IntValue, &       ! (in) optional
            & interval_unit = IntUnit, &         ! (in) optional
            & precision = Precision, &           ! (in) optional
            & time_average = TimeAverage, &      ! (in) optional
            & origin_value   = OriginValue, &    ! (in) optional
            & origin_unit    = OriginUnit, &     ! (in) optional
            & terminus_value = TerminusValue, &  ! (in) optional
            & terminus_unit  = TerminusUnit, &   ! (in) optional
            & slice_start  = SliceStart, &       ! (in) optional
            & slice_end    = SliceEnd, &         ! (in) optional
            & slice_stride = SliceStride, &      ! (in) optional
            & space_average = SpaceAverage, &    ! (in) optional
            & newfile_intvalue = NewFileIntValue, & ! (in) optional
            & newfile_intunit  = NewFileIntUnit, &  ! (in) optional
            & fileprefix = FilePrefix )          ! (in) optional

          ! ϿѿƽϤ뤿Υե饰ݴ
          ! Save flag for output all registered variables
          !
          if ( trim(Name) == '' ) then
            all_output_save = AllOutput
          end if

          !  ; Print
          !
          if ( trim(File) == '' ) File = trim(FilePrefix) // '<Name>.nc'

          if ( trim(Name) == '' ) then
            call MessageNotify( 'M', sub_sname, 'Global Settings:', rank_mpi = msnot_rank )
            call MessageNotify( 'M', sub_sname, '  AllOutput       = %b', l  = (/ AllOutput   /), rank_mpi = msnot_rank )
            call MessageNotify( 'M', sub_sname, '  FilePrefix      = %c', c1 = trim(FilePrefix   ), rank_mpi = msnot_rank )
          else
            call MessageNotify( 'M', sub_sname, 'Individual Settings:', rank_mpi = msnot_rank )
            call MessageNotify( 'M', sub_sname, '  Name            = %c', c1 = trim(Name           ), rank_mpi = msnot_rank )
            call MessageNotify( 'M', sub_sname, '  File            = %c', c1 = trim(File           ), rank_mpi = msnot_rank )
          end if
          call MessageNotify( 'M', sub_sname, '  Interval        = %f [%c]', &
            & d = (/ IntValue /), c1 = trim( IntUnit ), rank_mpi = msnot_rank )
          call MessageNotify( 'M', sub_sname, '  Precision       = %c', c1 = trim(Precision    ), rank_mpi = msnot_rank )
          call MessageNotify( 'M', sub_sname, '  TimeAverage     = %b', l  = (/ TimeAverage   /), rank_mpi = msnot_rank )
          call MessageNotify( 'M', sub_sname, '  Origin          = %f [%c]', &
            & d = (/ OriginValue /), c1 = trim( OriginUnit ), rank_mpi = msnot_rank )
          call MessageNotify( 'M', sub_sname, '  Terminus        = %f [%c]', &
            & d = (/ TerminusValue /), c1 = trim( TerminusUnit ), rank_mpi = msnot_rank )
          call MessageNotify( 'M', sub_sname, '  SliceStart      = (/ %*d /)', &
            &                                i = SliceStart(1:numdims-1), n = (/ numdims-1 /), rank_mpi = msnot_rank )
          call MessageNotify( 'M', sub_sname, '  SliceEnd        = (/ %*d /)', &
            &                                i = SliceEnd(1:numdims-1), n = (/ numdims-1 /), rank_mpi = msnot_rank )
          call MessageNotify( 'M', sub_sname, '  SliceStride     = (/ %*d /)', &
            &                                i = SliceStride(1:numdims-1), n = (/ numdims-1 /), rank_mpi = msnot_rank )
          call MessageNotify( 'M', sub_sname, '  SpaceAverage    = (/ %*b /)', &
            &                                l = SpaceAverage(1:numdims-1), n = (/ numdims-1 /), rank_mpi = msnot_rank )
          call MessageNotify( 'M', sub_sname, '  NewFileInterval = %d [%c]', &
            & i = (/ NewFileIntValue /), c1 = trim( NewFileIntUnit ), rank_mpi = msnot_rank )
          call MessageNotify( 'M', sub_sname, '', rank_mpi = msnot_rank )

        else
          call MessageNotify( 'M', sub_sname, '----- loading is finished (iostat=%d) -----', &
            & i = (/iostat_nml/), rank_mpi = msnot_rank )
        end if
      end do

      close( unit_nml )


    ! NAMELIST եɤ߹ޤʤ
    ! NAMELIST file is not loaded
    !
    else
      call MessageNotify( 'M', sub_sname, '----- "gtool_historyauto_nml" is not loaded" -----', rank_mpi = msnot_rank )
      Name = ''
      File = ''
      call HstNmlInfoInquire( &
        & gthstnml = gthstnml, &             ! (in)
        & interval_value = IntValue, &       ! (out) optional
        & interval_unit = IntUnit, &         ! (out) optional
        & precision = Precision, &           ! (out) optional
        & time_average = TimeAverage, &      ! (out) optional
        & origin_value   = OriginValue, &    ! (out) optional
        & origin_unit    = OriginUnit, &     ! (out) optional
        & terminus_value = TerminusValue, &  ! (out) optional
        & terminus_unit  = TerminusUnit, &   ! (out) optional
        & slice_start  = SliceStart, &       ! (out) optional
        & slice_end    = SliceEnd, &         ! (out) optional
        & slice_stride = SliceStride, &      ! (out) optional
        & space_average = SpaceAverage, &    ! (out) optional
        & newfile_intvalue = NewFileIntValue, & ! (out) optional
        & newfile_intunit  = NewFileIntUnit, &  ! (out) optional
        & fileprefix = FilePrefix )          ! (out) optional

      !  ; Print
      !
      call MessageNotify( 'M', sub_sname, 'Global Settings:', rank_mpi = msnot_rank )
      call MessageNotify( 'M', sub_sname, '  AllOutput       = %b', l  = (/ AllOutput   /), rank_mpi = msnot_rank )
      call MessageNotify( 'M', sub_sname, '  FilePrefix      = %c', c1 = trim(FilePrefix   ), rank_mpi = msnot_rank )
      call MessageNotify( 'M', sub_sname, '  Interval        = %f [%c]', &
        & d = (/ IntValue /), c1 = trim( IntUnit ), rank_mpi = msnot_rank )
      call MessageNotify( 'M', sub_sname, '  Precision       = %c', c1 = trim(Precision    ), rank_mpi = msnot_rank )
      call MessageNotify( 'M', sub_sname, '  TimeAverage     = %b', l  = (/ TimeAverage   /), rank_mpi = msnot_rank )
      call MessageNotify( 'M', sub_sname, '  Origin          = %f [%c]', &
        & d = (/ OriginValue /), c1 = trim( OriginUnit ), rank_mpi = msnot_rank )
      call MessageNotify( 'M', sub_sname, '  Terminus        = %f [%c]', &
        & d = (/ TerminusValue /), c1 = trim( TerminusUnit ), rank_mpi = msnot_rank )
      call MessageNotify( 'M', sub_sname, '  SliceStart      = (/ %*d /)', &
        &                                i = SliceStart(1:numdims-1), n = (/ numdims-1 /), rank_mpi = msnot_rank )
      call MessageNotify( 'M', sub_sname, '  SliceEnd        = (/ %*d /)', &
        &                                i = SliceEnd(1:numdims-1), n = (/ numdims-1 /), rank_mpi = msnot_rank )
      call MessageNotify( 'M', sub_sname, '  SliceStride     = (/ %*d /)', &
            &                                i = SliceStride(1:numdims-1), n = (/ numdims-1 /), rank_mpi = msnot_rank )
      call MessageNotify( 'M', sub_sname, '  SpaceAverage    = (/ %*b /)', &
        &                                l = SpaceAverage(1:numdims-1), n = (/ numdims-1 /), rank_mpi = msnot_rank )
      call MessageNotify( 'M', sub_sname, '  NewFileInterval = %d [%c]', &
        & i = (/ NewFileIntValue /), c1 = trim( NewFileIntUnit ), rank_mpi = msnot_rank )
      call MessageNotify( 'M', sub_sname, '' , rank_mpi = msnot_rank)

    end if

    ! λ, 㳰
    ! Termination and Exception handling
    !
    initialized = .true.

999 continue
    call StoreError(stat, subname, cause_c = cause_c)
    call EndSub(subname, 'stat=%d', i = (/stat/) )
  end subroutine HistoryAutoCreate1
