* Sample program for gtool_history/gtool5        2001/02/27 S.Takehiro
* 
* Solving diffusion equation 
*     du/dt = kappa d^2 u/dx^2
* for giving values of u at x=0 and 1. 
*
      program diffeq

      integer nx, nt, ndisp
        parameter( nx=30 )                       ! åɿ
        parameter( nt=200 )                      ! ֥ƥå׿
        parameter( ndisp=10 )                    ! ϴֳ
      double precision  dx, dt, kappa
        parameter( dx=1.0/(nx-1))                ! åɴֳ
        parameter( dt=0.0005 )                   ! ֳִ
        parameter( kappa=1.0D0 )                 ! ǮȻ
      double precision x(nx)                     ! ɸѿ
      double precision temp(nx), temp1(nx)       ! 

      integer i,it                               ! ѿ

      do i=1,nx
        x(i)=dx*(i-1)                            ! ɸ
      enddo

      do i=1,nx
        temp(i) = exp(-((x(i)-0.5)/0.1)**2)      ! 
      enddo

      do it=1,nt                                 ! ʬ
         do i=2,nx-1
            temp1(i) = temp(i) 
     &               + kappa*(temp(i+1)-2*temp(i)+temp(i-1))
     &                   /dx**2*dt
         enddo
         do i=1,nx
            temp(i) = temp1(i)
         enddo

         if ( mod(nt,ndisp) .eq. 0 ) then
            write(6,*)it*dt                      ! ѿ
            write(6,*)temp                       ! ѿ
         endif
      enddo

      stop
      end
