!= Sample program for gtool_history/gtool5
!
! * 2009/02/28 Y.Morikawa
! * 2007/06/25 M.Odaka
! * 2006/10/25 Y.Morikawa
! * 2003/08/21 M.Odaka
! * 2001/02/27 S.Takehiro
!
! Solving diffusion equation
! \[
!     du/dt = \kappa d^2 u/dx^2
! \]
! for giving values of $u$ at $x=[0,1]$.
!
program diffusion_date

  use gtool_history                                 ! Access module (⥸塼)
  use dc_date                                       ! Access module (⥸塼)
  use dc_types                                      ! Access module (⥸塼)

  integer, parameter     :: nx=30                   ! Grid number (åɿ)
  real(DP), parameter    :: dx=1.0/(nx-1)           ! Grid interval (åɴֳ)
  real(DP), parameter    :: dt=1.                   ! Time step [s] (ֳִ [])
  type(DC_DIFFTIME)      :: deltime                 ! Time step (ֳִ)
  type(DC_DIFFTIME)      :: endtime                 ! End time (λ)
  type(DC_DIFFTIME)      :: dsptime                 ! Output interval (ϴֳ)
  type(DC_DIFFTIME)      :: curtime                 ! Current time (߻)
  real(DP), dimension(nx):: x=(/(dx*(i-1),i=1,nx)/) ! X coordinate (ɸѿ)
  real(DP), dimension(nx):: temp                    ! Temperature ()
  real(DP), parameter    :: kappa=0.0001            ! Diffusion coefficient (ǮȻ)

  type(DC_DATETIME):: date                          ! Date ()
  character(256):: date_str

  call DCDateTimeCreate(date, year=2009, mon=2, day=28, hour=23, min=59)
                                                    ! Set date
                                                    ! ()

  call DCDiffTimeCreate(curtime, 0., 'sec')         ! Set initial time 
                                                    ! ()
  call DCDiffTimeCreate(deltime, dt, 'sec')         ! Set time step
                                                    ! (ֳִ)
  call DCDiffTimeCreate(endtime, 10., 'min')        ! Set end time 
                                                    ! (λ)
  call DCDiffTimeCreate(dsptime, 0.1, 'min')        ! Set output interval
                                                    ! (ϴֳ)

  temp = exp(-((x-0.5)/0.1)**2)                     ! Set initial value 
                                                    ! ()

  call HistoryCreate( &                             ! Create output file 
    & file='diffusion_date.nc', &                   ! (ҥȥ꡼)
    & title='Diffusion equation',                        &
    & source='Sample program of gtool_history/gtool5',   &
    & institution='GFD_Dennou Club davis project',       &
    & dims=(/'x','t'/), dimsizes=(/nx,0/),               &
    & longnames=(/'X-coordinate','time        '/),       &
    & units=(/'m  ','min'/),                             &
    & origin=curtime, interval=dsptime )

  call HistoryPut('x',x)                            ! Output 'x' (ѿ)

  call HistoryAddVariable( &                        ! Set output variable 
    & varname='temp', dims=(/'x','t'/), &           ! (ѿ) 
    & longname='temperature', units='K', xtype='double')

  call HistoryAddAttr('temp','gt_graph_tick_all',1)
  call HistoryAddAttr('temp','gt_graph_contour_spacing',(/0.0,1.0,0.01/))
  call HistoryAddAttr('temp','+gt_user_davis_kappa',kappa)

  call HistoryPut('temp',temp)                      ! Output 'temp' (ѿ)

  date_str = toChar(date)
  write(6,*) "Start: ", trim(date_str)              ! Display start date () 

  do while ( curtime <= endtime )                   ! Check termination (λȽ)

    temp(2:nx-1) = temp(2:nx-1) &                   ! Time integration (ʬ)
      & + kappa*(temp(3:nx)-2*temp(2:nx-1)+temp(1:nx-2))/dx**2*dt

    if ( mod( curtime, dsptime ) == 0 ) then        ! Check output timing (ϥߥȽ)
      call HistoryPut('temp',temp)                  ! Output 'temp' (ѿ)
    endif

    curtime = curtime + deltime                     ! Progress model time (ǥʹ)
  enddo

  date = date + curtime                             ! Evaluate end date (λ) 
  date_str = toChar(date)                           ! Convert date into characters (ʸѿѴ)
  write(6,*) "End:   ", trim(date_str)              ! Display end date (λ) 

  call HistoryClose
  stop
end program diffusion_date
