!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!$BI=Bj(B  ae_module $B%F%9%H%W%m%0%i%`(B
!
!$BMzNr(B  2002/01/25  $BC]9-??0l(B
!      2002/04/10  $BC]9-??0l(B
!      2007/11/07  $BC]9-??0l(B  $B%(%i!<%a%C%;!<%8DI2C(B
!
program ae_test_base2d

  use dc_message, only : MessageNotify
  use ae_module
  implicit none
  integer, parameter :: im=8, km=3, nm=3
  real(8), parameter :: xmin=0, xmax=1.0
  real(8), parameter :: eps=1.0D-14
  real(8), parameter :: pi=3.1415926535897932385D0

  real(8), dimension(nm,0:im-1) :: ag_f, ag_dfdx_sol
  real(8), dimension(nm,-km:km) :: ae_f, ae_f_sol
  real(8), dimension(nm,-km:km) :: ae_dfdx

  call MessageNotify('M','ae_test_base2d','ae_module 2-dim function tests')

  call ae_initial(im,km,xmin,xmax)

  ag_f(1,:) = 1
  ag_f(2,:) = sin(2*pi*g_x)
  ag_f(3,:) = cos(4*pi*g_x)

  ae_f_sol = 0.0D0
  ae_f_sol(1,0)=1.0D0
  ae_f_sol(2,-1)=-0.5D0
  ae_f_sol(3,2)=0.5D0

  ag_dfdx_sol(1,:) = 0.0
  ag_dfdx_sol(2,:) = 2*pi*cos(2*pi*g_x)
  ag_dfdx_sol(3,:) = -4*pi*sin(4*pi*g_x)

  write(6,*) 'f(1,:) = 1'
  write(6,*) 'f(2,:) = sin(2*pi*g_x)'
  write(6,*) 'f(3,:) = cos(4*pi*g_x)'
  write(6,*) 

  ae_f    = ae_ag(ag_f)
  ae_dfdx   = ae_dx_ae(ae_f)

  write(6,*) 'Forward Transform '
  write(6,*) 'Max.val of calculated error is ', maxval(abs(ae_f_sol- ae_f))
  if ( maxval(abs(ae_f_sol-ae_f)) > eps )then
     call MessageNotify('E','Test of ae_ag', &
          'Transform error too large.')
  endif

  write(6,*) 'Inverse Transform - original (result should be 0)'
  write(6,*) 'Max.val of calculated error is ', maxval(abs(ag_ae(ae_f)- ag_f))
  if ( maxval(abs(ag_ae(ae_f)- ag_f)) > eps )then
     call MessageNotify('E','Test of ag_ae', &
          'Transform error too large.')
  endif

  write(6,*) 
  write(6,*) 'Differentiation'
  write(6,*) 'Max.val of calculated errors are ',&
       maxval(abs(ag_ae(ae_dfdx)-ag_dfdx_sol ))
  if ( maxval(abs(ag_ae(ae_dfdx)-ag_dfdx_sol )) > eps )then
     call MessageNotify('E','Test of ae_dx_ae', &
          'Differentiation error too large.')
  end if

  write(6,*) 
  call MessageNotify('M','ae_test_base2d','ae_module 2-dim function tests succeeded!')

end program ae_test_base2d

