!----------------------------------------------------------------------
!     Copyright (c) 2007--2009 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  at_module ƥȥץ :: ִؿΥƥ
!
!  2007/10/24  ݹ
!      2009/01/04  ݹ  spml ˡȿ뤿ʣбǺ
!
program at_test_interpolate

  use dc_message, only : MessageNotify
  use at_module
  implicit none

  integer, parameter    :: im=32, km=32
  real(8), parameter    :: xmin=-5.0D0, xmax=1.0D0

  real(8), parameter    :: xval=0.5                    ! ֤κɸ
  real(8), dimension(3) :: xval1dim=(/0.5,0.1,-2.0/)   ! ֤κɸ

  real(8), parameter    :: eps=1.0D-10                 ! Ƹ

!--- Interpolate_t 
  real(8)                    :: zsol, zint             ! (, ׻)
  real(8), dimension(0:im)   :: g_z

!--- a_Interpolate_at 
  real(8), dimension(2)      :: ysol, yint          ! (, ׻)
  real(8), dimension(2,0:im) :: ag_y

!--- ѿ
  integer :: i,n,l

do i=1,2
  call at_initial(im,km/i,xmin,xmax)

!--------- Test of "Interpolate_t" ----------
  g_z = sin(g_X-(xmax+xmin)/3)
  zsol = sin(xval-(xmax+xmin)/3)
  zint = Interpolate_t(t_g(g_z),xval)

  write(6,*)'++++++Testing Interpolate_t+++++'
  write(6,*) 'analytic           calculated         error'
  write(6,*) zsol, zint, zsol-zint

  if ( abs(zsol-zint) > eps )then
     call MessageNotify('E','Test of Interpolate_t', &
          'Interpolation Error too large.')
  endif
  call MessageNotify('M','Test of Interpolate_t', &
       'Test of Interpolate_t suceeded!')

!--------- Test of "a_Interpolate_at" ----------

  ag_y(1,:) = cos(g_X-(xmax+xmin)/4)
  ag_y(2,:) = sin(g_X+(xmax+xmin)/4)
  ysol(1) =  cos(xval-(xmax+xmin)/4)
  ysol(2) = sin(xval+(xmax+xmin)/4)

  yint = a_Interpolate_at(at_ag(ag_y),xval)

  write(6,*)'++++++Testing a_Interpolate_at+++++'
  write(6,*) '    analytic              calculated             error'
  do n=1,2
     write(6,*) ysol(n), yint(n), ysol(n)-yint(n)
     if ( abs(ysol(n)-yint(n)) > eps )then
        call MessageNotify('E','Test of a_Interpolate_at', &
          'Interpolation Error too large.')
     endif
  enddo

  call MessageNotify('M','Test of Interpolate_t', &
       'Test of a_Interpolate_at suceeded!')

enddo

end program at_test_interpolate
