!----------------------------------------------------------------------
!     Copyright (c) 2008 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  wq_module ƥȥץ
!
!      ݥݥƥ󥷥ζ
!
!  2008/04/04  ݹ
!      2008/07/05  ʿ  ѹ
!
program wq_test_polmagbc

  use dc_message, only : MessageNotify
  use wq_module

  implicit none

  integer,parameter  :: im=32, jm=16, km=8   ! ʻ(, , ư)
  integer,parameter  :: nm=10, lm=15         ! ȿ(ʿ, ư)
  real(8),parameter  :: ra=2.5               ! Ⱦ

  real(8), dimension(0:im-1,1:jm,km)             :: xyr_POLMAG
  real(8), dimension(0:im-1,1:jm,km)             :: xyr_POLMAG_orig
  real(8), dimension((nm+1)*(nm+1),0:lm)   :: wq_POLMAG
  real(8), dimension((nm+1)*(nm+1),0:lm)   :: wq_POLMAG_orig
  real(8), dimension((nm+1)*(nm+1),km)     :: wr_POLMAG

  real(8), dimension((nm+1)*(nm+1),km)     :: wr_TopBoundary

  real(8), dimension((nm+1)*(nm+1),km)     :: wr_n   ! ȿ

  real(8), parameter  :: pi=3.1415926535897932385D0
  real(8), parameter  :: eps=2.0D-14

  integer :: i, j, k, l, n, nn(2)

  call MessageNotify('M','wq_test_polmagbc', &
       'wq_module  wq_PolmagBoundary subroutine test')

  write( 6,* ) 'Output is displayed if computational error is larger than',eps

  call wq_initial(im,jm,km,nm,lm,ra)

  !=================== wq_PolmagBoundary =======================
  ! P_10
  xyr_POLMAG = sin(xyr_lat) * sin( pi*xyr_rad/ra )

  ! P_1_1
  !xyr_POLMAG = cos(xyr_lat)*cos(xyr_lon)* sin( pi*(xyr_rad-ra)/ra )
  !xyr_POLMAG = 2*sin(xyr_lat)**2 * sin( pi*(xyr_rad-ra)/ra )

  xyr_POLMAG_orig = xyr_POLMAG
  wq_POLMAG = wq_xyr(xyr_POLMAG)
  wq_POLMAG_orig = wq_POLMAG
  call wq_PolmagBoundary(wq_POLMAG)

  do n=1,(nm+1)**2
     do l=0,lm-1
        if ( abs(wq_Polmag(n,l)-wq_POLMAG_orig(n,l)) > eps ) then
           write(6,*) 'internal value. : ', n,l,&
                     wq_Polmag(n,l)-wq_POLMAG_orig(n,l)
           call MessageNotify('E','wq_test_polmagbc',&
                           'internal value error too large')
        endif
     enddo
  enddo

  call MessageNotify('M','wq_test_polmagbc', &
                         'internal value test succeeded!')
  do k=1,km
     do n=1,(nm+1)**2
        nn=nm_l(n)
        wr_n(n,k) = nn(1)
     enddo
  enddo

  wr_TopBoundary = wr_wq(wq_RadDRad_wq(wq_POLMAG))/wr_RAD &
                     + (wr_n +1)*wr_wq(wq_POLMAG)/wr_RAD
  do n=1,(nm+1)*(nm+1)
     if ( abs(wr_TopBoundary(n,km)) > eps ) then
        write(6,*) 'Top B.C. : ', nm_l(n), wr_TopBoundary(n,km)
        call MessageNotify('E','wq_test_polmagbc','Top B.C. error too large')
     endif
  enddo
  call MessageNotify('M','wq_test_polmagbc', &
       'wq_PolmagBoundary test succeeded!')

  !=================== wq_PolmagBoundaryGrid =======================
  ! P_10
  !xyr_POLMAG = sin(xyr_lat) * sin( pi*(xyr_rad-ri)/(ro-ri) )

  ! P_1_1
  !xyr_POLMAG = cos(xyr_lat)*cos(xyr_lon)* sin( pi*(xyr_rad-ri)/(ro-ri) )
  xyr_POLMAG = 2*sin(xyr_lat)**2 * sin( pi*(xyr_rad-ra)/ra ) * xyr_Rad

  xyr_POLMAG_orig = xyr_POLMAG
  wr_POLMAG = wr_xyr(xyr_POLMAG)
  call wr_PolmagBoundaryGrid(wr_POLMAG)
  xyr_POLMAG = xyr_wr(wr_POLMAG)
  wq_POLMAG  = wq_wr(wr_POLMAG)

  do k=1,km-1
     do j=1,jm
        do i=0,im-1
           if ( abs(xyr_Polmag(i,j,k)-xyr_POLMAG_orig(i,j,k)) > eps ) then
              write(6,*) 'internal value. : ', i,j,k, &
                          xyr_Polmag(i,j,k)-xyr_POLMAG_orig(i,j,k)
              call MessageNotify('E','wq_test_polmagbc',&
                           'internal value error too large')
           endif
        enddo
     enddo
  enddo

  call MessageNotify('M','wq_test_polmagbc', &
                         'internal value test succeeded!')

  do k=1,km
     do n=1,(nm+1)**2
        nn=nm_l(n)
        wr_n(n,k) = nn(1)
     enddo
  enddo

  wr_TopBoundary = wr_wq(wq_RadDRad_wq(wq_POLMAG))/wr_RAD &
                      + (wr_n +1)*wr_POLMAG/wr_RAD
  do n=1,(nm+1)*(nm+1)
     if ( abs(wr_TopBoundary(n,km)) > eps ) then
        write(6,*) 'Top B.C. : ', nm_l(n), wr_TopBoundary(n,km)
        call MessageNotify('E','wq_test_polmagbc','Top B.C. error too large')
     endif
  enddo
  call MessageNotify('M','wq_test_polmagbc', &
       'wr_PolmagBoundaryGrid test succeeded!')


  call MessageNotify('M','wq_test_polmagbc', &
       'wq_module  wq_PolmagBoundary subroutine test succeded')

end program wq_test_polmagbc

